/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.ThreadUtils;
import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.common.util.MathUtils;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OfferRestrictions;
import haveno.core.offer.OfferUtil;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.OpenOfferManager;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.validation.FiatVolumeValidator;
import haveno.core.payment.validation.SecurityDepositValidator;
import haveno.core.payment.validation.XmrValidator;
import haveno.core.provider.price.MarketPrice;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.HavenoUtils;
import haveno.core.user.Preferences;
import haveno.core.util.FormattingUtils;
import haveno.core.util.ParsingUtils;
import haveno.core.util.PriceUtil;
import haveno.core.util.VolumeUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.coin.CoinUtil;
import haveno.core.util.validation.AmountValidator4Decimals;
import haveno.core.util.validation.AmountValidator8Decimals;
import haveno.core.util.validation.InputValidator;
import haveno.core.util.validation.MonetaryValidator;
import haveno.core.xmr.wallet.Restrictions;
import haveno.desktop.Navigation;
import haveno.desktop.common.model.ActivatableWithDataModel;
import haveno.desktop.main.MainView;
import haveno.desktop.main.funds.FundsView;
import haveno.desktop.main.funds.deposit.DepositView;
import haveno.desktop.main.offer.MutableOfferDataModel;
import haveno.desktop.main.offer.OfferViewModelUtil;
import haveno.desktop.main.offer.OfferViewUtil;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.settings.SettingsView;
import haveno.desktop.main.settings.preferences.PreferencesView;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.GUIUtil;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import org.bitcoinj.core.Coin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MutableOfferViewModel<M extends MutableOfferDataModel>
extends ActivatableWithDataModel<M> {
    private static final Logger log = LoggerFactory.getLogger(MutableOfferViewModel.class);
    private final XmrValidator xmrValidator;
    protected final SecurityDepositValidator securityDepositValidator;
    protected final PriceFeedService priceFeedService;
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final Navigation navigation;
    private final Preferences preferences;
    protected final CoinFormatter xmrFormatter;
    private final FiatVolumeValidator fiatVolumeValidator;
    private final AmountValidator4Decimals amountValidator4Decimals;
    private final AmountValidator8Decimals amountValidator8Decimals;
    protected final OfferUtil offerUtil;
    private String amountDescription;
    private String addressAsString;
    private final String paymentLabel;
    private boolean createOfferInProgress;
    public boolean createOfferCanceled;
    public final StringProperty amount = new SimpleStringProperty();
    public final StringProperty minAmount = new SimpleStringProperty();
    protected final StringProperty securityDeposit = new SimpleStringProperty();
    final StringProperty securityDepositInXMR = new SimpleStringProperty();
    final StringProperty securityDepositLabel = new SimpleStringProperty();
    public final StringProperty price = new SimpleStringProperty();
    public final StringProperty triggerPrice = new SimpleStringProperty("");
    public final BooleanProperty reserveExactAmount = new SimpleBooleanProperty(true);
    final StringProperty tradeFee = new SimpleStringProperty();
    final StringProperty tradeFeeInXmrWithFiat = new SimpleStringProperty();
    final StringProperty tradeFeeCurrencyCode = new SimpleStringProperty();
    final StringProperty tradeFeeDescription = new SimpleStringProperty();
    final BooleanProperty isTradeFeeVisible = new SimpleBooleanProperty(false);
    public final StringProperty marketPriceMargin = new SimpleStringProperty();
    public final StringProperty volume = new SimpleStringProperty();
    final StringProperty volumeDescriptionLabel = new SimpleStringProperty();
    final StringProperty volumePromptLabel = new SimpleStringProperty();
    final StringProperty tradeAmount = new SimpleStringProperty();
    final StringProperty totalToPay = new SimpleStringProperty();
    final StringProperty errorMessage = new SimpleStringProperty();
    final StringProperty tradeCurrencyCode = new SimpleStringProperty();
    final StringProperty waitingForFundsText = new SimpleStringProperty("");
    final StringProperty triggerPriceDescription = new SimpleStringProperty("");
    final StringProperty percentagePriceDescription = new SimpleStringProperty("");
    final StringProperty extraInfo = new SimpleStringProperty("");
    final BooleanProperty isPlaceOfferButtonDisabled = new SimpleBooleanProperty(true);
    final BooleanProperty cancelButtonDisabled = new SimpleBooleanProperty();
    public final BooleanProperty isNextButtonDisabled = new SimpleBooleanProperty(true);
    final BooleanProperty placeOfferCompleted = new SimpleBooleanProperty();
    final BooleanProperty showPayFundsScreenDisplayed = new SimpleBooleanProperty();
    private final BooleanProperty showTransactionPublishedScreen = new SimpleBooleanProperty();
    final BooleanProperty isWaitingForFunds = new SimpleBooleanProperty();
    final BooleanProperty isMinSecurityDeposit = new SimpleBooleanProperty();
    final ObjectProperty<InputValidator.ValidationResult> amountValidationResult = new SimpleObjectProperty();
    final ObjectProperty<InputValidator.ValidationResult> minAmountValidationResult = new SimpleObjectProperty();
    final ObjectProperty<InputValidator.ValidationResult> priceValidationResult = new SimpleObjectProperty();
    final ObjectProperty<InputValidator.ValidationResult> triggerPriceValidationResult = new SimpleObjectProperty((Object)new InputValidator.ValidationResult(true));
    final ObjectProperty<InputValidator.ValidationResult> volumeValidationResult = new SimpleObjectProperty();
    final ObjectProperty<InputValidator.ValidationResult> securityDepositValidationResult = new SimpleObjectProperty();
    final ObjectProperty<InputValidator.ValidationResult> extraInfoValidationResult = new SimpleObjectProperty();
    private ChangeListener<String> amountStringListener;
    private ChangeListener<String> minAmountStringListener;
    private ChangeListener<String> priceStringListener;
    private ChangeListener<String> marketPriceMarginStringListener;
    private ChangeListener<String> volumeStringListener;
    private ChangeListener<String> securityDepositStringListener;
    private ChangeListener<String> extraInfoStringListener;
    private ChangeListener<BigInteger> amountListener;
    private ChangeListener<BigInteger> minAmountListener;
    private ChangeListener<Price> priceListener;
    private ChangeListener<Volume> volumeListener;
    private ChangeListener<Number> securityDepositAsDoubleListener;
    private ChangeListener<Boolean> buyerAsTakerWithoutDepositListener;
    private ChangeListener<Boolean> isWalletFundedListener;
    private ChangeListener<String> errorMessageListener;
    protected Offer offer;
    private boolean inputIsMarketBasedPrice;
    private ChangeListener<Boolean> useMarketBasedPriceListener;
    private boolean ignorePriceStringListener;
    private boolean ignoreVolumeStringListener;
    private boolean ignoreAmountStringListener;
    private boolean ignoreSecurityDepositStringListener;
    private MarketPrice marketPrice;
    final IntegerProperty marketPriceAvailableProperty = new SimpleIntegerProperty(-1);
    private ChangeListener<Number> currenciesUpdateListener;
    protected boolean syncMinAmountWithAmount = true;

    @Inject
    public MutableOfferViewModel(M dataModel, FiatVolumeValidator fiatVolumeValidator, AmountValidator4Decimals amountValidator4Decimals, AmountValidator8Decimals amountValidator8Decimals, XmrValidator xmrValidator, SecurityDepositValidator securityDepositValidator, PriceFeedService priceFeedService, AccountAgeWitnessService accountAgeWitnessService, Navigation navigation, Preferences preferences, @Named(value="BTC") CoinFormatter xmrFormatter, OfferUtil offerUtil) {
        super(dataModel);
        this.fiatVolumeValidator = fiatVolumeValidator;
        this.amountValidator4Decimals = amountValidator4Decimals;
        this.amountValidator8Decimals = amountValidator8Decimals;
        this.xmrValidator = xmrValidator;
        this.securityDepositValidator = securityDepositValidator;
        this.priceFeedService = priceFeedService;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.navigation = navigation;
        this.preferences = preferences;
        this.xmrFormatter = xmrFormatter;
        this.offerUtil = offerUtil;
        this.paymentLabel = Res.get((String)"createOffer.fundsBox.paymentLabel", (Object[])new Object[]{((MutableOfferDataModel)dataModel).shortOfferId});
        this.createListeners();
    }

    @Override
    public void activate() {
        if (DevEnv.isDevMode()) {
            UserThread.runAfter(() -> {
                this.amount.set((Object)"0.001");
                this.price.set((Object)"210000");
                this.minAmount.set((Object)((String)this.amount.get()));
                this.onFocusOutPriceAsPercentageTextField(true, false);
                this.applyMakerFee();
                this.setAmountToModel();
                this.setMinAmountToModel();
                this.setPriceToModel();
                ((MutableOfferDataModel)this.dataModel).calculateVolume();
                ((MutableOfferDataModel)this.dataModel).calculateTotalToPay();
                this.updateButtonDisableState();
                this.updateSpinnerInfo();
                this.setExtraInfoToModel();
            }, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        this.addBindings();
        this.addListeners();
        this.updateButtonDisableState();
        this.updateMarketPriceAvailable();
    }

    @Override
    protected void deactivate() {
        this.removeBindings();
        this.removeListeners();
    }

    private void addBindings() {
        if (((MutableOfferDataModel)this.dataModel).getDirection() == OfferDirection.BUY) {
            this.volumeDescriptionLabel.bind((ObservableValue)Bindings.createStringBinding(() -> Res.get((String)"createOffer.amountPriceBox.buy.volumeDescription", (Object[])new Object[]{((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode().get()}), (Observable[])new Observable[]{((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode()}));
        } else {
            this.volumeDescriptionLabel.bind((ObservableValue)Bindings.createStringBinding(() -> Res.get((String)"createOffer.amountPriceBox.sell.volumeDescription", (Object[])new Object[]{((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode().get()}), (Observable[])new Observable[]{((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode()}));
        }
        this.volumePromptLabel.bind((ObservableValue)Bindings.createStringBinding(() -> Res.get((String)"createOffer.volume.prompt", (Object[])new Object[]{CurrencyUtil.getCurrencyCodeBase((String)((String)((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode().get()))}), (Observable[])new Observable[]{((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode()}));
        this.totalToPay.bind((ObservableValue)Bindings.createStringBinding(() -> HavenoUtils.formatXmr((BigInteger)((BigInteger)((MutableOfferDataModel)this.dataModel).totalToPayAsProperty().get()), (boolean)true), (Observable[])new Observable[]{((MutableOfferDataModel)this.dataModel).totalToPayAsProperty()}));
        this.tradeAmount.bind((ObservableValue)Bindings.createStringBinding(() -> HavenoUtils.formatXmr((BigInteger)((BigInteger)((MutableOfferDataModel)this.dataModel).getAmount().get()), (boolean)true), (Observable[])new Observable[]{((MutableOfferDataModel)this.dataModel).getAmount()}));
        this.tradeCurrencyCode.bind((ObservableValue)((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode());
        this.triggerPriceDescription.bind((ObservableValue)Bindings.createStringBinding(this::getTriggerPriceDescriptionLabel, (Observable[])new Observable[]{((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode()}));
        this.percentagePriceDescription.bind((ObservableValue)Bindings.createStringBinding(this::getPercentagePriceDescription, (Observable[])new Observable[]{((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode()}));
    }

    private void removeBindings() {
        this.totalToPay.unbind();
        this.tradeAmount.unbind();
        this.tradeCurrencyCode.unbind();
        this.volumeDescriptionLabel.unbind();
        this.volumePromptLabel.unbind();
        this.triggerPriceDescription.unbind();
        this.percentagePriceDescription.unbind();
    }

    private void createListeners() {
        this.amountStringListener = (ov, oldValue, newValue) -> {
            if (!this.ignoreAmountStringListener) {
                if (this.isXmrInputValid((String)newValue).isValid) {
                    this.setAmountToModel();
                    ((MutableOfferDataModel)this.dataModel).calculateVolume();
                    ((MutableOfferDataModel)this.dataModel).calculateTotalToPay();
                }
                this.updateSecurityDeposit();
                this.updateButtonDisableState();
            }
        };
        this.minAmountStringListener = (ov, oldValue, newValue) -> {
            if (this.isXmrInputValid((String)newValue).isValid) {
                this.setMinAmountToModel();
            }
            this.updateButtonDisableState();
        };
        this.priceStringListener = (ov, oldValue, newValue) -> {
            this.updateMarketPriceAvailable();
            if (!this.ignorePriceStringListener && this.isPriceInputValid((String)newValue).isValid) {
                this.setPriceToModel();
                ((MutableOfferDataModel)this.dataModel).calculateVolume();
                ((MutableOfferDataModel)this.dataModel).calculateTotalToPay();
                if (!this.inputIsMarketBasedPrice) {
                    if (this.marketPrice != null && this.marketPrice.isRecentExternalPriceAvailable()) {
                        double marketPriceAsDouble = this.marketPrice.getPrice();
                        try {
                            double priceAsDouble = ParsingUtils.parseNumberStringToDouble((String)((String)this.price.get()));
                            double relation = priceAsDouble / marketPriceAsDouble;
                            OfferDirection compareDirection = OfferDirection.BUY;
                            double percentage = ((MutableOfferDataModel)this.dataModel).getDirection() == compareDirection ? 1.0 - relation : relation - 1.0;
                            percentage = MathUtils.roundDouble((double)percentage, (int)4);
                            ((MutableOfferDataModel)this.dataModel).setMarketPriceMarginPct(percentage);
                            this.marketPriceMargin.set((Object)FormattingUtils.formatToPercent((double)percentage));
                            this.applyMakerFee();
                        }
                        catch (NumberFormatException t) {
                            this.marketPriceMargin.set((Object)"");
                            ((Popup)new Popup().warning(Res.get((String)"validation.NaN"))).show();
                        }
                    } else {
                        log.debug("We don't have a market price. We use the static price instead.");
                    }
                }
            }
            this.updateButtonDisableState();
        };
        this.marketPriceMarginStringListener = (ov, oldValue, newValue) -> {
            if (this.inputIsMarketBasedPrice) {
                try {
                    if (!newValue.isEmpty() && !newValue.equals("-")) {
                        double percentage = ParsingUtils.parsePercentStringToDouble((String)newValue);
                        if (percentage >= 1.0 || percentage <= -1.0) {
                            ((Popup)new Popup().warning(Res.get((String)"popup.warning.tooLargePercentageValue") + "\n" + Res.get((String)"popup.warning.examplePercentageValue"))).show();
                        } else {
                            String currencyCode = (String)((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode().get();
                            MarketPrice marketPrice = this.priceFeedService.getMarketPrice(currencyCode);
                            if (marketPrice != null && marketPrice.isRecentExternalPriceAvailable()) {
                                percentage = MathUtils.roundDouble((double)percentage, (int)4);
                                double marketPriceAsDouble = marketPrice.getPrice();
                                OfferDirection compareDirection = OfferDirection.BUY;
                                double factor = ((MutableOfferDataModel)this.dataModel).getDirection() == compareDirection ? 1.0 - percentage : 1.0 + percentage;
                                double targetPrice = marketPriceAsDouble * factor;
                                int precision = CurrencyUtil.isTraditionalCurrency((String)currencyCode) ? 8 : 8;
                                this.ignorePriceStringListener = true;
                                this.price.set((Object)FormattingUtils.formatRoundedDoubleWithPrecision((double)targetPrice, (int)precision));
                                this.ignorePriceStringListener = false;
                                this.setPriceToModel();
                                ((MutableOfferDataModel)this.dataModel).setMarketPriceMarginPct(percentage);
                                ((MutableOfferDataModel)this.dataModel).calculateVolume();
                                ((MutableOfferDataModel)this.dataModel).calculateTotalToPay();
                                this.updateButtonDisableState();
                                this.applyMakerFee();
                            } else {
                                this.marketPriceMargin.set((Object)"");
                                String id = "showNoPriceFeedAvailablePopup";
                                if (this.preferences.showAgain(id)) {
                                    ((Popup)((Popup)new Popup().warning(Res.get((String)"popup.warning.noPriceFeedAvailable"))).dontShowAgainId(id)).show();
                                }
                            }
                        }
                    }
                }
                catch (NumberFormatException t) {
                    log.error(t.toString());
                    t.printStackTrace();
                    ((Popup)new Popup().warning(Res.get((String)"validation.NaN"))).show();
                }
                catch (Throwable t) {
                    log.error(t.toString());
                    t.printStackTrace();
                    ((Popup)new Popup().warning(Res.get((String)"validation.inputError", (Object[])new Object[]{t.toString()}))).show();
                }
            }
        };
        this.useMarketBasedPriceListener = (observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.priceValidationResult.set((Object)new InputValidator.ValidationResult(true));
            }
        };
        this.volumeStringListener = (ov, oldValue, newValue) -> {
            if (!this.ignoreVolumeStringListener) {
                if (this.isVolumeInputValid((String)newValue).isValid) {
                    this.setVolumeToModel();
                    this.setPriceToModel();
                    ((MutableOfferDataModel)this.dataModel).calculateAmount();
                    ((MutableOfferDataModel)this.dataModel).calculateTotalToPay();
                }
                this.updateButtonDisableState();
            }
        };
        this.securityDepositStringListener = (ov, oldValue, newValue) -> {
            if (!this.ignoreSecurityDepositStringListener) {
                if (this.securityDepositValidator.validate((String)newValue).isValid) {
                    this.setSecurityDepositToModel();
                    ((MutableOfferDataModel)this.dataModel).calculateTotalToPay();
                }
                this.updateButtonDisableState();
            }
        };
        this.amountListener = (ov, oldValue, newValue) -> {
            if (newValue != null) {
                this.amount.set((Object)HavenoUtils.formatXmr((BigInteger)newValue));
                this.securityDepositInXMR.set((Object)HavenoUtils.formatXmr((BigInteger)((MutableOfferDataModel)this.dataModel).getSecurityDeposit(), (boolean)true));
            } else {
                this.amount.set((Object)"");
                this.securityDepositInXMR.set((Object)"");
            }
            this.applyMakerFee();
        };
        this.minAmountListener = (ov, oldValue, newValue) -> {
            if (newValue != null) {
                this.minAmount.set((Object)HavenoUtils.formatXmr((BigInteger)newValue));
            } else {
                this.minAmount.set((Object)"");
            }
        };
        this.priceListener = (ov, oldValue, newValue) -> {
            this.ignorePriceStringListener = true;
            if (newValue != null) {
                this.price.set((Object)FormattingUtils.formatPrice((Price)newValue));
            } else {
                this.price.set((Object)"");
            }
            this.ignorePriceStringListener = false;
            this.applyMakerFee();
        };
        this.volumeListener = (ov, oldValue, newValue) -> {
            this.ignoreVolumeStringListener = true;
            if (newValue != null) {
                this.volume.set((Object)VolumeUtil.formatVolume((Volume)newValue));
            } else {
                this.volume.set((Object)"");
            }
            this.ignoreVolumeStringListener = false;
            this.applyMakerFee();
        };
        this.securityDepositAsDoubleListener = (ov, oldValue, newValue) -> {
            if (newValue != null) {
                this.securityDeposit.set((Object)FormattingUtils.formatToPercent((double)((Double)newValue)));
                if (((MutableOfferDataModel)this.dataModel).getAmount().get() != null) {
                    this.securityDepositInXMR.set((Object)HavenoUtils.formatXmr((BigInteger)((MutableOfferDataModel)this.dataModel).getSecurityDeposit(), (boolean)true));
                }
                this.updateSecurityDeposit();
            } else {
                this.securityDeposit.set((Object)"");
                this.securityDepositInXMR.set((Object)"");
            }
        };
        this.buyerAsTakerWithoutDepositListener = (ov, oldValue, newValue) -> {
            if (((MutableOfferDataModel)this.dataModel).paymentAccount != null) {
                this.xmrValidator.setMaxValue(((MutableOfferDataModel)this.dataModel).paymentAccount.getPaymentMethod().getMaxTradeLimit((String)((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode().get()));
            }
            this.xmrValidator.setMaxTradeLimit(((MutableOfferDataModel)this.dataModel).getMaxTradeLimit());
            this.xmrValidator.setMinValue(((MutableOfferDataModel)this.dataModel).getMinTradeLimit());
            if (this.amount.get() != null) {
                this.amountValidationResult.set((Object)this.isXmrInputValid((String)this.amount.get()));
            }
            this.updateSecurityDeposit();
            this.setSecurityDepositToModel();
            this.onFocusOutSecurityDepositTextField(true, false);
            this.applyMakerFee();
            ((MutableOfferDataModel)this.dataModel).calculateTotalToPay();
            this.updateButtonDisableState();
        };
        this.extraInfoStringListener = (ov, oldValue, newValue) -> {
            if (newValue != null) {
                this.extraInfo.set((Object)newValue.trim());
                UserThread.execute(() -> this.onExtraInfoTextAreaChanged());
            }
        };
        this.isWalletFundedListener = (ov, oldValue, newValue) -> this.updateButtonDisableState();
        this.currenciesUpdateListener = (observable, oldValue, newValue) -> {
            this.updateMarketPriceAvailable();
            this.updateButtonDisableState();
        };
    }

    private void applyMakerFee() {
        this.tradeFeeCurrencyCode.set((Object)Res.getBaseCurrencyCode());
        this.tradeFeeDescription.set((Object)Res.get((String)"createOffer.tradeFee.descriptionXMROnly"));
        BigInteger makerFee = ((MutableOfferDataModel)this.dataModel).getMaxMakerFee();
        if (makerFee == null) {
            return;
        }
        this.isTradeFeeVisible.setValue(Boolean.valueOf(true));
        this.tradeFee.set((Object)HavenoUtils.formatXmr((BigInteger)makerFee));
        this.tradeFeeInXmrWithFiat.set((Object)OfferViewModelUtil.getTradeFeeWithFiatEquivalent(this.offerUtil, ((MutableOfferDataModel)this.dataModel).getMaxMakerFee(), this.xmrFormatter));
    }

    private void updateMarketPriceAvailable() {
        this.marketPrice = this.priceFeedService.getMarketPrice((String)((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode().get());
        this.marketPriceAvailableProperty.set(this.marketPrice == null || !this.marketPrice.isExternallyProvidedPrice() ? 0 : 1);
        ((MutableOfferDataModel)this.dataModel).setMarketPriceAvailable(this.marketPrice != null && this.marketPrice.isExternallyProvidedPrice());
    }

    private void addListeners() {
        this.amount.addListener(this.amountStringListener);
        this.minAmount.addListener(this.minAmountStringListener);
        this.price.addListener(this.priceStringListener);
        this.marketPriceMargin.addListener(this.marketPriceMarginStringListener);
        ((MutableOfferDataModel)this.dataModel).getUseMarketBasedPrice().addListener(this.useMarketBasedPriceListener);
        this.volume.addListener(this.volumeStringListener);
        this.securityDeposit.addListener(this.securityDepositStringListener);
        this.extraInfo.addListener(this.extraInfoStringListener);
        ((MutableOfferDataModel)this.dataModel).getAmount().addListener(this.amountListener);
        ((MutableOfferDataModel)this.dataModel).getMinAmount().addListener(this.minAmountListener);
        ((MutableOfferDataModel)this.dataModel).getPrice().addListener(this.priceListener);
        ((MutableOfferDataModel)this.dataModel).getVolume().addListener(this.volumeListener);
        ((MutableOfferDataModel)this.dataModel).getSecurityDepositPct().addListener(this.securityDepositAsDoubleListener);
        ((MutableOfferDataModel)this.dataModel).getBuyerAsTakerWithoutDeposit().addListener(this.buyerAsTakerWithoutDepositListener);
        ((MutableOfferDataModel)this.dataModel).getExtraInfo().addListener(this.extraInfoStringListener);
        ((MutableOfferDataModel)this.dataModel).getIsXmrWalletFunded().addListener(this.isWalletFundedListener);
        this.priceFeedService.updateCounterProperty().addListener(this.currenciesUpdateListener);
    }

    private void removeListeners() {
        this.amount.removeListener(this.amountStringListener);
        this.minAmount.removeListener(this.minAmountStringListener);
        this.price.removeListener(this.priceStringListener);
        this.marketPriceMargin.removeListener(this.marketPriceMarginStringListener);
        ((MutableOfferDataModel)this.dataModel).getUseMarketBasedPrice().removeListener(this.useMarketBasedPriceListener);
        this.volume.removeListener(this.volumeStringListener);
        this.securityDeposit.removeListener(this.securityDepositStringListener);
        this.extraInfo.removeListener(this.extraInfoStringListener);
        ((MutableOfferDataModel)this.dataModel).getAmount().removeListener(this.amountListener);
        ((MutableOfferDataModel)this.dataModel).getMinAmount().removeListener(this.minAmountListener);
        ((MutableOfferDataModel)this.dataModel).getPrice().removeListener(this.priceListener);
        ((MutableOfferDataModel)this.dataModel).getVolume().removeListener(this.volumeListener);
        ((MutableOfferDataModel)this.dataModel).getSecurityDepositPct().removeListener(this.securityDepositAsDoubleListener);
        ((MutableOfferDataModel)this.dataModel).getBuyerAsTakerWithoutDeposit().removeListener(this.buyerAsTakerWithoutDepositListener);
        ((MutableOfferDataModel)this.dataModel).getExtraInfo().removeListener(this.extraInfoStringListener);
        ((MutableOfferDataModel)this.dataModel).getIsXmrWalletFunded().removeListener(this.isWalletFundedListener);
        if (this.offer != null && this.errorMessageListener != null) {
            this.offer.getErrorMessageProperty().removeListener(this.errorMessageListener);
        }
        this.priceFeedService.updateCounterProperty().removeListener(this.currenciesUpdateListener);
    }

    boolean initWithData(OfferDirection direction, TradeCurrency tradeCurrency, boolean initAddressEntry) {
        boolean result = ((MutableOfferDataModel)this.dataModel).initWithData(direction, tradeCurrency, initAddressEntry);
        if (((MutableOfferDataModel)this.dataModel).getAddressEntry() != null) {
            this.addressAsString = ((MutableOfferDataModel)this.dataModel).getAddressEntry().getAddressString();
        }
        if (((MutableOfferDataModel)this.dataModel).paymentAccount != null) {
            this.xmrValidator.setMaxValue(((MutableOfferDataModel)this.dataModel).paymentAccount.getPaymentMethod().getMaxTradeLimit((String)((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode().get()));
        }
        this.xmrValidator.setMaxTradeLimit(((MutableOfferDataModel)this.dataModel).getMaxTradeLimit());
        this.xmrValidator.setMinValue(((MutableOfferDataModel)this.dataModel).getMinTradeLimit());
        boolean isBuy = ((MutableOfferDataModel)this.dataModel).getDirection() == OfferDirection.BUY;
        this.amountDescription = Res.get((String)"createOffer.amountPriceBox.amountDescription", (Object[])new Object[]{isBuy ? Res.get((String)"shared.buy") : Res.get((String)"shared.sell")});
        this.securityDepositValidator.setPaymentAccount(((MutableOfferDataModel)this.dataModel).paymentAccount);
        this.validateAndSetSecurityDepositToModel();
        this.securityDeposit.set((Object)FormattingUtils.formatToPercent((double)((MutableOfferDataModel)this.dataModel).getSecurityDepositPct().get()));
        this.securityDepositLabel.set((Object)this.getSecurityDepositLabel());
        this.applyMakerFee();
        return result;
    }

    void onPlaceOffer(Offer offer, Runnable resultHandler) {
        ThreadUtils.execute(() -> {
            this.errorMessage.set(null);
            this.createOfferInProgress = true;
            this.createOfferCanceled = false;
            ((MutableOfferDataModel)this.dataModel).onPlaceOffer(offer, transaction -> {
                this.createOfferInProgress = false;
                resultHandler.run();
                if (!this.createOfferCanceled) {
                    this.placeOfferCompleted.set(true);
                }
                this.errorMessage.set(null);
            }, errMessage -> {
                this.createOfferInProgress = false;
                if (offer.getState() == Offer.State.OFFER_FEE_RESERVED) {
                    this.errorMessage.set((Object)(errMessage + Res.get((String)"createOffer.errorInfo")));
                } else {
                    this.errorMessage.set((Object)errMessage);
                }
                UserThread.execute(() -> {
                    this.updateButtonDisableState();
                    this.updateSpinnerInfo();
                    resultHandler.run();
                });
            });
            UserThread.execute(() -> {
                this.updateButtonDisableState();
                this.updateSpinnerInfo();
            });
        }, (String)this.getClass().getSimpleName());
    }

    public void onCancelOffer(ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        log.info("Canceling posting offer {}", (Object)this.offer.getId());
        this.createOfferCanceled = true;
        OpenOfferManager openOfferManager = HavenoUtils.openOfferManager;
        Optional openOffer = openOfferManager.getOpenOffer(this.offer.getId());
        if (!openOffer.isPresent()) {
            if (resultHandler != null) {
                resultHandler.handleResult();
            }
            return;
        }
        openOfferManager.cancelOpenOffer((OpenOffer)openOffer.get(), () -> {
            UserThread.execute(() -> {
                this.updateButtonDisableState();
                this.updateSpinnerInfo();
            });
            if (resultHandler != null) {
                resultHandler.handleResult();
            }
        }, errorMessage -> UserThread.execute(() -> {
            this.updateButtonDisableState();
            this.updateSpinnerInfo();
            if (errorMessageHandler != null) {
                errorMessageHandler.handleErrorMessage(errorMessage);
            }
        }));
    }

    public void onPaymentAccountSelected(PaymentAccount paymentAccount) {
        ((MutableOfferDataModel)this.dataModel).onPaymentAccountSelected(paymentAccount);
        if (this.amount.get() != null) {
            this.amountValidationResult.set((Object)this.isXmrInputValid((String)this.amount.get()));
        }
        this.xmrValidator.setMaxValue(((MutableOfferDataModel)this.dataModel).paymentAccount.getPaymentMethod().getMaxTradeLimit((String)((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode().get()));
        this.xmrValidator.setMaxTradeLimit(((MutableOfferDataModel)this.dataModel).getMaxTradeLimit());
        this.securityDepositValidator.setPaymentAccount(paymentAccount);
    }

    public void onCurrencySelected(TradeCurrency tradeCurrency) {
        ((MutableOfferDataModel)this.dataModel).onCurrencySelected(tradeCurrency);
        this.marketPrice = this.priceFeedService.getMarketPrice((String)((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode().get());
        this.marketPriceAvailableProperty.set(this.marketPrice == null || !this.marketPrice.isExternallyProvidedPrice() ? 0 : 1);
        this.updateButtonDisableState();
    }

    void onShowPayFundsScreen(Runnable actionHandler) {
        actionHandler.run();
        this.showPayFundsScreenDisplayed.set(true);
        this.updateSpinnerInfo();
    }

    void fundFromSavingsWallet() {
        ((MutableOfferDataModel)this.dataModel).fundFromSavingsWallet();
        if (((MutableOfferDataModel)this.dataModel).getIsXmrWalletFunded().get()) {
            this.updateButtonDisableState();
        } else {
            ((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"shared.notEnoughFunds", (Object[])new Object[]{HavenoUtils.formatXmr((BigInteger)((BigInteger)((MutableOfferDataModel)this.dataModel).totalToPayAsProperty().get()), (boolean)true), HavenoUtils.formatXmr((BigInteger)((MutableOfferDataModel)this.dataModel).getTotalBalance(), (boolean)true)}))).actionButtonTextWithGoTo("funds.tab.deposit")).onAction(() -> this.navigation.navigateTo(MainView.class, FundsView.class, DepositView.class))).show();
        }
    }

    void onFocusOutAmountTextField(boolean oldValue, boolean newValue) {
        if (oldValue && !newValue) {
            InputValidator.ValidationResult result = this.isXmrInputValid((String)this.amount.get());
            this.amountValidationResult.set((Object)result);
            if (result.isValid) {
                this.setAmountToModel();
                this.ignoreAmountStringListener = true;
                this.amount.set((Object)HavenoUtils.formatXmr((BigInteger)((BigInteger)((MutableOfferDataModel)this.dataModel).getAmount().get())));
                this.ignoreAmountStringListener = false;
                ((MutableOfferDataModel)this.dataModel).calculateVolume();
                if (!((MutableOfferDataModel)this.dataModel).isMinAmountLessOrEqualAmount()) {
                    this.minAmount.set((Object)((String)this.amount.get()));
                } else {
                    this.amountValidationResult.set((Object)result);
                }
                if (this.minAmount.get() != null) {
                    this.minAmountValidationResult.set((Object)this.isXmrInputValid((String)this.minAmount.get()));
                }
            } else if (this.amount.get() != null && this.xmrValidator.getMaxTradeLimit() != null && this.xmrValidator.getMaxTradeLimit().longValueExact() == OfferRestrictions.TOLERATED_SMALL_TRADE_AMOUNT.longValueExact()) {
                if (ParsingUtils.parseNumberStringToDouble((String)((String)this.amount.get())) < HavenoUtils.atomicUnitsToXmr((BigInteger)((MutableOfferDataModel)this.dataModel).getMinTradeLimit())) {
                    this.amountValidationResult.set((Object)result);
                } else {
                    boolean isSellerWithinReleaseWindow;
                    this.amount.set((Object)HavenoUtils.formatXmr((BigInteger)this.xmrValidator.getMaxTradeLimit()));
                    boolean isBuy = ((MutableOfferDataModel)this.dataModel).getDirection() == OfferDirection.BUY;
                    boolean bl = isSellerWithinReleaseWindow = !isBuy && HavenoUtils.isReleasedWithinDays((int)60);
                    if (isSellerWithinReleaseWindow) {
                        Date releaseDate = HavenoUtils.getReleaseDate();
                        Calendar c = Calendar.getInstance();
                        c.setTime(releaseDate);
                        c.add(5, 60);
                        Date releaseDatePlusDays = c.getTime();
                        SimpleDateFormat formatter = new SimpleDateFormat("MMMM d, yyyy");
                        String releaseDatePlusDaysAsString = formatter.format(releaseDatePlusDays);
                        ((Popup)((Popup)new Popup().information(Res.get((String)"popup.warning.tradeLimitDueAccountAgeRestriction.seller.releaseLimit", (Object[])new Object[]{HavenoUtils.formatXmr((BigInteger)OfferRestrictions.TOLERATED_SMALL_TRADE_AMOUNT, (boolean)true), releaseDatePlusDaysAsString, Res.get((String)"offerbook.warning.newVersionAnnouncement")}))).width(900.0)).show();
                    } else {
                        ((Popup)((Popup)new Popup().information(Res.get((String)(isBuy ? "popup.warning.tradeLimitDueAccountAgeRestriction.buyer" : "popup.warning.tradeLimitDueAccountAgeRestriction.seller"), (Object[])new Object[]{HavenoUtils.formatXmr((BigInteger)OfferRestrictions.TOLERATED_SMALL_TRADE_AMOUNT, (boolean)true), Res.get((String)"offerbook.warning.newVersionAnnouncement")}))).width(900.0)).show();
                    }
                }
            }
            UserThread.execute(() -> {
                this.onFocusOutVolumeTextField(true, false);
                this.onFocusOutMinAmountTextField(true, false);
            });
            if (this.marketPriceMargin.get() == null && this.amount.get() != null && this.volume.get() != null) {
                this.updateMarketPriceToManual();
            }
        }
    }

    public void onFocusOutMinAmountTextField(boolean oldValue, boolean newValue) {
        if (oldValue && !newValue) {
            InputValidator.ValidationResult result = this.isXmrInputValid((String)this.minAmount.get());
            this.minAmountValidationResult.set((Object)result);
            if (result.isValid) {
                BigInteger minAmount = (BigInteger)((MutableOfferDataModel)this.dataModel).getMinAmount().get();
                this.syncMinAmountWithAmount = minAmount != null && minAmount.equals(((MutableOfferDataModel)this.dataModel).getAmount().get());
                this.setMinAmountToModel();
                ((MutableOfferDataModel)this.dataModel).calculateMinVolume();
                if (((MutableOfferDataModel)this.dataModel).getMinVolume().get() != null) {
                    InputValidator.ValidationResult minVolumeResult = this.isVolumeInputValid(VolumeUtil.formatVolume((Volume)((Volume)((MutableOfferDataModel)this.dataModel).getMinVolume().get())));
                    this.volumeValidationResult.set((Object)minVolumeResult);
                    this.updateButtonDisableState();
                }
                this.minAmount.set((Object)HavenoUtils.formatXmr((BigInteger)minAmount));
                if (!((MutableOfferDataModel)this.dataModel).isMinAmountLessOrEqualAmount()) {
                    this.amount.set((Object)((String)this.minAmount.get()));
                } else {
                    this.minAmountValidationResult.set((Object)result);
                    if (this.amount.get() != null) {
                        this.amountValidationResult.set((Object)this.isXmrInputValid((String)this.amount.get()));
                    }
                }
            } else {
                this.syncMinAmountWithAmount = true;
            }
            UserThread.execute(() -> this.onFocusOutSecurityDepositTextField(true, false));
        }
    }

    public void onFocusOutExtraInfoTextArea(boolean oldValue, boolean newValue) {
        if (oldValue && !newValue) {
            this.onExtraInfoTextAreaChanged();
        }
    }

    public void onExtraInfoTextAreaChanged() {
        this.extraInfoValidationResult.set((Object)this.getExtraInfoValidationResult());
        this.updateButtonDisableState();
        if (((InputValidator.ValidationResult)this.extraInfoValidationResult.get()).isValid) {
            this.setExtraInfoToModel();
        }
    }

    void onFocusOutTriggerPriceTextField(boolean oldValue, boolean newValue) {
        if (oldValue && !newValue) {
            this.onTriggerPriceTextFieldChanged();
        }
    }

    public void onTriggerPriceTextFieldChanged() {
        String triggerPriceAsString = (String)this.triggerPrice.get();
        this.triggerPriceValidationResult.set((Object)new InputValidator.ValidationResult(true));
        String currencyCode = (String)((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode().get();
        MarketPrice marketPrice = this.priceFeedService.getMarketPrice(currencyCode);
        InputValidator.ValidationResult result = PriceUtil.isTriggerPriceValid((String)triggerPriceAsString, (MarketPrice)marketPrice, (boolean)((MutableOfferDataModel)this.dataModel).isSellOffer(), (String)((MutableOfferDataModel)this.dataModel).getCurrencyCode());
        this.triggerPriceValidationResult.set((Object)result);
        this.updateButtonDisableState();
        if (result.isValid) {
            long triggerPriceAsLong = PriceUtil.getMarketPriceAsLong((String)triggerPriceAsString, (String)((MutableOfferDataModel)this.dataModel).getCurrencyCode());
            ((MutableOfferDataModel)this.dataModel).setTriggerPrice(triggerPriceAsLong);
            if (((MutableOfferDataModel)this.dataModel).getTriggerPrice() == 0L) {
                this.triggerPrice.set((Object)"");
            } else {
                this.triggerPrice.set((Object)PriceUtil.formatMarketPrice((long)((MutableOfferDataModel)this.dataModel).getTriggerPrice(), (String)((MutableOfferDataModel)this.dataModel).getCurrencyCode()));
            }
        }
    }

    public void onReserveExactAmountCheckboxChanged() {
        ((MutableOfferDataModel)this.dataModel).setReserveExactAmount(this.reserveExactAmount.get());
    }

    void onFixPriceToggleChange(boolean fixedPriceSelected) {
        this.inputIsMarketBasedPrice = !fixedPriceSelected;
        this.updateButtonDisableState();
        if (!fixedPriceSelected) {
            this.onTriggerPriceTextFieldChanged();
        }
    }

    void onFocusOutPriceTextField(boolean oldValue, boolean newValue) {
        if (oldValue && !newValue) {
            InputValidator.ValidationResult result = this.isPriceInputValid((String)this.price.get());
            this.priceValidationResult.set((Object)result);
            if (result.isValid) {
                this.setPriceToModel();
                this.ignorePriceStringListener = true;
                if (((MutableOfferDataModel)this.dataModel).getPrice().get() != null) {
                    this.price.set((Object)FormattingUtils.formatPrice((Price)((Price)((MutableOfferDataModel)this.dataModel).getPrice().get())));
                }
                this.ignorePriceStringListener = false;
                ((MutableOfferDataModel)this.dataModel).calculateVolume();
                ((MutableOfferDataModel)this.dataModel).calculateAmount();
                this.applyMakerFee();
            }
            UserThread.execute(() -> {
                this.onFocusOutVolumeTextField(true, false);
                this.triggerFocusOutOnAmountFields();
            });
        }
    }

    public void triggerFocusOutOnAmountFields() {
        this.onFocusOutAmountTextField(true, false);
        this.onFocusOutMinAmountTextField(true, false);
    }

    public void onFocusOutPriceAsPercentageTextField(boolean oldValue, boolean newValue) {
        boolean bl = this.inputIsMarketBasedPrice = !oldValue && newValue;
        if (oldValue && !newValue) {
            if (this.marketPriceMargin.get() == null) {
                this.inputIsMarketBasedPrice = true;
            }
            this.marketPriceMargin.set((Object)FormattingUtils.formatRoundedDoubleWithPrecision((double)(((MutableOfferDataModel)this.dataModel).getMarketPriceMarginPct() * 100.0), (int)2));
        }
        UserThread.execute(() -> {
            this.onFocusOutVolumeTextField(true, false);
            this.onTriggerPriceTextFieldChanged();
        });
    }

    void onFocusOutVolumeTextField(boolean oldValue, boolean newValue) {
        if (oldValue && !newValue) {
            InputValidator.ValidationResult result = this.isVolumeInputValid((String)this.volume.get());
            this.volumeValidationResult.set((Object)result);
            if (result.isValid) {
                this.setVolumeToModel();
                this.ignoreVolumeStringListener = true;
                Volume volume = (Volume)((MutableOfferDataModel)this.dataModel).getVolume().get();
                if (volume != null) {
                    volume = VolumeUtil.getAdjustedVolume((Volume)volume, (String)((MutableOfferDataModel)this.dataModel).getPaymentAccount().getPaymentMethod().getId());
                    this.volume.set((Object)VolumeUtil.formatVolume((Volume)volume));
                }
                this.ignoreVolumeStringListener = false;
                ((MutableOfferDataModel)this.dataModel).calculateAmount();
                if (!((MutableOfferDataModel)this.dataModel).isMinAmountLessOrEqualAmount()) {
                    this.minAmount.set((Object)this.amount.getValue());
                } else {
                    if (this.amount.get() != null) {
                        this.amountValidationResult.set((Object)this.isXmrInputValid((String)this.amount.get()));
                    }
                    if (this.amountValidationResult.getValue() != null && ((InputValidator.ValidationResult)this.amountValidationResult.getValue()).isValid && this.minAmount.get() != null) {
                        this.minAmountValidationResult.set((Object)this.isXmrInputValid((String)this.minAmount.get()));
                    }
                }
            }
            if (this.marketPriceMargin.get() == null && this.amount.get() != null && this.volume.get() != null) {
                this.updateMarketPriceToManual();
            }
            UserThread.execute(() -> this.onFocusOutSecurityDepositTextField(true, false));
        }
    }

    void onFocusOutSecurityDepositTextField(boolean oldValue, boolean newValue) {
        if (oldValue && !newValue && !this.isMinSecurityDeposit.get()) {
            InputValidator.ValidationResult result = this.securityDepositValidator.validate((String)this.securityDeposit.get());
            this.securityDepositValidationResult.set((Object)result);
            if (result.isValid) {
                double defaultSecurityDeposit = Restrictions.getDefaultSecurityDepositPct();
                String key = "buyerSecurityDepositIsLowerAsDefault";
                double depositAsDouble = ParsingUtils.parsePercentStringToDouble((String)((String)this.securityDeposit.get()));
                if (this.preferences.showAgain(key) && depositAsDouble < defaultSecurityDeposit) {
                    String postfix = ((MutableOfferDataModel)this.dataModel).isBuyOffer() ? Res.get((String)"createOffer.tooLowSecDeposit.makerIsBuyer") : Res.get((String)"createOffer.tooLowSecDeposit.makerIsSeller");
                    ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"createOffer.tooLowSecDeposit.warning", (Object[])new Object[]{FormattingUtils.formatToPercentWithSymbol((double)defaultSecurityDeposit)}) + "\n\n" + postfix)).width(800.0)).actionButtonText(Res.get((String)"createOffer.resetToDefault"))).onAction(() -> {
                        ((MutableOfferDataModel)this.dataModel).setSecurityDepositPct(defaultSecurityDeposit);
                        this.ignoreSecurityDepositStringListener = true;
                        this.securityDeposit.set((Object)FormattingUtils.formatToPercent((double)((MutableOfferDataModel)this.dataModel).getSecurityDepositPct().get()));
                        this.ignoreSecurityDepositStringListener = false;
                    })).closeButtonText(Res.get((String)"createOffer.useLowerValue"))).onClose(this::applySecurityDepositOnFocusOut)).dontShowAgainId(key)).show();
                } else {
                    this.applySecurityDepositOnFocusOut();
                }
            }
        }
    }

    private void applySecurityDepositOnFocusOut() {
        this.setSecurityDepositToModel();
        this.ignoreSecurityDepositStringListener = true;
        this.securityDeposit.set((Object)FormattingUtils.formatToPercent((double)((MutableOfferDataModel)this.dataModel).getSecurityDepositPct().get()));
        this.ignoreSecurityDepositStringListener = false;
    }

    public boolean isPriceInRange() {
        if (this.marketPriceMargin.get() != null && !((String)this.marketPriceMargin.get()).isEmpty()) {
            if (Math.abs(ParsingUtils.parsePercentStringToDouble((String)((String)this.marketPriceMargin.get()))) > this.preferences.getMaxPriceDistanceInPercent()) {
                this.displayPriceOutOfRangePopup();
                return false;
            }
            return true;
        }
        return true;
    }

    private void displayPriceOutOfRangePopup() {
        Popup popup = new Popup();
        ((Popup)((Popup)((Popup)((Popup)((Popup)popup.warning(Res.get((String)"createOffer.priceOutSideOfDeviation", (Object[])new Object[]{FormattingUtils.formatToPercentWithSymbol((double)this.preferences.getMaxPriceDistanceInPercent())}))).actionButtonText(Res.get((String)"createOffer.changePrice"))).onAction(popup::hide)).closeButtonTextWithGoTo("settings.tab.preferences")).onClose(() -> this.navigation.navigateTo(MainView.class, SettingsView.class, PreferencesView.class))).show();
    }

    CoinFormatter getXmrFormatter() {
        return this.xmrFormatter;
    }

    public boolean isShownAsBuyOffer() {
        return OfferViewUtil.isShownAsBuyOffer(((MutableOfferDataModel)this.dataModel).getDirection(), ((MutableOfferDataModel)this.dataModel).getTradeCurrency());
    }

    public boolean isSellOffer() {
        return ((MutableOfferDataModel)this.dataModel).getDirection() == OfferDirection.SELL;
    }

    public TradeCurrency getTradeCurrency() {
        return ((MutableOfferDataModel)this.dataModel).getTradeCurrency();
    }

    public String getTradeAmount() {
        return OfferViewModelUtil.getTradeFeeWithFiatEquivalent(this.offerUtil, (BigInteger)((MutableOfferDataModel)this.dataModel).getAmount().get(), this.xmrFormatter);
    }

    public String getSecurityDepositLabel() {
        return ((MutableOfferDataModel)this.dataModel).buyerAsTakerWithoutDeposit.get() && ((MutableOfferDataModel)this.dataModel).isSellOffer() ? Res.get((String)"createOffer.myDeposit") : (((MutableOfferDataModel)this.dataModel).isMinSecurityDeposit() ? Res.get((String)"createOffer.minSecurityDepositUsed") : Res.get((String)"createOffer.setDepositForBothTraders"));
    }

    public String getSecurityDepositPopOverLabel(String depositInXMR) {
        return ((MutableOfferDataModel)this.dataModel).buyerAsTakerWithoutDeposit.get() && ((MutableOfferDataModel)this.dataModel).isSellOffer() ? Res.get((String)"createOffer.myDepositInfo", (Object[])new Object[]{depositInXMR}) : (((MutableOfferDataModel)this.dataModel).isBuyOffer() ? Res.get((String)"createOffer.securityDepositInfoAsBuyer", (Object[])new Object[]{depositInXMR}) : Res.get((String)"createOffer.securityDepositInfo", (Object[])new Object[]{depositInXMR}));
    }

    public String getSecurityDepositInfo() {
        return OfferViewModelUtil.getTradeFeeWithFiatEquivalentAndPercentage(this.offerUtil, ((MutableOfferDataModel)this.dataModel).getSecurityDeposit(), (BigInteger)((MutableOfferDataModel)this.dataModel).getAmount().get(), this.xmrFormatter);
    }

    public String getSecurityDepositWithCode() {
        return HavenoUtils.formatXmr((BigInteger)((MutableOfferDataModel)this.dataModel).getSecurityDeposit(), (boolean)true);
    }

    public String getTradeFee() {
        return OfferViewModelUtil.getTradeFeeWithFiatEquivalentAndPercentage(this.offerUtil, ((MutableOfferDataModel)this.dataModel).getMaxMakerFee(), (BigInteger)((MutableOfferDataModel)this.dataModel).getAmount().get(), this.xmrFormatter);
    }

    public String getMakerFeePercentage() {
        BigInteger makerFee = ((MutableOfferDataModel)this.dataModel).getMaxMakerFee();
        return GUIUtil.getPercentage(makerFee, (BigInteger)((MutableOfferDataModel)this.dataModel).getAmount().get());
    }

    public String getTotalToPayInfo() {
        return OfferViewModelUtil.getTradeFeeWithFiatEquivalent(this.offerUtil, (BigInteger)((MutableOfferDataModel)this.dataModel).totalToPay.get(), this.xmrFormatter);
    }

    public String getFundsStructure() {
        String fundsStructure = Res.get((String)"createOffer.fundsBox.fundsStructure", (Object[])new Object[]{this.getSecurityDepositWithCode(), this.getMakerFeePercentage()});
        return fundsStructure;
    }

    public PaymentAccount getPaymentAccount() {
        return ((MutableOfferDataModel)this.dataModel).getPaymentAccount();
    }

    public String getAmountDescription() {
        return this.amountDescription;
    }

    public String getAddressAsString() {
        return this.addressAsString;
    }

    public String getPaymentLabel() {
        return this.paymentLabel;
    }

    public Offer createAndGetOffer() {
        this.offer = ((MutableOfferDataModel)this.dataModel).createAndGetOffer();
        return this.offer;
    }

    public Callback<ListView<PaymentAccount>, ListCell<PaymentAccount>> getPaymentAccountListCellFactory(ComboBox<PaymentAccount> paymentAccountsComboBox) {
        return GUIUtil.getPaymentAccountListCellFactory(paymentAccountsComboBox, this.accountAgeWitnessService);
    }

    public M getDataModel() {
        return (M)((MutableOfferDataModel)this.dataModel);
    }

    String getTriggerPriceDescriptionLabel() {
        String details = ((MutableOfferDataModel)this.dataModel).isBuyOffer() ? Res.get((String)"account.notifications.marketAlert.message.msg.above") : Res.get((String)"account.notifications.marketAlert.message.msg.below");
        return Res.get((String)"createOffer.triggerPrice.label", (Object[])new Object[]{details});
    }

    String getPercentagePriceDescription() {
        return ((MutableOfferDataModel)this.dataModel).isBuyOffer() ? Res.get((String)"shared.belowInPercent") : Res.get((String)"shared.aboveInPercent");
    }

    private void setAmountToModel() {
        if (this.amount.get() != null && !((String)this.amount.get()).isEmpty()) {
            BigInteger amount = HavenoUtils.coinToAtomicUnits((Coin)DisplayUtils.parseToCoinWith4Decimals((String)this.amount.get(), this.xmrFormatter));
            Price price = (Price)((MutableOfferDataModel)this.dataModel).getPrice().get();
            if (price != null && price.isPositive()) {
                amount = CoinUtil.getRoundedAmount((BigInteger)amount, (Price)price, (BigInteger)((MutableOfferDataModel)this.dataModel).getMinTradeLimit(), (BigInteger)((MutableOfferDataModel)this.dataModel).getMaxTradeLimit(), (String)((String)this.tradeCurrencyCode.get()), (String)((MutableOfferDataModel)this.dataModel).getPaymentAccount().getPaymentMethod().getId());
            }
            ((MutableOfferDataModel)this.dataModel).setAmount(amount);
            if (this.syncMinAmountWithAmount || ((MutableOfferDataModel)this.dataModel).getMinAmount().get() == null || ((BigInteger)((MutableOfferDataModel)this.dataModel).getMinAmount().get()).equals(Coin.ZERO)) {
                this.minAmount.set((Object)((String)this.amount.get()));
                this.setMinAmountToModel();
            }
        } else {
            ((MutableOfferDataModel)this.dataModel).setAmount(null);
        }
    }

    private void setMinAmountToModel() {
        if (this.minAmount.get() != null && !((String)this.minAmount.get()).isEmpty()) {
            BigInteger minAmount = HavenoUtils.coinToAtomicUnits((Coin)DisplayUtils.parseToCoinWith4Decimals((String)this.minAmount.get(), this.xmrFormatter));
            Price price = (Price)((MutableOfferDataModel)this.dataModel).getPrice().get();
            if (price != null && price.isPositive()) {
                minAmount = CoinUtil.getRoundedAmount((BigInteger)minAmount, (Price)price, (BigInteger)((MutableOfferDataModel)this.dataModel).getMinTradeLimit(), (BigInteger)((MutableOfferDataModel)this.dataModel).getMaxTradeLimit(), (String)((String)this.tradeCurrencyCode.get()), (String)((MutableOfferDataModel)this.dataModel).getPaymentAccount().getPaymentMethod().getId());
            }
            ((MutableOfferDataModel)this.dataModel).setMinAmount(minAmount);
        } else {
            ((MutableOfferDataModel)this.dataModel).setMinAmount(null);
        }
    }

    private void setPriceToModel() {
        if (this.price.get() != null && !((String)this.price.get()).isEmpty()) {
            try {
                ((MutableOfferDataModel)this.dataModel).setPrice(Price.parse((String)((String)((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode().get()), (String)((String)this.price.get())));
            }
            catch (Throwable t) {
                log.debug(t.getMessage());
            }
        } else {
            ((MutableOfferDataModel)this.dataModel).setPrice(null);
        }
    }

    private void setVolumeToModel() {
        if (this.volume.get() != null && !((String)this.volume.get()).isEmpty()) {
            try {
                ((MutableOfferDataModel)this.dataModel).setVolume(Volume.parse((String)((String)this.volume.get()), (String)((String)((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode().get())));
            }
            catch (Throwable t) {
                log.debug(t.getMessage());
            }
        } else {
            ((MutableOfferDataModel)this.dataModel).setVolume(null);
        }
    }

    private void setSecurityDepositToModel() {
        if (this.securityDeposit.get() != null && !((String)this.securityDeposit.get()).isEmpty() && !this.isMinSecurityDeposit.get()) {
            ((MutableOfferDataModel)this.dataModel).setSecurityDepositPct(ParsingUtils.parsePercentStringToDouble((String)((String)this.securityDeposit.get())));
        } else {
            ((MutableOfferDataModel)this.dataModel).setSecurityDepositPct(Restrictions.getDefaultSecurityDepositPct());
        }
    }

    private void setExtraInfoToModel() {
        if (this.extraInfo.get() != null && !((String)this.extraInfo.get()).isEmpty()) {
            ((MutableOfferDataModel)this.dataModel).setExtraInfo((String)this.extraInfo.get());
        } else {
            ((MutableOfferDataModel)this.dataModel).setExtraInfo(null);
        }
    }

    private void validateAndSetSecurityDepositToModel() {
        String value = FormattingUtils.formatToPercent((double)((MutableOfferDataModel)this.dataModel).getSecurityDepositPct().get());
        if (!this.securityDepositValidator.validate((String)value).isValid) {
            ((MutableOfferDataModel)this.dataModel).setSecurityDepositPct(Restrictions.getDefaultSecurityDepositPct());
        }
    }

    private InputValidator.ValidationResult isXmrInputValid(String input) {
        return this.xmrValidator.validate("" + HavenoUtils.atomicUnitsToXmr((BigInteger)HavenoUtils.parseXmr((String)input)));
    }

    private InputValidator.ValidationResult isPriceInputValid(String input) {
        return this.getPriceValidator().validate(input);
    }

    private InputValidator.ValidationResult isVolumeInputValid(String input) {
        return this.getVolumeValidator().validate(input);
    }

    private MonetaryValidator getPriceValidator() {
        return CurrencyUtil.isPricePrecise((String)this.getTradeCurrency().getCode()) ? this.amountValidator8Decimals : this.amountValidator4Decimals;
    }

    private MonetaryValidator getVolumeValidator() {
        String code = this.getTradeCurrency().getCode();
        if (CurrencyUtil.isFiatCurrency((String)code)) {
            return this.fiatVolumeValidator;
        }
        if (CurrencyUtil.isVolumeRoundedToNearestUnit((String)code)) {
            return this.amountValidator4Decimals;
        }
        return this.amountValidator8Decimals;
    }

    private void updateSpinnerInfo() {
        if (!this.showPayFundsScreenDisplayed.get() || this.errorMessage.get() != null || this.showTransactionPublishedScreen.get()) {
            this.waitingForFundsText.set((Object)"");
        } else if (((MutableOfferDataModel)this.dataModel).getIsXmrWalletFunded().get()) {
            this.waitingForFundsText.set((Object)"");
        } else {
            this.waitingForFundsText.set((Object)Res.get((String)"shared.waitingForFunds"));
        }
        this.isWaitingForFunds.set(!((String)this.waitingForFundsText.get()).isEmpty());
    }

    private void updateSecurityDeposit() {
        this.isMinSecurityDeposit.set(((MutableOfferDataModel)this.dataModel).isMinSecurityDeposit());
        this.securityDepositLabel.set((Object)this.getSecurityDepositLabel());
        if (((MutableOfferDataModel)this.dataModel).isMinSecurityDeposit()) {
            this.securityDeposit.set((Object)HavenoUtils.formatXmr((BigInteger)Restrictions.getMinSecurityDeposit()));
            this.securityDepositValidationResult.set((Object)new InputValidator.ValidationResult(true));
        } else {
            boolean hasBuyerAsTakerWithoutDeposit = ((MutableOfferDataModel)this.dataModel).buyerAsTakerWithoutDeposit.get() && ((MutableOfferDataModel)this.dataModel).isSellOffer();
            this.securityDeposit.set((Object)FormattingUtils.formatToPercent((double)(hasBuyerAsTakerWithoutDeposit ? Restrictions.getDefaultSecurityDepositPct() : ((MutableOfferDataModel)this.dataModel).getSecurityDepositPct().get())));
        }
    }

    void updateButtonDisableState() {
        boolean inputDataValid;
        ((MutableOfferDataModel)this.dataModel).calculateVolume();
        ((MutableOfferDataModel)this.dataModel).calculateTotalToPay();
        boolean bl = inputDataValid = this.isXmrInputValid((String)((String)this.amount.get())).isValid && this.isXmrInputValid((String)((String)this.minAmount.get())).isValid && this.isPriceInputValid((String)((String)this.price.get())).isValid && ((MutableOfferDataModel)this.dataModel).getPrice().get() != null && ((Price)((MutableOfferDataModel)this.dataModel).getPrice().get()).getValue() != 0L && this.isVolumeInputValid((String)((String)this.volume.get())).isValid && this.isVolumeInputValid((String)VolumeUtil.formatVolume((Volume)((Volume)((MutableOfferDataModel)this.dataModel).getMinVolume().get()))).isValid && ((MutableOfferDataModel)this.dataModel).isMinAmountLessOrEqualAmount();
        if (((MutableOfferDataModel)this.dataModel).useMarketBasedPrice.get() && ((MutableOfferDataModel)this.dataModel).isMarketPriceAvailable()) {
            boolean bl2 = inputDataValid = inputDataValid && ((InputValidator.ValidationResult)this.triggerPriceValidationResult.get()).isValid;
        }
        if (!((MutableOfferDataModel)this.dataModel).isMinSecurityDeposit()) {
            inputDataValid = inputDataValid && this.securityDepositValidator.validate((String)((String)this.securityDeposit.get())).isValid;
        }
        inputDataValid = inputDataValid && this.getExtraInfoValidationResult().isValid;
        this.isNextButtonDisabled.set(!inputDataValid);
        this.isPlaceOfferButtonDisabled.set(this.createOfferInProgress || !inputDataValid || !((MutableOfferDataModel)this.dataModel).getIsXmrWalletFunded().get());
    }

    private InputValidator.ValidationResult getExtraInfoValidationResult() {
        if (this.extraInfo.get() != null && !((String)this.extraInfo.get()).isEmpty() && ((String)this.extraInfo.get()).length() > Restrictions.getMaxExtraInfoLength()) {
            return new InputValidator.ValidationResult(false, Res.get((String)"createOffer.extraInfo.invalid.tooLong", (Object[])new Object[]{Restrictions.getMaxExtraInfoLength()}));
        }
        return new InputValidator.ValidationResult(true);
    }

    private void updateMarketPriceToManual() {
        String currencyCode = (String)((MutableOfferDataModel)this.dataModel).getTradeCurrencyCode().get();
        MarketPrice marketPrice = this.priceFeedService.getMarketPrice(currencyCode);
        if (marketPrice != null && marketPrice.isRecentExternalPriceAvailable()) {
            double marketPriceAsDouble = marketPrice.getPrice();
            double amountAsDouble = ParsingUtils.parseNumberStringToDouble((String)((String)this.amount.get()));
            double volumeAsDouble = ParsingUtils.parseNumberStringToDouble((String)((String)this.volume.get()));
            double manualPriceAsDouble = ((MutableOfferDataModel)this.dataModel).calculateMarketPriceManual(marketPriceAsDouble, volumeAsDouble, amountAsDouble);
            int precision = CurrencyUtil.isTraditionalCurrency((String)currencyCode) ? 8 : 8;
            this.price.set((Object)FormattingUtils.formatRoundedDoubleWithPrecision((double)manualPriceAsDouble, (int)precision));
            this.setPriceToModel();
            ((MutableOfferDataModel)this.dataModel).calculateTotalToPay();
            this.updateButtonDisableState();
            this.applyMakerFee();
        } else {
            this.marketPriceMargin.set((Object)"");
            String id = "showNoPriceFeedAvailablePopup";
            if (this.preferences.showAgain(id)) {
                ((Popup)((Popup)new Popup().warning(Res.get((String)"popup.warning.noPriceFeedAvailable"))).dontShowAgainId(id)).show();
            }
        }
    }
}

