/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer;

import de.jensd.fx.fontawesome.AwesomeIcon;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.common.util.Tuple2;
import haveno.common.util.Tuple3;
import haveno.common.util.Utilities;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.payment.FasterPaymentsAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.trade.HavenoUtils;
import haveno.core.user.DontShowAgainLookup;
import haveno.core.user.Preferences;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.ActivatableViewAndModel;
import haveno.desktop.components.AddressTextField;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.BalanceTextField;
import haveno.desktop.components.BusyAnimation;
import haveno.desktop.components.FundsTextField;
import haveno.desktop.components.InfoInputTextField;
import haveno.desktop.components.InputTextArea;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.TitledGroupBg;
import haveno.desktop.main.MainView;
import haveno.desktop.main.account.AccountView;
import haveno.desktop.main.account.content.traditionalaccounts.TraditionalAccountsView;
import haveno.desktop.main.offer.ClosableView;
import haveno.desktop.main.offer.MutableOfferDataModel;
import haveno.desktop.main.offer.MutableOfferViewModel;
import haveno.desktop.main.offer.OfferDataModel;
import haveno.desktop.main.offer.OfferView;
import haveno.desktop.main.offer.OfferViewUtil;
import haveno.desktop.main.offer.SelectableView;
import haveno.desktop.main.overlays.notifications.Notification;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.OfferDetailsWindow;
import haveno.desktop.main.overlays.windows.QRCodeWindow;
import haveno.desktop.main.portfolio.PortfolioView;
import haveno.desktop.main.portfolio.openoffer.OpenOffersView;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.util.StringConverter;
import net.glxn.qrgen.QRCode;
import net.glxn.qrgen.image.ImageType;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;
import org.jetbrains.annotations.NotNull;

public abstract class MutableOfferView<M extends MutableOfferViewModel<?>>
extends ActivatableViewAndModel<AnchorPane, M>
implements ClosableView,
SelectableView {
    protected final Navigation navigation;
    private final Preferences preferences;
    private final OfferDetailsWindow offerDetailsWindow;
    private final CoinFormatter xmrFormatter;
    private ScrollPane scrollPane;
    protected GridPane gridPane;
    private TitledGroupBg payFundsTitledGroupBg;
    private TitledGroupBg setDepositTitledGroupBg;
    private TitledGroupBg extraInfoTitledGroupBg;
    private TitledGroupBg paymentTitledGroupBg;
    protected TitledGroupBg amountTitledGroupBg;
    private BusyAnimation waitingForFundsSpinner;
    private AutoTooltipButton nextButton;
    private AutoTooltipButton cancelButton1;
    private AutoTooltipButton cancelButton2;
    private AutoTooltipButton placeOfferButton;
    private AutoTooltipButton fundFromSavingsWalletButton;
    private Button priceTypeToggleButton;
    private InputTextField fixedPriceTextField;
    private InputTextField marketBasedPriceTextField;
    private InputTextField triggerPriceInputTextField;
    protected InputTextField amountTextField;
    protected InputTextField minAmountTextField;
    protected InputTextField volumeTextField;
    protected InputTextField securityDepositInputTextField;
    private TextField currencyTextField;
    private AddressTextField addressTextField;
    private BalanceTextField balanceTextField;
    private ToggleButton reserveExactAmountSlider;
    private ToggleButton buyerAsTakerWithoutDepositSlider;
    protected InputTextArea extraInfoTextArea;
    private FundsTextField totalToPayTextField;
    private Label amountDescriptionLabel;
    private Label priceCurrencyLabel;
    private Label priceDescriptionLabel;
    private Label volumeDescriptionLabel;
    private Label waitingForFundsLabel;
    private Label marketBasedPriceLabel;
    private Label percentagePriceDescriptionLabel;
    private Label tradeFeeDescriptionLabel;
    private Label resultLabel;
    private Label tradeFeeInXmrLabel;
    private Label xLabel;
    private Label fakeXLabel;
    private Label securityDepositLabel;
    private Label securityDepositPercentageLabel;
    private Label triggerPriceCurrencyLabel;
    private Label triggerPriceDescriptionLabel;
    protected Label amountBtcLabel;
    protected Label volumeCurrencyLabel;
    protected Label minAmountBtcLabel;
    private ComboBox<PaymentAccount> paymentAccountsComboBox;
    private ComboBox<TradeCurrency> currencyComboBox;
    private ImageView qrCodeImageView;
    private StackPane qrCodePane;
    private VBox paymentAccountsSelection;
    private VBox currencySelection;
    private VBox fixedPriceBox;
    private VBox percentagePriceBox;
    private VBox currencyTextFieldBox;
    private VBox triggerPriceVBox;
    private HBox fundingHBox;
    private HBox firstRowHBox;
    private HBox secondRowHBox;
    private HBox placeOfferBox;
    private HBox amountValueCurrencyBox;
    private HBox priceAsPercentageValueCurrencyBox;
    private HBox volumeValueCurrencyBox;
    private HBox priceValueCurrencyBox;
    private HBox minAmountValueCurrencyBox;
    private HBox securityDepositAndFeeBox;
    private HBox triggerPriceHBox;
    private Subscription isWaitingForFundsSubscription;
    private Subscription balanceSubscription;
    private ChangeListener<Boolean> amountFocusedListener;
    private ChangeListener<Boolean> minAmountFocusedListener;
    private ChangeListener<Boolean> volumeFocusedListener;
    private ChangeListener<Boolean> securityDepositFocusedListener;
    private ChangeListener<Boolean> priceFocusedListener;
    private ChangeListener<Boolean> placeOfferCompletedListener;
    private ChangeListener<Boolean> priceAsPercentageFocusedListener;
    private ChangeListener<Boolean> getShowWalletFundedNotificationListener;
    private ChangeListener<Boolean> isMinSecurityDepositListener;
    private ChangeListener<Boolean> buyerAsTakerWithoutDepositListener;
    private ChangeListener<Boolean> triggerPriceFocusedListener;
    private ChangeListener<Boolean> extraInfoFocusedListener;
    private ChangeListener<BigInteger> missingCoinListener;
    private ChangeListener<String> tradeCurrencyCodeListener;
    private ChangeListener<String> errorMessageListener;
    private ChangeListener<String> marketPriceMarginListener;
    private ChangeListener<String> volumeListener;
    private ChangeListener<String> securityDepositInXMRListener;
    private ChangeListener<String> extraInfoListener;
    private ChangeListener<Number> marketPriceAvailableListener;
    private EventHandler<ActionEvent> currencyComboBoxSelectionHandler;
    private EventHandler<ActionEvent> paymentAccountsComboBoxSelectionHandler;
    private OfferView.CloseHandler closeHandler;
    protected int gridRow = 0;
    private final List<Node> editOfferElements = new ArrayList<Node>();
    private final HashMap<String, Boolean> paymentAccountWarningDisplayed = new HashMap();
    private boolean zelleWarningDisplayed;
    private boolean fasterPaymentsWarningDisplayed;
    private boolean isActivated;
    private InfoInputTextField marketBasedPriceInfoInputTextField;
    private InfoInputTextField volumeInfoInputTextField;
    private InfoInputTextField securityDepositInfoInputTextField;
    private InfoInputTextField triggerPriceInfoInputTextField;
    private Text xIcon;
    private Text fakeXIcon;
    private OfferView.OfferActionHandler offerActionHandler;
    private int heightAdjustment = -5;

    public MutableOfferView(M model, Navigation navigation, Preferences preferences, OfferDetailsWindow offerDetailsWindow, CoinFormatter btcFormatter) {
        super(model);
        this.navigation = navigation;
        this.preferences = preferences;
        this.offerDetailsWindow = offerDetailsWindow;
        this.xmrFormatter = btcFormatter;
    }

    @Override
    protected void initialize() {
        this.addScrollPane();
        this.addGridPane();
        this.addPaymentGroup();
        this.addAmountPriceGroup();
        this.addOptionsGroup();
        this.addExtraInfoGroup();
        this.addNextButtons();
        this.addFundingGroup();
        this.createListeners();
        this.balanceTextField.setFormatter(((MutableOfferViewModel)this.model).getXmrFormatter());
        this.paymentAccountsComboBox.setConverter(GUIUtil.getPaymentAccountsComboBoxStringConverter());
        this.paymentAccountsComboBox.setButtonCell(GUIUtil.getComboBoxButtonCell(Res.get((String)"shared.chooseTradingAccount"), this.paymentAccountsComboBox, false));
        this.paymentAccountsComboBox.setCellFactory(((MutableOfferViewModel)this.model).getPaymentAccountListCellFactory(this.paymentAccountsComboBox));
        this.doSetFocus();
    }

    protected void doSetFocus() {
        GUIUtil.focusWhenAddedToScene((Node)this.amountTextField);
    }

    @Override
    protected void activate() {
        if (((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).isTabSelected) {
            this.doActivate();
        }
    }

    protected void doActivate() {
        if (!this.isActivated) {
            this.isActivated = true;
            this.currencyComboBox.setPrefWidth(250.0);
            this.paymentAccountsComboBox.setPrefWidth(250.0);
            this.addBindings();
            this.addListeners();
            this.addSubscriptions();
            this.amountDescriptionLabel.setText(((MutableOfferViewModel)this.model).getAmountDescription());
            this.addressTextField.setAddress(((MutableOfferViewModel)this.model).getAddressAsString());
            this.addressTextField.setPaymentLabel(((MutableOfferViewModel)this.model).getPaymentLabel());
            this.currencyComboBox.getSelectionModel().select((Object)((MutableOfferViewModel)this.model).getTradeCurrency());
            this.paymentAccountsComboBox.setItems(this.getPaymentAccounts());
            this.paymentAccountsComboBox.getSelectionModel().select((Object)((MutableOfferViewModel)this.model).getPaymentAccount());
            this.onPaymentAccountsComboBoxSelected();
            this.balanceTextField.setTargetAmount((BigInteger)((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).totalToPayAsProperty().get());
            this.updatePriceToggle();
            Label popOverLabel = OfferViewUtil.createPopOverLabel(Res.get((String)"createOffer.triggerPrice.tooltip"));
            this.triggerPriceInfoInputTextField.setContentForPopOver((Node)popOverLabel, AwesomeIcon.SHIELD);
            this.buyerAsTakerWithoutDepositSlider.setSelected(((MutableOfferDataModel)((MutableOfferViewModel)this.model).dataModel).getBuyerAsTakerWithoutDeposit().get());
            this.triggerPriceInputTextField.setText((String)((MutableOfferViewModel)this.model).triggerPrice.get());
            this.extraInfoTextArea.setText((String)((MutableOfferDataModel)((MutableOfferViewModel)this.model).dataModel).extraInfo.get());
            if (((MutableOfferViewModel)this.model).showPayFundsScreenDisplayed.get()) {
                this.onShowPayFundsScreen();
            }
        }
    }

    @Override
    protected void deactivate() {
        if (this.isActivated) {
            this.isActivated = false;
            this.removeBindings();
            this.removeListeners();
            this.removeSubscriptions();
        }
    }

    @Override
    public void onTabSelected(boolean isSelected) {
        if (isSelected) {
            this.doActivate();
        } else {
            this.deactivate();
        }
        this.isActivated = isSelected;
        ((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).onTabSelected(isSelected);
    }

    public void initWithData(OfferDirection direction, TradeCurrency tradeCurrency, boolean initAddressEntry, OfferView.OfferActionHandler offerActionHandler) {
        String placeOfferButtonLabel;
        this.offerActionHandler = offerActionHandler;
        boolean result = ((MutableOfferViewModel)this.model).initWithData(direction, tradeCurrency, initAddressEntry);
        if (!result) {
            ((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"popup.warning.noTradingAccountSetup.headline"))).instruction(Res.get((String)"popup.warning.noTradingAccountSetup.msg"))).actionButtonTextWithGoTo("mainView.menu.account")).onAction(() -> {
                this.navigation.setReturnPath(this.navigation.getCurrentPath());
                this.navigation.navigateTo(MainView.class, AccountView.class, TraditionalAccountsView.class);
            })).show();
        }
        if (OfferViewUtil.isShownAsBuyOffer(direction, tradeCurrency)) {
            this.placeOfferButton.setId("buy-button-big");
            placeOfferButtonLabel = Res.get((String)"createOffer.placeOfferButton.buy", (Object[])new Object[]{tradeCurrency.getCode()});
            this.nextButton.setId("buy-button");
            this.fundFromSavingsWalletButton.setId("buy-button");
        } else {
            this.placeOfferButton.setId("sell-button-big");
            placeOfferButtonLabel = Res.get((String)"createOffer.placeOfferButton.sell", (Object[])new Object[]{tradeCurrency.getCode()});
            this.nextButton.setId("sell-button");
            this.fundFromSavingsWalletButton.setId("sell-button");
        }
        this.buyerAsTakerWithoutDepositSlider.setVisible(((MutableOfferViewModel)this.model).isSellOffer());
        this.buyerAsTakerWithoutDepositSlider.setManaged(((MutableOfferViewModel)this.model).isSellOffer());
        this.placeOfferButton.updateText(placeOfferButtonLabel);
        this.updatePriceToggle();
    }

    public void onClose() {
        if (((BigInteger)((OfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getBalance().get()).compareTo(BigInteger.ZERO) > 0 && !((MutableOfferViewModel)this.model).placeOfferCompleted.get()) {
            ((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).swapTradeToSavings();
        }
    }

    @Override
    public void setCloseHandler(OfferView.CloseHandler closeHandler) {
        this.closeHandler = closeHandler;
    }

    private void onPlaceOffer() {
        if (((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).canPlaceOffer()) {
            Offer offer = ((MutableOfferViewModel)this.model).createAndGetOffer();
            if (!DevEnv.isDevMode()) {
                this.offerDetailsWindow.onPlaceOffer(() -> ((MutableOfferViewModel)this.model).onPlaceOffer(offer, this.offerDetailsWindow::hide)).show(offer);
                this.offerDetailsWindow.onClose(() -> ((MutableOfferViewModel)this.model).onCancelOffer(null, null));
            } else {
                this.balanceSubscription.unsubscribe();
                ((MutableOfferViewModel)this.model).onPlaceOffer(offer, () -> {});
            }
        }
    }

    private void onShowPayFundsScreen() {
        this.nextButton.setVisible(false);
        this.nextButton.setManaged(false);
        this.nextButton.setOnAction(null);
        this.cancelButton1.setVisible(false);
        this.cancelButton1.setManaged(false);
        this.cancelButton1.setOnAction(null);
        this.setDepositTitledGroupBg.setVisible(false);
        this.setDepositTitledGroupBg.setManaged(false);
        this.securityDepositAndFeeBox.setVisible(false);
        this.securityDepositAndFeeBox.setManaged(false);
        this.buyerAsTakerWithoutDepositSlider.setVisible(false);
        this.buyerAsTakerWithoutDepositSlider.setManaged(false);
        this.extraInfoTitledGroupBg.setVisible(false);
        this.extraInfoTitledGroupBg.setManaged(false);
        this.extraInfoTextArea.setVisible(false);
        this.extraInfoTextArea.setManaged(false);
        this.updateQrCode();
        ((MutableOfferViewModel)this.model).onShowPayFundsScreen(() -> {
            if (!DevEnv.isDevMode()) {
                String key = "createOfferFundWalletInfo";
                String tradeAmountText = ((MutableOfferViewModel)this.model).isSellOffer() ? Res.get((String)"createOffer.createOfferFundWalletInfo.tradeAmount", (Object[])new Object[]{((MutableOfferViewModel)this.model).getTradeAmount()}) : "";
                String message = Res.get((String)"createOffer.createOfferFundWalletInfo.msg", (Object[])new Object[]{((MutableOfferViewModel)this.model).getTotalToPayInfo(), tradeAmountText, ((MutableOfferViewModel)this.model).getSecurityDepositInfo(), ((MutableOfferViewModel)this.model).getTradeFee()});
                ((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"createOffer.createOfferFundWalletInfo.headline"))).instruction(message)).dontShowAgainId(key)).show();
            }
            this.totalToPayTextField.setFundsStructure(((MutableOfferViewModel)this.model).getFundsStructure());
            this.totalToPayTextField.setContentForInfoPopOver((Node)this.createInfoPopover());
        });
        this.paymentAccountsSelection.setDisable(true);
        this.currencySelection.setDisable(true);
        this.editOfferElements.forEach(node -> {
            node.setMouseTransparent(true);
            node.setFocusTraversable(false);
        });
        this.updateOfferElementsStyle();
        if (this.triggerPriceInputTextField.getText().isEmpty()) {
            this.triggerPriceVBox.setVisible(false);
        }
        this.balanceTextField.setTargetAmount((BigInteger)((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).totalToPayAsProperty().get());
        this.showFundingGroup();
    }

    private void updateOfferElementsStyle() {
        GridPane.setColumnSpan((Node)this.firstRowHBox, (Integer)2);
        String activeInputStyle = "offer-input";
        String readOnlyInputStyle = "offer-input-readonly";
        this.amountValueCurrencyBox.getStyleClass().remove((Object)activeInputStyle);
        this.amountValueCurrencyBox.getStyleClass().add((Object)readOnlyInputStyle);
        this.priceAsPercentageValueCurrencyBox.getStyleClass().remove((Object)activeInputStyle);
        this.priceAsPercentageValueCurrencyBox.getStyleClass().add((Object)readOnlyInputStyle);
        this.volumeValueCurrencyBox.getStyleClass().remove((Object)activeInputStyle);
        this.volumeValueCurrencyBox.getStyleClass().add((Object)readOnlyInputStyle);
        this.priceValueCurrencyBox.getStyleClass().remove((Object)activeInputStyle);
        this.priceValueCurrencyBox.getStyleClass().add((Object)readOnlyInputStyle);
        this.minAmountValueCurrencyBox.getStyleClass().remove((Object)activeInputStyle);
        this.minAmountValueCurrencyBox.getStyleClass().add((Object)readOnlyInputStyle);
        this.triggerPriceHBox.getStyleClass().remove((Object)activeInputStyle);
        this.triggerPriceHBox.getStyleClass().add((Object)readOnlyInputStyle);
        GridPane.setColumnSpan((Node)this.secondRowHBox, (Integer)1);
        this.priceTypeToggleButton.setVisible(false);
        HBox.setMargin((Node)this.priceTypeToggleButton, (Insets)new Insets(16.0, -14.0, 0.0, 0.0));
        this.resultLabel.getStyleClass().add((Object)"small");
        this.xLabel.getStyleClass().add((Object)"small");
        this.xIcon.setStyle(String.format("-fx-font-family: %s; -fx-font-size: %s;", MaterialDesignIcon.CLOSE.fontFamily(), "1em"));
        this.fakeXIcon.setStyle(String.format("-fx-font-family: %s; -fx-font-size: %s;", MaterialDesignIcon.CLOSE.fontFamily(), "1em"));
        this.fakeXLabel.getStyleClass().add((Object)"small");
    }

    private void maybeShowZelleWarning(PaymentAccount paymentAccount) {
        if (paymentAccount.getPaymentMethod().getId().equals("ZELLE") && !this.zelleWarningDisplayed) {
            this.zelleWarningDisplayed = true;
            UserThread.runAfter(GUIUtil::showZelleWarning, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    private void maybeShowFasterPaymentsWarning(PaymentAccount paymentAccount) {
        if (paymentAccount.getPaymentMethod().getId().equals("FASTER_PAYMENTS") && ((FasterPaymentsAccount)paymentAccount).getHolderName().isEmpty() && !this.fasterPaymentsWarningDisplayed) {
            this.fasterPaymentsWarningDisplayed = true;
            UserThread.runAfter(() -> GUIUtil.showFasterPaymentsWarning(this.navigation), (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    private void maybeShowAccountWarning(PaymentAccount paymentAccount, boolean isBuyer) {
        String msgKey = paymentAccount.getPreTradeMessage(isBuyer);
        OfferViewUtil.showPaymentAccountWarning(msgKey, this.paymentAccountWarningDisplayed);
    }

    protected void onPaymentAccountsComboBoxSelected() {
        this.currencyComboBox.setOnAction(null);
        PaymentAccount paymentAccount = (PaymentAccount)this.paymentAccountsComboBox.getSelectionModel().getSelectedItem();
        if (paymentAccount != null) {
            this.maybeShowZelleWarning(paymentAccount);
            this.maybeShowFasterPaymentsWarning(paymentAccount);
            this.maybeShowAccountWarning(paymentAccount, ((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).isBuyOffer());
            this.currencySelection.setVisible(paymentAccount.hasMultipleCurrencies());
            this.currencySelection.setManaged(paymentAccount.hasMultipleCurrencies());
            this.currencyTextFieldBox.setVisible(!paymentAccount.hasMultipleCurrencies());
            ((MutableOfferViewModel)this.model).onPaymentAccountSelected(paymentAccount);
            ((MutableOfferViewModel)this.model).onCurrencySelected(((MutableOfferViewModel)this.model).getTradeCurrency());
            if (paymentAccount.hasMultipleCurrencies()) {
                List tradeCurrencies = paymentAccount.getTradeCurrencies();
                this.currencyComboBox.setItems(FXCollections.observableArrayList((Collection)tradeCurrencies));
                this.currencyComboBox.getSelectionModel().select((Object)((MutableOfferViewModel)this.model).getTradeCurrency());
            } else {
                TradeCurrency singleTradeCurrency = paymentAccount.getSingleTradeCurrency();
                if (singleTradeCurrency != null) {
                    this.currencyTextField.setText(singleTradeCurrency.getNameAndCode());
                }
            }
        } else {
            this.currencySelection.setVisible(false);
            this.currencySelection.setManaged(false);
            this.currencyTextFieldBox.setVisible(true);
            this.currencyTextField.setText("");
        }
        this.currencyComboBox.setOnAction(this.currencyComboBoxSelectionHandler);
        this.updatePriceToggle();
    }

    private void onCurrencyComboBoxSelected() {
        TradeCurrency currency = (TradeCurrency)this.currencyComboBox.getSelectionModel().getSelectedItem();
        ((MutableOfferViewModel)this.model).onCurrencySelected(currency);
        if (OfferViewUtil.isShownAsBuyOffer(((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getDirection(), currency)) {
            this.placeOfferButton.updateText(Res.get((String)"createOffer.placeOfferButton.buy", (Object[])new Object[]{currency.getCode()}));
        } else {
            this.placeOfferButton.updateText(Res.get((String)"createOffer.placeOfferButton.sell", (Object[])new Object[]{currency.getCode()}));
        }
    }

    protected void close() {
        if (this.closeHandler != null) {
            this.closeHandler.close();
        }
    }

    private void addBindings() {
        this.priceCurrencyLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> CurrencyUtil.getCounterCurrency((String)((String)((MutableOfferViewModel)this.model).tradeCurrencyCode.get())), (Observable[])new Observable[]{((MutableOfferViewModel)this.model).tradeCurrencyCode}));
        this.triggerPriceCurrencyLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> CurrencyUtil.getCounterCurrency((String)((String)((MutableOfferViewModel)this.model).tradeCurrencyCode.get())), (Observable[])new Observable[]{((MutableOfferViewModel)this.model).tradeCurrencyCode}));
        this.triggerPriceDescriptionLabel.textProperty().bind((ObservableValue)((MutableOfferViewModel)this.model).triggerPriceDescription);
        this.percentagePriceDescriptionLabel.textProperty().bind((ObservableValue)((MutableOfferViewModel)this.model).percentagePriceDescription);
        this.marketBasedPriceLabel.prefWidthProperty().bind((ObservableValue)this.priceCurrencyLabel.widthProperty());
        this.volumeCurrencyLabel.textProperty().bind((ObservableValue)((MutableOfferViewModel)this.model).tradeCurrencyCode);
        this.priceDescriptionLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> CurrencyUtil.getPriceWithCurrencyCode((String)((String)((MutableOfferViewModel)this.model).tradeCurrencyCode.get()), (String)"shared.fixedPriceInCurForCur"), (Observable[])new Observable[]{((MutableOfferViewModel)this.model).tradeCurrencyCode}));
        this.volumeDescriptionLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> ((StringProperty)((MutableOfferViewModel)this.model).volumeDescriptionLabel).get(), (Observable[])new Observable[]{((MutableOfferViewModel)this.model).tradeCurrencyCode, ((MutableOfferViewModel)this.model).volumeDescriptionLabel}));
        this.amountTextField.textProperty().bindBidirectional((Property)((MutableOfferViewModel)this.model).amount);
        this.minAmountTextField.textProperty().bindBidirectional((Property)((MutableOfferViewModel)this.model).minAmount);
        this.fixedPriceTextField.textProperty().bindBidirectional((Property)((MutableOfferViewModel)this.model).price);
        this.triggerPriceInputTextField.textProperty().bindBidirectional((Property)((MutableOfferViewModel)this.model).triggerPrice);
        this.marketBasedPriceTextField.textProperty().bindBidirectional((Property)((MutableOfferViewModel)this.model).marketPriceMargin);
        this.volumeTextField.textProperty().bindBidirectional((Property)((MutableOfferViewModel)this.model).volume);
        this.volumeTextField.promptTextProperty().bind((ObservableValue)((MutableOfferViewModel)this.model).volumePromptLabel);
        this.totalToPayTextField.textProperty().bind((ObservableValue)((MutableOfferViewModel)this.model).totalToPay);
        this.addressTextField.amountAsProperty().bind(((OfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getMissingCoin());
        this.securityDepositInputTextField.textProperty().bindBidirectional((Property)((MutableOfferViewModel)this.model).securityDeposit);
        this.securityDepositLabel.textProperty().bind((ObservableValue)((MutableOfferViewModel)this.model).securityDepositLabel);
        this.tradeFeeInXmrLabel.textProperty().bind((ObservableValue)((MutableOfferViewModel)this.model).tradeFeeInXmrWithFiat);
        this.tradeFeeDescriptionLabel.textProperty().bind((ObservableValue)((MutableOfferViewModel)this.model).tradeFeeDescription);
        this.extraInfoTextArea.textProperty().bindBidirectional((Property)((MutableOfferViewModel)this.model).extraInfo);
        this.amountTextField.validationResultProperty().bind(((MutableOfferViewModel)this.model).amountValidationResult);
        this.minAmountTextField.validationResultProperty().bind(((MutableOfferViewModel)this.model).minAmountValidationResult);
        this.fixedPriceTextField.validationResultProperty().bind(((MutableOfferViewModel)this.model).priceValidationResult);
        this.triggerPriceInputTextField.validationResultProperty().bind(((MutableOfferViewModel)this.model).triggerPriceValidationResult);
        this.volumeTextField.validationResultProperty().bind(((MutableOfferViewModel)this.model).volumeValidationResult);
        this.securityDepositInputTextField.validationResultProperty().bind(((MutableOfferViewModel)this.model).securityDepositValidationResult);
        this.extraInfoTextArea.validationResultProperty().bind(((MutableOfferViewModel)this.model).extraInfoValidationResult);
        this.fundingHBox.visibleProperty().bind((ObservableValue)((OfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getIsXmrWalletFunded().not().and((ObservableBooleanValue)((MutableOfferViewModel)this.model).showPayFundsScreenDisplayed));
        this.fundingHBox.managedProperty().bind((ObservableValue)((OfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getIsXmrWalletFunded().not().and((ObservableBooleanValue)((MutableOfferViewModel)this.model).showPayFundsScreenDisplayed));
        this.waitingForFundsLabel.textProperty().bind((ObservableValue)((MutableOfferViewModel)this.model).waitingForFundsText);
        this.placeOfferBox.visibleProperty().bind((ObservableValue)((OfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getIsXmrWalletFunded().and((ObservableBooleanValue)((MutableOfferViewModel)this.model).showPayFundsScreenDisplayed));
        this.placeOfferBox.managedProperty().bind((ObservableValue)((OfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getIsXmrWalletFunded().and((ObservableBooleanValue)((MutableOfferViewModel)this.model).showPayFundsScreenDisplayed));
        this.placeOfferButton.disableProperty().bind((ObservableValue)((MutableOfferViewModel)this.model).isPlaceOfferButtonDisabled);
        this.cancelButton2.disableProperty().bind((ObservableValue)((MutableOfferViewModel)this.model).cancelButtonDisabled);
        this.paymentAccountsComboBox.managedProperty().bind((ObservableValue)this.paymentAccountsComboBox.visibleProperty());
        this.paymentTitledGroupBg.managedProperty().bind((ObservableValue)this.paymentTitledGroupBg.visibleProperty());
        this.currencyComboBox.prefWidthProperty().bind((ObservableValue)this.paymentAccountsComboBox.widthProperty());
        this.currencyComboBox.managedProperty().bind((ObservableValue)this.currencyComboBox.visibleProperty());
        this.currencyTextFieldBox.prefWidthProperty().bind((ObservableValue)this.paymentAccountsComboBox.widthProperty());
        this.currencyTextFieldBox.managedProperty().bind((ObservableValue)this.currencyTextFieldBox.visibleProperty());
    }

    private void removeBindings() {
        this.priceCurrencyLabel.textProperty().unbind();
        this.triggerPriceCurrencyLabel.textProperty().unbind();
        this.triggerPriceDescriptionLabel.textProperty().unbind();
        this.percentagePriceDescriptionLabel.textProperty().unbind();
        this.volumeCurrencyLabel.textProperty().unbind();
        this.priceDescriptionLabel.textProperty().unbind();
        this.volumeDescriptionLabel.textProperty().unbind();
        this.amountTextField.textProperty().unbindBidirectional((Property)((MutableOfferViewModel)this.model).amount);
        this.minAmountTextField.textProperty().unbindBidirectional((Property)((MutableOfferViewModel)this.model).minAmount);
        this.fixedPriceTextField.textProperty().unbindBidirectional((Property)((MutableOfferViewModel)this.model).price);
        this.triggerPriceInputTextField.textProperty().unbindBidirectional((Property)((MutableOfferViewModel)this.model).triggerPrice);
        this.marketBasedPriceTextField.textProperty().unbindBidirectional((Property)((MutableOfferViewModel)this.model).marketPriceMargin);
        this.marketBasedPriceLabel.prefWidthProperty().unbind();
        this.volumeTextField.textProperty().unbindBidirectional((Property)((MutableOfferViewModel)this.model).volume);
        this.volumeTextField.promptTextProperty().unbindBidirectional((Property)((MutableOfferViewModel)this.model).volume);
        this.totalToPayTextField.textProperty().unbind();
        this.addressTextField.amountAsProperty().unbind();
        this.securityDepositInputTextField.textProperty().unbindBidirectional((Property)((MutableOfferViewModel)this.model).securityDeposit);
        this.securityDepositLabel.textProperty().unbind();
        this.tradeFeeInXmrLabel.textProperty().unbind();
        this.tradeFeeDescriptionLabel.textProperty().unbind();
        this.tradeFeeInXmrLabel.visibleProperty().unbind();
        this.tradeFeeDescriptionLabel.visibleProperty().unbind();
        this.extraInfoTextArea.textProperty().unbindBidirectional((Property)((MutableOfferViewModel)this.model).extraInfo);
        this.amountTextField.validationResultProperty().unbind();
        this.minAmountTextField.validationResultProperty().unbind();
        this.fixedPriceTextField.validationResultProperty().unbind();
        this.triggerPriceInputTextField.validationResultProperty().unbind();
        this.volumeTextField.validationResultProperty().unbind();
        this.securityDepositInputTextField.validationResultProperty().unbind();
        this.fundingHBox.visibleProperty().unbind();
        this.fundingHBox.managedProperty().unbind();
        this.waitingForFundsLabel.textProperty().unbind();
        this.placeOfferBox.visibleProperty().unbind();
        this.placeOfferBox.managedProperty().unbind();
        this.placeOfferButton.disableProperty().unbind();
        this.cancelButton2.disableProperty().unbind();
        this.paymentTitledGroupBg.managedProperty().unbind();
        this.paymentAccountsComboBox.managedProperty().unbind();
        this.currencyComboBox.managedProperty().unbind();
        this.currencyComboBox.prefWidthProperty().unbind();
        this.currencyTextFieldBox.managedProperty().unbind();
    }

    private void addSubscriptions() {
        this.isWaitingForFundsSubscription = EasyBind.subscribe((ObservableValue)((MutableOfferViewModel)this.model).isWaitingForFunds, isWaitingForFunds -> {
            this.waitingForFundsLabel.setVisible(isWaitingForFunds.booleanValue());
            this.waitingForFundsLabel.setManaged(isWaitingForFunds.booleanValue());
        });
        this.balanceSubscription = EasyBind.subscribe(((OfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getBalance(), this.balanceTextField::setBalance);
    }

    private void removeSubscriptions() {
        this.isWaitingForFundsSubscription.unsubscribe();
        this.balanceSubscription.unsubscribe();
    }

    private void createListeners() {
        this.amountFocusedListener = (o, oldValue, newValue) -> {
            ((MutableOfferViewModel)this.model).onFocusOutAmountTextField((boolean)oldValue, (boolean)newValue);
            this.amountTextField.setText((String)((MutableOfferViewModel)this.model).amount.get());
        };
        this.minAmountFocusedListener = (o, oldValue, newValue) -> {
            ((MutableOfferViewModel)this.model).onFocusOutMinAmountTextField((boolean)oldValue, (boolean)newValue);
            this.minAmountTextField.setText((String)((MutableOfferViewModel)this.model).minAmount.get());
        };
        this.priceFocusedListener = (o, oldValue, newValue) -> {
            ((MutableOfferViewModel)this.model).onFocusOutPriceTextField((boolean)oldValue, (boolean)newValue);
            this.fixedPriceTextField.setText((String)((MutableOfferViewModel)this.model).price.get());
        };
        this.priceAsPercentageFocusedListener = (o, oldValue, newValue) -> {
            ((MutableOfferViewModel)this.model).onFocusOutPriceAsPercentageTextField((boolean)oldValue, (boolean)newValue);
            this.marketBasedPriceTextField.setText((String)((MutableOfferViewModel)this.model).marketPriceMargin.get());
        };
        this.volumeFocusedListener = (o, oldValue, newValue) -> {
            ((MutableOfferViewModel)this.model).onFocusOutVolumeTextField((boolean)oldValue, (boolean)newValue);
            this.volumeTextField.setText((String)((MutableOfferViewModel)this.model).volume.get());
        };
        this.securityDepositFocusedListener = (o, oldValue, newValue) -> {
            ((MutableOfferViewModel)this.model).onFocusOutSecurityDepositTextField((boolean)oldValue, (boolean)newValue);
            this.securityDepositInputTextField.setText((String)((MutableOfferViewModel)this.model).securityDeposit.get());
        };
        this.triggerPriceFocusedListener = (o, oldValue, newValue) -> {
            ((MutableOfferViewModel)this.model).onFocusOutTriggerPriceTextField((boolean)oldValue, (boolean)newValue);
            this.triggerPriceInputTextField.setText((String)((MutableOfferViewModel)this.model).triggerPrice.get());
        };
        this.extraInfoFocusedListener = (observable, oldValue, newValue) -> {
            ((MutableOfferViewModel)this.model).onFocusOutExtraInfoTextArea((boolean)oldValue, (boolean)newValue);
            if (((MutableOfferViewModel)this.model).extraInfo.get() != null && !((String)((MutableOfferViewModel)this.model).extraInfo.get()).isEmpty()) {
                this.extraInfoTextArea.setText((String)((MutableOfferViewModel)this.model).extraInfo.get());
            }
        };
        this.errorMessageListener = (o, oldValue, newValue) -> {
            if (((MutableOfferViewModel)this.model).createOfferCanceled) {
                return;
            }
            if (newValue != null) {
                UserThread.runAfter(() -> ((Popup)new Popup().error(Res.get((String)"createOffer.amountPriceBox.error.message", (Object[])new Object[]{((MutableOfferViewModel)this.model).errorMessage.get()}))).show(), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        };
        this.paymentAccountsComboBoxSelectionHandler = e -> this.onPaymentAccountsComboBoxSelected();
        this.currencyComboBoxSelectionHandler = e -> this.onCurrencyComboBoxSelected();
        this.tradeCurrencyCodeListener = (observable, oldValue, newValue) -> {
            this.fixedPriceTextField.clear();
            this.marketBasedPriceTextField.clear();
            this.volumeTextField.clear();
            this.triggerPriceInputTextField.clear();
        };
        this.placeOfferCompletedListener = (o, oldValue, newValue) -> {
            if (DevEnv.isDevMode()) {
                this.close();
            } else if (newValue.booleanValue()) {
                String key = "createOfferSuccessInfo";
                if (DontShowAgainLookup.showAgain((String)key)) {
                    UserThread.runAfter(() -> ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"createOffer.success.headline"))).feedback(Res.get((String)"createOffer.success.info"))).dontShowAgainId(key)).actionButtonTextWithGoTo("portfolio.tab.openOffers")).onAction(this::closeAndGoToOpenOffers)).onClose(this::closeAndGoToOpenOffers)).show(), (long)1L);
                } else {
                    this.closeAndGoToOpenOffers();
                }
            }
        };
        this.marketPriceAvailableListener = (observable, oldValue, newValue) -> this.updatePriceToggle();
        this.getShowWalletFundedNotificationListener = (observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                Notification walletFundedNotification = ((Notification)((Notification)new Notification().headLine(Res.get((String)"notification.walletUpdate.headline"))).notification(Res.get((String)"notification.walletUpdate.msg", (Object[])new Object[]{HavenoUtils.formatXmr((BigInteger)((BigInteger)((OfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getTotalToPay().get()), (boolean)true)}))).autoClose();
                walletFundedNotification.show();
            }
        };
        this.securityDepositInXMRListener = (observable, oldValue, newValue) -> {
            if (!newValue.equals("")) {
                this.updateSecurityDepositLabels();
            } else {
                this.securityDepositInfoInputTextField.setContentForInfoPopOver(null);
            }
        };
        this.volumeListener = (observable, oldValue, newValue) -> {
            if (!newValue.equals("") && CurrencyUtil.isFiatCurrency((String)((String)((MutableOfferViewModel)this.model).tradeCurrencyCode.get()))) {
                Label popOverLabel = OfferViewUtil.createPopOverLabel(Res.get((String)"offerbook.info.roundedFiatVolume"));
                this.volumeInfoInputTextField.setContentForPrivacyPopOver((Node)popOverLabel);
            } else {
                this.volumeInfoInputTextField.hideIcon();
            }
        };
        this.missingCoinListener = (observable, oldValue, newValue) -> {
            if (!newValue.toString().equals("")) {
                this.updateQrCode();
            }
        };
        this.marketPriceMarginListener = (observable, oldValue, newValue) -> {
            if (this.marketBasedPriceInfoInputTextField != null) {
                if (newValue.equals("0.00")) {
                    String tooltip = ((MutableOfferViewModel)this.model).isSellOffer() ? Res.get((String)"createOffer.info.sellAtMarketPrice") : Res.get((String)"createOffer.info.buyAtMarketPrice");
                    Label atMarketPriceLabel = OfferViewUtil.createPopOverLabel(tooltip);
                    this.marketBasedPriceInfoInputTextField.setContentForInfoPopOver((Node)atMarketPriceLabel);
                } else if (newValue.contains("-")) {
                    String tooltip = ((MutableOfferViewModel)this.model).isSellOffer() ? Res.get((String)"createOffer.warning.sellBelowMarketPrice", (Object[])new Object[]{newValue.substring(1)}) : Res.get((String)"createOffer.warning.buyAboveMarketPrice", (Object[])new Object[]{newValue.substring(1)});
                    Label negativePercentageLabel = OfferViewUtil.createPopOverLabel(tooltip);
                    this.marketBasedPriceInfoInputTextField.setContentForWarningPopOver((Node)negativePercentageLabel);
                } else if (!newValue.equals("")) {
                    String tooltip = ((MutableOfferViewModel)this.model).isSellOffer() ? Res.get((String)"createOffer.info.sellAboveMarketPrice", (Object[])new Object[]{newValue}) : Res.get((String)"createOffer.info.buyBelowMarketPrice", (Object[])new Object[]{newValue});
                    Label positivePercentageLabel = OfferViewUtil.createPopOverLabel(tooltip);
                    this.marketBasedPriceInfoInputTextField.setContentForInfoPopOver((Node)positivePercentageLabel);
                }
            }
        };
        this.isMinSecurityDepositListener = (observable, oldValue, newValue) -> this.updateSecurityDepositLabels();
        this.buyerAsTakerWithoutDepositListener = (observable, oldValue, newValue) -> this.updateSecurityDepositLabels();
        this.extraInfoListener = (observable, oldValue, newValue) -> {
            if (newValue == null || !newValue.equals("")) {
                // empty if block
            }
        };
    }

    private void updateSecurityDepositLabels() {
        if (((MutableOfferViewModel)this.model).isMinSecurityDeposit.get()) {
            this.securityDepositPercentageLabel.setText(Res.getBaseCurrencyCode());
            this.securityDepositInputTextField.setDisable(true);
        } else {
            this.securityDepositPercentageLabel.setText("%");
            this.securityDepositInputTextField.setDisable(((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).buyerAsTakerWithoutDeposit.get());
        }
        if (((MutableOfferViewModel)this.model).securityDepositInXMR.get() != null && !((String)((MutableOfferViewModel)this.model).securityDepositInXMR.get()).equals("")) {
            Label depositInBTCInfo = OfferViewUtil.createPopOverLabel(((MutableOfferViewModel)this.model).getSecurityDepositPopOverLabel((String)((MutableOfferViewModel)this.model).securityDepositInXMR.get()));
            this.securityDepositInfoInputTextField.setContentForInfoPopOver((Node)depositInBTCInfo);
        }
    }

    private void updateQrCode() {
        byte[] imageBytes = QRCode.from((String)this.getMoneroURI()).withSize(300, 300).to(ImageType.PNG).stream().toByteArray();
        Image qrImage = new Image((InputStream)new ByteArrayInputStream(imageBytes));
        this.qrCodeImageView.setImage(qrImage);
    }

    private void closeAndGoToOpenOffers() {
        UserThread.runAfter(() -> this.navigation.navigateTo(MainView.class, PortfolioView.class, OpenOffersView.class), (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.close();
    }

    protected void updatePriceToggle() {
        int marketPriceAvailableValue = ((MutableOfferViewModel)this.model).marketPriceAvailableProperty.get();
        if (marketPriceAvailableValue > -1) {
            boolean showPriceToggle = marketPriceAvailableValue == 1 && !PaymentMethod.isFixedPriceOnly((String)((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).paymentAccount.getPaymentMethod().getId());
            this.percentagePriceBox.setVisible(showPriceToggle);
            this.priceTypeToggleButton.setVisible(showPriceToggle);
            boolean fixedPriceSelected = !((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getUseMarketBasedPrice().get() || !showPriceToggle;
            this.updatePriceToggleButtons(fixedPriceSelected);
        }
    }

    private void addListeners() {
        ((MutableOfferViewModel)this.model).tradeCurrencyCode.addListener(this.tradeCurrencyCodeListener);
        ((MutableOfferViewModel)this.model).marketPriceAvailableProperty.addListener(this.marketPriceAvailableListener);
        ((MutableOfferViewModel)this.model).marketPriceMargin.addListener(this.marketPriceMarginListener);
        ((MutableOfferViewModel)this.model).volume.addListener(this.volumeListener);
        ((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).missingCoin.addListener(this.missingCoinListener);
        ((MutableOfferViewModel)this.model).securityDepositInXMR.addListener(this.securityDepositInXMRListener);
        ((MutableOfferViewModel)this.model).isMinSecurityDeposit.addListener(this.isMinSecurityDepositListener);
        ((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).buyerAsTakerWithoutDeposit.addListener(this.buyerAsTakerWithoutDepositListener);
        ((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).extraInfo.addListener(this.extraInfoListener);
        this.amountTextField.focusedProperty().addListener(this.amountFocusedListener);
        this.minAmountTextField.focusedProperty().addListener(this.minAmountFocusedListener);
        this.fixedPriceTextField.focusedProperty().addListener(this.priceFocusedListener);
        this.triggerPriceInputTextField.focusedProperty().addListener(this.triggerPriceFocusedListener);
        this.marketBasedPriceTextField.focusedProperty().addListener(this.priceAsPercentageFocusedListener);
        this.volumeTextField.focusedProperty().addListener(this.volumeFocusedListener);
        this.securityDepositInputTextField.focusedProperty().addListener(this.securityDepositFocusedListener);
        this.extraInfoTextArea.focusedProperty().addListener(this.extraInfoFocusedListener);
        ((OfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getShowWalletFundedNotification().addListener(this.getShowWalletFundedNotificationListener);
        ((MutableOfferViewModel)this.model).errorMessage.addListener(this.errorMessageListener);
        ((MutableOfferViewModel)this.model).placeOfferCompleted.addListener(this.placeOfferCompletedListener);
        this.paymentAccountsComboBox.setOnAction(this.paymentAccountsComboBoxSelectionHandler);
        this.currencyComboBox.setOnAction(this.currencyComboBoxSelectionHandler);
    }

    private void removeListeners() {
        ((MutableOfferViewModel)this.model).tradeCurrencyCode.removeListener(this.tradeCurrencyCodeListener);
        ((MutableOfferViewModel)this.model).marketPriceAvailableProperty.removeListener(this.marketPriceAvailableListener);
        ((MutableOfferViewModel)this.model).marketPriceMargin.removeListener(this.marketPriceMarginListener);
        ((MutableOfferViewModel)this.model).volume.removeListener(this.volumeListener);
        ((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).missingCoin.removeListener(this.missingCoinListener);
        ((MutableOfferViewModel)this.model).securityDepositInXMR.removeListener(this.securityDepositInXMRListener);
        ((MutableOfferViewModel)this.model).isMinSecurityDeposit.removeListener(this.isMinSecurityDepositListener);
        ((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).buyerAsTakerWithoutDeposit.removeListener(this.buyerAsTakerWithoutDepositListener);
        ((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).extraInfo.removeListener(this.extraInfoListener);
        this.amountTextField.focusedProperty().removeListener(this.amountFocusedListener);
        this.minAmountTextField.focusedProperty().removeListener(this.minAmountFocusedListener);
        this.fixedPriceTextField.focusedProperty().removeListener(this.priceFocusedListener);
        this.triggerPriceInputTextField.focusedProperty().removeListener(this.triggerPriceFocusedListener);
        this.marketBasedPriceTextField.focusedProperty().removeListener(this.priceAsPercentageFocusedListener);
        this.volumeTextField.focusedProperty().removeListener(this.volumeFocusedListener);
        this.securityDepositInputTextField.focusedProperty().removeListener(this.securityDepositFocusedListener);
        this.extraInfoTextArea.focusedProperty().removeListener(this.extraInfoFocusedListener);
        ((OfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getShowWalletFundedNotification().removeListener(this.getShowWalletFundedNotificationListener);
        ((MutableOfferViewModel)this.model).errorMessage.removeListener(this.errorMessageListener);
        ((MutableOfferViewModel)this.model).placeOfferCompleted.removeListener(this.placeOfferCompletedListener);
        this.paymentAccountsComboBox.setOnAction(null);
        this.currencyComboBox.setOnAction(null);
    }

    private void addScrollPane() {
        this.scrollPane = GUIUtil.createScrollPane();
        ((AnchorPane)this.root).getChildren().add((Object)this.scrollPane);
    }

    private void addGridPane() {
        this.gridPane = new GridPane();
        this.gridPane.getStyleClass().add((Object)"content-pane");
        this.gridPane.setPadding(new Insets(25.0, 25.0, 25.0, 25.0));
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        GUIUtil.setDefaultTwoColumnConstraintsForGridPane(this.gridPane);
        this.scrollPane.setContent((Node)this.gridPane);
        this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
    }

    private void addPaymentGroup() {
        this.paymentTitledGroupBg = FormBuilder.addTitledGroupBg(this.gridPane, this.gridRow, 1, Res.get((String)"offerbook.createOffer"), this.heightAdjustment);
        GridPane.setColumnSpan((Node)this.paymentTitledGroupBg, (Integer)2);
        HBox paymentGroupBox = new HBox();
        paymentGroupBox.setAlignment(Pos.CENTER_LEFT);
        paymentGroupBox.setSpacing(12.0);
        paymentGroupBox.setPadding(new Insets(10.0, 0.0, 18.0, 0.0));
        Tuple3 tradingAccountBoxTuple = FormBuilder.addTopLabelComboBox(Res.get((String)"shared.chooseTradingAccount"), Res.get((String)"shared.chooseTradingAccount"));
        Tuple3 currencyBoxTuple = FormBuilder.addTopLabelComboBox(Res.get((String)"shared.currency"), Res.get((String)"list.currency.select"));
        this.paymentAccountsSelection = (VBox)tradingAccountBoxTuple.first;
        this.currencySelection = (VBox)currencyBoxTuple.first;
        paymentGroupBox.getChildren().addAll((Object[])new Node[]{this.paymentAccountsSelection, this.currencySelection});
        GridPane.setRowIndex((Node)paymentGroupBox, (Integer)this.gridRow);
        GridPane.setColumnSpan((Node)paymentGroupBox, (Integer)2);
        GridPane.setMargin((Node)paymentGroupBox, (Insets)new Insets(20.0 + (double)this.heightAdjustment, 0.0, 0.0, 0.0));
        this.gridPane.getChildren().add((Object)paymentGroupBox);
        ((VBox)tradingAccountBoxTuple.first).setMinWidth(800.0);
        this.paymentAccountsComboBox = (ComboBox)tradingAccountBoxTuple.third;
        this.paymentAccountsComboBox.setMinWidth(((VBox)tradingAccountBoxTuple.first).getMinWidth());
        this.paymentAccountsComboBox.setPrefWidth(((VBox)tradingAccountBoxTuple.first).getMinWidth());
        this.paymentAccountsComboBox.getStyleClass().add((Object)"input-with-border");
        this.editOfferElements.add((Node)this.paymentAccountsSelection);
        this.currencyComboBox = (ComboBox)currencyBoxTuple.third;
        this.currencyComboBox.setMaxWidth(((VBox)tradingAccountBoxTuple.first).getMinWidth() / 2.0);
        this.currencyComboBox.getStyleClass().add((Object)"input-with-border");
        this.editOfferElements.add((Node)this.currencySelection);
        this.currencyComboBox.setConverter((StringConverter)new StringConverter<TradeCurrency>(this){

            public String toString(TradeCurrency tradeCurrency) {
                return tradeCurrency.getNameAndCode();
            }

            public TradeCurrency fromString(String s) {
                return null;
            }
        });
        Tuple3<Label, TextField, VBox> currencyTextFieldTuple = FormBuilder.addTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.currency"), "", 5.0);
        this.currencyTextField = (TextField)currencyTextFieldTuple.second;
        this.currencyTextFieldBox = (VBox)currencyTextFieldTuple.third;
        this.currencyTextFieldBox.setMaxWidth(((VBox)tradingAccountBoxTuple.first).getMinWidth() / 2.0);
        this.currencyTextFieldBox.setVisible(false);
        this.editOfferElements.add((Node)this.currencyTextFieldBox);
        paymentGroupBox.getChildren().add((Object)this.currencyTextFieldBox);
    }

    private void addAmountPriceGroup() {
        this.amountTitledGroupBg = FormBuilder.addTitledGroupBg(this.gridPane, ++this.gridRow, 2, Res.get((String)"createOffer.setAmountPrice"), 25 + this.heightAdjustment);
        GridPane.setColumnSpan((Node)this.amountTitledGroupBg, (Integer)2);
        this.addAmountPriceFields();
        this.addSecondRow();
    }

    private void addOptionsGroup() {
        this.setDepositTitledGroupBg = FormBuilder.addTitledGroupBg(this.gridPane, ++this.gridRow, 2, Res.get((String)"shared.advancedOptions"), 25 + this.heightAdjustment);
        this.securityDepositAndFeeBox = new HBox();
        this.securityDepositAndFeeBox.setSpacing(40.0);
        GridPane.setRowIndex((Node)this.securityDepositAndFeeBox, (Integer)this.gridRow);
        GridPane.setColumnSpan((Node)this.securityDepositAndFeeBox, (Integer)Integer.MAX_VALUE);
        GridPane.setColumnIndex((Node)this.securityDepositAndFeeBox, (Integer)0);
        GridPane.setHalignment((Node)this.securityDepositAndFeeBox, (HPos)HPos.LEFT);
        GridPane.setMargin((Node)this.securityDepositAndFeeBox, (Insets)new Insets(50.0, 0.0, 0.0, 0.0));
        this.gridPane.getChildren().add((Object)this.securityDepositAndFeeBox);
        VBox tradeFeeFieldsBox = this.getTradeFeeFieldsBox();
        tradeFeeFieldsBox.setMinWidth(240.0);
        this.securityDepositAndFeeBox.getChildren().addAll((Object[])new Node[]{this.getSecurityDepositBox(), tradeFeeFieldsBox});
        this.buyerAsTakerWithoutDepositSlider = FormBuilder.addSlideToggleButton(this.gridPane, ++this.gridRow, Res.get((String)"createOffer.buyerAsTakerWithoutDeposit"));
        this.buyerAsTakerWithoutDepositSlider.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.buyerAsTakerWithoutDepositSlider.setOnAction(event -> {
            String key = "popup.info.buyerAsTakerWithoutDeposit";
            if (this.buyerAsTakerWithoutDepositSlider.isSelected() && DontShowAgainLookup.showAgain((String)key)) {
                ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)(key + ".headline")))).information(Res.get((String)key))).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.ok"))).onAction(() -> ((MutableOfferDataModel)((MutableOfferViewModel)this.model).dataModel).setBuyerAsTakerWithoutDeposit(true))).onClose(() -> {
                    this.buyerAsTakerWithoutDepositSlider.setSelected(false);
                    ((MutableOfferDataModel)((MutableOfferViewModel)this.model).dataModel).setBuyerAsTakerWithoutDeposit(false);
                })).dontShowAgainId(key)).show();
            } else {
                ((MutableOfferDataModel)((MutableOfferViewModel)this.model).dataModel).setBuyerAsTakerWithoutDeposit(this.buyerAsTakerWithoutDepositSlider.isSelected());
            }
        });
        GridPane.setHalignment((Node)this.buyerAsTakerWithoutDepositSlider, (HPos)HPos.LEFT);
        GridPane.setMargin((Node)this.buyerAsTakerWithoutDepositSlider, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
    }

    private void addExtraInfoGroup() {
        this.extraInfoTitledGroupBg = FormBuilder.addTitledGroupBg(this.gridPane, ++this.gridRow, 1, Res.get((String)"payment.shared.optionalExtra"), 25 + this.heightAdjustment);
        GridPane.setColumnSpan((Node)this.extraInfoTitledGroupBg, (Integer)3);
        this.extraInfoTextArea = new InputTextArea();
        this.extraInfoTextArea.setText("");
        this.extraInfoTextArea.setPromptText(Res.get((String)"payment.shared.extraInfo.prompt.offer"));
        this.extraInfoTextArea.getStyleClass().add((Object)"text-area");
        this.extraInfoTextArea.setWrapText(true);
        this.extraInfoTextArea.setPrefHeight(75.0);
        this.extraInfoTextArea.setMinHeight(75.0);
        this.extraInfoTextArea.setMaxHeight(75.0);
        this.extraInfoTextArea.setFocusTraversable(false);
        GridPane.setRowIndex((Node)this.extraInfoTextArea, (Integer)this.gridRow);
        GridPane.setColumnSpan((Node)this.extraInfoTextArea, (Integer)Integer.MAX_VALUE);
        GridPane.setColumnIndex((Node)this.extraInfoTextArea, (Integer)0);
        GridPane.setHalignment((Node)this.extraInfoTextArea, (HPos)HPos.LEFT);
        GridPane.setMargin((Node)this.extraInfoTextArea, (Insets)new Insets(50.0, 0.0, 10.0, 0.0));
        this.gridPane.getChildren().add((Object)this.extraInfoTextArea);
    }

    private void addNextButtons() {
        Tuple2<Button, Button> tuple = FormBuilder.add2ButtonsAfterGroup(this.gridPane, ++this.gridRow, Res.get((String)"shared.nextStep"), Res.get((String)"shared.cancel"));
        this.nextButton = (AutoTooltipButton)((Object)tuple.first);
        this.nextButton.setMaxWidth(200.0);
        this.editOfferElements.add((Node)this.nextButton);
        this.nextButton.disableProperty().bind((ObservableValue)((MutableOfferViewModel)this.model).isNextButtonDisabled);
        this.cancelButton1 = (AutoTooltipButton)((Object)tuple.second);
        this.cancelButton1.setMaxWidth(200.0);
        this.editOfferElements.add((Node)this.cancelButton1);
        this.cancelButton1.setDefaultButton(false);
        this.cancelButton1.setOnAction(e -> {
            this.close();
            ((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).swapTradeToSavings();
        });
        this.nextButton.setOnAction(e -> {
            if (((MutableOfferViewModel)this.model).isPriceInRange()) {
                boolean isSellOffer = ((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).isSellOffer();
                boolean exceedsUnsignedBuyLimit = ((BigInteger)((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getAmount().get()).compareTo(((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getMaxUnsignedBuyLimit()) > 0;
                String key = "popup.warning.tradeLimitDueAccountAgeRestriction.seller.exceedsUnsignedBuyLimit";
                if (isSellOffer && exceedsUnsignedBuyLimit && DontShowAgainLookup.showAgain((String)key) && HavenoUtils.isReleasedWithinDays((int)182)) {
                    ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)key, (Object[])new Object[]{HavenoUtils.formatXmr((BigInteger)((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getMaxUnsignedBuyLimit(), (boolean)true), Res.get((String)"offerbook.warning.newVersionAnnouncement")}))).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.ok"))).onAction(this::onShowPayFundsScreen)).width(900.0)).dontShowAgainId(key)).show();
                } else {
                    this.onShowPayFundsScreen();
                }
            }
        });
    }

    protected void hideOptionsGroup() {
        this.setDepositTitledGroupBg.setVisible(false);
        this.setDepositTitledGroupBg.setManaged(false);
        this.securityDepositAndFeeBox.setVisible(false);
        this.securityDepositAndFeeBox.setManaged(false);
        this.buyerAsTakerWithoutDepositSlider.setVisible(false);
        this.buyerAsTakerWithoutDepositSlider.setManaged(false);
    }

    protected void hideExtraInfoGroup() {
        this.extraInfoTitledGroupBg.setVisible(false);
        this.extraInfoTitledGroupBg.setManaged(false);
        this.extraInfoTextArea.setVisible(false);
        this.extraInfoTextArea.setManaged(false);
    }

    protected void hideNextButtons() {
        this.nextButton.setVisible(false);
        this.nextButton.setManaged(false);
        this.cancelButton1.setVisible(false);
        this.cancelButton1.setManaged(false);
    }

    protected void hideFundingGroup() {
        this.payFundsTitledGroupBg.setVisible(false);
        this.payFundsTitledGroupBg.setManaged(false);
        this.totalToPayTextField.setVisible(false);
        this.totalToPayTextField.setManaged(false);
        this.addressTextField.setVisible(false);
        this.addressTextField.setManaged(false);
        this.qrCodePane.setVisible(false);
        this.qrCodePane.setManaged(false);
        this.balanceTextField.setVisible(false);
        this.balanceTextField.setManaged(false);
        this.cancelButton2.setVisible(false);
        this.cancelButton2.setManaged(false);
        this.reserveExactAmountSlider.setVisible(false);
        this.reserveExactAmountSlider.setManaged(false);
    }

    protected void showFundingGroup() {
        this.payFundsTitledGroupBg.setVisible(true);
        this.payFundsTitledGroupBg.setManaged(true);
        this.totalToPayTextField.setVisible(true);
        this.totalToPayTextField.setManaged(true);
        this.addressTextField.setVisible(true);
        this.addressTextField.setManaged(true);
        this.qrCodePane.setVisible(true);
        this.qrCodePane.setManaged(true);
        this.balanceTextField.setVisible(true);
        this.balanceTextField.setManaged(true);
        this.cancelButton2.setVisible(true);
        this.cancelButton2.setManaged(true);
        this.reserveExactAmountSlider.setVisible(true);
        this.reserveExactAmountSlider.setManaged(true);
    }

    private VBox getSecurityDepositBox() {
        Tuple3<HBox, InfoInputTextField, Label> tuple = FormBuilder.getEditableValueBoxWithInfo(Res.get((String)"createOffer.securityDeposit.prompt"));
        this.securityDepositInfoInputTextField = (InfoInputTextField)((Object)tuple.second);
        this.securityDepositInputTextField = this.securityDepositInfoInputTextField.getInputTextField();
        this.securityDepositPercentageLabel = (Label)tuple.third;
        this.securityDepositPercentageLabel.setText("%");
        Tuple2<Label, VBox> tradeInputBoxTuple = FormBuilder.getTradeInputBox((Pane)tuple.first, ((MutableOfferViewModel)this.model).getSecurityDepositLabel());
        VBox depositBox = (VBox)tradeInputBoxTuple.second;
        this.securityDepositLabel = (Label)tradeInputBoxTuple.first;
        depositBox.setMaxWidth(310.0);
        this.editOfferElements.add((Node)this.securityDepositInputTextField);
        this.editOfferElements.add((Node)this.securityDepositPercentageLabel);
        return depositBox;
    }

    private void addFundingGroup() {
        this.payFundsTitledGroupBg = FormBuilder.addTitledGroupBg(this.gridPane, this.gridRow, 3, Res.get((String)"createOffer.fundsBox.title"), 20 + this.heightAdjustment);
        this.payFundsTitledGroupBg.getStyleClass().add((Object)"last");
        GridPane.setColumnSpan((Node)this.payFundsTitledGroupBg, (Integer)2);
        this.payFundsTitledGroupBg.setVisible(false);
        this.totalToPayTextField = FormBuilder.addFundsTextfield(this.gridPane, this.gridRow, Res.get((String)"shared.totalsNeeded"), 50.0);
        this.totalToPayTextField.setVisible(false);
        GridPane.setMargin((Node)this.totalToPayTextField, (Insets)new Insets((double)(60 + this.heightAdjustment), 10.0, 0.0, 0.0));
        Tuple2<StackPane, ImageView> qrCodeTuple = GUIUtil.getSmallXmrQrCodePane();
        this.qrCodePane = (StackPane)qrCodeTuple.first;
        this.qrCodeImageView = (ImageView)qrCodeTuple.second;
        Tooltip.install((Node)this.qrCodePane, (Tooltip)new Tooltip(Res.get((String)"shared.openLargeQRWindow")));
        this.qrCodePane.setOnMouseClicked(e -> UserThread.runAfter(() -> new QRCodeWindow(this.getMoneroURI()).show(), (long)200L, (TimeUnit)TimeUnit.MILLISECONDS));
        GridPane.setRowIndex((Node)this.qrCodePane, (Integer)this.gridRow);
        GridPane.setColumnIndex((Node)this.qrCodePane, (Integer)1);
        GridPane.setRowSpan((Node)this.qrCodePane, (Integer)3);
        GridPane.setValignment((Node)this.qrCodePane, (VPos)VPos.BOTTOM);
        GridPane.setMargin((Node)this.qrCodePane, (Insets)new Insets(11.0, 0.0, 0.0, 10.0));
        this.gridPane.getChildren().add((Object)this.qrCodePane);
        this.qrCodePane.setVisible(false);
        this.qrCodePane.setManaged(false);
        this.addressTextField = FormBuilder.addAddressTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.tradeWalletAddress"));
        this.addressTextField.setVisible(false);
        this.balanceTextField = FormBuilder.addBalanceTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.tradeWalletBalance"));
        this.balanceTextField.setVisible(false);
        this.reserveExactAmountSlider = FormBuilder.addSlideToggleButton(this.gridPane, ++this.gridRow, Res.get((String)"shared.reserveExactAmount"), this.heightAdjustment);
        GridPane.setHalignment((Node)this.reserveExactAmountSlider, (HPos)HPos.LEFT);
        GridPane.setMargin((Node)this.reserveExactAmountSlider, (Insets)new Insets(-5.0, 0.0, -5.0, 0.0));
        this.reserveExactAmountSlider.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.reserveExactAmountSlider.setVisible(false);
        this.reserveExactAmountSlider.setSelected(this.preferences.getSplitOfferOutput());
        this.reserveExactAmountSlider.setOnAction(event -> {
            boolean selected = this.reserveExactAmountSlider.isSelected();
            if (selected != this.preferences.getSplitOfferOutput()) {
                this.preferences.setSplitOfferOutput(selected);
                ((MutableOfferDataModel)((MutableOfferViewModel)this.model).dataModel).setReserveExactAmount(selected);
            }
        });
        this.fundingHBox = new HBox();
        this.fundingHBox.setVisible(false);
        this.fundingHBox.setManaged(false);
        this.fundingHBox.setSpacing(10.0);
        this.fundFromSavingsWalletButton = new AutoTooltipButton(Res.get((String)"shared.fundFromSavingsWalletButton"));
        this.fundFromSavingsWalletButton.setDefaultButton(true);
        this.fundFromSavingsWalletButton.getStyleClass().add((Object)"action-button");
        this.fundFromSavingsWalletButton.setOnAction(e -> ((MutableOfferViewModel)this.model).fundFromSavingsWallet());
        AutoTooltipLabel label = new AutoTooltipLabel(Res.get((String)"shared.OR"));
        label.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        AutoTooltipButton fundFromExternalWalletButton = new AutoTooltipButton(Res.get((String)"shared.fundFromExternalWalletButton"));
        fundFromExternalWalletButton.setDefaultButton(false);
        fundFromExternalWalletButton.setOnAction(e -> this.openWallet());
        this.waitingForFundsSpinner = new BusyAnimation(false);
        this.waitingForFundsLabel = new AutoTooltipLabel();
        this.waitingForFundsLabel.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        this.fundingHBox.getChildren().addAll((Object[])new Node[]{this.fundFromSavingsWalletButton, label, fundFromExternalWalletButton, this.waitingForFundsSpinner, this.waitingForFundsLabel});
        GridPane.setRowIndex((Node)this.fundingHBox, (Integer)(++this.gridRow));
        GridPane.setColumnSpan((Node)this.fundingHBox, (Integer)2);
        GridPane.setMargin((Node)this.fundingHBox, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
        this.gridPane.getChildren().add((Object)this.fundingHBox);
        this.placeOfferBox = new HBox();
        this.placeOfferBox.setSpacing(10.0);
        GridPane.setRowIndex((Node)this.placeOfferBox, (Integer)this.gridRow);
        GridPane.setColumnSpan((Node)this.placeOfferBox, (Integer)2);
        GridPane.setMargin((Node)this.placeOfferBox, (Insets)new Insets(5.0, 20.0, 0.0, 0.0));
        this.gridPane.getChildren().add((Object)this.placeOfferBox);
        this.placeOfferButton = new AutoTooltipButton();
        this.placeOfferButton.setOnAction(e -> this.onPlaceOffer());
        this.placeOfferButton.setMinHeight(40.0);
        this.placeOfferButton.setPadding(new Insets(0.0, 20.0, 0.0, 20.0));
        this.placeOfferBox.getChildren().add((Object)this.placeOfferButton);
        this.placeOfferBox.visibleProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.fundingHBox.getChildren().remove((Object)this.cancelButton2);
                this.placeOfferBox.getChildren().add((Object)this.cancelButton2);
            } else if (!this.fundingHBox.getChildren().contains((Object)this.cancelButton2)) {
                this.placeOfferBox.getChildren().remove((Object)this.cancelButton2);
                this.fundingHBox.getChildren().add((Object)this.cancelButton2);
            }
        });
        this.cancelButton2 = new AutoTooltipButton(Res.get((String)"shared.cancel"));
        this.fundingHBox.getChildren().add((Object)this.cancelButton2);
        this.cancelButton2.setOnAction(e -> {
            String key = "CreateOfferCancelAndFunded";
            if (((OfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getIsXmrWalletFunded().get() && this.preferences.showAgain(key)) {
                ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().backgroundInfo(Res.get((String)"createOffer.warnCancelOffer"))).closeButtonText(Res.get((String)"shared.no"))).actionButtonText(Res.get((String)"shared.yesCancel"))).onAction(() -> {
                    this.close();
                    ((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).swapTradeToSavings();
                })).dontShowAgainId(key)).show();
            } else {
                this.close();
                ((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).swapTradeToSavings();
            }
        });
        this.cancelButton2.setDefaultButton(false);
        this.cancelButton2.setVisible(false);
        this.hideFundingGroup();
    }

    private void openWallet() {
        try {
            Utilities.openURI((URI)URI.create(this.getMoneroURI()));
        }
        catch (Exception ex) {
            this.log.warn(ex.getMessage());
            ((Popup)new Popup().warning(Res.get((String)"shared.openDefaultWalletFailed"))).show();
        }
    }

    @NotNull
    private String getMoneroURI() {
        return GUIUtil.getMoneroURI(this.addressTextField.getAddress(), (BigInteger)((OfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getMissingCoin().get(), ((MutableOfferViewModel)this.model).getPaymentLabel());
    }

    private void addAmountPriceFields() {
        Tuple3<HBox, InputTextField, Label> amountValueCurrencyBoxTuple = FormBuilder.getEditableValueBox(Res.get((String)"createOffer.amount.prompt"));
        this.amountValueCurrencyBox = (HBox)amountValueCurrencyBoxTuple.first;
        this.amountTextField = (InputTextField)((Object)amountValueCurrencyBoxTuple.second);
        this.editOfferElements.add((Node)this.amountTextField);
        this.amountBtcLabel = (Label)amountValueCurrencyBoxTuple.third;
        this.editOfferElements.add((Node)this.amountBtcLabel);
        Tuple2<Label, VBox> amountInputBoxTuple = FormBuilder.getTradeInputBox((Pane)this.amountValueCurrencyBox, ((MutableOfferViewModel)this.model).getAmountDescription());
        this.amountDescriptionLabel = (Label)amountInputBoxTuple.first;
        this.editOfferElements.add((Node)this.amountDescriptionLabel);
        VBox amountBox = (VBox)amountInputBoxTuple.second;
        this.xLabel = new Label();
        this.xIcon = FormBuilder.getIconForLabel((GlyphIcons)MaterialDesignIcon.CLOSE, "2em", this.xLabel);
        this.xIcon.getStyleClass().add((Object)"opaque-icon");
        this.xLabel.getStyleClass().add((Object)"opaque-icon-character");
        Tuple3<HBox, InfoInputTextField, Label> priceAsPercentageTuple = FormBuilder.getEditableValueBoxWithInfo(Res.get((String)"createOffer.price.prompt"));
        this.priceAsPercentageValueCurrencyBox = (HBox)priceAsPercentageTuple.first;
        this.marketBasedPriceInfoInputTextField = (InfoInputTextField)((Object)priceAsPercentageTuple.second);
        this.marketBasedPriceTextField = this.marketBasedPriceInfoInputTextField.getInputTextField();
        this.editOfferElements.add((Node)this.marketBasedPriceTextField);
        this.marketBasedPriceLabel = (Label)priceAsPercentageTuple.third;
        this.editOfferElements.add((Node)this.marketBasedPriceLabel);
        Tuple2<Label, VBox> priceAsPercentageInputBoxTuple = FormBuilder.getTradeInputBox((Pane)this.priceAsPercentageValueCurrencyBox, ((MutableOfferViewModel)this.model).getPercentagePriceDescription());
        this.percentagePriceDescriptionLabel = (Label)priceAsPercentageInputBoxTuple.first;
        FormBuilder.getSmallIconForLabel((GlyphIcons)MaterialDesignIcon.CHART_LINE, this.percentagePriceDescriptionLabel, "small-icon-label");
        this.percentagePriceBox = (VBox)priceAsPercentageInputBoxTuple.second;
        this.resultLabel = new AutoTooltipLabel("=");
        this.resultLabel.getStyleClass().add((Object)"opaque-icon-character");
        Tuple3<HBox, InfoInputTextField, Label> volumeValueCurrencyBoxTuple = FormBuilder.getEditableValueBoxWithInfo(Res.get((String)"createOffer.volume.prompt"));
        this.volumeValueCurrencyBox = (HBox)volumeValueCurrencyBoxTuple.first;
        this.volumeInfoInputTextField = (InfoInputTextField)((Object)volumeValueCurrencyBoxTuple.second);
        this.volumeTextField = this.volumeInfoInputTextField.getInputTextField();
        this.editOfferElements.add((Node)this.volumeTextField);
        this.volumeCurrencyLabel = (Label)volumeValueCurrencyBoxTuple.third;
        this.editOfferElements.add((Node)this.volumeCurrencyLabel);
        Tuple2<Label, VBox> volumeInputBoxTuple = FormBuilder.getTradeInputBox((Pane)this.volumeValueCurrencyBox, (String)((MutableOfferViewModel)this.model).volumeDescriptionLabel.get());
        this.volumeDescriptionLabel = (Label)volumeInputBoxTuple.first;
        this.editOfferElements.add((Node)this.volumeDescriptionLabel);
        VBox volumeBox = (VBox)volumeInputBoxTuple.second;
        this.firstRowHBox = new HBox();
        this.firstRowHBox.setSpacing(5.0);
        this.firstRowHBox.setAlignment(Pos.CENTER_LEFT);
        this.firstRowHBox.getChildren().addAll((Object[])new Node[]{amountBox, this.xLabel, this.percentagePriceBox, this.resultLabel, volumeBox});
        GridPane.setColumnSpan((Node)this.firstRowHBox, (Integer)2);
        GridPane.setRowIndex((Node)this.firstRowHBox, (Integer)this.gridRow);
        GridPane.setMargin((Node)this.firstRowHBox, (Insets)new Insets((double)(40 + this.heightAdjustment), 10.0, 0.0, 0.0));
        this.gridPane.getChildren().add((Object)this.firstRowHBox);
    }

    private void updatePriceToggleButtons(boolean fixedPriceSelected) {
        int marketPriceAvailable = ((MutableOfferViewModel)this.model).marketPriceAvailableProperty.get();
        fixedPriceSelected = fixedPriceSelected || marketPriceAvailable == 0;
        ((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).setUseMarketBasedPrice(marketPriceAvailable == 1 && !fixedPriceSelected);
        this.percentagePriceBox.setDisable(fixedPriceSelected);
        this.fixedPriceBox.setDisable(!fixedPriceSelected);
        if (fixedPriceSelected) {
            this.firstRowHBox.getChildren().remove((Object)this.percentagePriceBox);
            this.secondRowHBox.getChildren().remove((Object)this.fixedPriceBox);
            if (!this.firstRowHBox.getChildren().contains((Object)this.fixedPriceBox)) {
                this.firstRowHBox.getChildren().add(2, (Object)this.fixedPriceBox);
            }
            if (!this.secondRowHBox.getChildren().contains((Object)this.percentagePriceBox)) {
                this.secondRowHBox.getChildren().add(2, (Object)this.percentagePriceBox);
            }
            ((MutableOfferViewModel)this.model).triggerPrice.set((Object)"");
            ((MutableOfferViewModel)this.model).onTriggerPriceTextFieldChanged();
        } else {
            this.firstRowHBox.getChildren().remove((Object)this.fixedPriceBox);
            this.secondRowHBox.getChildren().remove((Object)this.percentagePriceBox);
            if (!this.firstRowHBox.getChildren().contains((Object)this.percentagePriceBox)) {
                this.firstRowHBox.getChildren().add(2, (Object)this.percentagePriceBox);
            }
            if (!this.secondRowHBox.getChildren().contains((Object)this.fixedPriceBox)) {
                this.secondRowHBox.getChildren().add(2, (Object)this.fixedPriceBox);
            }
        }
        this.triggerPriceVBox.setVisible(!fixedPriceSelected);
        ((MutableOfferViewModel)this.model).onFixPriceToggleChange(fixedPriceSelected);
    }

    private void addSecondRow() {
        Tuple3<HBox, InputTextField, Label> priceValueCurrencyBoxTuple = FormBuilder.getEditableValueBox(Res.get((String)"createOffer.price.prompt"));
        this.priceValueCurrencyBox = (HBox)priceValueCurrencyBoxTuple.first;
        this.fixedPriceTextField = (InputTextField)((Object)priceValueCurrencyBoxTuple.second);
        this.editOfferElements.add((Node)this.fixedPriceTextField);
        this.priceCurrencyLabel = (Label)priceValueCurrencyBoxTuple.third;
        this.editOfferElements.add((Node)this.priceCurrencyLabel);
        Tuple2<Label, VBox> priceInputBoxTuple = FormBuilder.getTradeInputBox((Pane)this.priceValueCurrencyBox, "");
        this.priceDescriptionLabel = (Label)priceInputBoxTuple.first;
        FormBuilder.getSmallIconForLabel((GlyphIcons)MaterialDesignIcon.LOCK, this.priceDescriptionLabel, "small-icon-label");
        this.editOfferElements.add((Node)this.priceDescriptionLabel);
        this.fixedPriceBox = (VBox)priceInputBoxTuple.second;
        this.marketBasedPriceTextField.setPromptText(Res.get((String)"shared.enterPercentageValue"));
        this.marketBasedPriceLabel.setText("%");
        Tuple3<HBox, InputTextField, Label> amountValueCurrencyBoxTuple = FormBuilder.getEditableValueBox(Res.get((String)"createOffer.amount.prompt"));
        this.minAmountValueCurrencyBox = (HBox)amountValueCurrencyBoxTuple.first;
        this.minAmountTextField = (InputTextField)((Object)amountValueCurrencyBoxTuple.second);
        this.editOfferElements.add((Node)this.minAmountTextField);
        this.minAmountBtcLabel = (Label)amountValueCurrencyBoxTuple.third;
        this.editOfferElements.add((Node)this.minAmountBtcLabel);
        Tuple2<Label, VBox> amountInputBoxTuple = FormBuilder.getTradeInputBox((Pane)this.minAmountValueCurrencyBox, Res.get((String)"createOffer.amountPriceBox.minAmountDescription"));
        this.fakeXLabel = new Label();
        this.fakeXIcon = FormBuilder.getIconForLabel((GlyphIcons)MaterialDesignIcon.CLOSE, "2em", this.fakeXLabel);
        this.fakeXLabel.getStyleClass().add((Object)"opaque-icon-character");
        this.fakeXLabel.setVisible(false);
        this.priceTypeToggleButton = FormBuilder.getIconButton((GlyphIcons)MaterialDesignIcon.SWAP_VERTICAL);
        this.editOfferElements.add((Node)this.priceTypeToggleButton);
        HBox.setMargin((Node)this.priceTypeToggleButton, (Insets)new Insets(25.0, 1.5, 0.0, 0.0));
        this.priceTypeToggleButton.setOnAction(actionEvent -> this.updatePriceToggleButtons(((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getUseMarketBasedPrice().getValue()));
        Tuple3<HBox, InfoInputTextField, Label> triggerPriceTuple3 = FormBuilder.getEditableValueBoxWithInfo(Res.get((String)"createOffer.triggerPrice.prompt"));
        this.triggerPriceHBox = (HBox)triggerPriceTuple3.first;
        this.triggerPriceInfoInputTextField = (InfoInputTextField)((Object)triggerPriceTuple3.second);
        this.editOfferElements.add((Node)this.triggerPriceInfoInputTextField);
        this.triggerPriceInputTextField = this.triggerPriceInfoInputTextField.getInputTextField();
        this.triggerPriceCurrencyLabel = (Label)triggerPriceTuple3.third;
        this.editOfferElements.add((Node)this.triggerPriceCurrencyLabel);
        Tuple2<Label, VBox> triggerPriceTuple2 = FormBuilder.getTradeInputBox((Pane)this.triggerPriceHBox, ((MutableOfferViewModel)this.model).getTriggerPriceDescriptionLabel());
        this.triggerPriceDescriptionLabel = (Label)triggerPriceTuple2.first;
        this.triggerPriceDescriptionLabel.setPrefWidth(290.0);
        this.triggerPriceVBox = (VBox)triggerPriceTuple2.second;
        this.secondRowHBox = new HBox();
        this.secondRowHBox.setSpacing(5.0);
        this.secondRowHBox.setAlignment(Pos.CENTER_LEFT);
        this.secondRowHBox.getChildren().addAll((Object[])new Node[]{(Node)amountInputBoxTuple.second, this.fakeXLabel, this.fixedPriceBox, this.priceTypeToggleButton, this.triggerPriceVBox});
        GridPane.setColumnSpan((Node)this.secondRowHBox, (Integer)2);
        GridPane.setRowIndex((Node)this.secondRowHBox, (Integer)(++this.gridRow));
        GridPane.setColumnIndex((Node)this.secondRowHBox, (Integer)0);
        GridPane.setMargin((Node)this.secondRowHBox, (Insets)new Insets(0.0, 10.0, 10.0, 0.0));
        this.gridPane.getChildren().add((Object)this.secondRowHBox);
    }

    private VBox getTradeFeeFieldsBox() {
        this.tradeFeeInXmrLabel = new Label();
        this.tradeFeeInXmrLabel.setMouseTransparent(true);
        this.tradeFeeInXmrLabel.setId("trade-fee-textfield");
        VBox vBox = new VBox();
        vBox.setSpacing(6.0);
        vBox.setMaxWidth(300.0);
        vBox.setAlignment(Pos.CENTER_LEFT);
        vBox.getChildren().addAll((Object[])new Node[]{this.tradeFeeInXmrLabel});
        HBox hBox = new HBox();
        hBox.getChildren().addAll((Object[])new Node[]{vBox});
        hBox.setMinHeight(47.0);
        hBox.setMaxHeight(hBox.getMinHeight());
        HBox.setHgrow((Node)vBox, (Priority)Priority.ALWAYS);
        Tuple2<Label, VBox> tradeInputBox = FormBuilder.getTradeInputBox((Pane)hBox, Res.get((String)"createOffer.tradeFee.description"));
        this.tradeFeeDescriptionLabel = (Label)tradeInputBox.first;
        return (VBox)tradeInputBox.second;
    }

    private GridPane createInfoPopover() {
        GridPane infoGridPane = new GridPane();
        infoGridPane.setHgap(5.0);
        infoGridPane.setVgap(5.0);
        infoGridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        int i = 0;
        if (((MutableOfferViewModel)this.model).isSellOffer()) {
            OfferViewUtil.addPayInfoEntry(infoGridPane, i++, Res.getWithCol((String)"shared.tradeAmount"), ((MutableOfferViewModel)this.model).getTradeAmount());
        }
        OfferViewUtil.addPayInfoEntry(infoGridPane, i++, Res.getWithCol((String)"shared.yourSecurityDeposit"), ((MutableOfferViewModel)this.model).getSecurityDepositInfo());
        OfferViewUtil.addPayInfoEntry(infoGridPane, i++, Res.getWithCol((String)"createOffer.fundsBox.offerFee"), ((MutableOfferViewModel)this.model).getTradeFee());
        Separator separator = new Separator();
        separator.setOrientation(Orientation.HORIZONTAL);
        separator.getStyleClass().add((Object)"offer-separator");
        GridPane.setConstraints((Node)separator, (int)1, (int)i++);
        infoGridPane.getChildren().add((Object)separator);
        OfferViewUtil.addPayInfoEntry(infoGridPane, i, Res.getWithCol((String)"shared.total"), ((MutableOfferViewModel)this.model).getTotalToPayInfo());
        return infoGridPane;
    }

    private ObservableList<PaymentAccount> getPaymentAccounts() {
        return this.filterPaymentAccounts(((MutableOfferDataModel)((MutableOfferViewModel)this.model).getDataModel()).getPaymentAccounts());
    }

    protected abstract ObservableList<PaymentAccount> filterPaymentAccounts(ObservableList<PaymentAccount> var1);

    public void setOfferActionHandler(OfferView.OfferActionHandler offerActionHandler) {
        this.offerActionHandler = offerActionHandler;
    }
}

