/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.UserThread;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.util.MathUtils;
import haveno.common.util.Utilities;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.CreateOfferService;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OfferUtil;
import haveno.core.offer.OpenOfferManager;
import haveno.core.payment.PaymentAccount;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.handlers.TransactionResultHandler;
import haveno.core.trade.statistics.TradeStatistics3;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.core.util.VolumeUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.coin.CoinUtil;
import haveno.core.xmr.listeners.XmrBalanceListener;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.core.xmr.wallet.Restrictions;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.Navigation;
import haveno.desktop.main.offer.OfferDataModel;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.P2PService;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.SetChangeListener;
import org.jetbrains.annotations.NotNull;

public abstract class MutableOfferDataModel
extends OfferDataModel {
    protected final CreateOfferService createOfferService;
    protected final OpenOfferManager openOfferManager;
    private final XmrWalletService xmrWalletService;
    private final Preferences preferences;
    protected final User user;
    private final P2PService p2PService;
    protected final PriceFeedService priceFeedService;
    final String shortOfferId;
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final CoinFormatter btcFormatter;
    private final Navigation navigation;
    private final String offerId;
    private final SetChangeListener<PaymentAccount> paymentAccountsChangeListener;
    protected OfferDirection direction;
    protected TradeCurrency tradeCurrency;
    protected final StringProperty tradeCurrencyCode = new SimpleStringProperty();
    protected final BooleanProperty useMarketBasedPrice = new SimpleBooleanProperty();
    protected final ObjectProperty<BigInteger> amount = new SimpleObjectProperty();
    protected final ObjectProperty<BigInteger> minAmount = new SimpleObjectProperty();
    protected final ObjectProperty<Price> price = new SimpleObjectProperty();
    protected final ObjectProperty<Volume> volume = new SimpleObjectProperty();
    protected final ObjectProperty<Volume> minVolume = new SimpleObjectProperty();
    protected final ObjectProperty<String> extraInfo = new SimpleObjectProperty();
    protected final DoubleProperty securityDepositPct = new SimpleDoubleProperty();
    protected final BooleanProperty buyerAsTakerWithoutDeposit = new SimpleBooleanProperty();
    protected final ObservableList<PaymentAccount> paymentAccounts = FXCollections.observableArrayList();
    protected PaymentAccount paymentAccount;
    boolean isTabSelected;
    protected double marketPriceMarginPct = 0.0;
    private boolean marketPriceAvailable;
    protected boolean allowAmountUpdate = true;
    private final TradeStatisticsManager tradeStatisticsManager;
    private final Predicate<ObjectProperty<BigInteger>> isNonZeroAmount = c -> c.get() != null && ((BigInteger)c.get()).compareTo(BigInteger.ZERO) != 0;
    private final Predicate<ObjectProperty<Price>> isNonZeroPrice = p -> p.get() != null && !((Price)p.get()).isZero();
    private final Predicate<ObjectProperty<Volume>> isNonZeroVolume = v -> v.get() != null && !((Volume)v.get()).isZero();
    protected long triggerPrice;
    protected boolean reserveExactAmount;
    private XmrBalanceListener xmrBalanceListener;

    @Inject
    public MutableOfferDataModel(CreateOfferService createOfferService, OpenOfferManager openOfferManager, OfferUtil offerUtil, XmrWalletService xmrWalletService, Preferences preferences, User user, P2PService p2PService, PriceFeedService priceFeedService, AccountAgeWitnessService accountAgeWitnessService, @Named(value="BTC") CoinFormatter btcFormatter, TradeStatisticsManager tradeStatisticsManager, Navigation navigation) {
        super(xmrWalletService, offerUtil);
        this.xmrWalletService = xmrWalletService;
        this.createOfferService = createOfferService;
        this.openOfferManager = openOfferManager;
        this.preferences = preferences;
        this.user = user;
        this.p2PService = p2PService;
        this.priceFeedService = priceFeedService;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.btcFormatter = btcFormatter;
        this.navigation = navigation;
        this.tradeStatisticsManager = tradeStatisticsManager;
        this.offerId = OfferUtil.getRandomOfferId();
        this.shortOfferId = Utilities.getShortId((String)this.offerId);
        this.reserveExactAmount = preferences.getSplitOfferOutput();
        this.useMarketBasedPrice.set(preferences.isUsePercentageBasedPrice());
        this.securityDepositPct.set(Restrictions.getMinSecurityDepositPct());
        this.paymentAccountsChangeListener = change -> this.fillPaymentAccounts();
    }

    @Override
    public void activate() {
        this.addListeners();
        if (this.isTabSelected) {
            this.priceFeedService.setCurrencyCode((String)this.tradeCurrencyCode.get());
        }
        this.updateBalances();
    }

    @Override
    protected void deactivate() {
        this.removeListeners();
    }

    private void addListeners() {
        if (this.xmrBalanceListener != null) {
            this.xmrWalletService.addBalanceListener(this.xmrBalanceListener);
        }
        this.user.getPaymentAccountsAsObservable().addListener(this.paymentAccountsChangeListener);
    }

    private void removeListeners() {
        if (this.xmrBalanceListener != null) {
            this.xmrWalletService.removeBalanceListener(this.xmrBalanceListener);
        }
        this.user.getPaymentAccountsAsObservable().removeListener(this.paymentAccountsChangeListener);
    }

    public boolean initWithData(OfferDirection direction, TradeCurrency tradeCurrency, boolean initAddressEntry) {
        if (initAddressEntry) {
            this.addressEntry = this.xmrWalletService.getOrCreateAddressEntry(this.offerId, XmrAddressEntry.Context.OFFER_FUNDING);
            this.xmrBalanceListener = new XmrBalanceListener(this.getAddressEntry().getSubaddressIndex()){

                public void onBalanceChanged(BigInteger balance) {
                    MutableOfferDataModel.this.updateBalances();
                }
            };
        }
        this.direction = direction;
        this.tradeCurrency = tradeCurrency;
        this.fillPaymentAccounts();
        PaymentAccount lastSelectedPaymentAccount = this.getPreselectedPaymentAccount();
        PaymentAccount account = lastSelectedPaymentAccount != null && lastSelectedPaymentAccount.getTradeCurrencies().contains(tradeCurrency) && this.user.getPaymentAccounts() != null && this.user.getPaymentAccounts().stream().anyMatch(paymentAccount -> paymentAccount.getId().equals(lastSelectedPaymentAccount.getId())) ? lastSelectedPaymentAccount : this.user.findFirstPaymentAccountWithCurrency(tradeCurrency);
        if (account != null) {
            this.paymentAccount = account;
        } else {
            Optional<PaymentAccount> paymentAccountOptional = this.getAnyPaymentAccount();
            if (paymentAccountOptional.isPresent()) {
                this.paymentAccount = paymentAccountOptional.get();
            } else {
                this.log.warn("PaymentAccount not available. Should never get called as in offer view you should not be able to open a create offer view");
                return false;
            }
        }
        this.setTradeCurrencyFromPaymentAccount(this.paymentAccount);
        this.tradeCurrencyCode.set((Object)this.tradeCurrency.getCode());
        this.priceFeedService.setCurrencyCode((String)this.tradeCurrencyCode.get());
        this.calculateVolume();
        this.calculateTotalToPay();
        this.updateBalances();
        this.setSuggestedSecurityDeposit(this.getPaymentAccount());
        return true;
    }

    @NotNull
    private Optional<PaymentAccount> getAnyPaymentAccount() {
        if (CurrencyUtil.isFiatCurrency((String)this.tradeCurrency.getCode())) {
            return this.paymentAccounts.stream().filter(paymentAccount1 -> paymentAccount1.isFiat()).findAny();
        }
        if (CurrencyUtil.isCryptoCurrency((String)this.tradeCurrency.getCode())) {
            return this.paymentAccounts.stream().filter(paymentAccount1 -> paymentAccount1.isCryptoCurrency()).findAny();
        }
        return this.paymentAccounts.stream().filter(paymentAccount1 -> paymentAccount1.getTradeCurrency().isPresent()).findAny();
    }

    protected PaymentAccount getPreselectedPaymentAccount() {
        return this.preferences.getSelectedPaymentAccountForCreateOffer();
    }

    void onTabSelected(boolean isSelected) {
        this.isTabSelected = isSelected;
        if (this.isTabSelected) {
            this.priceFeedService.setCurrencyCode((String)this.tradeCurrencyCode.get());
        }
    }

    @Override
    protected void updateBalances() {
        if (this.addressEntry == null) {
            return;
        }
        super.updateBalances();
        UserThread.await(() -> {
            this.missingCoin.set((Object)this.offerUtil.getBalanceShortage((BigInteger)this.totalToPay.get(), (BigInteger)this.balance.get()));
            this.isXmrWalletFunded.set(this.offerUtil.isBalanceSufficient((BigInteger)this.totalToPay.get(), (BigInteger)this.balance.get()));
            if (this.totalToPay.get() != null && this.isXmrWalletFunded.get() && !this.showWalletFundedNotification.get()) {
                this.showWalletFundedNotification.set(true);
            }
        });
    }

    protected Offer createAndGetOffer() {
        return this.createOfferService.createAndGetOffer(this.offerId, this.direction, (String)this.tradeCurrencyCode.get(), (BigInteger)this.amount.get(), (BigInteger)this.minAmount.get(), this.useMarketBasedPrice.get() ? null : (Price)this.price.get(), this.useMarketBasedPrice.get(), this.useMarketBasedPrice.get() ? this.marketPriceMarginPct : 0.0, this.securityDepositPct.get(), this.paymentAccount, this.buyerAsTakerWithoutDeposit.get(), this.buyerAsTakerWithoutDeposit.get(), (String)this.extraInfo.get());
    }

    void onPlaceOffer(Offer offer, TransactionResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.openOfferManager.placeOffer(offer, this.useSavingsWallet, this.triggerPrice, this.reserveExactAmount, false, null, resultHandler, errorMessageHandler);
    }

    void onPaymentAccountSelected(PaymentAccount paymentAccount) {
        if (paymentAccount != null && !this.paymentAccount.equals((Object)paymentAccount)) {
            this.preferences.setSelectedPaymentAccountForCreateOffer(paymentAccount);
            this.paymentAccount = paymentAccount;
            this.setTradeCurrencyFromPaymentAccount(paymentAccount);
            this.setSuggestedSecurityDeposit(this.getPaymentAccount());
            if (this.amount.get() != null && this.allowAmountUpdate) {
                this.amount.set((Object)((BigInteger)this.amount.get()).min(this.getMaxTradeLimit()));
            }
        }
    }

    private void setSuggestedSecurityDeposit(PaymentAccount paymentAccount) {
        double minSecurityDeposit = Restrictions.getMinSecurityDepositPct();
        try {
            if (this.getTradeCurrency() == null) {
                this.setSecurityDepositPct(minSecurityDeposit);
                return;
            }
            int blocksRange = Restrictions.getLockTime((boolean)paymentAccount.getPaymentMethod().isBlockchain());
            Date startDate = new Date(System.currentTimeMillis() - (long)blocksRange * 10L * 60000L);
            List<TradeStatistics3> sortedRangeData = this.tradeStatisticsManager.getObservableTradeStatisticsSet().stream().filter(e -> e.getCurrency().equals(this.getTradeCurrency().getCode())).filter(e -> e.getDate().compareTo(startDate) >= 0).sorted(Comparator.comparing(TradeStatistics3::getDate)).collect(Collectors.toList());
            MathUtils.MovingAverage movingAverage = new MathUtils.MovingAverage(10, 0.2);
            double[] extremes = new double[]{Double.MAX_VALUE, Double.MIN_VALUE};
            sortedRangeData.forEach(e -> {
                long price = e.getTradePrice().getValue();
                movingAverage.next(price).ifPresent(val -> {
                    if (val < extremes[0]) {
                        extremes[0] = val;
                    }
                    if (val > extremes[1]) {
                        extremes[1] = val;
                    }
                });
            });
            double min = extremes[0];
            double max = extremes[1];
            if (min == 0.0 || max == 0.0) {
                this.setSecurityDepositPct(minSecurityDeposit);
                return;
            }
            double suggestedSecurityDeposit = Math.min(2.0 * (max - min) / max, Restrictions.getMaxSecurityDepositPct());
            this.securityDepositPct.set(Math.max(suggestedSecurityDeposit, minSecurityDeposit));
        }
        catch (Throwable t) {
            this.log.error(t.toString());
            this.securityDepositPct.set(minSecurityDeposit);
        }
    }

    private void setTradeCurrencyFromPaymentAccount(PaymentAccount paymentAccount) {
        if (!paymentAccount.getTradeCurrencies().contains(this.tradeCurrency)) {
            this.tradeCurrency = paymentAccount.getTradeCurrency().orElse(this.tradeCurrency);
        }
        Preconditions.checkNotNull((Object)this.tradeCurrency, (Object)"tradeCurrency must not be null");
        this.tradeCurrencyCode.set((Object)this.tradeCurrency.getCode());
    }

    void onCurrencySelected(TradeCurrency tradeCurrency) {
        if (tradeCurrency != null) {
            if (!this.tradeCurrency.equals((Object)tradeCurrency)) {
                this.volume.set(null);
                this.minVolume.set(null);
                this.price.set(null);
                this.marketPriceMarginPct = 0.0;
            }
            this.tradeCurrency = tradeCurrency;
            String code = this.tradeCurrency.getCode();
            this.tradeCurrencyCode.set((Object)code);
            if (this.paymentAccount != null) {
                this.paymentAccount.setSelectedTradeCurrency(tradeCurrency);
            }
            this.priceFeedService.setCurrencyCode(code);
            Optional<TradeCurrency> tradeCurrencyOptional = this.preferences.getTradeCurrenciesAsObservable().stream().filter(e -> e.getCode().equals(code)).findAny();
            if (tradeCurrencyOptional.isEmpty()) {
                if (CurrencyUtil.isCryptoCurrency((String)code)) {
                    CurrencyUtil.getCryptoCurrency((String)code).ifPresent(arg_0 -> ((Preferences)this.preferences).addCryptoCurrency(arg_0));
                } else {
                    CurrencyUtil.getTraditionalCurrency((String)code).ifPresent(arg_0 -> ((Preferences)this.preferences).addTraditionalCurrency(arg_0));
                }
            }
        }
    }

    void fundFromSavingsWallet() {
        this.useSavingsWallet = true;
        this.updateBalances();
    }

    boolean isMinAmountLessOrEqualAmount() {
        if (this.minAmount.get() != null && this.amount.get() != null) {
            return ((BigInteger)this.minAmount.get()).compareTo((BigInteger)this.amount.get()) <= 0;
        }
        return true;
    }

    public OfferDirection getDirection() {
        return this.direction;
    }

    boolean isSellOffer() {
        return this.direction == OfferDirection.SELL;
    }

    boolean isBuyOffer() {
        return this.direction == OfferDirection.BUY;
    }

    XmrAddressEntry getAddressEntry() {
        return this.addressEntry;
    }

    protected TradeCurrency getTradeCurrency() {
        return this.tradeCurrency;
    }

    protected PaymentAccount getPaymentAccount() {
        return this.paymentAccount;
    }

    protected void setUseMarketBasedPrice(boolean useMarketBasedPrice) {
        this.useMarketBasedPrice.set(useMarketBasedPrice);
        this.preferences.setUsePercentageBasedPrice(useMarketBasedPrice);
    }

    protected void setBuyerAsTakerWithoutDeposit(boolean buyerAsTakerWithoutDeposit) {
        this.buyerAsTakerWithoutDeposit.set(buyerAsTakerWithoutDeposit);
    }

    public ObservableList<PaymentAccount> getPaymentAccounts() {
        return this.paymentAccounts;
    }

    public double getMarketPriceMarginPct() {
        return this.marketPriceMarginPct;
    }

    BigInteger getMinTradeLimit() {
        return Restrictions.getMinTradeAmount();
    }

    BigInteger getMaxTradeLimit() {
        return this.offerUtil.getMaxTradeLimitForRelease(this.paymentAccount, (String)this.tradeCurrencyCode.get(), this.direction, this.buyerAsTakerWithoutDeposit.get());
    }

    double calculateMarketPriceManual(double marketPrice, double volumeAsDouble, double amountAsDouble) {
        double manualPriceAsDouble = this.offerUtil.calculateManualPrice(volumeAsDouble, amountAsDouble);
        double percentage = this.offerUtil.calculateMarketPriceMarginPct(manualPriceAsDouble, marketPrice);
        this.setMarketPriceMarginPct(percentage);
        return manualPriceAsDouble;
    }

    void calculateVolume() {
        if (this.isNonZeroPrice.test(this.price) && this.isNonZeroAmount.test(this.amount)) {
            try {
                Volume volumeByAmount = this.calculateVolumeForAmount(this.amount);
                this.volume.set((Object)volumeByAmount);
                this.calculateMinVolume();
            }
            catch (Throwable t) {
                this.log.error(t.toString());
            }
        }
        this.updateBalances();
    }

    void calculateMinVolume() {
        if (this.isNonZeroPrice.test(this.price) && this.isNonZeroAmount.test(this.minAmount)) {
            try {
                Volume volumeByAmount = this.calculateVolumeForAmount(this.minAmount);
                this.minVolume.set((Object)volumeByAmount);
            }
            catch (Throwable t) {
                this.log.error(t.toString());
            }
        }
    }

    private Volume calculateVolumeForAmount(ObjectProperty<BigInteger> minAmount) {
        Volume volumeByAmount = ((Price)this.price.get()).getVolumeByAmount((BigInteger)minAmount.get());
        volumeByAmount = VolumeUtil.getAdjustedVolume((Volume)volumeByAmount, (String)this.paymentAccount.getPaymentMethod().getId());
        return volumeByAmount;
    }

    void calculateAmount() {
        if (this.isNonZeroPrice.test(this.price) && this.isNonZeroVolume.test(this.volume) && this.allowAmountUpdate) {
            try {
                Volume volumeBefore = (Volume)this.volume.get();
                this.calculateVolume();
                if (this.amount.get() == null || !volumeBefore.equals((Object)((Price)this.price.get()).getVolumeByAmount((BigInteger)this.amount.get()))) {
                    BigInteger value = ((Price)this.price.get()).getAmountByVolume(volumeBefore);
                    BigInteger minAmount = this.getMinTradeLimit();
                    BigInteger maxAmount = this.getMaxTradeLimit();
                    value = value.max(minAmount);
                    value = value.min(maxAmount);
                    value = CoinUtil.getRoundedAmount((BigInteger)value, (Price)((Price)this.price.get()), (BigInteger)minAmount, (BigInteger)maxAmount, (String)((String)this.tradeCurrencyCode.get()), (String)this.paymentAccount.getPaymentMethod().getId());
                    this.amount.set((Object)value);
                }
                this.calculateTotalToPay();
            }
            catch (Throwable t) {
                this.log.error(t.toString());
            }
        }
    }

    void calculateTotalToPay() {
        BigInteger makerFee = this.getMaxMakerFee();
        if (this.direction != null && this.amount.get() != null && makerFee != null) {
            BigInteger feeAndSecDeposit = this.getSecurityDeposit().add(makerFee);
            BigInteger total = this.isBuyOffer() ? feeAndSecDeposit : feeAndSecDeposit.add((BigInteger)this.amount.get());
            this.totalToPay.set((Object)total);
            this.updateBalances();
        }
    }

    void swapTradeToSavings() {
        this.xmrWalletService.resetAddressEntriesForOpenOffer(this.offerId);
    }

    private void fillPaymentAccounts() {
        if (this.user.getPaymentAccounts() != null) {
            this.paymentAccounts.setAll(new HashSet(this.user.getPaymentAccounts()));
        }
        this.paymentAccounts.sort(Comparator.comparing(PaymentAccount::getAccountName));
    }

    protected abstract Set<PaymentAccount> getUserPaymentAccounts();

    protected void setAmount(BigInteger amount) {
        this.amount.set((Object)amount);
    }

    protected void setMinAmount(BigInteger minAmount) {
        this.minAmount.set((Object)minAmount);
    }

    protected void setPrice(Price price) {
        this.price.set((Object)price);
    }

    protected void setVolume(Volume volume) {
        this.volume.set((Object)volume);
    }

    protected void setSecurityDepositPct(double value) {
        this.securityDepositPct.set(value);
    }

    public void setMarketPriceAvailable(boolean marketPriceAvailable) {
        this.marketPriceAvailable = marketPriceAvailable;
    }

    public void setTriggerPrice(long triggerPrice) {
        this.triggerPrice = triggerPrice;
    }

    public void setMarketPriceMarginPct(double marketPriceMarginPct) {
        this.marketPriceMarginPct = marketPriceMarginPct;
    }

    public void setReserveExactAmount(boolean reserveExactAmount) {
        this.reserveExactAmount = reserveExactAmount;
    }

    protected void setExtraInfo(String extraInfo) {
        this.extraInfo.set((Object)extraInfo);
    }

    public BigInteger getMaxUnsignedBuyLimit() {
        return BigInteger.valueOf(this.accountAgeWitnessService.getUnsignedTradeLimit(this.paymentAccount.getPaymentMethod(), (String)this.tradeCurrencyCode.get(), OfferDirection.BUY));
    }

    protected ReadOnlyObjectProperty<BigInteger> getAmount() {
        return this.amount;
    }

    protected ReadOnlyObjectProperty<BigInteger> getMinAmount() {
        return this.minAmount;
    }

    public ReadOnlyObjectProperty<Price> getPrice() {
        return this.price;
    }

    ReadOnlyObjectProperty<Volume> getVolume() {
        return this.volume;
    }

    ReadOnlyObjectProperty<Volume> getMinVolume() {
        return this.minVolume;
    }

    public ReadOnlyBooleanProperty getBuyerAsTakerWithoutDeposit() {
        return this.buyerAsTakerWithoutDeposit;
    }

    public ReadOnlyStringProperty getTradeCurrencyCode() {
        return this.tradeCurrencyCode;
    }

    public String getCurrencyCode() {
        return (String)this.tradeCurrencyCode.get();
    }

    boolean isCryptoCurrency() {
        return CurrencyUtil.isCryptoCurrency((String)((String)this.tradeCurrencyCode.get()));
    }

    boolean isTraditionalCurrency() {
        return CurrencyUtil.isTraditionalCurrency((String)((String)this.tradeCurrencyCode.get()));
    }

    ReadOnlyBooleanProperty getUseMarketBasedPrice() {
        return this.useMarketBasedPrice;
    }

    ReadOnlyDoubleProperty getSecurityDepositPct() {
        return this.securityDepositPct;
    }

    protected BigInteger getSecurityDeposit() {
        BigInteger amount = (BigInteger)this.amount.get();
        if (amount == null) {
            amount = BigInteger.ZERO;
        }
        BigInteger percentOfAmount = CoinUtil.getPercentOfAmount((double)this.securityDepositPct.get(), (BigInteger)amount);
        return this.getBoundedSecurityDeposit(percentOfAmount);
    }

    protected BigInteger getBoundedSecurityDeposit(BigInteger value) {
        return Restrictions.getMinSecurityDeposit().max(value);
    }

    protected double getSecurityAsPercent(Offer offer) {
        BigInteger offerSellerSecurityDeposit = this.getBoundedSecurityDeposit(offer.getMaxSellerSecurityDeposit());
        double offerSellerSecurityDepositAsPercent = CoinUtil.getAsPercentPerXmr((BigInteger)offerSellerSecurityDeposit, (BigInteger)offer.getAmount());
        return Math.min(offerSellerSecurityDepositAsPercent, Restrictions.getMaxSecurityDepositPct());
    }

    ReadOnlyObjectProperty<BigInteger> totalToPayAsProperty() {
        return this.totalToPay;
    }

    public BigInteger getMaxMakerFee() {
        return HavenoUtils.multiply((BigInteger)((BigInteger)this.amount.get()), (double)HavenoUtils.getMakerFeePct((String)((String)this.tradeCurrencyCode.get()), (boolean)this.buyerAsTakerWithoutDeposit.get()));
    }

    boolean canPlaceOffer() {
        return GUIUtil.isBootstrappedOrShowPopup(this.p2PService) && GUIUtil.canCreateOrTakeOfferOrShowPopup(this.user, this.navigation);
    }

    public boolean isMinSecurityDeposit() {
        return this.getSecurityDeposit().compareTo(Restrictions.getMinSecurityDeposit()) <= 0;
    }

    public ReadOnlyObjectProperty<String> getExtraInfo() {
        return this.extraInfo;
    }

    public boolean isMarketPriceAvailable() {
        return this.marketPriceAvailable;
    }

    public long getTriggerPrice() {
        return this.triggerPrice;
    }

    public boolean isReserveExactAmount() {
        return this.reserveExactAmount;
    }
}

