/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.market.trades.charts.volume;

import haveno.desktop.main.market.trades.charts.CandleData;
import haveno.desktop.main.market.trades.charts.volume.VolumeBar;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.util.Duration;
import javafx.util.StringConverter;

public class VolumeChart
extends XYChart<Number, Number> {
    private final StringConverter<Number> toolTipStringConverter;

    public VolumeChart(Axis<Number> xAxis, Axis<Number> yAxis, StringConverter<Number> toolTipStringConverter) {
        super(xAxis, yAxis);
        this.toolTipStringConverter = toolTipStringConverter;
    }

    protected void layoutPlotChildren() {
        if (this.getData() == null) {
            return;
        }
        for (int seriesIndex = 0; seriesIndex < this.getData().size(); ++seriesIndex) {
            XYChart.Series series = (XYChart.Series)this.getData().get(seriesIndex);
            Iterator iterator = this.getDisplayedDataIterator(series);
            while (iterator.hasNext()) {
                XYChart.Data item = (XYChart.Data)iterator.next();
                double x = this.getXAxis().getDisplayPosition((Object)((Number)this.getCurrentDisplayedXValue(item)));
                double y = this.getYAxis().getDisplayPosition((Object)((Number)this.getCurrentDisplayedYValue(item)));
                Node itemNode = item.getNode();
                CandleData candleData = (CandleData)item.getExtraValue();
                if (!(itemNode instanceof VolumeBar) || candleData == null) continue;
                VolumeBar volumeBar = (VolumeBar)itemNode;
                double candleWidth = -1.0;
                if (this.getXAxis() instanceof NumberAxis) {
                    NumberAxis xa = (NumberAxis)this.getXAxis();
                    candleWidth = xa.getDisplayPosition((Number)1) * 0.6;
                }
                double height = this.getHeight() - 43.0;
                double upperYPos = Math.min(height - 5.0, y);
                volumeBar.update(height - upperYPos, candleWidth, candleData);
                volumeBar.setLayoutX(x);
                volumeBar.setLayoutY(upperYPos);
            }
        }
    }

    protected void dataItemChanged(XYChart.Data<Number, Number> item) {
    }

    protected void dataItemAdded(XYChart.Series<Number, Number> series, int itemIndex, XYChart.Data<Number, Number> item) {
        Node volumeBar = this.createCandle(this.getData().indexOf(series), item, itemIndex);
        this.getPlotChildren().remove((Object)volumeBar);
        if (this.shouldAnimate()) {
            volumeBar.setOpacity(0.0);
            this.getPlotChildren().add((Object)volumeBar);
            FadeTransition ft = new FadeTransition(Duration.millis((double)500.0), volumeBar);
            ft.setToValue(1.0);
            ft.play();
        } else {
            this.getPlotChildren().add((Object)volumeBar);
        }
    }

    protected void dataItemRemoved(XYChart.Data<Number, Number> item, XYChart.Series<Number, Number> series) {
        Node node = item.getNode();
        if (this.shouldAnimate()) {
            FadeTransition ft = new FadeTransition(Duration.millis((double)500.0), node);
            ft.setToValue(0.0);
            ft.setOnFinished(actionEvent -> {
                this.getPlotChildren().remove((Object)node);
                this.removeDataItemFromDisplay(series, item);
            });
            ft.play();
        } else {
            this.getPlotChildren().remove((Object)node);
            this.removeDataItemFromDisplay(series, item);
        }
    }

    protected void seriesAdded(XYChart.Series<Number, Number> series, int seriesIndex) {
        for (int j = 0; j < series.getData().size(); ++j) {
            XYChart.Data item = (XYChart.Data)series.getData().get(j);
            Node volumeBar = this.createCandle(seriesIndex, (XYChart.Data<Number, Number>)item, j);
            if (this.shouldAnimate()) {
                volumeBar.setOpacity(0.0);
                this.getPlotChildren().add((Object)volumeBar);
                FadeTransition ft = new FadeTransition(Duration.millis((double)500.0), volumeBar);
                ft.setToValue(1.0);
                ft.play();
                continue;
            }
            this.getPlotChildren().add((Object)volumeBar);
        }
    }

    protected void seriesRemoved(XYChart.Series<Number, Number> series) {
        for (XYChart.Data d : series.getData()) {
            Node volumeBar = d.getNode();
            if (this.shouldAnimate()) {
                FadeTransition ft = new FadeTransition(Duration.millis((double)500.0), volumeBar);
                ft.setToValue(0.0);
                ft.setOnFinished(actionEvent -> this.getPlotChildren().remove((Object)volumeBar));
                ft.play();
                continue;
            }
            this.getPlotChildren().remove((Object)volumeBar);
        }
        if (this.shouldAnimate()) {
            new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)500.0), event -> this.removeSeriesFromDisplay(series), new KeyValue[0])}).play();
        } else {
            this.removeSeriesFromDisplay(series);
        }
    }

    private Node createCandle(int seriesIndex, XYChart.Data<Number, Number> item, int itemIndex) {
        Object volumeBar = item.getNode();
        if (volumeBar instanceof VolumeBar) {
            ((VolumeBar)((Object)volumeBar)).setSeriesAndDataStyleClasses("series" + seriesIndex, "data" + itemIndex);
        } else {
            volumeBar = new VolumeBar("series" + seriesIndex, "data" + itemIndex, this.toolTipStringConverter);
            item.setNode(volumeBar);
        }
        return volumeBar;
    }

    protected void updateAxisRange() {
        Axis xa = this.getXAxis();
        Axis ya = this.getYAxis();
        ArrayList<Number> xData = null;
        ArrayList<Number> yData = null;
        if (xa.isAutoRanging()) {
            xData = new ArrayList<Number>();
        }
        if (ya.isAutoRanging()) {
            yData = new ArrayList<Number>();
        }
        if (xData != null || yData != null) {
            for (XYChart.Series series : this.getData()) {
                for (XYChart.Data data : series.getData()) {
                    if (xData != null) {
                        xData.add((Number)data.getXValue());
                    }
                    if (yData == null) continue;
                    yData.add((Number)data.getYValue());
                }
            }
            if (xData != null) {
                xa.invalidateRange(xData);
            }
            if (yData != null) {
                ya.invalidateRange(yData);
            }
        }
    }
}

