/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.market.trades.charts.volume;

import haveno.core.locale.Res;
import haveno.core.util.VolumeUtil;
import haveno.desktop.main.market.trades.charts.CandleData;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Region;
import javafx.util.StringConverter;

public class VolumeBar
extends Group {
    private String seriesStyleClass;
    private String dataStyleClass;
    private final StringConverter<Number> volumeStringConverter;
    private final Region bar = new Region();
    private final Tooltip tooltip;

    VolumeBar(String seriesStyleClass, String dataStyleClass, StringConverter<Number> volumeStringConverter) {
        this.seriesStyleClass = seriesStyleClass;
        this.dataStyleClass = dataStyleClass;
        this.volumeStringConverter = volumeStringConverter;
        this.setAutoSizeChildren(false);
        this.getChildren().add((Object)this.bar);
        this.updateStyleClasses();
        this.tooltip = new Tooltip();
        Tooltip.install((Node)this, (Tooltip)this.tooltip);
    }

    public void setSeriesAndDataStyleClasses(String seriesStyleClass, String dataStyleClass) {
        this.seriesStyleClass = seriesStyleClass;
        this.dataStyleClass = dataStyleClass;
        this.updateStyleClasses();
    }

    public void update(double height, double candleWidth, CandleData candleData) {
        this.bar.resizeRelocate(-candleWidth / 2.0, 0.0, candleWidth, height);
        String volumeInXmr = this.volumeStringConverter.toString((Object)candleData.accumulatedAmount);
        String volumeInUsd = VolumeUtil.formatLargeFiat((double)candleData.volumeInUsd, (String)"USD");
        this.tooltip.setText(Res.get((String)"market.trades.tooltip.volumeBar", (Object[])new Object[]{volumeInXmr, volumeInUsd, candleData.numTrades, candleData.date}));
    }

    private void updateStyleClasses() {
        this.bar.getStyleClass().setAll((Object[])new String[]{"volume-bar", this.seriesStyleClass, this.dataStyleClass, "bg"});
    }
}

