/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.market.trades.charts.price;

import haveno.core.locale.Res;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.main.market.trades.charts.CandleData;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;

public class CandleTooltip
extends GridPane {
    private final StringConverter<Number> priceStringConverter;
    private final Label openValue = new AutoTooltipLabel();
    private final Label closeValue = new AutoTooltipLabel();
    private final Label highValue = new AutoTooltipLabel();
    private final Label lowValue = new AutoTooltipLabel();
    private final Label averageValue = new AutoTooltipLabel();
    private final Label medianValue = new AutoTooltipLabel();
    private final Label dateValue = new AutoTooltipLabel();

    CandleTooltip(StringConverter<Number> priceStringConverter) {
        this.priceStringConverter = priceStringConverter;
        this.setHgap(5.0);
        this.setVgap(2.0);
        AutoTooltipLabel open = new AutoTooltipLabel(Res.get((String)"market.trades.tooltip.candle.open"));
        AutoTooltipLabel close = new AutoTooltipLabel(Res.get((String)"market.trades.tooltip.candle.close"));
        AutoTooltipLabel high = new AutoTooltipLabel(Res.get((String)"market.trades.tooltip.candle.high"));
        AutoTooltipLabel low = new AutoTooltipLabel(Res.get((String)"market.trades.tooltip.candle.low"));
        AutoTooltipLabel average = new AutoTooltipLabel(Res.get((String)"market.trades.tooltip.candle.average"));
        AutoTooltipLabel median = new AutoTooltipLabel(Res.get((String)"market.trades.tooltip.candle.median"));
        AutoTooltipLabel date = new AutoTooltipLabel(Res.get((String)"market.trades.tooltip.candle.date"));
        CandleTooltip.setConstraints((Node)open, (int)0, (int)0);
        CandleTooltip.setConstraints((Node)this.openValue, (int)1, (int)0);
        CandleTooltip.setConstraints((Node)close, (int)0, (int)1);
        CandleTooltip.setConstraints((Node)this.closeValue, (int)1, (int)1);
        CandleTooltip.setConstraints((Node)high, (int)0, (int)2);
        CandleTooltip.setConstraints((Node)this.highValue, (int)1, (int)2);
        CandleTooltip.setConstraints((Node)low, (int)0, (int)3);
        CandleTooltip.setConstraints((Node)this.lowValue, (int)1, (int)3);
        CandleTooltip.setConstraints((Node)average, (int)0, (int)4);
        CandleTooltip.setConstraints((Node)this.averageValue, (int)1, (int)4);
        CandleTooltip.setConstraints((Node)median, (int)0, (int)5);
        CandleTooltip.setConstraints((Node)this.medianValue, (int)1, (int)5);
        CandleTooltip.setConstraints((Node)date, (int)0, (int)6);
        CandleTooltip.setConstraints((Node)this.dateValue, (int)1, (int)6);
        ColumnConstraints columnConstraints1 = new ColumnConstraints();
        columnConstraints1.setHalignment(HPos.RIGHT);
        columnConstraints1.setHgrow(Priority.NEVER);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setHgrow(Priority.ALWAYS);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints1, columnConstraints2});
        this.getChildren().addAll((Object[])new Node[]{open, this.openValue, close, this.closeValue, high, this.highValue, low, this.lowValue, average, this.averageValue, median, this.medianValue, date, this.dateValue});
    }

    public void update(CandleData candleData) {
        this.openValue.setText(this.priceStringConverter.toString((Object)candleData.open));
        this.closeValue.setText(this.priceStringConverter.toString((Object)candleData.close));
        this.highValue.setText(this.priceStringConverter.toString((Object)candleData.high));
        this.lowValue.setText(this.priceStringConverter.toString((Object)candleData.low));
        this.averageValue.setText(this.priceStringConverter.toString((Object)candleData.average));
        this.medianValue.setText(this.priceStringConverter.toString((Object)candleData.median));
        this.dateValue.setText(candleData.date);
    }
}

