/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.market.trades.charts.price;

import haveno.desktop.main.market.trades.charts.CandleData;
import haveno.desktop.main.market.trades.charts.price.Candle;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.animation.FadeTransition;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.util.Duration;
import javafx.util.StringConverter;

public class CandleStickChart
extends XYChart<Number, Number> {
    private final StringConverter<Number> priceStringConverter;

    public CandleStickChart(Axis<Number> xAxis, Axis<Number> yAxis, StringConverter<Number> priceStringConverter) {
        super(xAxis, yAxis);
        this.priceStringConverter = priceStringConverter;
    }

    protected void layoutPlotChildren() {
        if (this.getData() == null) {
            return;
        }
        for (int seriesIndex = 0; seriesIndex < this.getData().size(); ++seriesIndex) {
            XYChart.Series series = (XYChart.Series)this.getData().get(seriesIndex);
            Iterator iterator = this.getDisplayedDataIterator(series);
            Path seriesPath = null;
            if (series.getNode() instanceof Path) {
                seriesPath = (Path)series.getNode();
                seriesPath.getElements().clear();
            }
            while (iterator.hasNext()) {
                XYChart.Data item = (XYChart.Data)iterator.next();
                double x = this.getXAxis().getDisplayPosition((Object)((Number)this.getCurrentDisplayedXValue(item)));
                double y = this.getYAxis().getDisplayPosition((Object)((Number)this.getCurrentDisplayedYValue(item)));
                Node itemNode = item.getNode();
                CandleData candleData = (CandleData)item.getExtraValue();
                if (itemNode instanceof Candle && candleData != null) {
                    Candle candle = (Candle)itemNode;
                    double close = this.getYAxis().getDisplayPosition((Object)candleData.close);
                    double high = this.getYAxis().getDisplayPosition((Object)candleData.high);
                    double low = this.getYAxis().getDisplayPosition((Object)candleData.low);
                    double candleWidth = -1.0;
                    if (this.getXAxis() instanceof NumberAxis) {
                        NumberAxis xa = (NumberAxis)this.getXAxis();
                        candleWidth = xa.getDisplayPosition((Number)1) * 0.6;
                    }
                    candle.update(close - y, high - y, low - y, candleWidth);
                    candle.updateTooltip(candleData);
                    candle.setLayoutX(x);
                    candle.setLayoutY(y);
                }
                if (seriesPath == null || candleData == null) continue;
                double displayPosition = this.getYAxis().getDisplayPosition((Object)candleData.average);
                if (seriesPath.getElements().isEmpty()) {
                    seriesPath.getElements().add((Object)new MoveTo(x, displayPosition));
                    continue;
                }
                seriesPath.getElements().add((Object)new LineTo(x, displayPosition));
            }
        }
    }

    protected void dataItemChanged(XYChart.Data<Number, Number> item) {
    }

    protected void dataItemAdded(XYChart.Series<Number, Number> series, int itemIndex, XYChart.Data<Number, Number> item) {
        Node candle = this.createCandle(this.getData().indexOf(series), item, itemIndex);
        this.getPlotChildren().remove((Object)candle);
        if (this.shouldAnimate()) {
            candle.setOpacity(0.0);
            this.getPlotChildren().add((Object)candle);
            FadeTransition ft = new FadeTransition(Duration.millis((double)500.0), candle);
            ft.setToValue(1.0);
            ft.play();
        } else {
            this.getPlotChildren().add((Object)candle);
        }
        if (series.getNode() instanceof Path) {
            Path seriesPath = (Path)series.getNode();
            seriesPath.toFront();
        }
    }

    protected void dataItemRemoved(XYChart.Data<Number, Number> item, XYChart.Series<Number, Number> series) {
        if (series.getNode() instanceof Path) {
            Path seriesPath = (Path)series.getNode();
            seriesPath.getElements().clear();
        }
        Node node = item.getNode();
        if (this.shouldAnimate()) {
            FadeTransition ft = new FadeTransition(Duration.millis((double)500.0), node);
            ft.setToValue(0.0);
            ft.setOnFinished(actionEvent -> {
                this.getPlotChildren().remove((Object)node);
                this.removeDataItemFromDisplay(series, item);
            });
            ft.play();
        } else {
            this.getPlotChildren().remove((Object)node);
            this.removeDataItemFromDisplay(series, item);
        }
    }

    protected void seriesAdded(XYChart.Series<Number, Number> series, int seriesIndex) {
        for (int j = 0; j < series.getData().size(); ++j) {
            XYChart.Data item = (XYChart.Data)series.getData().get(j);
            Node candle = this.createCandle(seriesIndex, (XYChart.Data<Number, Number>)item, j);
            if (this.getPlotChildren().contains((Object)candle)) continue;
            this.getPlotChildren().add((Object)candle);
            if (!this.shouldAnimate()) continue;
            candle.setOpacity(0.0);
            FadeTransition ft = new FadeTransition(Duration.millis((double)500.0), candle);
            ft.setToValue(1.0);
            ft.play();
        }
        Path seriesPath = new Path();
        seriesPath.getStyleClass().setAll((Object[])new String[]{"candlestick-average-line", "series" + seriesIndex});
        series.setNode((Node)seriesPath);
        if (!this.getPlotChildren().contains((Object)seriesPath)) {
            this.getPlotChildren().add((Object)seriesPath);
            if (this.shouldAnimate()) {
                seriesPath.setOpacity(0.0);
                FadeTransition ft = new FadeTransition(Duration.millis((double)500.0), (Node)seriesPath);
                ft.setToValue(1.0);
                ft.play();
            }
        }
    }

    protected void seriesRemoved(XYChart.Series<Number, Number> series) {
        for (XYChart.Data d : series.getData()) {
            Node candle = d.getNode();
            if (this.shouldAnimate()) {
                FadeTransition ft = new FadeTransition(Duration.millis((double)500.0), candle);
                ft.setToValue(0.0);
                ft.setOnFinished(actionEvent -> this.getPlotChildren().remove((Object)candle));
                ft.play();
                continue;
            }
            this.getPlotChildren().remove((Object)candle);
        }
        if (series.getNode() instanceof Path) {
            Path seriesPath = (Path)series.getNode();
            if (this.shouldAnimate()) {
                FadeTransition ft = new FadeTransition(Duration.millis((double)500.0), (Node)seriesPath);
                ft.setToValue(0.0);
                ft.setOnFinished(actionEvent -> {
                    this.getPlotChildren().remove((Object)seriesPath);
                    seriesPath.getElements().clear();
                    this.removeSeriesFromDisplay(series);
                });
                ft.play();
            } else {
                this.getPlotChildren().remove((Object)seriesPath);
                seriesPath.getElements().clear();
                this.removeSeriesFromDisplay(series);
            }
        } else {
            this.removeSeriesFromDisplay(series);
        }
    }

    private Node createCandle(int seriesIndex, XYChart.Data<Number, Number> item, int itemIndex) {
        Object candle = item.getNode();
        if (candle instanceof Candle) {
            ((Candle)((Object)candle)).setSeriesAndDataStyleClasses("series" + seriesIndex, "data" + itemIndex);
        } else {
            candle = new Candle("series" + seriesIndex, "data" + itemIndex, this.priceStringConverter);
            item.setNode(candle);
        }
        return candle;
    }

    protected void updateAxisRange() {
        Axis xa = this.getXAxis();
        Axis ya = this.getYAxis();
        ArrayList<Number> xData = null;
        ArrayList<Number> yData = null;
        if (xa.isAutoRanging()) {
            xData = new ArrayList<Number>();
        }
        if (ya.isAutoRanging()) {
            yData = new ArrayList<Number>();
        }
        if (xData != null || yData != null) {
            for (XYChart.Series series : this.getData()) {
                for (XYChart.Data data : series.getData()) {
                    if (xData != null) {
                        xData.add((Number)data.getXValue());
                    }
                    if (yData == null) continue;
                    if (data.getExtraValue() instanceof CandleData) {
                        CandleData candleData = (CandleData)data.getExtraValue();
                        yData.add(candleData.high);
                        yData.add(candleData.low);
                        continue;
                    }
                    yData.add((Number)data.getYValue());
                }
            }
            if (xData != null) {
                xa.invalidateRange(xData);
            }
            if (yData != null) {
                ya.invalidateRange(yData);
            }
        }
    }
}

