/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.market.trades.charts.price;

import haveno.desktop.main.market.trades.charts.CandleData;
import haveno.desktop.main.market.trades.charts.price.CandleTooltip;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Region;
import javafx.scene.shape.Line;
import javafx.util.StringConverter;

public class Candle
extends Group {
    private String seriesStyleClass;
    private String dataStyleClass;
    private final CandleTooltip candleTooltip;
    private final Line highLowLine = new Line();
    private final Region bar = new Region();
    private boolean openAboveClose = true;
    private double closeOffset;

    Candle(String seriesStyleClass, String dataStyleClass, StringConverter<Number> priceStringConverter) {
        this.seriesStyleClass = seriesStyleClass;
        this.dataStyleClass = dataStyleClass;
        this.setAutoSizeChildren(false);
        this.getChildren().addAll((Object[])new Node[]{this.highLowLine, this.bar});
        this.getStyleClass().setAll((Object[])new String[]{"candlestick-candle", seriesStyleClass, dataStyleClass});
        this.updateStyleClasses();
        this.candleTooltip = new CandleTooltip(priceStringConverter);
        Tooltip tooltip = new Tooltip();
        tooltip.setGraphic((Node)this.candleTooltip);
        Tooltip.install((Node)this, (Tooltip)tooltip);
    }

    public void setSeriesAndDataStyleClasses(String seriesStyleClass, String dataStyleClass) {
        this.seriesStyleClass = seriesStyleClass;
        this.dataStyleClass = dataStyleClass;
        this.getStyleClass().setAll((Object[])new String[]{"candlestick-candle", seriesStyleClass, dataStyleClass});
        this.updateStyleClasses();
    }

    public void update(double closeOffset, double highOffset, double lowOffset, double candleWidth) {
        this.closeOffset = closeOffset;
        this.openAboveClose = closeOffset > 0.0;
        this.updateStyleClasses();
        this.highLowLine.setStartY(highOffset);
        this.highLowLine.setEndY(lowOffset);
        if (this.openAboveClose) {
            this.bar.resizeRelocate(-candleWidth / 2.0, 0.0, candleWidth, Math.max(5.0, closeOffset));
        } else {
            this.bar.resizeRelocate(-candleWidth / 2.0, closeOffset, candleWidth, Math.max(5.0, closeOffset * -1.0));
        }
    }

    public void updateTooltip(CandleData candleData) {
        this.candleTooltip.update(candleData);
    }

    private void updateStyleClasses() {
        String style;
        String string = style = this.openAboveClose ? "open-above-close" : "close-above-open";
        if (this.closeOffset == 0.0) {
            style = "empty";
        }
        this.highLowLine.getStyleClass().setAll((Object[])new String[]{"candlestick-line", this.seriesStyleClass, this.dataStyleClass, style});
        this.bar.getStyleClass().setAll((Object[])new String[]{"candlestick-bar", this.seriesStyleClass, this.dataStyleClass, style});
    }
}

