/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.market.trades;

import com.google.inject.Inject;
import haveno.common.UserThread;
import haveno.common.util.CompletableFutureUtils;
import haveno.core.locale.CryptoCurrency;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.GlobalSettings;
import haveno.core.locale.TradeCurrency;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.statistics.TradeStatistics3;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.core.user.Preferences;
import haveno.desktop.Navigation;
import haveno.desktop.common.model.ActivatableViewModel;
import haveno.desktop.main.MainView;
import haveno.desktop.main.market.trades.ChartCalculations;
import haveno.desktop.main.settings.SettingsView;
import haveno.desktop.main.settings.preferences.PreferencesView;
import haveno.desktop.util.CurrencyList;
import haveno.desktop.util.CurrencyListItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.SetChangeListener;
import javafx.scene.chart.XYChart;
import javafx.util.Pair;
import javax.annotation.Nullable;

class TradesChartsViewModel
extends ActivatableViewModel {
    static final int MAX_TICKS = 90;
    private static final int TAB_INDEX = 2;
    private final TradeStatisticsManager tradeStatisticsManager;
    final Preferences preferences;
    private final PriceFeedService priceFeedService;
    private final Navigation navigation;
    private final SetChangeListener<TradeStatistics3> setChangeListener;
    final ObjectProperty<TradeCurrency> selectedTradeCurrencyProperty = new SimpleObjectProperty();
    final BooleanProperty showAllTradeCurrenciesProperty = new SimpleBooleanProperty(false);
    private final CurrencyList currencyListItems;
    private final CurrencyListItem showAllCurrencyListItem = new CurrencyListItem((TradeCurrency)new CryptoCurrency("list.currency.showAll", ""), -1);
    final ObservableList<TradeStatistics3> tradeStatisticsByCurrency = FXCollections.observableArrayList();
    final ObservableList<XYChart.Data<Number, Number>> priceItems = FXCollections.observableArrayList();
    final ObservableList<XYChart.Data<Number, Number>> volumeItems = FXCollections.observableArrayList();
    final ObservableList<XYChart.Data<Number, Number>> volumeInUsdItems = FXCollections.observableArrayList();
    private final Map<Long, Pair<Date, Set<TradeStatistics3>>> itemsPerInterval = new HashMap<Long, Pair<Date, Set<TradeStatistics3>>>();
    TickUnit tickUnit;
    private int selectedTabIndex;
    final Map<TickUnit, Map<Long, Long>> usdAveragePriceMapsPerTickUnit = new HashMap<TickUnit, Map<Long, Long>>();
    private boolean fillTradeCurrenciesOnActivateCalled;
    private volatile boolean deactivateCalled;

    @Inject
    TradesChartsViewModel(TradeStatisticsManager tradeStatisticsManager, Preferences preferences, PriceFeedService priceFeedService, Navigation navigation) {
        this.tradeStatisticsManager = tradeStatisticsManager;
        this.preferences = preferences;
        this.priceFeedService = priceFeedService;
        this.navigation = navigation;
        this.setChangeListener = change -> {
            this.applyAsyncTradeStatisticsForCurrency(this.getCurrencyCode()).whenComplete((result, throwable) -> {
                if (this.deactivateCalled) {
                    return;
                }
                if (throwable != null) {
                    this.log.error("Error at setChangeListener/applyAsyncTradeStatisticsForCurrency. {}", (Object)throwable.toString());
                    return;
                }
                this.applyAsyncChartData();
            });
            this.fillTradeCurrencies();
        };
        String tradeChartsScreenCurrencyCode = preferences.getTradeChartsScreenCurrencyCode();
        this.showAllTradeCurrenciesProperty.set(this.isShowAllEntry(tradeChartsScreenCurrencyCode));
        TradeCurrency tradeCurrency = CurrencyUtil.getTradeCurrency((String)tradeChartsScreenCurrencyCode).orElse(GlobalSettings.getDefaultTradeCurrency());
        this.selectedTradeCurrencyProperty.set((Object)tradeCurrency);
        this.tickUnit = TickUnit.values()[preferences.getTradeStatisticsTickUnitIndex()];
        this.currencyListItems = new CurrencyList(this.preferences);
    }

    @Override
    protected void activate() {
        long ts = System.currentTimeMillis();
        this.deactivateCalled = false;
        this.tradeStatisticsManager.getObservableTradeStatisticsSet().addListener(this.setChangeListener);
        if (!this.fillTradeCurrenciesOnActivateCalled) {
            this.fillTradeCurrencies();
            this.fillTradeCurrenciesOnActivateCalled = true;
        }
        this.syncPriceFeedCurrency();
        this.setMarketPriceFeedCurrency();
        ArrayList<CompletableFuture<Boolean>> allFutures = new ArrayList<CompletableFuture<Boolean>>();
        CompletableFuture<Boolean> task1Done = new CompletableFuture<Boolean>();
        allFutures.add(task1Done);
        CompletableFuture<Boolean> task2Done = new CompletableFuture<Boolean>();
        allFutures.add(task2Done);
        CompletableFutureUtils.allOf(allFutures).whenComplete((res, throwable) -> {
            if (this.deactivateCalled) {
                return;
            }
            if (throwable != null) {
                this.log.error(throwable.toString());
                return;
            }
            UserThread.execute(this::applyAsyncChartData);
        });
        this.applyAsyncUsdAveragePriceMapsPerTickUnit(task1Done);
        this.applyAsyncTradeStatisticsForCurrency(this.getCurrencyCode(), task2Done);
        this.log.debug("activate took {}", (Object)(System.currentTimeMillis() - ts));
    }

    @Override
    protected void deactivate() {
        this.deactivateCalled = true;
        this.tradeStatisticsManager.getObservableTradeStatisticsSet().removeListener(this.setChangeListener);
        UserThread.execute(() -> {
            this.usdAveragePriceMapsPerTickUnit.clear();
            this.tradeStatisticsByCurrency.clear();
            this.priceItems.clear();
            this.volumeItems.clear();
            this.volumeInUsdItems.clear();
            this.itemsPerInterval.clear();
        });
    }

    private void applyAsyncUsdAveragePriceMapsPerTickUnit(CompletableFuture<Boolean> completeFuture) {
        long ts = System.currentTimeMillis();
        ChartCalculations.getUsdAveragePriceMapsPerTickUnit((Set<TradeStatistics3>)this.tradeStatisticsManager.getObservableTradeStatisticsSet()).whenComplete((usdAveragePriceMapsPerTickUnit, throwable) -> {
            if (this.deactivateCalled) {
                return;
            }
            if (throwable != null) {
                this.log.error("Error at applyAsyncUsdAveragePriceMapsPerTickUnit. {}", (Object)throwable.toString());
                completeFuture.completeExceptionally((Throwable)throwable);
                return;
            }
            UserThread.execute(() -> {
                this.usdAveragePriceMapsPerTickUnit.clear();
                this.usdAveragePriceMapsPerTickUnit.putAll((Map<TickUnit, Map<Long, Long>>)usdAveragePriceMapsPerTickUnit);
                this.log.debug("applyAsyncUsdAveragePriceMapsPerTickUnit took {}", (Object)(System.currentTimeMillis() - ts));
                completeFuture.complete(true);
            });
        });
    }

    private CompletableFuture<Boolean> applyAsyncTradeStatisticsForCurrency(String currencyCode) {
        return this.applyAsyncTradeStatisticsForCurrency(currencyCode, null);
    }

    private CompletableFuture<Boolean> applyAsyncTradeStatisticsForCurrency(String currencyCode, @Nullable CompletableFuture<Boolean> completeFuture) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        long ts = System.currentTimeMillis();
        ChartCalculations.getTradeStatisticsForCurrency((Set<TradeStatistics3>)this.tradeStatisticsManager.getObservableTradeStatisticsSet(), currencyCode, this.showAllTradeCurrenciesProperty.get()).whenComplete((list, throwable) -> {
            if (this.deactivateCalled) {
                return;
            }
            if (throwable != null) {
                this.log.error("Error at applyAsyncTradeStatisticsForCurrency. {}", (Object)throwable.toString());
                if (completeFuture != null) {
                    completeFuture.completeExceptionally((Throwable)throwable);
                }
                return;
            }
            UserThread.execute(() -> {
                this.tradeStatisticsByCurrency.setAll((Collection)list);
                this.log.debug("applyAsyncTradeStatisticsForCurrency took {}", (Object)(System.currentTimeMillis() - ts));
                if (completeFuture != null) {
                    completeFuture.complete(true);
                }
                future.complete(true);
            });
        });
        return future;
    }

    private void applyAsyncChartData() {
        long ts = System.currentTimeMillis();
        ChartCalculations.getUpdateChartResult(new ArrayList<TradeStatistics3>((Collection<TradeStatistics3>)this.tradeStatisticsByCurrency), this.tickUnit, this.usdAveragePriceMapsPerTickUnit, this.getCurrencyCode()).whenComplete((updateChartResult, throwable) -> {
            if (this.deactivateCalled) {
                return;
            }
            if (throwable != null) {
                this.log.error("Error at applyAsyncChartData. {}", throwable);
                return;
            }
            UserThread.execute(() -> {
                this.itemsPerInterval.clear();
                this.itemsPerInterval.putAll(updateChartResult.getItemsPerInterval());
                this.priceItems.setAll(updateChartResult.getPriceItems());
                this.volumeItems.setAll(updateChartResult.getVolumeItems());
                this.volumeInUsdItems.setAll(updateChartResult.getVolumeInUsdItems());
                this.log.debug("applyAsyncChartData took {}", (Object)(System.currentTimeMillis() - ts));
            });
        });
    }

    void onSetTradeCurrency(TradeCurrency tradeCurrency) {
        if (tradeCurrency != null) {
            String code = tradeCurrency.getCode();
            if (this.isEditEntry(code)) {
                this.navigation.navigateTo(MainView.class, SettingsView.class, PreferencesView.class);
                return;
            }
            boolean showAllEntry = this.isShowAllEntry(code);
            this.showAllTradeCurrenciesProperty.set(showAllEntry);
            if (showAllEntry) {
                this.priceFeedService.setCurrencyCode(GlobalSettings.getDefaultTradeCurrency().getCode());
            } else {
                this.selectedTradeCurrencyProperty.set((Object)tradeCurrency);
                this.priceFeedService.setCurrencyCode(code);
            }
            this.preferences.setTradeChartsScreenCurrencyCode(code);
            this.applyAsyncTradeStatisticsForCurrency(this.getCurrencyCode()).whenComplete((result, throwable) -> {
                if (this.deactivateCalled) {
                    return;
                }
                if (throwable != null) {
                    this.log.error("Error at onSetTradeCurrency/applyAsyncTradeStatisticsForCurrency. {}", (Object)throwable.toString());
                    return;
                }
                this.applyAsyncChartData();
            });
        }
    }

    void setTickUnit(TickUnit tickUnit) {
        this.tickUnit = tickUnit;
        this.preferences.setTradeStatisticsTickUnitIndex(tickUnit.ordinal());
        this.applyAsyncChartData();
    }

    void setSelectedTabIndex(int selectedTabIndex) {
        this.selectedTabIndex = selectedTabIndex;
        this.syncPriceFeedCurrency();
        this.setMarketPriceFeedCurrency();
    }

    public String getCurrencyCode() {
        return ((TradeCurrency)this.selectedTradeCurrencyProperty.get()).getCode();
    }

    public ObservableList<CurrencyListItem> getCurrencyListItems() {
        return this.currencyListItems.getObservableList();
    }

    public Optional<CurrencyListItem> getSelectedCurrencyListItem() {
        return this.currencyListItems.getObservableList().stream().filter(e -> e.tradeCurrency.equals(this.selectedTradeCurrencyProperty.get())).findAny();
    }

    long getTimeFromTickIndex(long tick) {
        return ChartCalculations.getTimeFromTickIndex(tick, this.itemsPerInterval);
    }

    private void fillTradeCurrencies() {
        List<TradeCurrency> tradeCurrencyList = this.tradeStatisticsManager.getObservableTradeStatisticsSet().stream().flatMap(e -> CurrencyUtil.getTradeCurrency((String)e.getCurrency()).stream()).collect(Collectors.toList());
        this.currencyListItems.updateWithCurrencies(tradeCurrencyList, this.showAllCurrencyListItem);
    }

    private void setMarketPriceFeedCurrency() {
        if (this.selectedTabIndex == 2) {
            if (this.showAllTradeCurrenciesProperty.get()) {
                this.priceFeedService.setCurrencyCode(GlobalSettings.getDefaultTradeCurrency().getCode());
            } else {
                this.priceFeedService.setCurrencyCode(this.getCurrencyCode());
            }
        }
    }

    private void syncPriceFeedCurrency() {
        if (this.selectedTabIndex == 2) {
            this.priceFeedService.setCurrencyCode(((TradeCurrency)this.selectedTradeCurrencyProperty.get()).getCode());
        }
    }

    private boolean isShowAllEntry(@Nullable String id) {
        return id != null && id.equals("list.currency.showAll");
    }

    private boolean isEditEntry(@Nullable String id) {
        return id != null && id.equals("list.currency.editList");
    }

    public static enum TickUnit {
        YEAR,
        MONTH,
        WEEK,
        DAY,
        HOUR,
        MINUTE_10;

    }
}

