/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.market.trades;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.googlecode.jcsv.writer.CSVEntryConverter;
import com.jfoenix.controls.JFXTabPane;
import haveno.common.UserThread;
import haveno.common.util.MathUtils;
import haveno.common.util.Tuple2;
import haveno.common.util.Tuple3;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.statistics.TradeStatistics3;
import haveno.core.user.CookieKey;
import haveno.core.user.User;
import haveno.core.util.FormattingUtils;
import haveno.core.util.VolumeUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.common.view.ActivatableViewAndModel;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.AutoTooltipSlideToggleButton;
import haveno.desktop.components.AutoTooltipTableColumn;
import haveno.desktop.components.AutoTooltipToggleButton;
import haveno.desktop.components.AutocompleteComboBox;
import haveno.desktop.components.ColoredDecimalPlacesWithZerosText;
import haveno.desktop.main.market.trades.TradeStatistics3ListItem;
import haveno.desktop.main.market.trades.TradesChartsViewModel;
import haveno.desktop.main.market.trades.charts.price.CandleStickChart;
import haveno.desktop.main.market.trades.charts.volume.VolumeChart;
import haveno.desktop.util.CurrencyListItem;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.jetbrains.annotations.NotNull;

@FxmlView
public class TradesChartsView
extends ActivatableViewAndModel<VBox, TradesChartsViewModel> {
    private static final int SHOW_ALL = 0;
    private final User user;
    private final CoinFormatter coinFormatter;
    private VolumeChart volumeChart;
    private VolumeChart volumeInUsdChart;
    private CandleStickChart priceChart;
    private AutocompleteComboBox<CurrencyListItem> currencyComboBox;
    private TableView<TradeStatistics3ListItem> tableView;
    private Hyperlink exportLink;
    private HBox toolBox;
    private Pane rootParent;
    private AnchorPane priceChartPane;
    private AnchorPane volumeChartPane;
    private HBox footer;
    private AutoTooltipSlideToggleButton showVolumeAsUsdToggleButton;
    private Label nrOfTradeStatisticsLabel;
    private ToggleGroup toggleGroup;
    private SingleSelectionModel<Tab> tabPaneSelectionModel;
    private TableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem> priceColumn;
    private TableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem> volumeColumn;
    private TableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem> marketColumn;
    private SortedList<TradeStatistics3ListItem> sortedList = new SortedList(FXCollections.observableArrayList());
    private ChangeListener<Toggle> timeUnitChangeListener;
    private ChangeListener<Number> priceAxisYWidthListener;
    private ChangeListener<Number> volumeAxisYWidthListener;
    private ChangeListener<Number> selectedTabIndexListener;
    private ChangeListener<Number> parentHeightListener;
    private ChangeListener<String> priceColumnLabelListener;
    private ListChangeListener<XYChart.Data<Number, Number>> itemsChangeListener;
    private ListChangeListener<TradeStatistics3> tradeStatisticsByCurrencyListener;
    private MonadicBinding<Void> currencySelectionBinding;
    private Subscription currencySelectionSubscriber;
    private final StringProperty priceColumnLabel = new SimpleStringProperty();
    private NumberAxis priceAxisX;
    private NumberAxis priceAxisY;
    private NumberAxis volumeAxisY;
    private NumberAxis volumeAxisX;
    private NumberAxis volumeInUsdAxisX;
    private XYChart.Series<Number, Number> priceSeries;
    private final XYChart.Series<Number, Number> volumeSeries = new XYChart.Series();
    private final XYChart.Series<Number, Number> volumeInUsdSeries = new XYChart.Series();
    private double priceAxisYWidth;
    private double volumeAxisYWidth;

    @Inject
    public TradesChartsView(TradesChartsViewModel model, User user, @Named(value="BTC") CoinFormatter coinFormatter) {
        super(model);
        this.user = user;
        this.coinFormatter = coinFormatter;
    }

    @Override
    public void initialize() {
        ((VBox)this.root).setAlignment(Pos.CENTER_LEFT);
        this.toolBox = this.getToolBox();
        this.createCharts();
        this.createTable();
        this.footer = new HBox();
        VBox.setVgrow((Node)this.footer, (Priority)Priority.ALWAYS);
        Pane spacer = new Pane();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.nrOfTradeStatisticsLabel = new AutoTooltipLabel(" ");
        this.nrOfTradeStatisticsLabel.setPadding(new Insets(-2.0, 0.0, -10.0, 12.0));
        this.exportLink = new Hyperlink(Res.get((String)"shared.exportCSV"));
        this.exportLink.setPadding(new Insets(-2.0, 12.0, -10.0, 0.0));
        this.footer.getChildren().addAll((Object[])new Node[]{this.nrOfTradeStatisticsLabel, spacer, this.exportLink});
        ((VBox)this.root).getChildren().addAll((Object[])new Node[]{this.toolBox, this.priceChartPane, this.volumeChartPane, this.tableView, this.footer});
        this.timeUnitChangeListener = (observable, oldValue, newValue) -> UserThread.execute(() -> {
            if (newValue != null) {
                ((TradesChartsViewModel)this.model).setTickUnit((TradesChartsViewModel.TickUnit)((Object)((Object)((Object)newValue.getUserData()))));
                this.priceAxisX.setTickLabelFormatter(this.getTimeAxisStringConverter());
                this.volumeAxisX.setTickLabelFormatter(this.getTimeAxisStringConverter());
                this.volumeInUsdAxisX.setTickLabelFormatter(this.getTimeAxisStringConverter());
            }
        });
        this.priceAxisYWidthListener = (observable, oldValue, newValue) -> UserThread.execute(() -> {
            this.priceAxisYWidth = (Double)newValue;
            this.layoutChart();
        });
        this.volumeAxisYWidthListener = (observable, oldValue, newValue) -> UserThread.execute(() -> {
            this.volumeAxisYWidth = (Double)newValue;
            this.layoutChart();
        });
        this.tradeStatisticsByCurrencyListener = c -> UserThread.execute(() -> {
            this.nrOfTradeStatisticsLabel.setText(Res.get((String)"market.trades.nrOfTrades", (Object[])new Object[]{((TradesChartsViewModel)this.model).tradeStatisticsByCurrency.size()}));
            this.fillList();
        });
        this.parentHeightListener = (observable, oldValue, newValue) -> UserThread.execute(this::layout);
        this.priceColumnLabelListener = (o, oldVal, newVal) -> UserThread.execute(() -> this.priceColumn.setGraphic((Node)new AutoTooltipLabel((String)newVal)));
        this.itemsChangeListener = c -> UserThread.execute(this::updateChartData);
        this.currencySelectionBinding = EasyBind.combine((ObservableValue)((TradesChartsViewModel)this.model).showAllTradeCurrenciesProperty, ((TradesChartsViewModel)this.model).selectedTradeCurrencyProperty, (showAll, selectedTradeCurrency) -> {
            UserThread.execute(() -> {
                this.priceChart.setVisible(showAll == false);
                this.priceChart.setManaged(showAll == false);
                this.priceColumn.setSortable(showAll == false);
                if (showAll.booleanValue()) {
                    this.volumeColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.amount")));
                    this.priceColumnLabel.set((Object)Res.get((String)"shared.price"));
                    if (!this.tableView.getColumns().contains(this.marketColumn)) {
                        this.tableView.getColumns().add(1, this.marketColumn);
                    }
                    this.volumeChart.setPrefHeight(this.volumeChart.getMaxHeight());
                    this.volumeInUsdChart.setPrefHeight(this.volumeInUsdChart.getMaxHeight());
                } else {
                    this.volumeChart.setPrefHeight(this.volumeChart.getMinHeight());
                    this.volumeInUsdChart.setPrefHeight(this.volumeInUsdChart.getMinHeight());
                    this.priceSeries.setName(selectedTradeCurrency.getName());
                    String code = selectedTradeCurrency.getCode();
                    this.volumeColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.amountWithCur", (Object[])new Object[]{code})));
                    this.priceColumnLabel.set((Object)CurrencyUtil.getPriceWithCurrencyCode((String)code));
                    this.tableView.getColumns().remove(this.marketColumn);
                }
                this.layout();
            });
            return null;
        });
    }

    @Override
    protected void activate() {
        this.tabPaneSelectionModel = GUIUtil.getParentOfType(this.root, JFXTabPane.class).getSelectionModel();
        this.selectedTabIndexListener = (observable, oldValue, newValue) -> ((TradesChartsViewModel)this.model).setSelectedTabIndex((Integer)newValue);
        ((TradesChartsViewModel)this.model).setSelectedTabIndex(this.tabPaneSelectionModel.getSelectedIndex());
        this.tabPaneSelectionModel.selectedIndexProperty().addListener(this.selectedTabIndexListener);
        this.currencyComboBox.setConverter(new CurrencyStringConverter((ComboBox<CurrencyListItem>)this.currencyComboBox));
        this.currencyComboBox.getEditor().getStyleClass().add((Object)"combo-box-editor-bold");
        this.currencyComboBox.setAutocompleteItems((List<CurrencyListItem>)((TradesChartsViewModel)this.model).getCurrencyListItems());
        this.currencyComboBox.setVisibleRowCount(10);
        if (((TradesChartsViewModel)this.model).showAllTradeCurrenciesProperty.get()) {
            this.currencyComboBox.getSelectionModel().select(0);
        } else if (((TradesChartsViewModel)this.model).getSelectedCurrencyListItem().isPresent()) {
            this.currencyComboBox.getSelectionModel().select((Object)((TradesChartsViewModel)this.model).getSelectedCurrencyListItem().get());
        }
        this.currencyComboBox.getEditor().setText(new CurrencyStringConverter((ComboBox<CurrencyListItem>)this.currencyComboBox).toString((CurrencyListItem)this.currencyComboBox.getSelectionModel().getSelectedItem()));
        this.currencyComboBox.setOnChangeConfirmed((EventHandler<Event>)((EventHandler)e -> UserThread.execute(() -> {
            if (this.currencyComboBox.getEditor().getText().isEmpty()) {
                return;
            }
            CurrencyListItem selectedItem = (CurrencyListItem)this.currencyComboBox.getSelectionModel().getSelectedItem();
            if (selectedItem != null) {
                ((TradesChartsViewModel)this.model).onSetTradeCurrency(selectedItem.tradeCurrency);
            }
        })));
        ((Toggle)this.toggleGroup.getToggles().get(((TradesChartsViewModel)this.model).tickUnit.ordinal())).setSelected(true);
        ((TradesChartsViewModel)this.model).priceItems.addListener(this.itemsChangeListener);
        this.toggleGroup.selectedToggleProperty().addListener(this.timeUnitChangeListener);
        this.priceAxisY.widthProperty().addListener(this.priceAxisYWidthListener);
        this.volumeAxisY.widthProperty().addListener(this.volumeAxisYWidthListener);
        ((TradesChartsViewModel)this.model).tradeStatisticsByCurrency.addListener(this.tradeStatisticsByCurrencyListener);
        this.priceAxisY.labelProperty().bind((ObservableValue)this.priceColumnLabel);
        this.priceColumnLabel.addListener(this.priceColumnLabelListener);
        this.currencySelectionSubscriber = this.currencySelectionBinding.subscribe((observable, oldValue, newValue) -> {});
        boolean useAnimations = ((TradesChartsViewModel)this.model).preferences.isUseAnimations();
        this.priceChart.setAnimated(useAnimations);
        this.volumeChart.setAnimated(useAnimations);
        this.volumeInUsdChart.setAnimated(useAnimations);
        this.nrOfTradeStatisticsLabel.setText(Res.get((String)"market.trades.nrOfTrades", (Object[])new Object[]{((TradesChartsViewModel)this.model).tradeStatisticsByCurrency.size()}));
        this.exportLink.setOnAction(e -> this.exportToCsv());
        if (((VBox)this.root).getParent() instanceof Pane) {
            this.rootParent = (Pane)((VBox)this.root).getParent();
            this.rootParent.heightProperty().addListener(this.parentHeightListener);
        }
        this.user.getCookie().getAsOptionalBoolean(CookieKey.TRADE_STAT_CHART_USE_USD).ifPresent(showUsd -> {
            this.showVolumeAsUsdToggleButton.setSelected((boolean)showUsd);
            this.showVolumeAsUsd((Boolean)showUsd);
        });
        this.showVolumeAsUsdToggleButton.setOnAction(e -> {
            boolean selected = this.showVolumeAsUsdToggleButton.isSelected();
            this.showVolumeAsUsd(selected);
            this.user.getCookie().putAsBoolean(CookieKey.TRADE_STAT_CHART_USE_USD, selected);
            this.user.requestPersistence();
        });
        this.layout();
    }

    @Override
    protected void deactivate() {
        this.tabPaneSelectionModel.selectedIndexProperty().removeListener(this.selectedTabIndexListener);
        ((TradesChartsViewModel)this.model).priceItems.removeListener(this.itemsChangeListener);
        this.toggleGroup.selectedToggleProperty().removeListener(this.timeUnitChangeListener);
        this.priceAxisY.widthProperty().removeListener(this.priceAxisYWidthListener);
        this.volumeAxisY.widthProperty().removeListener(this.volumeAxisYWidthListener);
        ((TradesChartsViewModel)this.model).tradeStatisticsByCurrency.removeListener(this.tradeStatisticsByCurrencyListener);
        this.priceAxisY.labelProperty().unbind();
        this.priceColumnLabel.removeListener(this.priceColumnLabelListener);
        this.currencySelectionSubscriber.unsubscribe();
        this.sortedList.comparatorProperty().unbind();
        this.priceSeries.getData().clear();
        this.priceChart.getData().clear();
        this.exportLink.setOnAction(null);
        this.showVolumeAsUsdToggleButton.setOnAction(null);
        if (this.rootParent != null) {
            this.rootParent.heightProperty().removeListener(this.parentHeightListener);
        }
    }

    private void showVolumeAsUsd(Boolean showUsd) {
        this.volumeChart.setVisible(showUsd == false);
        this.volumeChart.setManaged(showUsd == false);
        this.volumeInUsdChart.setVisible(showUsd);
        this.volumeInUsdChart.setManaged(showUsd);
    }

    private void fillList() {
        long ts = System.currentTimeMillis();
        CompletableFuture.supplyAsync(() -> ((TradesChartsViewModel)this.model).tradeStatisticsByCurrency.stream().map(tradeStatistics -> new TradeStatistics3ListItem((TradeStatistics3)tradeStatistics, ((TradesChartsViewModel)this.model).showAllTradeCurrenciesProperty.get())).collect(Collectors.toCollection(FXCollections::observableArrayList))).whenComplete((listItems, throwable) -> {
            this.log.debug("Creating listItems took {} ms", (Object)(System.currentTimeMillis() - ts));
            long ts2 = System.currentTimeMillis();
            this.sortedList.comparatorProperty().unbind();
            this.sortedList = new SortedList(listItems);
            this.sortedList.comparatorProperty().bind((ObservableValue)this.tableView.comparatorProperty());
            this.log.debug("Created sorted list took {} ms", (Object)(System.currentTimeMillis() - ts2));
            UserThread.execute(() -> this.tableView.setItems(this.sortedList));
        });
    }

    private void exportToCsv() {
        ObservableList<TableColumn<TradeStatistics3ListItem, ?>> tableColumns = GUIUtil.getContentColumns(this.tableView);
        int reportColumns = tableColumns.size() + 1;
        boolean showAllTradeCurrencies = ((TradesChartsViewModel)this.model).showAllTradeCurrenciesProperty.get();
        CSVEntryConverter headerConverter = item -> {
            String[] columns = new String[reportColumns];
            columns[0] = "Epoch time in ms";
            for (int i = 0; i < tableColumns.size(); ++i) {
                columns[i + 1] = ((AutoTooltipLabel)((TableColumn)tableColumns.get(i)).getGraphic()).getText();
            }
            return columns;
        };
        CSVEntryConverter contentConverter = showAllTradeCurrencies ? item -> {
            String[] columns = new String[reportColumns];
            columns[0] = String.valueOf(item.getDateAsLong());
            columns[1] = item.getDateString();
            columns[2] = item.getMarket();
            columns[3] = item.getPriceString();
            columns[4] = item.getAmountString();
            columns[5] = item.getVolumeString();
            columns[6] = item.getPaymentMethodString();
            return columns;
        } : item -> {
            String[] columns = new String[reportColumns];
            columns[0] = String.valueOf(item.getDateAsLong());
            columns[1] = item.getDateString();
            columns[2] = item.getPriceString();
            columns[3] = item.getAmountString();
            columns[4] = item.getVolumeString();
            columns[5] = item.getPaymentMethodString();
            return columns;
        };
        String details = showAllTradeCurrencies ? "all-markets" : ((TradesChartsViewModel)this.model).getCurrencyCode();
        GUIUtil.exportCSV("trade-statistics-" + details + ".csv", headerConverter, contentConverter, new TradeStatistics3ListItem(null, showAllTradeCurrencies), this.sortedList, (Stage)((VBox)this.root).getScene().getWindow());
    }

    private void createCharts() {
        this.priceSeries = new XYChart.Series();
        this.priceAxisX = new NumberAxis(0.0, 91.0, 1.0);
        this.priceAxisX.setTickUnit(4.0);
        this.priceAxisX.setMinorTickCount(4);
        this.priceAxisX.setMinorTickVisible(true);
        this.priceAxisX.setForceZeroInRange(false);
        this.addTickMarkLabelCssClass(this.priceAxisX, "axis-tick-mark-text-node");
        this.priceAxisY = new NumberAxis();
        this.priceAxisY.setForceZeroInRange(false);
        this.priceAxisY.setAutoRanging(true);
        this.priceAxisY.setTickLabelFormatter((StringConverter)new StringConverter<Number>(){

            public String toString(Number object) {
                String currencyCode = ((TradesChartsViewModel)TradesChartsView.this.model).getCurrencyCode();
                double doubleValue = (Double)object;
                if (CurrencyUtil.isCryptoCurrency((String)currencyCode)) {
                    double value = MathUtils.scaleDownByPowerOf10((double)doubleValue, (int)8);
                    return FormattingUtils.formatRoundedDoubleWithPrecision((double)value, (int)8).replaceFirst("0{3}$", "");
                }
                DecimalFormat df = new DecimalFormat(",###");
                return df.format(Double.parseDouble(FormattingUtils.formatPrice((Price)Price.valueOf((String)currencyCode, (long)MathUtils.doubleToLong((double)doubleValue)))));
            }

            public Number fromString(String string) {
                return null;
            }
        });
        this.priceChart = new CandleStickChart((Axis<Number>)this.priceAxisX, (Axis<Number>)this.priceAxisY, new StringConverter<Number>(){

            public String toString(Number object) {
                if (CurrencyUtil.isCryptoCurrency((String)((TradesChartsViewModel)TradesChartsView.this.model).getCurrencyCode())) {
                    double value = MathUtils.scaleDownByPowerOf10((long)((Long)object), (int)8);
                    return FormattingUtils.formatRoundedDoubleWithPrecision((double)value, (int)8);
                }
                return FormattingUtils.formatPrice((Price)Price.valueOf((String)((TradesChartsViewModel)TradesChartsView.this.model).getCurrencyCode(), (long)((Long)object)));
            }

            public Number fromString(String string) {
                return null;
            }
        });
        this.priceChart.setId("price-chart");
        this.priceChart.setMinHeight(188.0);
        this.priceChart.setPrefHeight(188.0);
        this.priceChart.setMaxHeight(300.0);
        this.priceChart.setLegendVisible(false);
        this.priceChart.setPadding(new Insets(0.0));
        this.priceChart.setData(FXCollections.observableArrayList(List.of(this.priceSeries)));
        this.priceChartPane = new AnchorPane();
        this.priceChartPane.getStyleClass().add((Object)"chart-pane");
        AnchorPane.setTopAnchor((Node)this.priceChart, (Double)15.0);
        AnchorPane.setBottomAnchor((Node)this.priceChart, (Double)10.0);
        AnchorPane.setLeftAnchor((Node)this.priceChart, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.priceChart, (Double)10.0);
        this.priceChartPane.getChildren().add((Object)this.priceChart);
        this.volumeAxisX = new NumberAxis(0.0, 91.0, 1.0);
        this.volumeAxisY = new NumberAxis();
        this.volumeChart = this.getVolumeChart(this.volumeAxisX, this.volumeAxisY, this.volumeSeries, "XMR");
        this.volumeInUsdAxisX = new NumberAxis(0.0, 91.0, 1.0);
        NumberAxis volumeInUsdAxisY = new NumberAxis();
        this.volumeInUsdChart = this.getVolumeChart(this.volumeInUsdAxisX, volumeInUsdAxisY, this.volumeInUsdSeries, "USD");
        this.volumeInUsdChart.setVisible(false);
        this.volumeInUsdChart.setManaged(false);
        this.showVolumeAsUsdToggleButton = new AutoTooltipSlideToggleButton();
        this.showVolumeAsUsdToggleButton.setText(Res.get((String)"market.trades.showVolumeInUSD"));
        this.showVolumeAsUsdToggleButton.setPadding(new Insets(-15.0, 0.0, 0.0, 10.0));
        VBox vBox = new VBox();
        AnchorPane.setTopAnchor((Node)vBox, (Double)15.0);
        AnchorPane.setBottomAnchor((Node)vBox, (Double)10.0);
        AnchorPane.setLeftAnchor((Node)vBox, (Double)0.0);
        AnchorPane.setRightAnchor((Node)vBox, (Double)10.0);
        vBox.getChildren().addAll((Object[])new Node[]{this.showVolumeAsUsdToggleButton, this.volumeChart, this.volumeInUsdChart});
        this.volumeChartPane = new AnchorPane();
        this.volumeChartPane.getStyleClass().add((Object)"chart-pane");
        this.volumeChartPane.getChildren().add((Object)vBox);
    }

    private VolumeChart getVolumeChart(NumberAxis axisX, NumberAxis axisY, XYChart.Series<Number, Number> series, final String currency) {
        axisX.setTickUnit(4.0);
        axisX.setMinorTickCount(4);
        axisX.setMinorTickVisible(true);
        axisX.setForceZeroInRange(false);
        this.addTickMarkLabelCssClass(axisX, "axis-tick-mark-text-node");
        axisY.setForceZeroInRange(true);
        axisY.setAutoRanging(true);
        axisY.setLabel(Res.get((String)"shared.volumeWithCur", (Object[])new Object[]{currency}));
        axisY.setTickLabelFormatter((StringConverter)new StringConverter<Number>(this){

            public String toString(Number volume) {
                return currency.equals("XMR") ? HavenoUtils.formatXmr((long)MathUtils.doubleToLong((double)((Double)volume))) : VolumeUtil.formatLargeFiatWithUnitPostFix((double)((Double)volume), (String)"USD");
            }

            public Number fromString(String string) {
                return null;
            }
        });
        StringConverter<Number> xmrStringConverter = new StringConverter<Number>(this){

            public String toString(Number volume) {
                return HavenoUtils.formatXmr((long)((Long)volume), (boolean)true);
            }

            public Number fromString(String string) {
                return null;
            }
        };
        VolumeChart volumeChart = new VolumeChart((Axis<Number>)axisX, (Axis<Number>)axisY, xmrStringConverter);
        volumeChart.setId("volume-chart");
        volumeChart.setData(FXCollections.observableArrayList(List.of(series)));
        volumeChart.setMinHeight(138.0);
        volumeChart.setPrefHeight(138.0);
        volumeChart.setMaxHeight(200.0);
        volumeChart.setLegendVisible(false);
        volumeChart.setPadding(new Insets(0.0));
        return volumeChart;
    }

    private void updateChartData() {
        this.volumeSeries.getData().setAll(((TradesChartsViewModel)this.model).volumeItems);
        this.volumeInUsdSeries.getData().setAll(((TradesChartsViewModel)this.model).volumeInUsdItems);
        this.priceSeries.getData().clear();
        this.priceSeries = new XYChart.Series();
        this.priceSeries.getData().setAll(((TradesChartsViewModel)this.model).priceItems);
        this.priceChart.getData().clear();
        this.priceChart.setData(FXCollections.observableArrayList(List.of(this.priceSeries)));
        this.priceAxisX.setTickLabelFormatter(this.getTimeAxisStringConverter());
        this.volumeAxisX.setTickLabelFormatter(this.getTimeAxisStringConverter());
        this.volumeInUsdAxisX.setTickLabelFormatter(this.getTimeAxisStringConverter());
    }

    private void layoutChart() {
        UserThread.execute(() -> {
            if (this.volumeAxisYWidth > this.priceAxisYWidth) {
                this.priceChart.setPadding(new Insets(0.0, 0.0, 0.0, this.volumeAxisYWidth - this.priceAxisYWidth));
                this.volumeChart.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
                this.volumeInUsdChart.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
            } else if (this.volumeAxisYWidth < this.priceAxisYWidth) {
                this.priceChart.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
                this.volumeChart.setPadding(new Insets(0.0, 0.0, 0.0, this.priceAxisYWidth - this.volumeAxisYWidth));
                this.volumeInUsdChart.setPadding(new Insets(0.0, 0.0, 0.0, this.priceAxisYWidth - this.volumeAxisYWidth));
            }
        });
    }

    @NotNull
    private StringConverter<Number> getTimeAxisStringConverter() {
        return new StringConverter<Number>(){

            public String toString(Number object) {
                long index = MathUtils.doubleToLong((double)((Double)object));
                if (91L == index) {
                    return "";
                }
                long time = ((TradesChartsViewModel)TradesChartsView.this.model).getTimeFromTickIndex(index);
                String fmt = "";
                switch (((TradesChartsViewModel)((TradesChartsView)TradesChartsView.this).model).tickUnit) {
                    case YEAR: {
                        fmt = "yyyy";
                        break;
                    }
                    case MONTH: {
                        fmt = "MMMyy";
                        break;
                    }
                    case WEEK: 
                    case DAY: {
                        fmt = "dd/MMM\nyyyy";
                        break;
                    }
                    case HOUR: 
                    case MINUTE_10: {
                        fmt = "HH:mm\ndd/MMM";
                        break;
                    }
                }
                return DisplayUtils.formatDateAxis(new Date(time), fmt);
            }

            public Number fromString(String string) {
                return null;
            }
        };
    }

    private void addTickMarkLabelCssClass(NumberAxis axis, String cssClass) {
        axis.getChildrenUnmodifiable().addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                for (Node mark : c.getAddedSubList()) {
                    if (!(mark instanceof Text)) continue;
                    mark.getStyleClass().add((Object)cssClass);
                }
            }
        });
    }

    private HBox getToolBox() {
        Tuple3 currencyComboBoxTuple = FormBuilder.addTopLabelAutocompleteComboBox(Res.get((String)"shared.currency"));
        this.currencyComboBox = (AutocompleteComboBox)((Object)currencyComboBoxTuple.third);
        this.currencyComboBox.setCellFactory(GUIUtil.getCurrencyListItemCellFactory(Res.get((String)"shared.trade"), Res.get((String)"shared.trades"), ((TradesChartsViewModel)this.model).preferences));
        this.currencyComboBox.getStyleClass().add((Object)"input-with-border");
        Pane spacer = new Pane();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.toggleGroup = new ToggleGroup();
        ToggleButton year = this.getToggleButton(Res.get((String)"time.year"), TradesChartsViewModel.TickUnit.YEAR, this.toggleGroup, "toggle-left");
        ToggleButton month = this.getToggleButton(Res.get((String)"time.month"), TradesChartsViewModel.TickUnit.MONTH, this.toggleGroup, "toggle-center");
        ToggleButton week = this.getToggleButton(Res.get((String)"time.week"), TradesChartsViewModel.TickUnit.WEEK, this.toggleGroup, "toggle-center");
        ToggleButton day = this.getToggleButton(Res.get((String)"time.day"), TradesChartsViewModel.TickUnit.DAY, this.toggleGroup, "toggle-center");
        ToggleButton hour = this.getToggleButton(Res.get((String)"time.hour"), TradesChartsViewModel.TickUnit.HOUR, this.toggleGroup, "toggle-center");
        ToggleButton minute10 = this.getToggleButton(Res.get((String)"time.minute10"), TradesChartsViewModel.TickUnit.MINUTE_10, this.toggleGroup, "toggle-right");
        HBox toggleBox = new HBox();
        toggleBox.setSpacing(0.0);
        toggleBox.setAlignment(Pos.CENTER_LEFT);
        toggleBox.getChildren().addAll((Object[])new Node[]{year, month, week, day, hour, minute10});
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.getTopLabelWithVBox(Res.get((String)"shared.interval"), (Node)toggleBox);
        HBox hBox = new HBox();
        hBox.setSpacing(0.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.getChildren().addAll((Object[])new Node[]{(Node)currencyComboBoxTuple.first, spacer, (Node)topLabelWithVBox.second});
        return hBox;
    }

    private ToggleButton getToggleButton(String label, TradesChartsViewModel.TickUnit tickUnit, ToggleGroup toggleGroup, String style) {
        AutoTooltipToggleButton toggleButton = new AutoTooltipToggleButton(label);
        toggleButton.setUserData((Object)tickUnit);
        toggleButton.setToggleGroup(toggleGroup);
        toggleButton.setId(style);
        return toggleButton;
    }

    private void createTable() {
        this.tableView = new TableView();
        GUIUtil.applyTableStyle(this.tableView);
        VBox.setVgrow(this.tableView, (Priority)Priority.ALWAYS);
        this.tableView.getStyleClass().add((Object)"non-interactive-table");
        AutoTooltipTableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem> dateColumn = new AutoTooltipTableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem>(this, Res.get((String)"shared.dateTime")){
            {
                this.setMinWidth(240.0);
                this.setMaxWidth(240.0);
            }
        };
        dateColumn.getStyleClass().addAll((Object[])new String[]{"number-column"});
        dateColumn.setCellValueFactory(tradeStatistics -> new ReadOnlyObjectWrapper((Object)((TradeStatistics3ListItem)tradeStatistics.getValue())));
        dateColumn.setCellFactory((Callback)new Callback<TableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem>, TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem>>(this){

            public TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem> call(TableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem> column) {
                return new TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem>(this){

                    public void updateItem(TradeStatistics3ListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setText(item.getDateString());
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        dateColumn.setComparator(Comparator.comparing(TradeStatistics3ListItem::getDate));
        this.tableView.getColumns().add((Object)dateColumn);
        this.marketColumn = new AutoTooltipTableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem>(this, Res.get((String)"shared.market")){
            {
                this.setMinWidth(130.0);
                this.setMaxWidth(130.0);
            }
        };
        this.marketColumn.getStyleClass().add((Object)"number-column");
        this.marketColumn.setCellValueFactory(tradeStatistics -> new ReadOnlyObjectWrapper((Object)((TradeStatistics3ListItem)tradeStatistics.getValue())));
        this.marketColumn.setCellFactory((Callback)new Callback<TableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem>, TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem>>(this){

            public TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem> call(TableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem> column) {
                return new TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem>(this){

                    public void updateItem(TradeStatistics3ListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setText(item.getMarket());
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        this.marketColumn.setComparator(Comparator.comparing(TradeStatistics3ListItem::getMarket));
        this.tableView.getColumns().add(this.marketColumn);
        this.priceColumn = new TableColumn();
        this.priceColumn.getStyleClass().add((Object)"number-column");
        this.priceColumn.setCellValueFactory(tradeStatistics -> new ReadOnlyObjectWrapper((Object)((TradeStatistics3ListItem)tradeStatistics.getValue())));
        this.priceColumn.setCellFactory((Callback)new Callback<TableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem>, TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem>>(this){

            public TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem> call(TableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem> column) {
                return new TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem>(this){

                    public void updateItem(TradeStatistics3ListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setText(item.getPriceString());
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        this.priceColumn.setComparator(Comparator.comparing(TradeStatistics3ListItem::getTradePrice));
        this.tableView.getColumns().add(this.priceColumn);
        AutoTooltipTableColumn amountColumn = new AutoTooltipTableColumn(Res.get((String)"shared.amountWithCur", (Object[])new Object[]{Res.getBaseCurrencyCode()}));
        amountColumn.getStyleClass().add((Object)"number-column");
        amountColumn.setCellValueFactory(tradeStatistics -> new ReadOnlyObjectWrapper((Object)((TradeStatistics3ListItem)tradeStatistics.getValue())));
        amountColumn.setCellFactory((Callback)new Callback<TableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem>, TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem>>(this){

            public TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem> call(TableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem> column) {
                return new TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem>(this){

                    public void updateItem(TradeStatistics3ListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setGraphic((Node)new ColoredDecimalPlacesWithZerosText(item.getAmountString(), 3));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        amountColumn.setComparator(Comparator.comparing(TradeStatistics3ListItem::getTradeAmount));
        this.tableView.getColumns().add(amountColumn);
        this.volumeColumn = new TableColumn();
        this.volumeColumn.getStyleClass().add((Object)"number-column");
        this.volumeColumn.setCellValueFactory(tradeStatistics -> new ReadOnlyObjectWrapper((Object)((TradeStatistics3ListItem)tradeStatistics.getValue())));
        this.volumeColumn.setCellFactory((Callback)new Callback<TableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem>, TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem>>(this){

            public TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem> call(TableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem> column) {
                return new TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem>(this){

                    public void updateItem(TradeStatistics3ListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setText(item.getVolumeString());
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        this.volumeColumn.setComparator(Comparator.comparing(TradeStatistics3ListItem::getTradeVolume));
        this.tableView.getColumns().add(this.volumeColumn);
        AutoTooltipTableColumn paymentMethodColumn = new AutoTooltipTableColumn(Res.get((String)"shared.paymentMethod"));
        paymentMethodColumn.getStyleClass().addAll((Object[])new String[]{"number-column"});
        paymentMethodColumn.setCellValueFactory(tradeStatistics -> new ReadOnlyObjectWrapper((Object)((TradeStatistics3ListItem)tradeStatistics.getValue())));
        paymentMethodColumn.setCellFactory((Callback)new Callback<TableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem>, TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem>>(this){

            public TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem> call(TableColumn<TradeStatistics3ListItem, TradeStatistics3ListItem> column) {
                return new TableCell<TradeStatistics3ListItem, TradeStatistics3ListItem>(this){

                    public void updateItem(TradeStatistics3ListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setText(item.getPaymentMethodString());
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        paymentMethodColumn.setComparator(Comparator.comparing(TradeStatistics3ListItem::getPaymentMethodString));
        this.tableView.getColumns().add(paymentMethodColumn);
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        AutoTooltipLabel placeholder = new AutoTooltipLabel(Res.get((String)"table.placeholder.noData"));
        placeholder.setWrapText(true);
        this.tableView.setPlaceholder((Node)placeholder);
        dateColumn.setSortType(TableColumn.SortType.DESCENDING);
        this.tableView.getSortOrder().add((Object)dateColumn);
    }

    private void layout() {
        double available = ((VBox)this.root).getParent() instanceof Pane ? ((Pane)((VBox)this.root).getParent()).getHeight() : ((VBox)this.root).getHeight();
        if (available == 0.0) {
            UserThread.execute(this::layout);
            return;
        }
        available = available - this.volumeChartPane.getHeight() - this.toolBox.getHeight() - this.footer.getHeight() - 60.0;
        if (!((TradesChartsViewModel)this.model).showAllTradeCurrenciesProperty.get()) {
            double priceChartPaneHeight = this.priceChartPane.getHeight();
            if (priceChartPaneHeight == 0.0) {
                UserThread.execute(this::layout);
                return;
            }
            available -= priceChartPaneHeight;
        } else if (this.volumeChartPane.getHeight() < this.volumeChart.getMaxHeight()) {
            UserThread.execute(this::layout);
            return;
        }
        this.tableView.setPrefHeight(available);
    }

    static class CurrencyStringConverter
    extends StringConverter<CurrencyListItem> {
        private final ComboBox<CurrencyListItem> comboBox;

        CurrencyStringConverter(ComboBox<CurrencyListItem> comboBox) {
            this.comboBox = comboBox;
        }

        public String toString(CurrencyListItem currencyItem) {
            return currencyItem != null ? currencyItem.codeDashNameString() : "";
        }

        public CurrencyListItem fromString(String query) {
            if (this.comboBox.getItems().isEmpty()) {
                return null;
            }
            if (query.isEmpty()) {
                return null;
            }
            return this.comboBox.getItems().stream().filter(currencyItem -> currencyItem.codeDashNameString().equals(query)).findAny().orElse(null);
        }
    }
}

