/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.market.trades;

import haveno.common.app.Capabilities;
import haveno.common.proto.network.GetDataResponsePriority;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.FormattingUtils;
import haveno.core.util.VolumeUtil;
import haveno.desktop.util.DisplayUtils;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import protobuf.PersistableNetworkPayload;
import protobuf.TradeStatistics3;

public class TradeStatistics3ListItem {
    private final haveno.core.trade.statistics.TradeStatistics3 tradeStatistics3;
    private final boolean showAllTradeCurrencies;
    private String dateString;
    private String market;
    private String priceString;
    private String volumeString;
    private String paymentMethodString;
    private String amountString;

    public TradeStatistics3ListItem(@Nullable haveno.core.trade.statistics.TradeStatistics3 tradeStatistics3, boolean showAllTradeCurrencies) {
        this.tradeStatistics3 = tradeStatistics3;
        this.showAllTradeCurrencies = showAllTradeCurrencies;
    }

    public String getDateString() {
        if (this.dateString == null) {
            this.dateString = this.tradeStatistics3 != null ? DisplayUtils.formatDateTime(this.tradeStatistics3.getDate()) : "";
        }
        return this.dateString;
    }

    public String getMarket() {
        if (this.market == null) {
            this.market = this.tradeStatistics3 != null ? CurrencyUtil.getCurrencyPair((String)this.tradeStatistics3.getCurrency()) : "";
        }
        return this.market;
    }

    public String getPriceString() {
        if (this.priceString == null) {
            this.priceString = this.tradeStatistics3 != null ? FormattingUtils.formatPrice((Price)this.tradeStatistics3.getTradePrice()) : "";
        }
        return this.priceString;
    }

    public String getVolumeString() {
        if (this.volumeString == null) {
            this.volumeString = this.tradeStatistics3 != null ? (this.showAllTradeCurrencies ? VolumeUtil.formatVolumeWithCode((Volume)this.tradeStatistics3.getTradeVolume()) : VolumeUtil.formatVolume((Volume)this.tradeStatistics3.getTradeVolume())) : "";
        }
        return this.volumeString;
    }

    public String getPaymentMethodString() {
        if (this.paymentMethodString == null) {
            this.paymentMethodString = this.tradeStatistics3 != null ? Res.get((String)this.tradeStatistics3.getPaymentMethodId()) : "";
        }
        return this.paymentMethodString;
    }

    public String getAmountString() {
        if (this.amountString == null) {
            this.amountString = this.tradeStatistics3 != null ? HavenoUtils.formatXmr((long)this.getAmount(), (boolean)false, (int)4) : "";
        }
        return this.amountString;
    }

    public byte[] createHash() {
        return this.tradeStatistics3.createHash();
    }

    public TradeStatistics3 toProtoTradeStatistics3() {
        return this.tradeStatistics3.toProtoTradeStatistics3();
    }

    public PersistableNetworkPayload toProtoMessage() {
        return this.tradeStatistics3.toProtoMessage();
    }

    public byte[] getHash() {
        return this.tradeStatistics3.getHash();
    }

    public boolean verifyHashSize() {
        return this.tradeStatistics3.verifyHashSize();
    }

    public Capabilities getRequiredCapabilities() {
        return this.tradeStatistics3.getRequiredCapabilities();
    }

    public Date getDate() {
        return this.tradeStatistics3.getDate();
    }

    public LocalDateTime getLocalDateTime() {
        return this.tradeStatistics3.getLocalDateTime();
    }

    public long getDateAsLong() {
        return this.tradeStatistics3.getDateAsLong();
    }

    public int maxItems() {
        return this.tradeStatistics3.maxItems();
    }

    public void pruneOptionalData() {
        this.tradeStatistics3.pruneOptionalData();
    }

    public String getPaymentMethodId() {
        return this.tradeStatistics3.getPaymentMethodId();
    }

    public Price getTradePrice() {
        return this.tradeStatistics3.getTradePrice();
    }

    public long getNormalizedPrice() {
        return this.tradeStatistics3.getNormalizedPrice();
    }

    public BigInteger getTradeAmount() {
        return this.tradeStatistics3.getTradeAmount();
    }

    public Volume getTradeVolume() {
        return this.tradeStatistics3.getTradeVolume();
    }

    public boolean isValid() {
        return this.tradeStatistics3.isValid();
    }

    public String getCurrency() {
        return this.tradeStatistics3.getCurrency();
    }

    public long getAmount() {
        return this.tradeStatistics3.getAmount();
    }

    public String getArbitrator() {
        return this.tradeStatistics3.getArbitrator();
    }

    public Map<String, String> getExtraDataMap() {
        return this.tradeStatistics3.getExtraDataMap();
    }

    public GetDataResponsePriority getGetDataResponsePriority() {
        return this.tradeStatistics3.getGetDataResponsePriority();
    }
}

