/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.market.trades;

import com.google.common.annotations.VisibleForTesting;
import haveno.common.util.MathUtils;
import haveno.core.locale.CurrencyUtil;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.statistics.TradeStatistics3;
import haveno.desktop.main.market.trades.TradesChartsViewModel;
import haveno.desktop.main.market.trades.charts.CandleData;
import haveno.desktop.util.DisplayUtils;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javafx.scene.chart.XYChart;
import javafx.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartCalculations {
    private static final Logger log = LoggerFactory.getLogger(ChartCalculations.class);
    static final ZoneId ZONE_ID = ZoneId.systemDefault();

    static CompletableFuture<Map<TradesChartsViewModel.TickUnit, Map<Long, Long>>> getUsdAveragePriceMapsPerTickUnit(Set<TradeStatistics3> tradeStatisticsSet) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap usdAveragePriceMapsPerTickUnit = new HashMap();
            HashMap<TradesChartsViewModel.TickUnit, Map> dateMapsPerTickUnit = new HashMap<TradesChartsViewModel.TickUnit, Map>();
            for (TradesChartsViewModel.TickUnit tick2 : TradesChartsViewModel.TickUnit.values()) {
                dateMapsPerTickUnit.put(tick2, new HashMap());
            }
            tradeStatisticsSet.stream().filter(e -> e.getCurrency().equals("USD")).forEach(tradeStatistics -> {
                for (TradesChartsViewModel.TickUnit tick : TradesChartsViewModel.TickUnit.values()) {
                    long time = ChartCalculations.roundToTick(tradeStatistics.getLocalDateTime(), tick).getTime();
                    Map map = (Map)dateMapsPerTickUnit.get((Object)tick);
                    map.putIfAbsent(time, new ArrayList());
                    ((List)map.get(time)).add(tradeStatistics);
                }
            });
            dateMapsPerTickUnit.forEach((tick, map) -> {
                HashMap priceMap = new HashMap();
                map.forEach((date, tradeStatisticsList) -> priceMap.put(date, ChartCalculations.getAverageTraditionalPrice(tradeStatisticsList)));
                usdAveragePriceMapsPerTickUnit.put(tick, priceMap);
            });
            return usdAveragePriceMapsPerTickUnit;
        });
    }

    static CompletableFuture<List<TradeStatistics3>> getTradeStatisticsForCurrency(Set<TradeStatistics3> tradeStatisticsSet, String currencyCode, boolean showAllTradeCurrencies) {
        return CompletableFuture.supplyAsync(() -> tradeStatisticsSet.stream().filter(e -> showAllTradeCurrencies || e.getCurrency().equals(currencyCode)).collect(Collectors.toList()));
    }

    static CompletableFuture<UpdateChartResult> getUpdateChartResult(List<TradeStatistics3> tradeStatisticsByCurrency, TradesChartsViewModel.TickUnit tickUnit, Map<TradesChartsViewModel.TickUnit, Map<Long, Long>> usdAveragePriceMapsPerTickUnit, String currencyCode) {
        return CompletableFuture.supplyAsync(() -> {
            Map<Long, Pair<Date, Set<TradeStatistics3>>> itemsPerInterval = ChartCalculations.getItemsPerInterval(tradeStatisticsByCurrency, tickUnit);
            Map usdAveragePriceMap = (Map)usdAveragePriceMapsPerTickUnit.get((Object)tickUnit);
            AtomicLong averageUsdPrice = new AtomicLong(0L);
            List candleDataList = itemsPerInterval.entrySet().stream().filter(entry -> (Long)entry.getKey() >= 0L && !((Set)((Pair)entry.getValue()).getValue()).isEmpty()).map(entry -> {
                long tickStartDate = ((Date)((Pair)entry.getValue()).getKey()).getTime();
                if (usdAveragePriceMap.containsKey(tickStartDate)) {
                    averageUsdPrice.set((Long)usdAveragePriceMap.get(tickStartDate));
                }
                return ChartCalculations.getCandleData((Long)entry.getKey(), (Set)((Pair)entry.getValue()).getValue(), averageUsdPrice.get(), tickUnit, currencyCode, itemsPerInterval);
            }).sorted(Comparator.comparingLong(o -> o.tick)).collect(Collectors.toList());
            List<XYChart.Data<Number, Number>> priceItems = candleDataList.stream().map(e -> new XYChart.Data((Object)e.tick, (Object)e.open, e)).collect(Collectors.toList());
            List<XYChart.Data<Number, Number>> volumeItems = candleDataList.stream().map(candleData -> new XYChart.Data((Object)candleData.tick, (Object)candleData.accumulatedAmount, candleData)).collect(Collectors.toList());
            List<XYChart.Data<Number, Number>> volumeInUsdItems = candleDataList.stream().map(candleData -> new XYChart.Data((Object)candleData.tick, (Object)candleData.volumeInUsd, candleData)).collect(Collectors.toList());
            return new UpdateChartResult(itemsPerInterval, priceItems, volumeItems, volumeInUsdItems);
        });
    }

    static Map<Long, Pair<Date, Set<TradeStatistics3>>> getItemsPerInterval(List<TradeStatistics3> tradeStatisticsByCurrency, TradesChartsViewModel.TickUnit tickUnit) {
        HashMap<Long, Pair<Date, Set<TradeStatistics3>>> itemsPerInterval = new HashMap<Long, Pair<Date, Set<TradeStatistics3>>>();
        Date time = new Date();
        for (long i = 91L; i >= 0L; --i) {
            Pair pair = new Pair((Object)((Date)time.clone()), new HashSet());
            itemsPerInterval.put(i, (Pair<Date, Set<TradeStatistics3>>)pair);
            time.setTime(time.getTime() - 1L);
            time = ChartCalculations.roundToTick(time, tickUnit);
        }
        tradeStatisticsByCurrency.forEach(tradeStatistics -> {
            for (long i = 90L; i > 0L; --i) {
                Pair pair = (Pair)itemsPerInterval.get(i);
                if (!tradeStatistics.getDate().after((Date)pair.getKey())) continue;
                ((Set)pair.getValue()).add(tradeStatistics);
                break;
            }
        });
        return itemsPerInterval;
    }

    static Date roundToTick(LocalDateTime localDate, TradesChartsViewModel.TickUnit tickUnit) {
        switch (tickUnit) {
            case YEAR: {
                return Date.from(localDate.withMonth(1).withDayOfYear(1).withHour(0).withMinute(0).withSecond(0).withNano(0).atZone(ZONE_ID).toInstant());
            }
            case MONTH: {
                return Date.from(localDate.withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0).atZone(ZONE_ID).toInstant());
            }
            case WEEK: {
                int dayOfWeek = localDate.getDayOfWeek().getValue();
                LocalDateTime firstDayOfWeek = ChronoUnit.DAYS.addTo(localDate, 1 - dayOfWeek);
                return Date.from(firstDayOfWeek.withHour(0).withMinute(0).withSecond(0).withNano(0).atZone(ZONE_ID).toInstant());
            }
            case DAY: {
                return Date.from(localDate.withHour(0).withMinute(0).withSecond(0).withNano(0).atZone(ZONE_ID).toInstant());
            }
            case HOUR: {
                return Date.from(localDate.withMinute(0).withSecond(0).withNano(0).atZone(ZONE_ID).toInstant());
            }
            case MINUTE_10: {
                return Date.from(localDate.withMinute(localDate.getMinute() - localDate.getMinute() % 10).withSecond(0).withNano(0).atZone(ZONE_ID).toInstant());
            }
        }
        return Date.from(localDate.atZone(ZONE_ID).toInstant());
    }

    static Date roundToTick(Date time, TradesChartsViewModel.TickUnit tickUnit) {
        return ChartCalculations.roundToTick(time.toInstant().atZone(ZONE_ID).toLocalDateTime(), tickUnit);
    }

    private static long getAverageTraditionalPrice(List<TradeStatistics3> tradeStatisticsList) {
        BigInteger accumulatedAmount = BigInteger.ZERO;
        BigInteger accumulatedVolume = BigInteger.ZERO;
        for (TradeStatistics3 tradeStatistics : tradeStatisticsList) {
            accumulatedAmount = accumulatedAmount.add(BigInteger.valueOf(tradeStatistics.getAmount()));
            accumulatedVolume = accumulatedVolume.add(BigInteger.valueOf(tradeStatistics.getTradeVolume().getValue()));
        }
        BigInteger accumulatedVolumeAsBI = MathUtils.scaleUpByPowerOf10((BigInteger)accumulatedVolume, (int)12);
        return MathUtils.roundDoubleToLong((double)HavenoUtils.divide((BigInteger)accumulatedVolumeAsBI, (BigInteger)accumulatedAmount));
    }

    @VisibleForTesting
    static CandleData getCandleData(long tick, Set<TradeStatistics3> set, long averageUsdPrice, TradesChartsViewModel.TickUnit tickUnit, String currencyCode, Map<Long, Pair<Date, Set<TradeStatistics3>>> itemsPerInterval) {
        long open = 0L;
        long close = 0L;
        long high = 0L;
        long low = 0L;
        BigInteger accumulatedVolume = BigInteger.ZERO;
        BigInteger accumulatedAmount = BigInteger.ZERO;
        long numTrades = set.size();
        ArrayList<Long> tradePrices = new ArrayList<Long>();
        for (TradeStatistics3 item : set) {
            long tradePriceAsLong = item.getTradePrice().getValue();
            low = low != 0L ? Math.min(low, tradePriceAsLong) : tradePriceAsLong;
            high = high != 0L ? Math.max(high, tradePriceAsLong) : tradePriceAsLong;
            accumulatedVolume = accumulatedVolume.add(BigInteger.valueOf(item.getTradeVolume().getValue()));
            accumulatedAmount = accumulatedAmount.add(item.getTradeAmount());
            tradePrices.add(tradePriceAsLong);
        }
        Collections.sort(tradePrices);
        ArrayList<TradeStatistics3> list = new ArrayList<TradeStatistics3>(set);
        list.sort(Comparator.comparingLong(TradeStatistics3::getDateAsLong));
        if (list.size() > 0) {
            open = ((TradeStatistics3)list.get(0)).getTradePrice().getValue();
            close = ((TradeStatistics3)list.get(list.size() - 1)).getTradePrice().getValue();
        }
        Long[] prices = new Long[tradePrices.size()];
        tradePrices.toArray(prices);
        long medianPrice = MathUtils.getMedian((Long[])prices);
        boolean isBullish = close > open;
        int smallestUnitExponent = CurrencyUtil.isCryptoCurrency((String)currencyCode) ? 8 : 8;
        BigInteger accumulatedVolumeAsBI = MathUtils.scaleUpByPowerOf10((BigInteger)accumulatedVolume, (int)(smallestUnitExponent + 4));
        long averagePrice = MathUtils.roundDoubleToLong((double)HavenoUtils.divide((BigInteger)accumulatedVolumeAsBI, (BigInteger)accumulatedAmount));
        Date dateFrom = new Date(ChartCalculations.getTimeFromTickIndex(tick, itemsPerInterval));
        Date dateTo = new Date(ChartCalculations.getTimeFromTickIndex(tick + 1L, itemsPerInterval));
        String dateString = tickUnit.ordinal() > TradesChartsViewModel.TickUnit.DAY.ordinal() ? DisplayUtils.formatDateTimeSpan(dateFrom, dateTo) : DisplayUtils.formatDate(dateFrom) + " - " + DisplayUtils.formatDate(dateTo);
        averageUsdPrice = (long)MathUtils.scaleDownByPowerOf10((double)averageUsdPrice, (int)smallestUnitExponent);
        long volumeInUsd = averageUsdPrice * MathUtils.scaleDownByPowerOf10((BigInteger)accumulatedAmount, (int)4).longValue();
        volumeInUsd = (long)MathUtils.scaleDownByPowerOf10((double)volumeInUsd, (int)smallestUnitExponent);
        return new CandleData(tick, open, close, high, low, averagePrice, medianPrice, accumulatedAmount.longValueExact(), accumulatedVolume.longValueExact(), numTrades, isBullish, dateString, volumeInUsd);
    }

    static long getTimeFromTickIndex(long tick, Map<Long, Pair<Date, Set<TradeStatistics3>>> itemsPerInterval) {
        if (tick > 91L || itemsPerInterval.get(tick) == null) {
            return 0L;
        }
        return ((Date)itemsPerInterval.get(tick).getKey()).getTime();
    }

    static class UpdateChartResult {
        private final Map<Long, Pair<Date, Set<TradeStatistics3>>> itemsPerInterval;
        private final List<XYChart.Data<Number, Number>> priceItems;
        private final List<XYChart.Data<Number, Number>> volumeItems;
        private final List<XYChart.Data<Number, Number>> volumeInUsdItems;

        public UpdateChartResult(Map<Long, Pair<Date, Set<TradeStatistics3>>> itemsPerInterval, List<XYChart.Data<Number, Number>> priceItems, List<XYChart.Data<Number, Number>> volumeItems, List<XYChart.Data<Number, Number>> volumeInUsdItems) {
            this.itemsPerInterval = itemsPerInterval;
            this.priceItems = priceItems;
            this.volumeItems = volumeItems;
            this.volumeInUsdItems = volumeInUsdItems;
        }

        public Map<Long, Pair<Date, Set<TradeStatistics3>>> getItemsPerInterval() {
            return this.itemsPerInterval;
        }

        public List<XYChart.Data<Number, Number>> getPriceItems() {
            return this.priceItems;
        }

        public List<XYChart.Data<Number, Number>> getVolumeItems() {
            return this.volumeItems;
        }

        public List<XYChart.Data<Number, Number>> getVolumeInUsdItems() {
            return this.volumeInUsdItems;
        }
    }
}

