/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.market.spread;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.UserThread;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.provider.price.MarketPrice;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.FormattingUtils;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.common.model.ActivatableViewModel;
import haveno.desktop.main.market.spread.SpreadItem;
import haveno.desktop.main.offer.offerbook.OfferBook;
import haveno.desktop.main.offer.offerbook.OfferBookListItem;
import haveno.desktop.main.overlays.popups.Popup;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

class SpreadViewModel
extends ActivatableViewModel {
    private final OfferBook offerBook;
    private final PriceFeedService priceFeedService;
    private final CoinFormatter formatter;
    private final ObservableList<OfferBookListItem> offerBookListItems;
    private final ListChangeListener<OfferBookListItem> listChangeListener;
    final ObservableList<SpreadItem> spreadItems = FXCollections.observableArrayList();
    final IntegerProperty maxPlacesForAmount = new SimpleIntegerProperty();
    private boolean includePaymentMethod;
    private boolean expandedView;

    @Inject
    public SpreadViewModel(OfferBook offerBook, PriceFeedService priceFeedService, @Named(value="BTC") CoinFormatter formatter) {
        this.offerBook = offerBook;
        this.priceFeedService = priceFeedService;
        this.formatter = formatter;
        this.includePaymentMethod = false;
        this.offerBookListItems = offerBook.getOfferBookListItems();
        this.listChangeListener = c -> UserThread.execute(() -> this.update(this.offerBookListItems));
    }

    public String getKeyColumnName() {
        return this.includePaymentMethod ? Res.get((String)"shared.paymentMethod") : Res.get((String)"shared.currency");
    }

    public void setExpandedView(boolean expandedView) {
        this.expandedView = expandedView;
        this.update(this.offerBookListItems);
    }

    @Override
    protected void activate() {
        this.offerBookListItems.addListener(this.listChangeListener);
        this.offerBook.fillOfferBookListItems();
        this.update(this.offerBookListItems);
    }

    @Override
    protected void deactivate() {
        this.offerBookListItems.removeListener(this.listChangeListener);
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(ObservableList<OfferBookListItem> offerBookListItems) {
        HashMap offersByCurrencyMap = new HashMap();
        ObservableList<OfferBookListItem> observableList = offerBookListItems;
        synchronized (observableList) {
            for (OfferBookListItem offerBookListItem : offerBookListItems) {
                Offer offer = offerBookListItem.getOffer();
                Object key = offer.getCounterCurrencyCode();
                if (this.includePaymentMethod) {
                    key = offer.getPaymentMethod().getShortName();
                    if (this.expandedView) {
                        key = (String)key + ":" + offer.getCounterCurrencyCode();
                    }
                }
                if (!offersByCurrencyMap.containsKey(key)) {
                    offersByCurrencyMap.put((String)key, new ArrayList());
                }
                ((List)offersByCurrencyMap.get(key)).add(offer);
            }
        }
        this.spreadItems.clear();
        BigInteger totalAmount = BigInteger.ZERO;
        for (String key : offersByCurrencyMap.keySet()) {
            Price bestBuyOfferPrice;
            List offers = (List)offersByCurrencyMap.get(key);
            List uniqueOffers = offers.stream().filter(SpreadViewModel.distinctByKey(Offer::getId)).collect(Collectors.toList());
            List buyOffers = uniqueOffers.stream().filter(e -> e.getDirection().equals((Object)OfferDirection.BUY)).sorted((o1, o2) -> {
                long b;
                long a = o1.getPrice() != null ? o1.getPrice().getValue() : 0L;
                long l = b = o2.getPrice() != null ? o2.getPrice().getValue() : 0L;
                if (a != b) {
                    return a < b ? 1 : -1;
                }
                return 0;
            }).collect(Collectors.toList());
            List sellOffers = uniqueOffers.stream().filter(e -> e.getDirection().equals((Object)OfferDirection.SELL)).sorted((o1, o2) -> {
                long b;
                long a = o1.getPrice() != null ? o1.getPrice().getValue() : 0L;
                long l = b = o2.getPrice() != null ? o2.getPrice().getValue() : 0L;
                if (a != b) {
                    return a > b ? 1 : -1;
                }
                return 0;
            }).collect(Collectors.toList());
            Price spread = null;
            String percentage = "";
            double percentageValue = 0.0;
            Price bestSellOfferPrice = sellOffers.isEmpty() ? null : ((Offer)sellOffers.get(0)).getPrice();
            Price price = bestBuyOfferPrice = buyOffers.isEmpty() ? null : ((Offer)buyOffers.get(0)).getPrice();
            if (bestBuyOfferPrice != null && bestSellOfferPrice != null && ((Offer)sellOffers.get(0)).getCounterCurrencyCode().equals(((Offer)buyOffers.get(0)).getCounterCurrencyCode())) {
                MarketPrice marketPrice = this.priceFeedService.getMarketPrice(((Offer)sellOffers.get(0)).getCounterCurrencyCode());
                try {
                    spread = bestSellOfferPrice.subtract(bestBuyOfferPrice);
                    if (spread != null && marketPrice != null && marketPrice.isPriceAvailable()) {
                        double marketPriceAsDouble = marketPrice.getPrice();
                        boolean isTraditionalCurrency = offers.size() > 0 && ((Offer)offers.get(0)).getPaymentMethod().isTraditional();
                        double precision = isTraditionalCurrency ? Math.pow(10.0, 8.0) : Math.pow(10.0, 8.0);
                        BigDecimal marketPriceAsBigDecimal = BigDecimal.valueOf(marketPriceAsDouble).multiply(BigDecimal.valueOf(precision));
                        percentageValue = BigDecimal.valueOf(spread.getValue()).multiply(BigDecimal.valueOf(10000L)).divide(marketPriceAsBigDecimal, RoundingMode.HALF_UP).doubleValue() / 10000.0;
                        percentage = FormattingUtils.formatPercentagePrice((double)percentageValue);
                    }
                }
                catch (Throwable t) {
                    try {
                        String msg = "An error occurred at the spread calculation.\nError msg: " + t.toString() + "\nDetails of offer data: \nbestSellOfferPrice: " + bestSellOfferPrice.getValue() + "\nbestBuyOfferPrice: " + bestBuyOfferPrice.getValue() + "\nsellOffer getCurrencyCode: " + ((Offer)sellOffers.get(0)).getCounterCurrencyCode() + "\nbuyOffer getCurrencyCode: " + ((Offer)buyOffers.get(0)).getCounterCurrencyCode() + "\n\nPlease copy and paste this data and send it to the developers so they can investigate the issue.";
                        ((Popup)new Popup().error(msg)).show();
                        this.log.error(t.toString());
                        t.printStackTrace();
                    }
                    catch (Throwable t2) {
                        this.log.error(t2.toString());
                        t2.printStackTrace();
                    }
                }
            }
            BigInteger totalAmountForCurrency = BigInteger.ZERO;
            for (Offer offer : offers) {
                totalAmount = totalAmount.add(offer.getAmount());
                totalAmountForCurrency = totalAmountForCurrency.add(offer.getAmount());
            }
            this.spreadItems.add((Object)new SpreadItem(key, buyOffers.size(), sellOffers.size(), uniqueOffers.size(), spread, percentage, percentageValue, totalAmountForCurrency));
        }
        this.maxPlacesForAmount.set(this.formatAmount(totalAmount, false).length());
    }

    public String getAmount(BigInteger amount) {
        return this.formatAmount(amount, true);
    }

    private String formatAmount(BigInteger amount, boolean decimalAligned) {
        return this.formatter.formatCoin(HavenoUtils.atomicUnitsToCoin((BigInteger)amount), 4, decimalAligned, this.maxPlacesForAmount.get());
    }

    public void setIncludePaymentMethod(boolean includePaymentMethod) {
        this.includePaymentMethod = includePaymentMethod;
    }

    public boolean isIncludePaymentMethod() {
        return this.includePaymentMethod;
    }

    public boolean isExpandedView() {
        return this.expandedView;
    }
}

