/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.market.spread;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.UserThread;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.common.view.ActivatableViewAndModel;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.AutoTooltipTableColumn;
import haveno.desktop.components.ColoredDecimalPlacesWithZerosText;
import haveno.desktop.main.market.spread.SpreadItem;
import haveno.desktop.main.market.spread.SpreadViewModel;
import haveno.desktop.util.GUIUtil;
import java.math.BigInteger;
import java.util.Comparator;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.transformation.SortedList;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.Callback;

@FxmlView
public class SpreadView
extends ActivatableViewAndModel<GridPane, SpreadViewModel> {
    private final CoinFormatter formatter;
    private TableView<SpreadItem> tableView;
    private SortedList<SpreadItem> sortedList;
    private ListChangeListener<SpreadItem> itemListChangeListener;
    private TableColumn<SpreadItem, SpreadItem> totalAmountColumn;
    private TableColumn<SpreadItem, SpreadItem> numberOfOffersColumn;
    private TableColumn<SpreadItem, SpreadItem> numberOfBuyOffersColumn;
    private TableColumn<SpreadItem, SpreadItem> numberOfSellOffersColumn;

    @Inject
    public SpreadView(SpreadViewModel model, @Named(value="BTC") CoinFormatter formatter) {
        super(model);
        this.formatter = formatter;
    }

    @Override
    public void initialize() {
        this.tableView = new TableView();
        GUIUtil.applyTableStyle(this.tableView);
        this.tableView.getStyleClass().add((Object)"non-interactive-table");
        int gridRow = 0;
        GridPane.setRowIndex(this.tableView, (Integer)gridRow);
        GridPane.setVgrow(this.tableView, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.tableView, (Priority)Priority.ALWAYS);
        ((GridPane)this.root).getChildren().add(this.tableView);
        AutoTooltipLabel placeholder = new AutoTooltipLabel(Res.get((String)"table.placeholder.noData"));
        placeholder.setWrapText(true);
        this.tableView.setPlaceholder((Node)placeholder);
        TableColumn<SpreadItem, SpreadItem> currencyColumn = this.getCurrencyColumn();
        this.tableView.getColumns().add(currencyColumn);
        this.numberOfOffersColumn = this.getNumberOfOffersColumn();
        this.tableView.getColumns().add(this.numberOfOffersColumn);
        this.numberOfBuyOffersColumn = this.getNumberOfBuyOffersColumn();
        this.tableView.getColumns().add(this.numberOfBuyOffersColumn);
        this.numberOfSellOffersColumn = this.getNumberOfSellOffersColumn();
        this.tableView.getColumns().add(this.numberOfSellOffersColumn);
        this.totalAmountColumn = this.getTotalAmountColumn();
        this.tableView.getColumns().add(this.totalAmountColumn);
        TableColumn<SpreadItem, SpreadItem> spreadColumn = this.getSpreadColumn();
        this.tableView.getColumns().add(spreadColumn);
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        currencyColumn.setComparator(Comparator.comparing(o -> ((SpreadViewModel)this.model).isIncludePaymentMethod() ? o.currencyCode : CurrencyUtil.getNameByCode((String)o.currencyCode)));
        this.numberOfOffersColumn.setComparator(Comparator.comparingInt(o3 -> o3.numberOfOffers));
        this.numberOfBuyOffersColumn.setComparator(Comparator.comparingInt(o3 -> o3.numberOfBuyOffers));
        this.numberOfSellOffersColumn.setComparator(Comparator.comparingInt(o2 -> o2.numberOfSellOffers));
        this.totalAmountColumn.setComparator(Comparator.comparing(o -> o.totalAmount));
        spreadColumn.setComparator(Comparator.comparingDouble(o -> o.percentageValue));
        this.numberOfOffersColumn.setSortType(TableColumn.SortType.DESCENDING);
        this.tableView.getSortOrder().add(this.numberOfOffersColumn);
        this.itemListChangeListener = c -> this.updateHeaders();
    }

    @Override
    protected void activate() {
        this.sortedList = new SortedList(((SpreadViewModel)this.model).spreadItems);
        this.sortedList.comparatorProperty().bind((ObservableValue)this.tableView.comparatorProperty());
        this.tableView.setItems(this.sortedList);
        this.sortedList.addListener(this.itemListChangeListener);
        this.updateHeaders();
    }

    @Override
    protected void deactivate() {
        this.sortedList.comparatorProperty().unbind();
        this.sortedList.removeListener(this.itemListChangeListener);
    }

    private void updateHeaders() {
        int numberOfOffers = this.sortedList.stream().mapToInt(item -> item.numberOfOffers).sum();
        int numberOfBuyOffers = this.sortedList.stream().mapToInt(item -> item.numberOfBuyOffers).sum();
        int numberOfSellOffers = this.sortedList.stream().mapToInt(item -> item.numberOfSellOffers).sum();
        BigInteger totalAmount = BigInteger.ZERO;
        for (SpreadItem item2 : this.sortedList) {
            totalAmount = totalAmount.add(item2.totalAmount);
        }
        String total = HavenoUtils.formatXmr((BigInteger)totalAmount);
        UserThread.execute(() -> {
            this.numberOfOffersColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"market.spread.numberOfOffersColumn", (Object[])new Object[]{numberOfOffers})));
            this.numberOfBuyOffersColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"market.spread.numberOfBuyOffersColumn", (Object[])new Object[]{numberOfBuyOffers})));
            this.numberOfSellOffersColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"market.spread.numberOfSellOffersColumn", (Object[])new Object[]{numberOfSellOffers})));
            this.totalAmountColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"market.spread.totalAmountColumn", (Object[])new Object[]{total})));
        });
    }

    private TableColumn<SpreadItem, SpreadItem> getCurrencyColumn() {
        AutoTooltipTableColumn<SpreadItem, SpreadItem> column = new AutoTooltipTableColumn<SpreadItem, SpreadItem>(this, ((SpreadViewModel)this.model).getKeyColumnName()){
            {
                this.setMinWidth(160.0);
            }
        };
        column.getStyleClass().addAll((Object[])new String[]{"number-column"});
        column.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((SpreadItem)item.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<SpreadItem, SpreadItem>, TableCell<SpreadItem, SpreadItem>>(){

            public TableCell<SpreadItem, SpreadItem> call(TableColumn<SpreadItem, SpreadItem> column) {
                return new TableCell<SpreadItem, SpreadItem>(){

                    public void updateItem(SpreadItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            if (((SpreadViewModel)SpreadView.this.model).isIncludePaymentMethod()) {
                                this.setText(item.currencyCode);
                            } else {
                                this.setText(CurrencyUtil.getNameAndCode((String)item.currencyCode));
                            }
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        return column;
    }

    private TableColumn<SpreadItem, SpreadItem> getNumberOfOffersColumn() {
        TableColumn<SpreadItem, SpreadItem> column = new TableColumn<SpreadItem, SpreadItem>(this){
            {
                this.setMinWidth(100.0);
            }
        };
        column.getStyleClass().add((Object)"number-column");
        column.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((SpreadItem)item.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<SpreadItem, SpreadItem>, TableCell<SpreadItem, SpreadItem>>(this){

            public TableCell<SpreadItem, SpreadItem> call(TableColumn<SpreadItem, SpreadItem> column) {
                return new TableCell<SpreadItem, SpreadItem>(this){

                    public void updateItem(SpreadItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(String.valueOf(item.numberOfOffers));
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        return column;
    }

    private TableColumn<SpreadItem, SpreadItem> getNumberOfBuyOffersColumn() {
        TableColumn<SpreadItem, SpreadItem> column = new TableColumn<SpreadItem, SpreadItem>(this){
            {
                this.setMinWidth(100.0);
            }
        };
        column.getStyleClass().add((Object)"number-column");
        column.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((SpreadItem)item.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<SpreadItem, SpreadItem>, TableCell<SpreadItem, SpreadItem>>(this){

            public TableCell<SpreadItem, SpreadItem> call(TableColumn<SpreadItem, SpreadItem> column) {
                return new TableCell<SpreadItem, SpreadItem>(this){

                    public void updateItem(SpreadItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(String.valueOf(item.numberOfBuyOffers));
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        return column;
    }

    private TableColumn<SpreadItem, SpreadItem> getNumberOfSellOffersColumn() {
        TableColumn<SpreadItem, SpreadItem> column = new TableColumn<SpreadItem, SpreadItem>(this){
            {
                this.setMinWidth(100.0);
            }
        };
        column.getStyleClass().add((Object)"number-column");
        column.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((SpreadItem)item.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<SpreadItem, SpreadItem>, TableCell<SpreadItem, SpreadItem>>(this){

            public TableCell<SpreadItem, SpreadItem> call(TableColumn<SpreadItem, SpreadItem> column) {
                return new TableCell<SpreadItem, SpreadItem>(this){

                    public void updateItem(SpreadItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(String.valueOf(item.numberOfSellOffers));
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        return column;
    }

    private TableColumn<SpreadItem, SpreadItem> getTotalAmountColumn() {
        TableColumn<SpreadItem, SpreadItem> column = new TableColumn<SpreadItem, SpreadItem>(this){
            {
                this.setMinWidth(140.0);
            }
        };
        column.getStyleClass().addAll((Object[])new String[]{"number-column", "highlight-text"});
        column.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((SpreadItem)item.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<SpreadItem, SpreadItem>, TableCell<SpreadItem, SpreadItem>>(){

            public TableCell<SpreadItem, SpreadItem> call(TableColumn<SpreadItem, SpreadItem> column) {
                return new TableCell<SpreadItem, SpreadItem>(){

                    public void updateItem(SpreadItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new ColoredDecimalPlacesWithZerosText(((SpreadViewModel)SpreadView.this.model).getAmount(item.totalAmount), 3));
                        } else {
                            this.setText("");
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        return column;
    }

    private TableColumn<SpreadItem, SpreadItem> getSpreadColumn() {
        AutoTooltipTableColumn<SpreadItem, SpreadItem> column = new AutoTooltipTableColumn<SpreadItem, SpreadItem>(this, Res.get((String)"market.spread.spreadColumn")){
            {
                this.setMinWidth(110.0);
            }
        };
        column.getStyleClass().addAll((Object[])new String[]{"number-column", "highlight-text"});
        column.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((SpreadItem)item.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<SpreadItem, SpreadItem>, TableCell<SpreadItem, SpreadItem>>(this){

            public TableCell<SpreadItem, SpreadItem> call(TableColumn<SpreadItem, SpreadItem> column) {
                return new TableCell<SpreadItem, SpreadItem>(this){

                    public void updateItem(SpreadItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            if (item.priceSpread != null) {
                                this.setText(item.percentage);
                            } else {
                                this.setText("-");
                            }
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        return column;
    }
}

