/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.market.offerbook;

import com.google.common.math.LongMath;
import com.google.inject.Inject;
import haveno.common.UserThread;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.GlobalSettings;
import haveno.core.locale.TradeCurrency;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OpenOfferManager;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.HavenoUtils;
import haveno.core.user.Preferences;
import haveno.core.util.VolumeUtil;
import haveno.desktop.Navigation;
import haveno.desktop.common.model.ActivatableViewModel;
import haveno.desktop.main.MainView;
import haveno.desktop.main.market.offerbook.OfferListItem;
import haveno.desktop.main.offer.BuyOfferView;
import haveno.desktop.main.offer.OfferViewUtil;
import haveno.desktop.main.offer.SellOfferView;
import haveno.desktop.main.offer.offerbook.OfferBook;
import haveno.desktop.main.offer.offerbook.OfferBookListItem;
import haveno.desktop.main.settings.SettingsView;
import haveno.desktop.main.settings.preferences.PreferencesView;
import haveno.desktop.util.CurrencyList;
import haveno.desktop.util.CurrencyListItem;
import haveno.desktop.util.DisplayUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.chart.XYChart;

class OfferBookChartViewModel
extends ActivatableViewModel {
    private static final int TAB_INDEX = 0;
    private final OfferBook offerBook;
    private final OpenOfferManager openOfferManager;
    final Preferences preferences;
    final PriceFeedService priceFeedService;
    final AccountAgeWitnessService accountAgeWitnessService;
    private final Navigation navigation;
    final ObjectProperty<TradeCurrency> selectedTradeCurrencyProperty = new SimpleObjectProperty();
    private final List<XYChart.Data<Number, Number>> buyData = new ArrayList<XYChart.Data<Number, Number>>();
    private final List<XYChart.Data<Number, Number>> sellData = new ArrayList<XYChart.Data<Number, Number>>();
    private final ObservableList<OfferBookListItem> offerBookListItems;
    private final ListChangeListener<OfferBookListItem> offerBookListItemsListener;
    final CurrencyList currencyListItems;
    private final ObservableList<OfferListItem> topBuyOfferList = FXCollections.observableArrayList();
    private final ObservableList<OfferListItem> topSellOfferList = FXCollections.observableArrayList();
    private final ChangeListener<Number> currenciesUpdatedListener;
    private int selectedTabIndex;
    public final IntegerProperty maxPlacesForBuyPrice = new SimpleIntegerProperty();
    public final IntegerProperty maxPlacesForBuyVolume = new SimpleIntegerProperty();
    public final IntegerProperty maxPlacesForSellPrice = new SimpleIntegerProperty();
    public final IntegerProperty maxPlacesForSellVolume = new SimpleIntegerProperty();

    @Inject
    OfferBookChartViewModel(OfferBook offerBook, OpenOfferManager openOfferManager, Preferences preferences, PriceFeedService priceFeedService, AccountAgeWitnessService accountAgeWitnessService, Navigation navigation) {
        this.offerBook = offerBook;
        this.openOfferManager = openOfferManager;
        this.preferences = preferences;
        this.priceFeedService = priceFeedService;
        this.navigation = navigation;
        this.accountAgeWitnessService = accountAgeWitnessService;
        String code = preferences.getOfferBookChartScreenCurrencyCode();
        if (code != null) {
            Optional tradeCurrencyOptional = CurrencyUtil.getTradeCurrency((String)code);
            if (tradeCurrencyOptional.isPresent()) {
                this.selectedTradeCurrencyProperty.set((Object)((TradeCurrency)tradeCurrencyOptional.get()));
            } else {
                this.selectedTradeCurrencyProperty.set((Object)GlobalSettings.getDefaultTradeCurrency());
            }
        } else {
            this.selectedTradeCurrencyProperty.set((Object)GlobalSettings.getDefaultTradeCurrency());
        }
        this.offerBookListItems = offerBook.getOfferBookListItems();
        this.offerBookListItemsListener = c -> {
            c.next();
            if (c.wasAdded() || c.wasRemoved()) {
                ArrayList list = new ArrayList(c.getRemoved());
                list.addAll(c.getAddedSubList());
                if (list.stream().map(OfferBookListItem::getOffer).anyMatch(e -> e.getCounterCurrencyCode().equals(((TradeCurrency)this.selectedTradeCurrencyProperty.get()).getCode()))) {
                    this.updateChartData();
                }
            }
            this.fillTradeCurrencies();
        };
        this.currenciesUpdatedListener = (observable, oldValue, newValue) -> {
            if (!this.isAnyPriceAbsent()) {
                UserThread.execute(() -> {
                    offerBook.fillOfferBookListItems();
                    this.updateChartData();
                    OfferBookChartViewModel self = this;
                    priceFeedService.updateCounterProperty().removeListener(self.currenciesUpdatedListener);
                });
            }
        };
        this.currencyListItems = new CurrencyList(preferences);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTradeCurrencies() {
        ObservableList<OfferBookListItem> observableList = this.offerBookListItems;
        synchronized (observableList) {
            List<TradeCurrency> tradeCurrencyList = this.offerBookListItems.stream().map(e -> {
                String currencyCode = e.getOffer().getCounterCurrencyCode();
                Optional tradeCurrencyOptional = CurrencyUtil.getTradeCurrency((String)currencyCode);
                return tradeCurrencyOptional.orElse(null);
            }).filter(Objects::nonNull).collect(Collectors.toList());
            this.currencyListItems.updateWithCurrencies(tradeCurrencyList, null);
        }
    }

    @Override
    protected void activate() {
        this.offerBookListItems.addListener(this.offerBookListItemsListener);
        this.offerBook.fillOfferBookListItems();
        this.fillTradeCurrencies();
        this.updateChartData();
        if (this.isAnyPriceAbsent()) {
            this.priceFeedService.updateCounterProperty().addListener(this.currenciesUpdatedListener);
        }
        this.syncPriceFeedCurrency();
    }

    @Override
    protected void deactivate() {
        this.offerBookListItems.removeListener(this.offerBookListItemsListener);
    }

    public void onSetTradeCurrency(TradeCurrency tradeCurrency) {
        if (tradeCurrency != null) {
            String code = tradeCurrency.getCode();
            if (this.isEditEntry(code)) {
                this.navigation.navigateTo(MainView.class, SettingsView.class, PreferencesView.class);
            } else {
                this.selectedTradeCurrencyProperty.set((Object)tradeCurrency);
                this.preferences.setOfferBookChartScreenCurrencyCode(code);
                this.updateChartData();
                this.priceFeedService.setCurrencyCode(code);
            }
        }
    }

    public void setSelectedTabIndex(int selectedTabIndex) {
        this.selectedTabIndex = selectedTabIndex;
        this.syncPriceFeedCurrency();
    }

    public boolean isSellOffer(OfferDirection direction) {
        return direction == OfferDirection.SELL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTotalAmount(OfferDirection direction) {
        ObservableList<OfferBookListItem> observableList = this.offerBookListItems;
        synchronized (observableList) {
            List offerList = this.offerBookListItems.stream().map(OfferBookListItem::getOffer).filter(e -> e.getCounterCurrencyCode().equals(((TradeCurrency)this.selectedTradeCurrencyProperty.get()).getCode()) && e.getDirection().equals((Object)direction)).collect(Collectors.toList());
            BigInteger sum = BigInteger.ZERO;
            for (Offer offer : offerList) {
                sum = sum.add(offer.getAmount());
            }
            return HavenoUtils.atomicUnitsToXmr((BigInteger)sum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Volume getTotalVolume(OfferDirection direction) {
        ObservableList<OfferBookListItem> observableList = this.offerBookListItems;
        synchronized (observableList) {
            List volumes = this.offerBookListItems.stream().map(OfferBookListItem::getOffer).filter(e -> e.getCounterCurrencyCode().equals(((TradeCurrency)this.selectedTradeCurrencyProperty.get()).getCode()) && e.getDirection().equals((Object)direction)).map(Offer::getVolume).collect(Collectors.toList());
            try {
                return VolumeUtil.sum(volumes);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public boolean isCrypto() {
        return CurrencyUtil.isCryptoCurrency((String)this.getCurrencyCode());
    }

    public boolean isMyOffer(Offer offer) {
        return this.openOfferManager.isMyOffer(offer);
    }

    public void goToOfferView(OfferDirection direction) {
        this.updateScreenCurrencyInPreferences(direction);
        Class offerView = this.isSellOffer(direction) ? BuyOfferView.class : SellOfferView.class;
        this.navigation.navigateTo(MainView.class, offerView, OfferViewUtil.getOfferBookViewClass(this.getCurrencyCode()));
    }

    public List<XYChart.Data<Number, Number>> getBuyData() {
        return this.buyData;
    }

    public List<XYChart.Data<Number, Number>> getSellData() {
        return this.sellData;
    }

    public String getCurrencyCode() {
        return ((TradeCurrency)this.selectedTradeCurrencyProperty.get()).getCode();
    }

    public ObservableList<OfferBookListItem> getOfferBookListItems() {
        return this.offerBookListItems;
    }

    public ObservableList<OfferListItem> getTopBuyOfferList() {
        return this.topBuyOfferList;
    }

    public ObservableList<OfferListItem> getTopSellOfferList() {
        return this.topSellOfferList;
    }

    public ObservableList<CurrencyListItem> getCurrencyListItems() {
        return this.currencyListItems.getObservableList();
    }

    public Optional<CurrencyListItem> getSelectedCurrencyListItem() {
        return this.currencyListItems.getObservableList().stream().filter(e -> e.tradeCurrency.equals(this.selectedTradeCurrencyProperty.get())).findAny();
    }

    public int getMaxNumberOfPriceZeroDecimalsToColorize(Offer offer) {
        return CurrencyUtil.isVolumeRoundedToNearestUnit((String)offer.getCounterCurrencyCode()) ? 0 : 7;
    }

    public int getZeroDecimalsForPrice(Offer offer) {
        return CurrencyUtil.isPricePrecise((String)offer.getCounterCurrencyCode()) ? 7 : 3;
    }

    public String getPrice(Offer offer) {
        return this.formatPrice(offer, true);
    }

    private String formatPrice(Offer offer, boolean decimalAligned) {
        return DisplayUtils.formatPrice(offer.getPrice(), decimalAligned, offer.isBuyOffer() ? this.maxPlacesForBuyPrice.get() : this.maxPlacesForSellPrice.get());
    }

    public String getVolume(Offer offer) {
        return this.formatVolume(offer, true);
    }

    private String formatVolume(Offer offer, boolean decimalAligned) {
        return VolumeUtil.formatVolume((Offer)offer, (Boolean)decimalAligned, (int)(offer.isBuyOffer() ? this.maxPlacesForBuyVolume.get() : this.maxPlacesForSellVolume.get()), (boolean)false);
    }

    private void syncPriceFeedCurrency() {
        if (this.selectedTabIndex == 0) {
            this.priceFeedService.setCurrencyCode(this.getCurrencyCode());
        }
    }

    private boolean isAnyPriceAbsent() {
        return this.offerBookListItems.stream().anyMatch(item -> item.getOffer().getPrice() == null);
    }

    private void updateChartData() {
        Optional<Offer> highestSellVolumeOffer;
        Comparator<Offer> offerPriceComparator = Comparator.comparing(Offer::getPrice, Comparator.nullsLast(Comparator.naturalOrder()));
        Comparator<Offer> offerAmountComparator = Comparator.comparing(Offer::getAmount).reversed();
        Comparator<Offer> buyOfferSortComparator = offerPriceComparator.reversed().thenComparing(offerAmountComparator);
        Comparator<Offer> sellOfferSortComparator = offerPriceComparator.thenComparing(offerAmountComparator);
        OfferDirection buyOfferDirection = OfferDirection.BUY;
        List<Offer> allBuyOffers = this.offerBookListItems.stream().map(OfferBookListItem::getOffer).filter(e -> e.getCounterCurrencyCode().equals(((TradeCurrency)this.selectedTradeCurrencyProperty.get()).getCode()) && e.getDirection().equals((Object)buyOfferDirection)).sorted(buyOfferSortComparator).collect(Collectors.toList());
        Optional<Offer> highestBuyPriceOffer = allBuyOffers.stream().filter(o -> o.getPrice() != null).max(Comparator.comparingLong(o -> o.getPrice().getValue()));
        if (highestBuyPriceOffer.isPresent()) {
            Offer offer = highestBuyPriceOffer.get();
            this.maxPlacesForBuyPrice.set(this.formatPrice(offer, false).length());
        } else {
            this.log.debug("highestBuyPriceOffer not present");
        }
        Optional<Offer> highestBuyVolumeOffer = allBuyOffers.stream().filter(o -> o.getVolume() != null).max(Comparator.comparingLong(o -> o.getVolume().getValue()));
        if (highestBuyVolumeOffer.isPresent()) {
            Offer offer = highestBuyVolumeOffer.get();
            this.maxPlacesForBuyVolume.set(this.formatVolume(offer, false).length());
        }
        this.buildChartAndTableEntries(allBuyOffers, OfferDirection.BUY, this.buyData, this.topBuyOfferList);
        OfferDirection sellOfferDirection = OfferDirection.SELL;
        List<Offer> allSellOffers = this.offerBookListItems.stream().map(OfferBookListItem::getOffer).filter(e -> e.getCounterCurrencyCode().equals(((TradeCurrency)this.selectedTradeCurrencyProperty.get()).getCode()) && e.getDirection().equals((Object)sellOfferDirection)).sorted(sellOfferSortComparator).collect(Collectors.toList());
        Optional<Offer> highestSellPriceOffer = allSellOffers.stream().filter(o -> o.getPrice() != null).max(Comparator.comparingLong(o -> o.getPrice().getValue()));
        if (highestSellPriceOffer.isPresent()) {
            Offer offer = highestSellPriceOffer.get();
            this.maxPlacesForSellPrice.set(this.formatPrice(offer, false).length());
        }
        if ((highestSellVolumeOffer = allSellOffers.stream().filter(o -> o.getVolume() != null).max(Comparator.comparingLong(o -> o.getVolume().getValue()))).isPresent()) {
            Offer offer = highestSellVolumeOffer.get();
            this.maxPlacesForSellVolume.set(this.formatVolume(offer, false).length());
        }
        this.buildChartAndTableEntries(allSellOffers, OfferDirection.SELL, this.sellData, this.topSellOfferList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildChartAndTableEntries(List<Offer> sortedList, OfferDirection direction, List<XYChart.Data<Number, Number>> data, ObservableList<OfferListItem> offerTableList) {
        List<XYChart.Data<Number, Number>> list = data;
        synchronized (list) {
            data.clear();
            double accumulatedAmount = 0.0;
            ArrayList<OfferListItem> offerTableListTemp = new ArrayList<OfferListItem>();
            for (Offer offer : sortedList) {
                Price price = offer.getPrice();
                if (price == null) continue;
                double amount = (double)offer.getAmount().longValueExact() / (double)LongMath.pow((long)10L, (int)HavenoUtils.XMR_SMALLEST_UNIT_EXPONENT);
                offerTableListTemp.add(new OfferListItem(offer, accumulatedAmount += amount));
                double priceAsDouble = (double)price.getValue() / (double)LongMath.pow((long)10L, (int)price.smallestUnitExponent());
                if (direction.equals((Object)OfferDirection.BUY)) {
                    data.add(0, (XYChart.Data<Number, Number>)new XYChart.Data((Object)priceAsDouble, (Object)accumulatedAmount));
                    continue;
                }
                data.add((XYChart.Data<Number, Number>)new XYChart.Data((Object)priceAsDouble, (Object)accumulatedAmount));
            }
            offerTableList.setAll(offerTableListTemp);
        }
    }

    private boolean isEditEntry(String id) {
        return id.equals("list.currency.editList");
    }

    private void updateScreenCurrencyInPreferences(OfferDirection direction) {
        if (this.isSellOffer(direction)) {
            if (CurrencyUtil.isFiatCurrency((String)this.getCurrencyCode())) {
                this.preferences.setBuyScreenCurrencyCode(this.getCurrencyCode());
            } else if (CurrencyUtil.isCryptoCurrency((String)this.getCurrencyCode())) {
                this.preferences.setBuyScreenCryptoCurrencyCode(this.getCurrencyCode());
            } else if (CurrencyUtil.isTraditionalCurrency((String)this.getCurrencyCode())) {
                this.preferences.setBuyScreenOtherCurrencyCode(this.getCurrencyCode());
            }
        } else if (CurrencyUtil.isFiatCurrency((String)this.getCurrencyCode())) {
            this.preferences.setSellScreenCurrencyCode(this.getCurrencyCode());
        } else if (CurrencyUtil.isCryptoCurrency((String)this.getCurrencyCode())) {
            this.preferences.setSellScreenCryptoCurrencyCode(this.getCurrencyCode());
        } else if (CurrencyUtil.isTraditionalCurrency((String)this.getCurrencyCode())) {
            this.preferences.setSellScreenOtherCurrencyCode(this.getCurrencyCode());
        }
    }
}

