/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.market.offerbook;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.jfoenix.controls.JFXTabPane;
import haveno.common.UserThread;
import haveno.common.util.Tuple3;
import haveno.common.util.Tuple4;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.monetary.Volume;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.util.FormattingUtils;
import haveno.core.util.VolumeUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.common.view.ActivatableViewAndModel;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.AutoTooltipTableColumn;
import haveno.desktop.components.AutocompleteComboBox;
import haveno.desktop.components.ColoredDecimalPlacesWithZerosText;
import haveno.desktop.components.PeerInfoIconSmall;
import haveno.desktop.main.market.offerbook.OfferBookChartViewModel;
import haveno.desktop.main.market.offerbook.OfferListItem;
import haveno.desktop.main.offer.offerbook.OfferBookListItem;
import haveno.desktop.util.CurrencyListItem;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.NodeAddress;
import java.text.DecimalFormat;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.chart.AreaChart;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;

@FxmlView
public class OfferBookChartView
extends ActivatableViewAndModel<VBox, OfferBookChartViewModel> {
    private final boolean useDevPrivilegeKeys;
    private NumberAxis xAxis;
    private XYChart.Series<Number, Number> seriesBuy;
    private XYChart.Series<Number, Number> seriesSell;
    private final CoinFormatter formatter;
    private TableView<OfferListItem> buyOfferTableView;
    private TableView<OfferListItem> sellOfferTableView;
    private AreaChart<Number, Number> areaChart;
    private AnchorPane chartPane;
    private AutocompleteComboBox<CurrencyListItem> currencyComboBox;
    private Subscription tradeCurrencySubscriber;
    private final StringProperty volumeSellColumnLabel = new SimpleStringProperty();
    private final StringProperty volumeBuyColumnLabel = new SimpleStringProperty();
    private final StringProperty amountSellColumnLabel = new SimpleStringProperty();
    private final StringProperty amountBuyColumnLabel = new SimpleStringProperty();
    private final StringProperty priceColumnLabel = new SimpleStringProperty();
    private AutoTooltipButton sellButton;
    private AutoTooltipButton buyButton;
    private ChangeListener<Number> selectedTabIndexListener;
    private SingleSelectionModel<Tab> tabPaneSelectionModel;
    private Label sellHeaderLabel;
    private Label buyHeaderLabel;
    private ChangeListener<OfferListItem> sellTableRowSelectionListener;
    private ChangeListener<OfferListItem> buyTableRowSelectionListener;
    private ListChangeListener<OfferBookListItem> changeListener;
    private ListChangeListener<CurrencyListItem> currencyListItemsListener;
    private final double dataLimitFactor = 3.0;
    private final double initialOfferTableViewHeight = 78.0;
    private final double offerTableExtraMarginBottom = 0.0;
    private final Function<Double, Double> offerTableViewHeight = screenSize -> {
        double pixelsPerOfferTableRow = 15.6;
        int extraRows = screenSize <= 710.0 ? 0 : (int)((screenSize - 710.0) / pixelsPerOfferTableRow);
        return extraRows == 0 ? 78.0 : Math.ceil(78.0 + (double)(extraRows + 1) * pixelsPerOfferTableRow);
    };
    private ChangeListener<Number> havenoWindowVerticalSizeListener;

    @Inject
    public OfferBookChartView(OfferBookChartViewModel model, @Named(value="BTC") CoinFormatter formatter, @Named(value="useDevPrivilegeKeys") boolean useDevPrivilegeKeys) {
        super(model);
        this.formatter = formatter;
        this.useDevPrivilegeKeys = useDevPrivilegeKeys;
    }

    @Override
    public void initialize() {
        this.createListener();
        Tuple3 currencyComboBoxTuple = FormBuilder.addTopLabelAutocompleteComboBox(Res.get((String)"shared.currency"), 0);
        this.currencyComboBox = (AutocompleteComboBox)((Object)currencyComboBoxTuple.third);
        this.currencyComboBox.setCellFactory(GUIUtil.getCurrencyListItemCellFactory(Res.get((String)"shared.oneOffer"), Res.get((String)"shared.multipleOffers"), ((OfferBookChartViewModel)this.model).preferences));
        this.currencyComboBox.getStyleClass().add((Object)"input-with-border");
        this.createChart();
        VBox.setMargin((Node)this.chartPane, (Insets)new Insets(0.0, 0.0, 5.0, 0.0));
        Tuple4<TableView<OfferListItem>, VBox, Button, Label> tupleBuy = this.getOfferTable(OfferDirection.BUY);
        Tuple4<TableView<OfferListItem>, VBox, Button, Label> tupleSell = this.getOfferTable(OfferDirection.SELL);
        this.buyOfferTableView = (TableView)tupleBuy.first;
        this.sellOfferTableView = (TableView)tupleSell.first;
        this.sellButton = (AutoTooltipButton)((Object)tupleBuy.third);
        this.buyButton = (AutoTooltipButton)((Object)tupleSell.third);
        this.sellHeaderLabel = (Label)tupleBuy.fourth;
        this.buyHeaderLabel = (Label)tupleSell.fourth;
        HBox bottomHBox = new HBox();
        bottomHBox.setSpacing(20.0);
        bottomHBox.setAlignment(Pos.CENTER);
        VBox.setMargin((Node)bottomHBox, (Insets)new Insets(-5.0, 0.0, 0.0, 0.0));
        HBox.setHgrow((Node)((Node)tupleBuy.second), (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)((Node)tupleSell.second), (Priority)Priority.ALWAYS);
        ((VBox)tupleBuy.second).setUserData((Object)OfferDirection.BUY.name());
        ((VBox)tupleSell.second).setUserData((Object)OfferDirection.SELL.name());
        bottomHBox.getChildren().addAll((Object[])new Node[]{(Node)tupleSell.second, (Node)tupleBuy.second});
        ((VBox)this.root).getChildren().addAll((Object[])new Node[]{(Node)currencyComboBoxTuple.first, this.chartPane, bottomHBox});
    }

    @Override
    protected void activate() {
        this.tabPaneSelectionModel = GUIUtil.getParentOfType(this.root, JFXTabPane.class).getSelectionModel();
        this.selectedTabIndexListener = (observable, oldValue, newValue) -> ((OfferBookChartViewModel)this.model).setSelectedTabIndex((Integer)newValue);
        ((OfferBookChartViewModel)this.model).setSelectedTabIndex(this.tabPaneSelectionModel.getSelectedIndex());
        this.tabPaneSelectionModel.selectedIndexProperty().addListener(this.selectedTabIndexListener);
        this.currencyComboBox.setConverter(new CurrencyListItemStringConverter((ComboBox<CurrencyListItem>)this.currencyComboBox));
        this.currencyComboBox.getEditor().getStyleClass().add((Object)"combo-box-editor-bold");
        this.currencyComboBox.setAutocompleteItems((List<CurrencyListItem>)((OfferBookChartViewModel)this.model).getCurrencyListItems());
        this.currencyComboBox.setVisibleRowCount(10);
        if (((OfferBookChartViewModel)this.model).getSelectedCurrencyListItem().isPresent()) {
            CurrencyListItem selectedItem = ((OfferBookChartViewModel)this.model).getSelectedCurrencyListItem().get();
            this.currencyComboBox.getSelectionModel().select((Object)((OfferBookChartViewModel)this.model).getSelectedCurrencyListItem().get());
            this.currencyComboBox.getEditor().setText(new CurrencyListItemStringConverter((ComboBox<CurrencyListItem>)this.currencyComboBox).toString(selectedItem));
        }
        this.currencyComboBox.setOnChangeConfirmed((EventHandler<Event>)((EventHandler)e -> {
            CurrencyListItem selectedItem = (CurrencyListItem)this.currencyComboBox.getSelectionModel().getSelectedItem();
            if (selectedItem != null) {
                ((OfferBookChartViewModel)this.model).onSetTradeCurrency(selectedItem.tradeCurrency);
                UserThread.execute(() -> this.updateChartData());
            }
        }));
        ((OfferBookChartViewModel)this.model).currencyListItems.getObservableList().addListener(this.currencyListItemsListener);
        ((OfferBookChartViewModel)this.model).getOfferBookListItems().addListener(this.changeListener);
        this.tradeCurrencySubscriber = EasyBind.subscribe(((OfferBookChartViewModel)this.model).selectedTradeCurrencyProperty, tradeCurrency -> {
            final String code = tradeCurrency.getCode();
            this.xAxis.setTickLabelFormatter((StringConverter)new StringConverter<Number>(){
                final int cryptoPrecision = 3;
                final DecimalFormat df = new DecimalFormat(",###");

                public String toString(Number object) {
                    try {
                        double doubleValue = (Double)object;
                        if (CurrencyUtil.isCryptoCurrency((String)((OfferBookChartViewModel)OfferBookChartView.this.model).getCurrencyCode())) {
                            String withCryptoPrecision = FormattingUtils.formatRoundedDoubleWithPrecision((double)doubleValue, (int)3);
                            if (withCryptoPrecision.startsWith("0.0")) {
                                return FormattingUtils.formatRoundedDoubleWithPrecision((double)doubleValue, (int)8).replaceFirst("0+$", "");
                            }
                            return withCryptoPrecision.replaceFirst("0+$", "");
                        }
                        return this.df.format(Double.parseDouble(FormattingUtils.formatRoundedDoubleWithPrecision((double)doubleValue, (int)0)));
                    }
                    catch (IllegalArgumentException e) {
                        OfferBookChartView.this.log.error("Error converting number to string, tradeCurrency={}, number={}\n", new Object[]{code, object, e});
                        return "NaN";
                    }
                }

                public Number fromString(String string) {
                    return null;
                }
            });
            String viewBaseCurrencyCode = Res.getBaseCurrencyCode();
            String viewPriceCurrencyCode = code;
            this.sellHeaderLabel.setText(Res.get((String)"market.offerBook.sellOffersHeaderLabel", (Object[])new Object[]{viewBaseCurrencyCode}));
            this.sellButton.updateText(Res.get((String)"shared.sellCurrency", (Object[])new Object[]{viewBaseCurrencyCode}));
            this.sellButton.setGraphic((Node)GUIUtil.getCurrencyIconWithBorder(viewBaseCurrencyCode));
            this.sellButton.setOnAction(e -> ((OfferBookChartViewModel)this.model).goToOfferView(OfferDirection.BUY));
            this.sellButton.setId("sell-button-big");
            this.buyHeaderLabel.setText(Res.get((String)"market.offerBook.buyOffersHeaderLabel", (Object[])new Object[]{viewBaseCurrencyCode}));
            this.buyButton.updateText(Res.get((String)"shared.buyCurrency", (Object[])new Object[]{viewBaseCurrencyCode}));
            this.buyButton.setGraphic((Node)GUIUtil.getCurrencyIconWithBorder(viewBaseCurrencyCode));
            this.buyButton.setOnAction(e -> ((OfferBookChartViewModel)this.model).goToOfferView(OfferDirection.SELL));
            this.buyButton.setId("buy-button-big");
            this.priceColumnLabel.set((Object)Res.get((String)"shared.priceWithCur", (Object[])new Object[]{viewPriceCurrencyCode}));
            this.xAxis.setLabel(CurrencyUtil.getPriceWithCurrencyCode((String)code));
            this.seriesBuy.setName(this.sellHeaderLabel.getText() + "   ");
            this.seriesSell.setName(this.buyHeaderLabel.getText());
        });
        this.buyOfferTableView.setItems(((OfferBookChartViewModel)this.model).getTopBuyOfferList());
        this.sellOfferTableView.setItems(((OfferBookChartViewModel)this.model).getTopSellOfferList());
        this.buyOfferTableView.getSelectionModel().selectedItemProperty().addListener(this.buyTableRowSelectionListener);
        this.sellOfferTableView.getSelectionModel().selectedItemProperty().addListener(this.sellTableRowSelectionListener);
        ((VBox)this.root).getScene().heightProperty().addListener(this.havenoWindowVerticalSizeListener);
        this.layout();
        this.updateChartData();
    }

    private void createListener() {
        this.changeListener = c -> UserThread.execute(() -> this.updateChartData());
        this.currencyListItemsListener = c -> {
            if (((OfferBookChartViewModel)this.model).getSelectedCurrencyListItem().isPresent()) {
                this.currencyComboBox.getSelectionModel().select((Object)((OfferBookChartViewModel)this.model).getSelectedCurrencyListItem().get());
            }
        };
        this.sellTableRowSelectionListener = (observable, oldValue, newValue) -> ((OfferBookChartViewModel)this.model).goToOfferView(OfferDirection.SELL);
        this.buyTableRowSelectionListener = (observable, oldValue, newValue) -> ((OfferBookChartViewModel)this.model).goToOfferView(OfferDirection.BUY);
        this.havenoWindowVerticalSizeListener = (observable, oldValue, newValue) -> this.layout();
    }

    @Override
    protected void deactivate() {
        ((OfferBookChartViewModel)this.model).getOfferBookListItems().removeListener(this.changeListener);
        this.tabPaneSelectionModel.selectedIndexProperty().removeListener(this.selectedTabIndexListener);
        ((OfferBookChartViewModel)this.model).currencyListItems.getObservableList().removeListener(this.currencyListItemsListener);
        this.tradeCurrencySubscriber.unsubscribe();
        this.buyOfferTableView.getSelectionModel().selectedItemProperty().removeListener(this.buyTableRowSelectionListener);
        this.sellOfferTableView.getSelectionModel().selectedItemProperty().removeListener(this.sellTableRowSelectionListener);
    }

    private void createChart() {
        this.xAxis = new NumberAxis();
        this.xAxis.setForceZeroInRange(false);
        this.xAxis.setAutoRanging(true);
        this.xAxis.setTickMarkVisible(true);
        this.xAxis.setMinorTickVisible(false);
        NumberAxis yAxis = new NumberAxis();
        yAxis.setForceZeroInRange(false);
        yAxis.setSide(Side.RIGHT);
        yAxis.setAutoRanging(true);
        yAxis.setTickMarkVisible(true);
        yAxis.setMinorTickVisible(false);
        yAxis.getStyleClass().add((Object)"axisy");
        yAxis.setLabel(CurrencyUtil.getOfferVolumeCode((String)Res.getBaseCurrencyCode()));
        this.seriesBuy = new XYChart.Series();
        this.seriesSell = new XYChart.Series();
        this.areaChart = new AreaChart((Axis)this.xAxis, (Axis)yAxis);
        this.areaChart.setLegendVisible(false);
        this.areaChart.setAnimated(false);
        this.areaChart.setId("charts");
        this.areaChart.setMinHeight(270.0);
        this.areaChart.setPrefHeight(270.0);
        this.areaChart.setCreateSymbols(true);
        this.areaChart.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
        this.areaChart.getData().addAll(List.of(this.seriesBuy, this.seriesSell));
        this.chartPane = new AnchorPane();
        this.chartPane.getStyleClass().add((Object)"chart-pane");
        AnchorPane.setTopAnchor(this.areaChart, (Double)15.0);
        AnchorPane.setBottomAnchor(this.areaChart, (Double)10.0);
        AnchorPane.setLeftAnchor(this.areaChart, (Double)10.0);
        AnchorPane.setRightAnchor(this.areaChart, (Double)0.0);
        this.chartPane.getChildren().add(this.areaChart);
    }

    private synchronized void updateChartData() {
        String formattedVolumeBuy;
        Volume volumeSell = ((OfferBookChartViewModel)this.model).getTotalVolume(OfferDirection.SELL);
        Volume volumeBuy = ((OfferBookChartViewModel)this.model).getTotalVolume(OfferDirection.BUY);
        String formattedVolumeSell = volumeSell == null ? null : VolumeUtil.formatVolume((Volume)volumeSell);
        String string = formattedVolumeBuy = volumeBuy == null ? null : VolumeUtil.formatVolume((Volume)volumeBuy);
        if (((OfferBookChartViewModel)this.model).getSellData().isEmpty()) {
            formattedVolumeSell = "0.0";
        }
        if (((OfferBookChartViewModel)this.model).getBuyData().isEmpty()) {
            formattedVolumeBuy = "0.0";
        }
        this.volumeSellColumnLabel.set((Object)Res.get((String)"offerbook.volumeTotal", (Object[])new Object[]{((OfferBookChartViewModel)this.model).getCurrencyCode(), formattedVolumeSell == null ? "" : "(" + formattedVolumeSell + ")"}));
        this.volumeBuyColumnLabel.set((Object)Res.get((String)"offerbook.volumeTotal", (Object[])new Object[]{((OfferBookChartViewModel)this.model).getCurrencyCode(), formattedVolumeBuy == null ? "" : "(" + formattedVolumeBuy + ")"}));
        this.amountSellColumnLabel.set((Object)Res.get((String)"offerbook.XMRTotal", (Object[])new Object[]{"" + ((OfferBookChartViewModel)this.model).getTotalAmount(OfferDirection.SELL)}));
        this.amountBuyColumnLabel.set((Object)Res.get((String)"offerbook.XMRTotal", (Object[])new Object[]{"" + ((OfferBookChartViewModel)this.model).getTotalAmount(OfferDirection.BUY)}));
        this.seriesSell.getData().clear();
        this.seriesBuy.getData().clear();
        this.areaChart.getData().clear();
        this.seriesSell.getData().addAll(this.filterOutliersSell(((OfferBookChartViewModel)this.model).getSellData()));
        this.seriesBuy.getData().addAll(this.filterOutliersBuy(((OfferBookChartViewModel)this.model).getBuyData()));
        this.areaChart.getData().addAll(List.of(this.seriesBuy, this.seriesSell));
    }

    List<XYChart.Data<Number, Number>> filterOutliersBuy(List<XYChart.Data<Number, Number>> buy) {
        List<Double> mnmx = this.minMaxFilterLeft(buy);
        if (mnmx.get(0) == Double.MAX_VALUE || mnmx.get(1) == Double.MIN_VALUE) {
            return buy;
        }
        return this.filterLeft(buy, mnmx.get(1));
    }

    List<XYChart.Data<Number, Number>> filterOutliersSell(List<XYChart.Data<Number, Number>> sell) {
        List<Double> mnmx = this.minMaxFilterRight(sell);
        if (mnmx.get(0) == Double.MAX_VALUE || mnmx.get(1) == Double.MIN_VALUE) {
            return sell;
        }
        return this.filterRight(sell, mnmx.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Double> minMaxFilterLeft(List<XYChart.Data<Number, Number>> data) {
        List<XYChart.Data<Number, Number>> list = data;
        synchronized (list) {
            double maxValue = data.stream().mapToDouble(o -> ((Number)o.getXValue()).doubleValue()).max().orElse(Double.MIN_VALUE);
            double minValue = data.stream().mapToDouble(o -> ((Number)o.getXValue()).doubleValue()).filter(o -> o > maxValue / 3.0).min().orElse(Double.MAX_VALUE);
            return List.of(Double.valueOf(minValue), Double.valueOf(maxValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Double> minMaxFilterRight(List<XYChart.Data<Number, Number>> data) {
        List<XYChart.Data<Number, Number>> list = data;
        synchronized (list) {
            double minValue = data.stream().mapToDouble(o -> ((Number)o.getXValue()).doubleValue()).min().orElse(Double.MAX_VALUE);
            double maxValue = data.stream().mapToDouble(o -> ((Number)o.getXValue()).doubleValue()).filter(o -> o < minValue * 3.0).max().orElse(Double.MIN_VALUE);
            return List.of(Double.valueOf(minValue), Double.valueOf(maxValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<XYChart.Data<Number, Number>> filterLeft(List<XYChart.Data<Number, Number>> data, double maxValue) {
        List<XYChart.Data<Number, Number>> list = data;
        synchronized (list) {
            return data.stream().filter(o -> ((Number)o.getXValue()).doubleValue() > maxValue / 3.0).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<XYChart.Data<Number, Number>> filterRight(List<XYChart.Data<Number, Number>> data, double minValue) {
        List<XYChart.Data<Number, Number>> list = data;
        synchronized (list) {
            return data.stream().filter(o -> ((Number)o.getXValue()).doubleValue() < minValue * 3.0).collect(Collectors.toList());
        }
    }

    private Tuple4<TableView<OfferListItem>, VBox, Button, Label> getOfferTable(OfferDirection direction) {
        TableView tableView = new TableView();
        GUIUtil.applyTableStyle(tableView, false);
        tableView.setMinHeight(78.0);
        tableView.setPrefHeight(78.0);
        tableView.setMinWidth(480.0);
        tableView.getStyleClass().addAll((Object[])new String[]{"offer-table", "non-interactive-table"});
        TableColumn priceColumn = new TableColumn();
        priceColumn.textProperty().bind((ObservableValue)this.priceColumnLabel);
        priceColumn.setMinWidth(115.0);
        priceColumn.setMaxWidth(115.0);
        priceColumn.setSortable(false);
        priceColumn.getStyleClass().add((Object)"number-column");
        priceColumn.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OfferListItem)offer.getValue())));
        priceColumn.setCellFactory((Callback)new Callback<TableColumn<OfferListItem, OfferListItem>, TableCell<OfferListItem, OfferListItem>>(){

            public TableCell<OfferListItem, OfferListItem> call(TableColumn<OfferListItem, OfferListItem> column) {
                return new TableCell<OfferListItem, OfferListItem>(){
                    private Offer offer;
                    final ChangeListener<Number> listener = new ChangeListener<Number>(){

                        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                            if (offer != null && offer.getPrice() != null) {
                                this.setText("");
                                this.setGraphic((Node)new ColoredDecimalPlacesWithZerosText(((OfferBookChartViewModel)OfferBookChartView.this.model).getPrice(offer), ((OfferBookChartViewModel)OfferBookChartView.this.model).getZeroDecimalsForPrice(offer)));
                                ((OfferBookChartViewModel)((OfferBookChartView)OfferBookChartView.this).model).priceFeedService.updateCounterProperty().removeListener(listener);
                            }
                        }
                    };

                    public void updateItem(OfferListItem offerListItem, boolean empty) {
                        super.updateItem((Object)offerListItem, empty);
                        if (offerListItem != null && !empty) {
                            Offer offer = offerListItem.offer;
                            if (offer.getPrice() == null) {
                                this.offer = offer;
                                ((OfferBookChartViewModel)((OfferBookChartView)OfferBookChartView.this).model).priceFeedService.updateCounterProperty().addListener(this.listener);
                                this.setText(Res.get((String)"shared.na"));
                            } else {
                                this.setGraphic((Node)new ColoredDecimalPlacesWithZerosText(((OfferBookChartViewModel)OfferBookChartView.this.model).getPrice(offer), ((OfferBookChartViewModel)OfferBookChartView.this.model).getZeroDecimalsForPrice(offer)));
                            }
                        } else {
                            ((OfferBookChartViewModel)((OfferBookChartView)OfferBookChartView.this).model).priceFeedService.updateCounterProperty().removeListener(this.listener);
                            this.offer = null;
                            this.setText("");
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        boolean isSellTable = ((OfferBookChartViewModel)this.model).isSellOffer(direction);
        TableColumn volumeColumn = new TableColumn();
        volumeColumn.setMinWidth(115.0);
        volumeColumn.setSortable(false);
        volumeColumn.textProperty().bind((ObservableValue)(isSellTable ? this.volumeSellColumnLabel : this.volumeBuyColumnLabel));
        volumeColumn.getStyleClass().addAll((Object[])new String[]{"number-column"});
        volumeColumn.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OfferListItem)offer.getValue())));
        volumeColumn.setCellFactory((Callback)new Callback<TableColumn<OfferListItem, OfferListItem>, TableCell<OfferListItem, OfferListItem>>(){

            public TableCell<OfferListItem, OfferListItem> call(TableColumn<OfferListItem, OfferListItem> column) {
                return new TableCell<OfferListItem, OfferListItem>(){
                    private Offer offer;
                    final ChangeListener<Number> listener = new ChangeListener<Number>(){

                        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                            if (offer != null && offer.getPrice() != null) {
                                this.renderCellContentRange();
                                ((OfferBookChartViewModel)((OfferBookChartView)OfferBookChartView.this).model).priceFeedService.updateCounterProperty().removeListener(listener);
                            }
                        }
                    };

                    public void updateItem(OfferListItem offerListItem, boolean empty) {
                        super.updateItem((Object)offerListItem, empty);
                        if (offerListItem != null && !empty) {
                            this.offer = offerListItem.offer;
                            if (this.offer.getPrice() == null) {
                                this.offer = offerListItem.offer;
                                ((OfferBookChartViewModel)((OfferBookChartView)OfferBookChartView.this).model).priceFeedService.updateCounterProperty().addListener(this.listener);
                                this.setText(Res.get((String)"shared.na"));
                            } else {
                                this.renderCellContentRange();
                            }
                        } else {
                            ((OfferBookChartViewModel)((OfferBookChartView)OfferBookChartView.this).model).priceFeedService.updateCounterProperty().removeListener(this.listener);
                            this.offer = null;
                            this.setText("");
                            this.setGraphic(null);
                        }
                    }

                    private void renderCellContentRange() {
                        String volumeRange = VolumeUtil.formatVolume((Offer)this.offer, (Boolean)true, (int)2);
                        this.setText("");
                        this.setGraphic((Node)new ColoredDecimalPlacesWithZerosText(volumeRange, ((OfferBookChartViewModel)OfferBookChartView.this.model).getMaxNumberOfPriceZeroDecimalsToColorize(this.offer)));
                    }
                };
            }
        });
        TableColumn amountColumn = new TableColumn();
        amountColumn.textProperty().bind((ObservableValue)(isSellTable ? this.amountSellColumnLabel : this.amountBuyColumnLabel));
        amountColumn.setMinWidth(115.0);
        amountColumn.setSortable(false);
        amountColumn.getStyleClass().add((Object)"number-column");
        amountColumn.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OfferListItem)offer.getValue())));
        amountColumn.setCellFactory((Callback)new Callback<TableColumn<OfferListItem, OfferListItem>, TableCell<OfferListItem, OfferListItem>>(){

            public TableCell<OfferListItem, OfferListItem> call(TableColumn<OfferListItem, OfferListItem> column) {
                return new TableCell<OfferListItem, OfferListItem>(){

                    public void updateItem(OfferListItem offerListItem, boolean empty) {
                        super.updateItem((Object)offerListItem, empty);
                        if (offerListItem != null && !empty) {
                            String amountRange = DisplayUtils.formatAmount(offerListItem.offer, OfferBookChartView.this.formatter);
                            this.setGraphic((Node)new ColoredDecimalPlacesWithZerosText(amountRange, 3));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        AutoTooltipTableColumn<OfferListItem, OfferListItem> avatarColumn = new AutoTooltipTableColumn<OfferListItem, OfferListItem>(this, isSellTable ? Res.get((String)"shared.sellerUpperCase") : Res.get((String)"shared.buyerUpperCase")){
            {
                this.setMinWidth(80.0);
                this.setMaxWidth(80.0);
                this.setSortable(true);
            }
        };
        avatarColumn.getStyleClass().addAll((Object[])new String[]{"avatar-column"});
        avatarColumn.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OfferListItem)offer.getValue())));
        avatarColumn.setCellFactory((Callback)new Callback<TableColumn<OfferListItem, OfferListItem>, TableCell<OfferListItem, OfferListItem>>(){

            public TableCell<OfferListItem, OfferListItem> call(TableColumn<OfferListItem, OfferListItem> column) {
                return new TableCell<OfferListItem, OfferListItem>(){

                    public void updateItem(OfferListItem newItem, boolean empty) {
                        super.updateItem((Object)newItem, empty);
                        if (newItem != null && !empty) {
                            Offer offer = newItem.offer;
                            boolean myOffer = ((OfferBookChartViewModel)OfferBookChartView.this.model).isMyOffer(offer);
                            if (!myOffer) {
                                NodeAddress makersNodeAddress = offer.getOwnerNodeAddress();
                                String role = Res.get((String)"peerInfoIcon.tooltip.maker");
                                PeerInfoIconSmall peerInfoIcon = new PeerInfoIconSmall(makersNodeAddress, role, offer, ((OfferBookChartViewModel)((OfferBookChartView)OfferBookChartView.this).model).preferences, ((OfferBookChartViewModel)((OfferBookChartView)OfferBookChartView.this).model).accountAgeWitnessService, OfferBookChartView.this.useDevPrivilegeKeys);
                                this.setGraphic((Node)peerInfoIcon);
                            } else {
                                this.setGraphic((Node)new Label(Res.get((String)"shared.me")));
                            }
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        tableView.getColumns().add((Object)volumeColumn);
        tableView.getColumns().add((Object)amountColumn);
        tableView.getColumns().add((Object)priceColumn);
        tableView.getColumns().add((Object)avatarColumn);
        tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        AutoTooltipLabel placeholder = new AutoTooltipLabel(Res.get((String)"table.placeholder.noItems", (Object[])new Object[]{Res.get((String)"shared.multipleOffers")}));
        placeholder.setWrapText(true);
        tableView.setPlaceholder((Node)placeholder);
        HBox titleButtonBox = new HBox();
        titleButtonBox.getStyleClass().add((Object)"offer-table-top");
        titleButtonBox.setAlignment(Pos.CENTER);
        AutoTooltipLabel titleLabel = new AutoTooltipLabel();
        titleLabel.getStyleClass().add((Object)"table-title");
        AutoTooltipButton button = new AutoTooltipButton();
        button.setContentDisplay(ContentDisplay.RIGHT);
        button.setGraphicTextGap(10.0);
        button.setMinHeight(32.0);
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        titleButtonBox.getChildren().addAll((Object[])new Node[]{titleLabel, spacer, button});
        VBox vBox = new VBox();
        VBox.setVgrow((Node)tableView, (Priority)Priority.ALWAYS);
        vBox.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        vBox.setSpacing(0.0);
        vBox.setFillWidth(true);
        vBox.getChildren().addAll((Object[])new Node[]{titleButtonBox, tableView});
        return new Tuple4((Object)tableView, (Object)vBox, (Object)button, (Object)titleLabel);
    }

    private void layout() {
        UserThread.runAfter(() -> {
            if (((VBox)this.root).getScene() != null) {
                double newTableViewHeight = this.offerTableViewHeight.apply(((VBox)this.root).getScene().getHeight());
                if (this.buyOfferTableView.getHeight() != newTableViewHeight) {
                    this.buyOfferTableView.setMinHeight(newTableViewHeight);
                    this.sellOfferTableView.setMinHeight(newTableViewHeight);
                }
            }
        }, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    static class CurrencyListItemStringConverter
    extends StringConverter<CurrencyListItem> {
        private final ComboBox<CurrencyListItem> comboBox;

        CurrencyListItemStringConverter(ComboBox<CurrencyListItem> comboBox) {
            this.comboBox = comboBox;
        }

        public String toString(CurrencyListItem currencyItem) {
            return currencyItem != null ? currencyItem.codeDashNameString() : "";
        }

        public CurrencyListItem fromString(String s) {
            return this.comboBox.getItems().stream().filter(currencyItem -> currencyItem.codeDashNameString().equals(s)).findAny().orElse(null);
        }
    }
}

