/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.market;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.util.Utilities;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.statistics.TradeStatistics3;
import haveno.core.trade.statistics.TradeStatistics3StorageService;
import haveno.core.util.FormattingUtils;
import haveno.core.util.VolumeUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.CachingViewLoader;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.common.view.View;
import haveno.desktop.common.view.ViewLoader;
import haveno.desktop.main.MainView;
import haveno.desktop.main.market.offerbook.OfferBookChartView;
import haveno.desktop.main.market.spread.SpreadView;
import haveno.desktop.main.market.spread.SpreadViewPaymentMethod;
import haveno.desktop.main.market.trades.TradesChartsView;
import haveno.desktop.main.offer.offerbook.OfferBook;
import haveno.desktop.main.offer.offerbook.OfferBookListItem;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.DisplayUtils;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.apache.commons.lang3.StringUtils;

@FxmlView
public class MarketView
extends ActivatableView<TabPane, Void> {
    @FXML
    Tab offerBookTab;
    @FXML
    Tab tradesTab;
    @FXML
    Tab spreadTab;
    @FXML
    Tab spreadTabPaymentMethod;
    private final ViewLoader viewLoader;
    private final TradeStatistics3StorageService tradeStatistics3StorageService;
    private final OfferBook offerBook;
    private final CoinFormatter formatter;
    private final Navigation navigation;
    private Navigation.Listener navigationListener;
    private ChangeListener<Tab> tabChangeListener;
    private EventHandler<KeyEvent> keyEventEventHandler;
    private Scene scene;

    @Inject
    public MarketView(CachingViewLoader viewLoader, TradeStatistics3StorageService tradeStatistics3StorageService, OfferBook offerBook, @Named(value="BTC") CoinFormatter formatter, Navigation navigation) {
        this.viewLoader = viewLoader;
        this.tradeStatistics3StorageService = tradeStatistics3StorageService;
        this.offerBook = offerBook;
        this.formatter = formatter;
        this.navigation = navigation;
    }

    @Override
    public void initialize() {
        this.offerBookTab.setText(Res.get((String)"market.tabs.offerBook"));
        this.spreadTab.setText(Res.get((String)"market.tabs.spreadCurrency"));
        this.spreadTabPaymentMethod.setText(Res.get((String)"market.tabs.spreadPayment"));
        this.tradesTab.setText(Res.get((String)"market.tabs.trades"));
        this.navigationListener = (viewPath, data) -> {
            if (viewPath.size() == 3 && viewPath.indexOf(MarketView.class) == 1) {
                this.loadView(viewPath.tip());
            }
        };
        this.tabChangeListener = (ov, oldValue, newValue) -> {
            if (newValue == this.offerBookTab) {
                this.navigation.navigateTo(MainView.class, MarketView.class, OfferBookChartView.class);
            } else if (newValue == this.tradesTab) {
                this.navigation.navigateTo(MainView.class, MarketView.class, TradesChartsView.class);
            } else if (newValue == this.spreadTab) {
                this.navigation.navigateTo(MainView.class, MarketView.class, SpreadView.class);
            } else if (newValue == this.spreadTabPaymentMethod) {
                this.navigation.navigateTo(MainView.class, MarketView.class, SpreadViewPaymentMethod.class);
            }
        };
        this.keyEventEventHandler = keyEvent -> {
            if (Utilities.isCtrlPressed((KeyCode)KeyCode.T, (KeyEvent)keyEvent)) {
                String allTradesWithReferralId = this.getAllTradesWithReferralId();
                ((Popup)((Popup)((Popup)new Popup().message(StringUtils.abbreviate((String)allTradesWithReferralId, (int)600))).actionButtonText(Res.get((String)"shared.copyToClipboard"))).onAction(() -> Utilities.copyToClipboard((String)allTradesWithReferralId))).show();
            } else if (Utilities.isCtrlPressed((KeyCode)KeyCode.O, (KeyEvent)keyEvent)) {
                String allOffersWithReferralId = this.getAllOffersWithReferralId();
                ((Popup)((Popup)((Popup)new Popup().message(StringUtils.abbreviate((String)allOffersWithReferralId, (int)600))).actionButtonText(Res.get((String)"shared.copyToClipboard"))).onAction(() -> Utilities.copyToClipboard((String)allOffersWithReferralId))).show();
            }
        };
    }

    @Override
    protected void activate() {
        ((TabPane)this.root).getSelectionModel().selectedItemProperty().addListener(this.tabChangeListener);
        this.navigation.addListener(this.navigationListener);
        if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.offerBookTab) {
            this.navigation.navigateTo(MainView.class, MarketView.class, OfferBookChartView.class);
        } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.tradesTab) {
            this.navigation.navigateTo(MainView.class, MarketView.class, TradesChartsView.class);
        } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.spreadTab) {
            this.navigation.navigateTo(MainView.class, MarketView.class, SpreadView.class);
        } else {
            this.navigation.navigateTo(MainView.class, MarketView.class, SpreadViewPaymentMethod.class);
        }
        if (((TabPane)this.root).getScene() != null) {
            this.scene = ((TabPane)this.root).getScene();
            this.scene.addEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
        }
    }

    @Override
    protected void deactivate() {
        ((TabPane)this.root).getSelectionModel().selectedItemProperty().removeListener(this.tabChangeListener);
        this.navigation.removeListener(this.navigationListener);
        if (this.scene != null) {
            this.scene.removeEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
        }
    }

    private void loadView(Class<? extends View> viewClass) {
        Tab tab;
        View view = this.viewLoader.load(viewClass);
        if (view instanceof OfferBookChartView) {
            tab = this.offerBookTab;
        } else if (view instanceof TradesChartsView) {
            tab = this.tradesTab;
        } else if (view instanceof SpreadViewPaymentMethod) {
            tab = this.spreadTabPaymentMethod;
        } else if (view instanceof SpreadView) {
            tab = this.spreadTab;
        } else {
            throw new IllegalArgumentException("Navigation to " + String.valueOf(viewClass) + " is not supported");
        }
        if (tab.getContent() != null && tab.getContent() instanceof ScrollPane) {
            ((ScrollPane)tab.getContent()).setContent(view.getRoot());
        } else {
            tab.setContent(view.getRoot());
        }
        ((TabPane)this.root).getSelectionModel().select((Object)tab);
    }

    private String getAllTradesWithReferralId() {
        List list = this.tradeStatistics3StorageService.getMapOfAllData().values().stream().filter(e -> e instanceof TradeStatistics3).map(e -> (TradeStatistics3)e).filter(tradeStatistics3 -> tradeStatistics3.getExtraDataMap() != null).filter(tradeStatistics3 -> tradeStatistics3.getExtraDataMap().get("referralId") != null).map(tradeStatistics3 -> {
            StringBuilder sb = new StringBuilder();
            sb.append("Date: ").append(DisplayUtils.formatDateTime(tradeStatistics3.getDate())).append("\n").append("Market: ").append(CurrencyUtil.getCurrencyPair((String)tradeStatistics3.getCurrency())).append("\n").append("Price: ").append(FormattingUtils.formatPrice((Price)tradeStatistics3.getTradePrice())).append("\n").append("Amount: ").append(HavenoUtils.formatXmr((BigInteger)tradeStatistics3.getTradeAmount())).append("\n").append("Volume: ").append(VolumeUtil.formatVolume((Volume)tradeStatistics3.getTradeVolume())).append("\n").append("Payment method: ").append(Res.get((String)tradeStatistics3.getPaymentMethodId())).append("\n").append("ReferralID: ").append((String)tradeStatistics3.getExtraDataMap().get("referralId"));
            return sb.toString();
        }).collect(Collectors.toList());
        return Joiner.on((String)"\n\n").join(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAllOffersWithReferralId() {
        ObservableList<OfferBookListItem> observableList = this.offerBook.getOfferBookListItems();
        synchronized (observableList) {
            List list = this.offerBook.getOfferBookListItems().stream().map(OfferBookListItem::getOffer).filter(offer -> offer.getExtraDataMap() != null).filter(offer -> offer.getExtraDataMap().get("referralId") != null).map(offer -> {
                StringBuilder sb = new StringBuilder();
                sb.append("Offer ID: ").append(offer.getId()).append("\n").append("Type: ").append(offer.getDirection().name()).append("\n").append("Market: ").append(CurrencyUtil.getCurrencyPair((String)offer.getCounterCurrencyCode())).append("\n").append("Price: ").append(FormattingUtils.formatPrice((Price)offer.getPrice())).append("\n").append("Amount: ").append(DisplayUtils.formatAmount(offer, this.formatter)).append(" BTC\n").append("Payment method: ").append(Res.get((String)offer.getPaymentMethod().getId())).append("\n").append("ReferralID: ").append((String)offer.getExtraDataMap().get("referralId"));
                return sb.toString();
            }).collect(Collectors.toList());
            return Joiner.on((String)"\n\n").join(list);
        }
    }
}

