/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.funds.withdrawal;

import com.google.inject.Inject;
import haveno.common.util.Tuple3;
import haveno.core.locale.Res;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.TradeManager;
import haveno.core.util.validation.BtcAddressValidator;
import haveno.core.xmr.listeners.XmrBalanceListener;
import haveno.core.xmr.setup.WalletsSetup;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.BusyAnimation;
import haveno.desktop.components.HyperlinkWithIcon;
import haveno.desktop.components.TitledGroupBg;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.TxWithdrawWindow;
import haveno.desktop.main.overlays.windows.WalletPasswordWindow;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.P2PService;
import java.math.BigInteger;
import java.util.Arrays;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import monero.common.MoneroRpcConnection;
import monero.common.MoneroUtils;
import monero.daemon.model.MoneroNetworkType;
import monero.wallet.model.MoneroDestination;
import monero.wallet.model.MoneroTxConfig;
import monero.wallet.model.MoneroTxWallet;

@FxmlView
public class WithdrawalView
extends ActivatableView<VBox, Void> {
    @FXML
    private GridPane gridPane;
    private BusyAnimation spinningWheel;
    private StackPane overlayPane;
    private Label amountLabel;
    private TextField amountTextField;
    private TextField withdrawToTextField;
    private TextField withdrawMemoTextField;
    private final XmrWalletService xmrWalletService;
    private final TradeManager tradeManager;
    private final P2PService p2PService;
    private final WalletPasswordWindow walletPasswordWindow;
    private XmrBalanceListener balanceListener;
    private BigInteger amount = BigInteger.ZERO;
    private ChangeListener<String> amountListener;
    private ChangeListener<Boolean> amountFocusListener;
    private int rowIndex = 0;
    boolean sendMax = false;

    @Inject
    private WithdrawalView(XmrWalletService xmrWalletService, TradeManager tradeManager, P2PService p2PService, WalletsSetup walletsSetup, BtcAddressValidator btcAddressValidator, WalletPasswordWindow walletPasswordWindow) {
        this.xmrWalletService = xmrWalletService;
        this.tradeManager = tradeManager;
        this.p2PService = p2PService;
        this.walletPasswordWindow = walletPasswordWindow;
    }

    @Override
    public void initialize() {
        this.spinningWheel = new BusyAnimation();
        this.overlayPane = new StackPane();
        this.overlayPane.setStyle("-fx-background-color: transparent;");
        this.overlayPane.setVisible(false);
        this.overlayPane.getChildren().add((Object)this.spinningWheel);
        ((VBox)this.root).getChildren().add((Object)this.overlayPane);
        TitledGroupBg titledGroupBg = FormBuilder.addTitledGroupBg(this.gridPane, this.rowIndex, 4, Res.get((String)"funds.deposit.withdrawFromWallet"));
        titledGroupBg.getStyleClass().add((Object)"last");
        this.withdrawToTextField = (TextField)FormBuilder.addTopLabelInputTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"funds.withdrawal.toLabel", (Object[])new Object[]{Res.getBaseCurrencyCode()})).second;
        Tuple3<Label, TextField, HyperlinkWithIcon> feeTuple3 = FormBuilder.addTopLabelTextFieldHyperLink(this.gridPane, ++this.rowIndex, "", Res.get((String)"funds.withdrawal.receiverAmount", (Object[])new Object[]{Res.getBaseCurrencyCode()}), Res.get((String)"funds.withdrawal.sendMax"), 0.0);
        this.amountLabel = (Label)feeTuple3.first;
        this.amountTextField = (TextField)feeTuple3.second;
        this.amountTextField.setMinWidth(225.0);
        HyperlinkWithIcon sendMaxLink = (HyperlinkWithIcon)((Object)feeTuple3.third);
        this.withdrawMemoTextField = (TextField)FormBuilder.addTopLabelInputTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"funds.withdrawal.memoLabel", (Object[])new Object[]{Res.getBaseCurrencyCode()})).second;
        Button withdrawButton = FormBuilder.addButton(this.gridPane, ++this.rowIndex, Res.get((String)"funds.withdrawal.withdrawButton"), 15.0);
        withdrawButton.setOnAction(event -> {
            this.showLoadingIndicator();
            new Thread(() -> {
                this.onWithdraw();
                Platform.runLater(() -> this.hideLoadingIndicator());
            }).start();
        });
        sendMaxLink.setOnAction(event -> {
            this.sendMax = true;
            this.amount = null;
            this.amountTextField.setText(Res.get((String)"funds.withdrawal.maximum"));
        });
        this.balanceListener = new XmrBalanceListener(this){

            public void onBalanceChanged(BigInteger balance) {
            }
        };
        this.amountListener = (observable, oldValue, newValue) -> {
            if (this.amountTextField.focusedProperty().get()) {
                this.sendMax = false;
                try {
                    this.amount = HavenoUtils.parseXmr((String)this.amountTextField.getText());
                }
                catch (Throwable t) {
                    this.log.error("Error at amountTextField input. " + t.toString());
                }
            }
        };
        this.amountFocusListener = (observable, oldValue, newValue) -> {
            if (oldValue.booleanValue() && !newValue.booleanValue() && !this.sendMax) {
                if (this.amount.compareTo(BigInteger.ZERO) > 0) {
                    this.amountTextField.setText(HavenoUtils.formatXmr((BigInteger)this.amount));
                } else {
                    this.amountTextField.setText("");
                }
            }
        };
        this.amountLabel.setText(Res.get((String)"funds.withdrawal.receiverAmount"));
    }

    private void showLoadingIndicator() {
        this.overlayPane.setVisible(true);
        this.spinningWheel.play();
        ((VBox)this.root).setDisable(true);
    }

    private void hideLoadingIndicator() {
        this.overlayPane.setVisible(false);
        this.spinningWheel.stop();
        ((VBox)this.root).setDisable(false);
    }

    @Override
    protected void activate() {
        this.reset();
        this.amountTextField.textProperty().addListener(this.amountListener);
        this.amountTextField.focusedProperty().addListener(this.amountFocusListener);
        this.xmrWalletService.addBalanceListener(this.balanceListener);
        GUIUtil.requestFocus((Node)this.withdrawToTextField);
    }

    @Override
    protected void deactivate() {
        this.spinningWheel.stop();
        this.xmrWalletService.removeBalanceListener(this.balanceListener);
        this.amountTextField.textProperty().removeListener(this.amountListener);
        this.amountTextField.focusedProperty().removeListener(this.amountFocusListener);
    }

    private void onWithdraw() {
        if (GUIUtil.isReadyForTxBroadcastOrShowPopup(this.xmrWalletService)) {
            try {
                String withdrawToAddress = this.withdrawToTextField.getText();
                boolean sendMax = this.sendMax;
                BigInteger amount = this.amount;
                if (!MoneroUtils.isValidAddress((String)withdrawToAddress, (MoneroNetworkType)XmrWalletService.getMoneroNetworkType())) {
                    throw new IllegalArgumentException(Res.get((String)"validation.xmr.invalidAddress"));
                }
                if (sendMax) {
                    amount = this.xmrWalletService.getAvailableBalance();
                }
                if (amount.compareTo(BigInteger.ZERO) <= 0) {
                    throw new RuntimeException(Res.get((String)"portfolio.pending.step5_buyer.amountTooLow"));
                }
                MoneroTxWallet tx = null;
                for (int i = 0; i < 5; ++i) {
                    MoneroRpcConnection sourceConnection = this.xmrWalletService.getXmrConnectionService().getConnection();
                    try {
                        this.log.info("Creating withdraw tx");
                        long startTime = System.currentTimeMillis();
                        tx = this.xmrWalletService.createTx(new MoneroTxConfig().setAccountIndex(Integer.valueOf(0)).setAmount(amount).setAddress(withdrawToAddress).setSubtractFeeFrom(sendMax ? Arrays.asList(0) : null));
                        this.log.info("Done creating withdraw tx in {} ms", (Object)(System.currentTimeMillis() - startTime));
                        break;
                    }
                    catch (Exception e) {
                        if (WithdrawalView.isNotEnoughMoney(e.getMessage())) {
                            throw e;
                        }
                        this.log.warn("Error creating creating withdraw tx, attempt={}/{}, error={}", new Object[]{i + 1, 5, e.getMessage()});
                        if (i == 4) {
                            throw e;
                        }
                        if (this.xmrWalletService.getXmrConnectionService().isConnected().booleanValue()) {
                            this.xmrWalletService.requestSwitchToNextBestConnection(sourceConnection);
                        }
                        HavenoUtils.waitFor((long)5000L);
                        continue;
                    }
                }
                this.popupConfirmationMessage(tx);
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (WithdrawalView.isNotEnoughMoney(e.getMessage())) {
                    ((Popup)new Popup().warning(Res.get((String)"funds.withdrawal.notEnoughFunds"))).show();
                }
                ((Popup)new Popup().warning(e.getMessage())).show();
            }
        }
    }

    private static boolean isNotEnoughMoney(String errorMsg) {
        return errorMsg.contains("not enough");
    }

    private void popupConfirmationMessage(MoneroTxWallet tx) {
        String withdrawToAddress = ((MoneroDestination)tx.getOutgoingTransfer().getDestinations().get(0)).getAddress();
        BigInteger receiverAmount = ((MoneroDestination)tx.getOutgoingTransfer().getDestinations().get(0)).getAmount();
        BigInteger fee = tx.getFee();
        String messageText = Res.get((String)"shared.sendFundsDetailsWithFee", (Object[])new Object[]{HavenoUtils.formatXmr((BigInteger)receiverAmount, (boolean)true), withdrawToAddress, HavenoUtils.formatXmr((BigInteger)fee, (boolean)true)});
        Popup popup = new Popup();
        ((Popup)((Popup)((Popup)((Popup)((Popup)popup.headLine(Res.get((String)"funds.withdrawal.confirmWithdrawalRequest"))).confirmation(messageText)).actionButtonText(Res.get((String)"shared.yes"))).onAction(() -> {
            if (this.xmrWalletService.isWalletEncrypted()) {
                ((WalletPasswordWindow)((WalletPasswordWindow)this.walletPasswordWindow.headLine(Res.get((String)"walletPasswordWindow.headline"))).onSuccess(() -> this.relayTx(tx, withdrawToAddress, receiverAmount, fee)).onClose(() -> popup.hide())).hideForgotPasswordButton().show();
            } else {
                this.relayTx(tx, withdrawToAddress, receiverAmount, fee);
            }
        })).closeButtonText(Res.get((String)"shared.cancel"))).show();
    }

    private void relayTx(MoneroTxWallet tx, String withdrawToAddress, BigInteger receiverAmount, BigInteger fee) {
        try {
            this.xmrWalletService.getWallet().relayTx(tx);
            this.xmrWalletService.getWallet().setTxNote(tx.getHash(), this.withdrawMemoTextField.getText());
            new TxWithdrawWindow(tx.getHash(), withdrawToAddress, HavenoUtils.formatXmr((BigInteger)receiverAmount, (boolean)true), HavenoUtils.formatXmr((BigInteger)fee, (boolean)true), this.xmrWalletService.getWallet().getTxNote(tx.getHash())).show();
            this.log.debug("onWithdraw onSuccess tx ID:{}", (Object)tx.getHash());
        }
        catch (Exception e) {
            e.printStackTrace();
            ((Popup)new Popup().warning(e.getMessage())).show();
        }
    }

    private void reset() {
        this.sendMax = false;
        this.amount = BigInteger.ZERO;
        this.amountTextField.setText("");
        this.amountTextField.setPromptText(Res.get((String)"funds.withdrawal.setAmount"));
        this.withdrawToTextField.setText("");
        this.withdrawToTextField.setPromptText(Res.get((String)"funds.withdrawal.fillDestAddress"));
        this.withdrawMemoTextField.setText("");
        this.withdrawMemoTextField.setPromptText(Res.get((String)"funds.withdrawal.memo"));
    }
}

