/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.funds.withdrawal;

import haveno.common.UserThread;
import haveno.core.locale.Res;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.listeners.XmrBalanceListener;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.components.AutoTooltipLabel;
import java.math.BigInteger;
import javafx.scene.control.Label;

class WithdrawalListItem {
    private final XmrBalanceListener balanceListener;
    private final Label balanceLabel;
    private final XmrAddressEntry addressEntry;
    private final XmrWalletService walletService;
    private final CoinFormatter formatter;
    private BigInteger balance;
    private final String addressString;
    private boolean isSelected;

    public WithdrawalListItem(XmrAddressEntry addressEntry, XmrWalletService walletService, CoinFormatter formatter) {
        this.addressEntry = addressEntry;
        this.walletService = walletService;
        this.formatter = formatter;
        this.addressString = addressEntry.getAddressString();
        this.balanceLabel = new AutoTooltipLabel();
        this.balanceListener = new XmrBalanceListener(addressEntry.getSubaddressIndex()){

            public void onBalanceChanged(BigInteger balance) {
                WithdrawalListItem.this.updateBalance();
            }
        };
        walletService.addBalanceListener(this.balanceListener);
        this.updateBalance();
    }

    public void cleanup() {
        this.walletService.removeBalanceListener(this.balanceListener);
    }

    private void updateBalance() {
        this.balance = this.walletService.getBalanceForSubaddress(this.addressEntry.getSubaddressIndex());
        if (this.balance != null) {
            UserThread.execute(() -> this.balanceLabel.setText(HavenoUtils.formatXmr((BigInteger)this.balance)));
        }
    }

    public final String getLabel() {
        if (this.addressEntry.isOpenOffer()) {
            return Res.getWithCol((String)"shared.offerId") + " " + this.addressEntry.getShortOfferId();
        }
        if (this.addressEntry.isTradePayout()) {
            return Res.getWithCol((String)"shared.tradeId") + " " + this.addressEntry.getShortOfferId();
        }
        if (this.addressEntry.getContext() == XmrAddressEntry.Context.ARBITRATOR) {
            return Res.get((String)"funds.withdrawal.arbitrationFee");
        }
        return "-";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WithdrawalListItem)) {
            return false;
        }
        WithdrawalListItem that = (WithdrawalListItem)o;
        return this.addressEntry.equals((Object)that.addressEntry);
    }

    public int hashCode() {
        return this.addressEntry.hashCode();
    }

    public XmrAddressEntry getAddressEntry() {
        return this.addressEntry;
    }

    public Label getBalanceLabel() {
        return this.balanceLabel;
    }

    public BigInteger getBalance() {
        return this.balance;
    }

    public String getAddressString() {
        return this.addressString;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }
}

