/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.funds.transactions;

import com.google.inject.Inject;
import com.googlecode.jcsv.writer.CSVEntryConverter;
import de.jensd.fx.fontawesome.AwesomeIcon;
import haveno.core.api.XmrConnectionService;
import haveno.core.locale.Res;
import haveno.core.offer.OpenOffer;
import haveno.core.trade.Trade;
import haveno.core.user.Preferences;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.AddressWithIconAndDirection;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.HyperlinkWithIcon;
import haveno.desktop.main.funds.transactions.DisplayedTransactions;
import haveno.desktop.main.funds.transactions.DisplayedTransactionsFactory;
import haveno.desktop.main.funds.transactions.TransactionsListItem;
import haveno.desktop.main.overlays.windows.OfferDetailsWindow;
import haveno.desktop.main.overlays.windows.TradeDetailsWindow;
import haveno.desktop.main.overlays.windows.TxDetailsWindow;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.P2PService;
import java.math.BigInteger;
import java.util.Comparator;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import monero.wallet.model.MoneroWalletListener;
import monero.wallet.model.MoneroWalletListenerI;

@FxmlView
public class TransactionsView
extends ActivatableView<VBox, Void> {
    @FXML
    TableView<TransactionsListItem> tableView;
    @FXML
    TableColumn<TransactionsListItem, TransactionsListItem> dateColumn;
    @FXML
    TableColumn<TransactionsListItem, TransactionsListItem> detailsColumn;
    @FXML
    TableColumn<TransactionsListItem, TransactionsListItem> addressColumn;
    @FXML
    TableColumn<TransactionsListItem, TransactionsListItem> transactionColumn;
    @FXML
    TableColumn<TransactionsListItem, TransactionsListItem> amountColumn;
    @FXML
    TableColumn<TransactionsListItem, TransactionsListItem> txFeeColumn;
    @FXML
    TableColumn<TransactionsListItem, TransactionsListItem> confidenceColumn;
    @FXML
    TableColumn<TransactionsListItem, TransactionsListItem> memoColumn;
    @FXML
    Label numItems;
    @FXML
    Region spacer;
    @FXML
    AutoTooltipButton exportButton;
    private final DisplayedTransactions displayedTransactions;
    private final SortedList<TransactionsListItem> sortedDisplayedTransactions;
    private final XmrWalletService xmrWalletService;
    private final Preferences preferences;
    private final TradeDetailsWindow tradeDetailsWindow;
    private final OfferDetailsWindow offerDetailsWindow;
    private final TxDetailsWindow txDetailsWindow;
    private EventHandler<KeyEvent> keyEventEventHandler;
    private Scene scene;
    private final TransactionsUpdater transactionsUpdater = new TransactionsUpdater();

    @Inject
    private TransactionsView(XmrWalletService xmrWalletService, P2PService p2PService, XmrConnectionService xmrConnectionService, Preferences preferences, TradeDetailsWindow tradeDetailsWindow, OfferDetailsWindow offerDetailsWindow, TxDetailsWindow txDetailsWindow, DisplayedTransactionsFactory displayedTransactionsFactory) {
        this.xmrWalletService = xmrWalletService;
        this.preferences = preferences;
        this.tradeDetailsWindow = tradeDetailsWindow;
        this.offerDetailsWindow = offerDetailsWindow;
        this.txDetailsWindow = txDetailsWindow;
        this.displayedTransactions = displayedTransactionsFactory.create();
        this.sortedDisplayedTransactions = this.displayedTransactions.asSortedList();
    }

    @Override
    public void initialize() {
        GUIUtil.applyTableStyle(this.tableView);
        this.dateColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.dateTime")));
        this.detailsColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.details")));
        this.addressColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.address")));
        this.transactionColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.txId", (Object[])new Object[]{Res.getBaseCurrencyCode()})));
        this.amountColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.amountWithCur", (Object[])new Object[]{Res.getBaseCurrencyCode()})));
        this.txFeeColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.txFee", (Object[])new Object[]{Res.getBaseCurrencyCode()})));
        this.confidenceColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.confirmations", (Object[])new Object[]{Res.getBaseCurrencyCode()})));
        this.memoColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"funds.tx.memo")));
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.tableView.setPlaceholder((Node)new AutoTooltipLabel(Res.get((String)"funds.tx.noTxAvailable")));
        this.tableView.getStyleClass().add((Object)"non-interactive-table");
        this.setDateColumnCellFactory();
        this.setDetailsColumnCellFactory();
        this.setAddressColumnCellFactory();
        this.setTransactionColumnCellFactory();
        this.setAmountColumnCellFactory();
        this.setTxFeeColumnCellFactory();
        this.setConfidenceColumnCellFactory();
        this.setMemoColumnCellFactory();
        this.dateColumn.setComparator(Comparator.comparing(TransactionsListItem::getDate));
        this.detailsColumn.setComparator((o1, o2) -> {
            String id1;
            String string = !o1.getDetails().isEmpty() ? o1.getDetails() : (id1 = o1.getTradable() != null ? o1.getTradable().getId() : o1.getTxId());
            String id2 = !o2.getDetails().isEmpty() ? o2.getDetails() : (o2.getTradable() != null ? o2.getTradable().getId() : o2.getTxId());
            return id1.compareTo(id2);
        });
        this.addressColumn.setComparator(Comparator.comparing(item -> item.getDirection() + item.getAddressString()));
        this.transactionColumn.setComparator(Comparator.comparing(TransactionsListItem::getTxId));
        this.amountColumn.setComparator(Comparator.comparing(TransactionsListItem::getAmount));
        this.confidenceColumn.setComparator(Comparator.comparingLong(TransactionsListItem::getNumConfirmations));
        this.memoColumn.setComparator(Comparator.comparing(TransactionsListItem::getMemo, Comparator.nullsLast(Comparator.naturalOrder())));
        this.dateColumn.setSortType(TableColumn.SortType.DESCENDING);
        this.tableView.getSortOrder().add(this.dateColumn);
        this.keyEventEventHandler = event -> {};
        HBox.setHgrow((Node)this.spacer, (Priority)Priority.ALWAYS);
        this.numItems.setId("num-offers");
        this.numItems.setPadding(new Insets(-5.0, 0.0, 0.0, 10.0));
        this.exportButton.updateText(Res.get((String)"shared.exportCSV"));
    }

    @Override
    protected void activate() {
        this.sortedDisplayedTransactions.comparatorProperty().bind((ObservableValue)this.tableView.comparatorProperty());
        this.tableView.setItems(this.sortedDisplayedTransactions);
        try {
            this.displayedTransactions.update();
        }
        catch (Exception e) {
            this.log.warn("Failed to update displayed transactions");
            e.printStackTrace();
        }
        this.xmrWalletService.addWalletListener((MoneroWalletListenerI)this.transactionsUpdater);
        this.scene = ((VBox)this.root).getScene();
        if (this.scene != null) {
            this.scene.addEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
        }
        this.numItems.setText(Res.get((String)"shared.numItemsLabel", (Object[])new Object[]{this.sortedDisplayedTransactions.size()}));
        this.exportButton.setOnAction(event -> {
            ObservableList<TableColumn<TransactionsListItem, ?>> tableColumns = GUIUtil.getContentColumns(this.tableView);
            int reportColumns = tableColumns.size();
            CSVEntryConverter headerConverter = item -> {
                String[] columns = new String[reportColumns];
                for (int i = 0; i < columns.length; ++i) {
                    columns[i] = ((AutoTooltipLabel)((TableColumn)tableColumns.get(i)).getGraphic()).getText();
                }
                return columns;
            };
            CSVEntryConverter contentConverter = item -> {
                String[] columns = new String[reportColumns];
                columns[0] = item.getDateString();
                columns[1] = item.getDetails();
                columns[2] = item.getDirection() + " " + item.getAddressString();
                columns[3] = item.getTxId();
                columns[4] = item.getAmountStr();
                columns[5] = item.getTxFeeStr();
                columns[6] = String.valueOf(item.getNumConfirmations());
                columns[7] = item.getMemo() == null ? "" : item.getMemo();
                return columns;
            };
            GUIUtil.exportCSV("transactions.csv", headerConverter, contentConverter, new TransactionsListItem(), this.sortedDisplayedTransactions, (Stage)((VBox)this.root).getScene().getWindow());
        });
    }

    @Override
    protected void deactivate() {
        this.sortedDisplayedTransactions.comparatorProperty().unbind();
        this.displayedTransactions.forEach(TransactionsListItem::cleanup);
        this.xmrWalletService.removeWalletListener((MoneroWalletListenerI)this.transactionsUpdater);
        if (this.scene != null) {
            this.scene.removeEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
        }
        this.exportButton.setOnAction(null);
    }

    private void openTxInBlockExplorer(TransactionsListItem item) {
        if (item.getTxId() != null) {
            GUIUtil.openWebPage(this.preferences.getBlockChainExplorer().txUrl + item.getTxId(), false);
        }
    }

    private void openDetailPopup(TransactionsListItem item) {
        if (item.getTradable() instanceof OpenOffer) {
            this.offerDetailsWindow.show(item.getTradable().getOffer());
        } else if (item.getTradable() instanceof Trade) {
            this.tradeDetailsWindow.show((Trade)item.getTradable());
        }
    }

    private void openTxDetailPopup(TransactionsListItem item) {
        this.txDetailsWindow.show(item);
    }

    private void setDateColumnCellFactory() {
        this.dateColumn.setCellValueFactory(addressListItem -> new ReadOnlyObjectWrapper((Object)((TransactionsListItem)addressListItem.getValue())));
        this.dateColumn.setMaxWidth(200.0);
        this.dateColumn.setMinWidth(this.dateColumn.getMaxWidth());
        this.dateColumn.setCellFactory((Callback)new Callback<TableColumn<TransactionsListItem, TransactionsListItem>, TableCell<TransactionsListItem, TransactionsListItem>>(this){

            public TableCell<TransactionsListItem, TransactionsListItem> call(TableColumn<TransactionsListItem, TransactionsListItem> column) {
                return new TableCell<TransactionsListItem, TransactionsListItem>(this){

                    public void updateItem(TransactionsListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(item.getDateString()));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setDetailsColumnCellFactory() {
        this.detailsColumn.setCellValueFactory(addressListItem -> new ReadOnlyObjectWrapper((Object)((TransactionsListItem)addressListItem.getValue())));
        this.detailsColumn.setCellFactory((Callback)new Callback<TableColumn<TransactionsListItem, TransactionsListItem>, TableCell<TransactionsListItem, TransactionsListItem>>(){

            public TableCell<TransactionsListItem, TransactionsListItem> call(TableColumn<TransactionsListItem, TransactionsListItem> column) {
                return new TableCell<TransactionsListItem, TransactionsListItem>(){
                    private HyperlinkWithIcon hyperlinkWithIcon;

                    public void updateItem(TransactionsListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            if (item.getDetailsAvailable()) {
                                this.hyperlinkWithIcon = new HyperlinkWithIcon(item.getDetails(), AwesomeIcon.INFO_SIGN);
                                this.hyperlinkWithIcon.setOnAction(event -> TransactionsView.this.openDetailPopup(item));
                                this.hyperlinkWithIcon.setTooltip(new Tooltip(Res.get((String)"tooltip.openPopupForDetails")));
                                this.setGraphic((Node)this.hyperlinkWithIcon);
                            } else {
                                this.setGraphic((Node)new AutoTooltipLabel(item.getDetails()));
                            }
                        } else {
                            this.setGraphic(null);
                            if (this.hyperlinkWithIcon != null) {
                                this.hyperlinkWithIcon.setOnAction(null);
                            }
                        }
                    }
                };
            }
        });
    }

    private void setAddressColumnCellFactory() {
        this.addressColumn.setCellValueFactory(addressListItem -> new ReadOnlyObjectWrapper((Object)((TransactionsListItem)addressListItem.getValue())));
        this.addressColumn.setCellFactory((Callback)new Callback<TableColumn<TransactionsListItem, TransactionsListItem>, TableCell<TransactionsListItem, TransactionsListItem>>(this){

            public TableCell<TransactionsListItem, TransactionsListItem> call(TableColumn<TransactionsListItem, TransactionsListItem> column) {
                return new TableCell<TransactionsListItem, TransactionsListItem>(this){
                    private AddressWithIconAndDirection field;

                    public void updateItem(TransactionsListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            String addressString = item.getAddressString();
                            this.field = new AddressWithIconAndDirection(item.getDirection(), addressString, item.getReceived());
                            this.field.setTooltip(new Tooltip(Res.get((String)"tooltip.openBlockchainForAddress", (Object[])new Object[]{addressString})));
                            this.setGraphic((Node)this.field);
                        } else {
                            this.setGraphic(null);
                            if (this.field != null) {
                                this.field.setOnAction(null);
                            }
                        }
                    }
                };
            }
        });
    }

    private void setTransactionColumnCellFactory() {
        this.transactionColumn.setCellValueFactory(addressListItem -> new ReadOnlyObjectWrapper((Object)((TransactionsListItem)addressListItem.getValue())));
        this.transactionColumn.setCellFactory((Callback)new Callback<TableColumn<TransactionsListItem, TransactionsListItem>, TableCell<TransactionsListItem, TransactionsListItem>>(){

            public TableCell<TransactionsListItem, TransactionsListItem> call(TableColumn<TransactionsListItem, TransactionsListItem> column) {
                return new TableCell<TransactionsListItem, TransactionsListItem>(){
                    private HyperlinkWithIcon hyperlinkWithIcon;

                    public void updateItem(TransactionsListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            String transactionId = item.getTxId();
                            this.hyperlinkWithIcon = new HyperlinkWithIcon(transactionId, AwesomeIcon.INFO_SIGN);
                            this.hyperlinkWithIcon.setOnAction(event -> TransactionsView.this.openTxDetailPopup(item));
                            this.hyperlinkWithIcon.setTooltip(new Tooltip(Res.get((String)"txDetailsWindow.headline")));
                            this.setGraphic((Node)this.hyperlinkWithIcon);
                        } else {
                            this.setGraphic(null);
                            if (this.hyperlinkWithIcon != null) {
                                this.hyperlinkWithIcon.setOnAction(null);
                            }
                        }
                    }
                };
            }
        });
    }

    private void setAmountColumnCellFactory() {
        this.amountColumn.setCellValueFactory(addressListItem -> new ReadOnlyObjectWrapper((Object)((TransactionsListItem)addressListItem.getValue())));
        this.amountColumn.getStyleClass().add((Object)"highlight-text");
        this.amountColumn.setCellFactory((Callback)new Callback<TableColumn<TransactionsListItem, TransactionsListItem>, TableCell<TransactionsListItem, TransactionsListItem>>(this){

            public TableCell<TransactionsListItem, TransactionsListItem> call(TableColumn<TransactionsListItem, TransactionsListItem> column) {
                return new TableCell<TransactionsListItem, TransactionsListItem>(this){

                    public void updateItem(TransactionsListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(item.getAmountStr()));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setTxFeeColumnCellFactory() {
        this.txFeeColumn.setCellValueFactory(addressListItem -> new ReadOnlyObjectWrapper((Object)((TransactionsListItem)addressListItem.getValue())));
        this.txFeeColumn.getStyleClass().add((Object)"highlight-text");
        this.txFeeColumn.setCellFactory((Callback)new Callback<TableColumn<TransactionsListItem, TransactionsListItem>, TableCell<TransactionsListItem, TransactionsListItem>>(this){

            public TableCell<TransactionsListItem, TransactionsListItem> call(TableColumn<TransactionsListItem, TransactionsListItem> column) {
                return new TableCell<TransactionsListItem, TransactionsListItem>(this){

                    public void updateItem(TransactionsListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(item.getTxFeeStr()));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setMemoColumnCellFactory() {
        this.memoColumn.setCellValueFactory(addressListItem -> new ReadOnlyObjectWrapper((Object)((TransactionsListItem)addressListItem.getValue())));
        this.memoColumn.getStyleClass().add((Object)"highlight-text");
        this.memoColumn.setCellFactory((Callback)new Callback<TableColumn<TransactionsListItem, TransactionsListItem>, TableCell<TransactionsListItem, TransactionsListItem>>(this){

            public TableCell<TransactionsListItem, TransactionsListItem> call(TableColumn<TransactionsListItem, TransactionsListItem> column) {
                return new TableCell<TransactionsListItem, TransactionsListItem>(this){

                    public void updateItem(TransactionsListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(item.getMemo()));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setConfidenceColumnCellFactory() {
        this.confidenceColumn.setCellValueFactory(addressListItem -> new ReadOnlyObjectWrapper((Object)((TransactionsListItem)addressListItem.getValue())));
        this.confidenceColumn.setCellFactory((Callback)new Callback<TableColumn<TransactionsListItem, TransactionsListItem>, TableCell<TransactionsListItem, TransactionsListItem>>(this){

            public TableCell<TransactionsListItem, TransactionsListItem> call(TableColumn<TransactionsListItem, TransactionsListItem> column) {
                return new TableCell<TransactionsListItem, TransactionsListItem>(this){

                    public void updateItem(TransactionsListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)item.getTxConfidenceIndicator());
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private class TransactionsUpdater
    extends MoneroWalletListener {
        private TransactionsUpdater() {
        }

        public void onNewBlock(long height) {
            TransactionsView.this.displayedTransactions.update();
        }

        public void onBalancesChanged(BigInteger newBalance, BigInteger newUnlockedBalance) {
            TransactionsView.this.displayedTransactions.update();
        }
    }
}

