/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.funds.transactions;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import haveno.core.locale.Res;
import haveno.core.offer.Offer;
import haveno.core.offer.OpenOffer;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Tradable;
import haveno.core.trade.Trade;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.components.indicator.TxConfidenceIndicator;
import haveno.desktop.main.funds.transactions.TransactionAwareTradable;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.GUIUtil;
import java.math.BigInteger;
import java.util.Date;
import java.util.Optional;
import javafx.scene.control.Tooltip;
import javax.annotation.Nullable;
import monero.daemon.model.MoneroTx;
import monero.wallet.model.MoneroDestination;
import monero.wallet.model.MoneroIncomingTransfer;
import monero.wallet.model.MoneroOutgoingTransfer;
import monero.wallet.model.MoneroTransfer;
import monero.wallet.model.MoneroTxWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionsListItem {
    private static final Logger log = LoggerFactory.getLogger(TransactionsListItem.class);
    private String dateString;
    private final Date date;
    private final String txId;
    @Nullable
    private Tradable tradable;
    private String details = "";
    private String addressString = "";
    private String direction = "";
    private boolean received;
    private boolean detailsAvailable;
    private BigInteger amount = BigInteger.ZERO;
    private BigInteger txFee = BigInteger.ZERO;
    private String memo = "";
    private long confirmations = 0L;
    private boolean initialTxConfidenceVisibility = true;
    private final Supplier<LazyFields> lazyFieldsSupplier;
    private XmrWalletService xmrWalletService;
    private MoneroTxWallet tx;

    private LazyFields lazy() {
        return (LazyFields)this.lazyFieldsSupplier.get();
    }

    TransactionsListItem() {
        this.date = null;
        this.txId = null;
        this.lazyFieldsSupplier = null;
    }

    TransactionsListItem(final MoneroTxWallet tx, XmrWalletService xmrWalletService, TransactionAwareTradable transactionAwareTradable) {
        MoneroOutgoingTransfer transfer;
        BigInteger valueSentFromMe;
        this.tx = tx;
        this.memo = tx.getNote();
        this.txId = tx.getHash();
        this.xmrWalletService = xmrWalletService;
        this.confirmations = tx.getNumConfirmations() == null ? 0L : tx.getNumConfirmations();
        Optional<Tradable> optionalTradable = Optional.ofNullable(transactionAwareTradable).map(TransactionAwareTradable::asTradable);
        BigInteger valueSentToMe = tx.getIncomingAmount() == null ? BigInteger.ZERO : tx.getIncomingAmount();
        BigInteger bigInteger = valueSentFromMe = tx.getOutgoingAmount() == null ? BigInteger.ZERO : tx.getOutgoingAmount();
        this.addressString = ((MoneroTransfer)tx.getTransfers().get(0)).isIncoming() != false ? ((MoneroIncomingTransfer)tx.getTransfers().get(0)).getAddress() : ((transfer = (MoneroOutgoingTransfer)tx.getTransfers().get(0)).getDestinations() != null ? ((MoneroDestination)transfer.getDestinations().get(0)).getAddress() : "unavailable");
        if (valueSentFromMe.compareTo(BigInteger.ZERO) == 0) {
            this.amount = valueSentToMe;
            this.direction = Res.get((String)"funds.tx.direction.receivedWith");
            this.received = true;
        } else {
            this.amount = valueSentFromMe.multiply(BigInteger.valueOf(-1L));
            this.received = false;
            this.direction = Res.get((String)"funds.tx.direction.sentTo");
            this.txFee = tx.getFee().multiply(BigInteger.valueOf(-1L));
        }
        if (optionalTradable.isPresent()) {
            this.tradable = optionalTradable.get();
            this.detailsAvailable = true;
            String tradeId = this.tradable.getShortId();
            if (this.tradable instanceof OpenOffer) {
                this.details = Res.get((String)"funds.tx.createOfferFee", (Object[])new Object[]{tradeId});
            } else if (this.tradable instanceof Trade) {
                Trade trade = (Trade)this.tradable;
                Offer offer = trade.getOffer();
                if (trade.getSelf().getDepositTxHash() != null && trade.getSelf().getDepositTxHash().equals(this.txId)) {
                    this.details = Res.get((String)"funds.tx.multiSigDeposit", (Object[])new Object[]{tradeId});
                    this.addressString = trade.getProcessModel().getMultisigAddress();
                } else if (trade.getPayoutTxId() != null && trade.getPayoutTxId().equals(this.txId)) {
                    this.details = Res.get((String)"funds.tx.multiSigPayout", (Object[])new Object[]{tradeId});
                    if (this.amount.compareTo(BigInteger.ZERO) == 0) {
                        this.initialTxConfidenceVisibility = false;
                    }
                } else {
                    Trade.DisputeState disputeState = trade.getDisputeState();
                    if (disputeState == Trade.DisputeState.DISPUTE_CLOSED) {
                        this.details = valueSentToMe.compareTo(BigInteger.ZERO) > 0 ? Res.get((String)"funds.tx.disputePayout", (Object[])new Object[]{tradeId}) : Res.get((String)"funds.tx.disputeLost", (Object[])new Object[]{tradeId});
                    } else if (disputeState == Trade.DisputeState.REFUND_REQUEST_CLOSED || disputeState == Trade.DisputeState.REFUND_REQUESTED || disputeState == Trade.DisputeState.REFUND_REQUEST_STARTED_BY_PEER) {
                        if (valueSentToMe.compareTo(BigInteger.ZERO) > 0) {
                            this.details = Res.get((String)"funds.tx.refund", (Object[])new Object[]{tradeId});
                        } else {
                            this.amount = BigInteger.ZERO;
                            this.details = Res.get((String)"funds.tx.collateralForRefund", (Object[])new Object[]{tradeId});
                            this.initialTxConfidenceVisibility = false;
                        }
                    } else {
                        this.details = Res.get((String)"funds.tx.unknown", (Object[])new Object[]{tradeId});
                        if (trade instanceof ArbitratorTrade) {
                            if (this.txId.equals(trade.getMaker().getDepositTxHash())) {
                                this.details = Res.get((String)"funds.tx.makerTradeFee", (Object[])new Object[]{tradeId});
                            } else if (this.txId.equals(trade.getTaker().getDepositTxHash())) {
                                this.details = Res.get((String)"funds.tx.takerTradeFee", (Object[])new Object[]{tradeId});
                            }
                        }
                    }
                }
            }
        }
        Long timestamp = tx.getBlock() == null ? System.currentTimeMillis() : tx.getBlock().getTimestamp() * 1000L;
        this.date = new Date(timestamp);
        this.dateString = DisplayUtils.formatDateTime(this.date);
        this.lazyFieldsSupplier = Suppliers.memoize(() -> new LazyFields(){
            {
                this.txConfidenceIndicator = new TxConfidenceIndicator();
                this.txConfidenceIndicator.setId("funds-confidence");
                this.tooltip = new Tooltip(Res.get((String)"shared.notUsedYet"));
                this.txConfidenceIndicator.setProgress(0.0);
                this.txConfidenceIndicator.setTooltip(this.tooltip);
                this.txConfidenceIndicator.setVisible(TransactionsListItem.this.initialTxConfidenceVisibility);
                GUIUtil.updateConfidence((MoneroTx)tx, this.tooltip, this.txConfidenceIndicator);
                TransactionsListItem.this.confirmations = tx.getNumConfirmations();
            }
        });
    }

    public void cleanup() {
    }

    public TxConfidenceIndicator getTxConfidenceIndicator() {
        return this.lazy().txConfidenceIndicator;
    }

    public final String getDateString() {
        return this.dateString;
    }

    public String getAmountStr() {
        return HavenoUtils.formatXmr((BigInteger)this.amount);
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public BigInteger getTxFee() {
        return this.txFee;
    }

    public String getTxFeeStr() {
        return this.txFee.equals(BigInteger.ZERO) ? "" : HavenoUtils.formatXmr((BigInteger)this.txFee);
    }

    public String getAddressString() {
        return this.addressString;
    }

    public String getDirection() {
        return this.direction;
    }

    public String getTxId() {
        return this.txId;
    }

    public boolean getReceived() {
        return this.received;
    }

    public String getDetails() {
        return this.details;
    }

    public boolean getDetailsAvailable() {
        return this.detailsAvailable;
    }

    public Date getDate() {
        return this.date;
    }

    @Nullable
    public Tradable getTradable() {
        return this.tradable;
    }

    public long getNumConfirmations() {
        return this.confirmations;
    }

    public String getMemo() {
        return this.memo;
    }

    public boolean isInitialTxConfidenceVisibility() {
        return this.initialTxConfidenceVisibility;
    }

    public MoneroTxWallet getTx() {
        return this.tx;
    }

    private static class LazyFields {
        TxConfidenceIndicator txConfidenceIndicator;
        Tooltip tooltip;

        private LazyFields() {
        }
    }
}

