/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.funds.transactions;

import haveno.common.crypto.PubKeyRing;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.dispute.refund.RefundManager;
import haveno.core.trade.Tradable;
import haveno.core.trade.Trade;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.main.funds.transactions.TransactionAwareTradable;
import javafx.collections.ObservableList;
import monero.wallet.model.MoneroTxWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransactionAwareTrade
implements TransactionAwareTradable {
    private static final Logger log = LoggerFactory.getLogger(TransactionAwareTrade.class);
    private final Trade trade;
    private final ArbitrationManager arbitrationManager;
    private final RefundManager refundManager;
    private final XmrWalletService xmrWalletService;
    private final PubKeyRing pubKeyRing;

    TransactionAwareTrade(Trade trade, ArbitrationManager arbitrationManager, RefundManager refundManager, XmrWalletService xmrWalletService, PubKeyRing pubKeyRing) {
        this.trade = trade;
        this.arbitrationManager = arbitrationManager;
        this.refundManager = refundManager;
        this.xmrWalletService = xmrWalletService;
        this.pubKeyRing = pubKeyRing;
    }

    @Override
    public boolean isRelatedToTransaction(MoneroTxWallet transaction) {
        String txId = transaction.getHash();
        boolean isMakerDepositTx = this.isMakerDepositTx(txId);
        boolean isTakerDepositTx = this.isTakerDepositTx(txId);
        boolean isPayoutTx = this.isPayoutTx(txId);
        boolean isDisputedPayoutTx = this.isDisputedPayoutTx(txId);
        return isMakerDepositTx || isTakerDepositTx || isPayoutTx || isDisputedPayoutTx;
    }

    private boolean isPayoutTx(String txId) {
        return txId.equals(this.trade.getPayoutTxId());
    }

    private boolean isMakerDepositTx(String txId) {
        return txId.equals(this.trade.getMaker().getDepositTxHash());
    }

    private boolean isTakerDepositTx(String txId) {
        return txId.equals(this.trade.getTaker().getDepositTxHash());
    }

    private boolean isDisputedPayoutTx(String txId) {
        String delegateId = this.trade.getId();
        ObservableList disputes = this.arbitrationManager.getDisputesAsObservableList();
        boolean isAnyDisputeRelatedToThis = this.arbitrationManager.getDisputedTradeIds().contains(this.trade.getId());
        return isAnyDisputeRelatedToThis && disputes.stream().anyMatch(dispute -> {
            String disputePayoutTxId = dispute.getDisputePayoutTxId();
            boolean isDisputePayoutTx = txId.equals(disputePayoutTxId);
            String disputeTradeId = dispute.getTradeId();
            boolean isDisputeRelatedToThis = delegateId.equals(disputeTradeId);
            return isDisputePayoutTx && isDisputeRelatedToThis;
        });
    }

    @Override
    public Tradable asTradable() {
        return this.trade;
    }
}

