/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.funds.transactions;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.crypto.PubKeyRingProvider;
import haveno.core.offer.OpenOffer;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.dispute.refund.RefundManager;
import haveno.core.trade.Tradable;
import haveno.core.trade.Trade;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.main.funds.transactions.DummyTransactionAwareTradable;
import haveno.desktop.main.funds.transactions.TransactionAwareOpenOffer;
import haveno.desktop.main.funds.transactions.TransactionAwareTradable;
import haveno.desktop.main.funds.transactions.TransactionAwareTrade;

@Singleton
public class TransactionAwareTradableFactory {
    private final ArbitrationManager arbitrationManager;
    private final RefundManager refundManager;
    private final XmrWalletService xmrWalletService;
    private final PubKeyRingProvider pubKeyRingProvider;

    @Inject
    TransactionAwareTradableFactory(ArbitrationManager arbitrationManager, RefundManager refundManager, XmrWalletService xmrWalletService, PubKeyRingProvider pubKeyRingProvider) {
        this.arbitrationManager = arbitrationManager;
        this.refundManager = refundManager;
        this.xmrWalletService = xmrWalletService;
        this.pubKeyRingProvider = pubKeyRingProvider;
    }

    TransactionAwareTradable create(Tradable delegate) {
        if (delegate instanceof OpenOffer) {
            return new TransactionAwareOpenOffer((OpenOffer)delegate);
        }
        if (delegate instanceof Trade) {
            return new TransactionAwareTrade((Trade)delegate, this.arbitrationManager, this.refundManager, this.xmrWalletService, this.pubKeyRingProvider.get());
        }
        return new DummyTransactionAwareTradable(delegate);
    }
}

