/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.funds.transactions;

import haveno.common.UserThread;
import haveno.core.trade.Tradable;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.main.funds.transactions.ObservableListDecorator;
import haveno.desktop.main.funds.transactions.TradableRepository;
import haveno.desktop.main.funds.transactions.TransactionAwareTradable;
import haveno.desktop.main.funds.transactions.TransactionAwareTradableFactory;
import haveno.desktop.main.funds.transactions.TransactionListItemFactory;
import haveno.desktop.main.funds.transactions.TransactionsListItem;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import monero.wallet.model.MoneroTxWallet;

class DisplayedTransactions
extends ObservableListDecorator<TransactionsListItem> {
    private final XmrWalletService xmrWalletService;
    private final TradableRepository tradableRepository;
    private final TransactionListItemFactory transactionListItemFactory;
    private final TransactionAwareTradableFactory transactionAwareTradableFactory;

    DisplayedTransactions(XmrWalletService xmrWalletService, TradableRepository tradableRepository, TransactionListItemFactory transactionListItemFactory, TransactionAwareTradableFactory transactionAwareTradableFactory) {
        this.xmrWalletService = xmrWalletService;
        this.tradableRepository = tradableRepository;
        this.transactionListItemFactory = transactionListItemFactory;
        this.transactionAwareTradableFactory = transactionAwareTradableFactory;
    }

    void update() {
        List<TransactionsListItem> transactionsListItems = this.getTransactionListItems();
        UserThread.execute(() -> {
            this.forEach(TransactionsListItem::cleanup);
            this.setAll(transactionsListItems);
        });
    }

    private List<TransactionsListItem> getTransactionListItems() {
        List transactions = this.xmrWalletService.getTxs(false);
        return transactions.stream().map(this::convertTransactionToListItem).collect(Collectors.toList());
    }

    private TransactionsListItem convertTransactionToListItem(MoneroTxWallet transaction) {
        Set<Tradable> tradables = this.tradableRepository.getAll();
        TransactionAwareTradable maybeTradable = tradables.stream().map(this.transactionAwareTradableFactory::create).filter(tradable -> tradable.isRelatedToTransaction(transaction)).findAny().orElse(null);
        return this.transactionListItemFactory.create(transaction, maybeTradable);
    }
}

