/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.funds.reserved;

import haveno.core.locale.Res;
import haveno.core.offer.OpenOffer;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.listeners.BalanceListener;
import haveno.core.xmr.model.AddressEntry;
import haveno.core.xmr.wallet.BtcWalletService;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.util.DisplayUtils;
import java.util.Optional;
import javafx.scene.control.Label;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Transaction;

class ReservedListItem {
    private final BalanceListener balanceListener;
    private final BtcWalletService btcWalletService;
    private final CoinFormatter formatter;
    private final Label balanceLabel;
    private final OpenOffer openOffer;
    private final AddressEntry addressEntry;
    private final String addressString;
    private final Address address;
    private Coin balance;
    private String balanceString;

    public ReservedListItem(OpenOffer openOffer, AddressEntry addressEntry, BtcWalletService btcWalletService, CoinFormatter formatter) {
        this.openOffer = openOffer;
        this.addressEntry = addressEntry;
        this.btcWalletService = btcWalletService;
        this.formatter = formatter;
        this.addressString = addressEntry.getAddressString();
        this.address = addressEntry.getAddress();
        this.balanceLabel = new AutoTooltipLabel();
        this.balanceListener = new BalanceListener(this.address){

            public void onBalanceChanged(Coin balance, Transaction tx) {
                ReservedListItem.this.updateBalance();
            }
        };
        btcWalletService.addBalanceListener(this.balanceListener);
        this.updateBalance();
    }

    ReservedListItem() {
        this.openOffer = null;
        this.addressEntry = null;
        this.btcWalletService = null;
        this.formatter = null;
        this.addressString = null;
        this.address = null;
        this.balanceLabel = null;
        this.balanceListener = null;
    }

    public void cleanup() {
        this.btcWalletService.removeBalanceListener(this.balanceListener);
    }

    private void updateBalance() {
        Optional addressEntryOptional = this.btcWalletService.getAddressEntry(this.openOffer.getId(), AddressEntry.Context.RESERVED_FOR_TRADE);
        addressEntryOptional.ifPresent(addressEntry -> {
            this.balance = this.btcWalletService.getBalanceForAddress(addressEntry.getAddress());
            if (this.balance != null) {
                this.balanceString = this.formatter.formatCoin(this.balance);
                this.balanceLabel.setText(this.balanceString);
            }
        });
    }

    public String getDateAsString() {
        return DisplayUtils.formatDateTime(this.openOffer.getDate());
    }

    public String getDetails() {
        return this.openOffer != null ? Res.get((String)"funds.reserved.reserved", (Object[])new Object[]{this.openOffer.getShortId()}) : Res.get((String)"shared.noDetailsAvailable");
    }

    public Label getBalanceLabel() {
        return this.balanceLabel;
    }

    public OpenOffer getOpenOffer() {
        return this.openOffer;
    }

    public AddressEntry getAddressEntry() {
        return this.addressEntry;
    }

    public String getAddressString() {
        return this.addressString;
    }

    public Address getAddress() {
        return this.address;
    }

    public Coin getBalance() {
        return this.balance;
    }

    public String getBalanceString() {
        return this.balanceString;
    }
}

