/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.funds.locked;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.googlecode.jcsv.writer.CSVEntryConverter;
import de.jensd.fx.fontawesome.AwesomeIcon;
import haveno.core.locale.Res;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.OpenOfferManager;
import haveno.core.trade.Tradable;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.user.Preferences;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.listeners.BalanceListener;
import haveno.core.xmr.model.AddressEntry;
import haveno.core.xmr.wallet.BtcWalletService;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.HyperlinkWithIcon;
import haveno.desktop.main.funds.locked.LockedListItem;
import haveno.desktop.main.overlays.windows.OfferDetailsWindow;
import haveno.desktop.main.overlays.windows.TradeDetailsWindow;
import haveno.desktop.util.GUIUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Transaction;

@FxmlView
public class LockedView
extends ActivatableView<VBox, Void> {
    @FXML
    TableView<LockedListItem> tableView;
    @FXML
    TableColumn<LockedListItem, LockedListItem> dateColumn;
    @FXML
    TableColumn<LockedListItem, LockedListItem> detailsColumn;
    @FXML
    TableColumn<LockedListItem, LockedListItem> addressColumn;
    @FXML
    TableColumn<LockedListItem, LockedListItem> balanceColumn;
    @FXML
    Label numItems;
    @FXML
    Region spacer;
    @FXML
    AutoTooltipButton exportButton;
    private final BtcWalletService btcWalletService;
    private final TradeManager tradeManager;
    private final OpenOfferManager openOfferManager;
    private final Preferences preferences;
    private final CoinFormatter formatter;
    private final OfferDetailsWindow offerDetailsWindow;
    private final TradeDetailsWindow tradeDetailsWindow;
    private final ObservableList<LockedListItem> observableList = FXCollections.observableArrayList();
    private final SortedList<LockedListItem> sortedList = new SortedList(this.observableList);
    private BalanceListener balanceListener;
    private ListChangeListener<OpenOffer> openOfferListChangeListener;
    private ListChangeListener<Trade> tradeListChangeListener;

    @Inject
    private LockedView(BtcWalletService btcWalletService, TradeManager tradeManager, OpenOfferManager openOfferManager, Preferences preferences, @Named(value="BTC") CoinFormatter formatter, OfferDetailsWindow offerDetailsWindow, TradeDetailsWindow tradeDetailsWindow) {
        this.btcWalletService = btcWalletService;
        this.tradeManager = tradeManager;
        this.openOfferManager = openOfferManager;
        this.preferences = preferences;
        this.formatter = formatter;
        this.offerDetailsWindow = offerDetailsWindow;
        this.tradeDetailsWindow = tradeDetailsWindow;
    }

    @Override
    public void initialize() {
        this.dateColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.dateTime")));
        this.detailsColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.details")));
        this.addressColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.address")));
        this.balanceColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.balanceWithCur", (Object[])new Object[]{Res.getBaseCurrencyCode()})));
        GUIUtil.applyTableStyle(this.tableView);
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableView.setPlaceholder((Node)new AutoTooltipLabel(Res.get((String)"funds.locked.noFunds")));
        this.setDateColumnCellFactory();
        this.setDetailsColumnCellFactory();
        this.setAddressColumnCellFactory();
        this.setBalanceColumnCellFactory();
        this.addressColumn.setComparator(Comparator.comparing(LockedListItem::getAddressString));
        this.detailsColumn.setComparator(Comparator.comparing(o -> o.getTrade().getId()));
        this.balanceColumn.setComparator(Comparator.comparing(LockedListItem::getBalance));
        this.dateColumn.setComparator(Comparator.comparing(o -> this.getTradable((LockedListItem)o).map(Tradable::getDate).orElse(new Date(0L))));
        this.tableView.getSortOrder().add(this.dateColumn);
        this.dateColumn.setSortType(TableColumn.SortType.DESCENDING);
        this.balanceListener = new BalanceListener(){

            public void onBalanceChanged(Coin balance, Transaction tx) {
                LockedView.this.updateList();
            }
        };
        this.openOfferListChangeListener = c -> this.updateList();
        this.tradeListChangeListener = c -> this.updateList();
        HBox.setHgrow((Node)this.spacer, (Priority)Priority.ALWAYS);
        this.numItems.setId("num-offers");
        this.numItems.setPadding(new Insets(-5.0, 0.0, 0.0, 10.0));
        this.exportButton.updateText(Res.get((String)"shared.exportCSV"));
    }

    @Override
    protected void activate() {
        this.openOfferManager.getObservableList().addListener(this.openOfferListChangeListener);
        this.tradeManager.getObservableList().addListener(this.tradeListChangeListener);
        this.sortedList.comparatorProperty().bind((ObservableValue)this.tableView.comparatorProperty());
        this.tableView.setItems(this.sortedList);
        this.updateList();
        this.btcWalletService.addBalanceListener(this.balanceListener);
        this.numItems.setText(Res.get((String)"shared.numItemsLabel", (Object[])new Object[]{this.sortedList.size()}));
        this.exportButton.setOnAction(event -> {
            ObservableList<TableColumn<LockedListItem, ?>> tableColumns = GUIUtil.getContentColumns(this.tableView);
            int reportColumns = tableColumns.size();
            CSVEntryConverter headerConverter = item -> {
                String[] columns = new String[reportColumns];
                for (int i = 0; i < columns.length; ++i) {
                    columns[i] = ((AutoTooltipLabel)((TableColumn)tableColumns.get(i)).getGraphic()).getText();
                }
                return columns;
            };
            CSVEntryConverter contentConverter = item -> {
                String[] columns = new String[reportColumns];
                columns[0] = item.getDateString();
                columns[1] = item.getDetails();
                columns[2] = item.getAddressString();
                columns[3] = item.getBalanceString();
                return columns;
            };
            GUIUtil.exportCSV("lockedInTradesFunds.csv", headerConverter, contentConverter, new LockedListItem(), this.sortedList, (Stage)((VBox)this.root).getScene().getWindow());
        });
    }

    @Override
    protected void deactivate() {
        this.openOfferManager.getObservableList().removeListener(this.openOfferListChangeListener);
        this.tradeManager.getObservableList().removeListener(this.tradeListChangeListener);
        this.sortedList.comparatorProperty().unbind();
        this.observableList.forEach(LockedListItem::cleanup);
        this.btcWalletService.removeBalanceListener(this.balanceListener);
        this.exportButton.setOnAction(null);
    }

    private void updateList() {
        this.observableList.forEach(LockedListItem::cleanup);
        this.observableList.setAll((Collection)this.tradeManager.getTradesStreamWithFundsLockedIn().map(trade -> {
            Optional addressEntryOptional = this.btcWalletService.getAddressEntry(trade.getId(), AddressEntry.Context.MULTI_SIG);
            return addressEntryOptional.map(addressEntry -> new LockedListItem((Trade)trade, (AddressEntry)addressEntry, this.btcWalletService, this.formatter)).orElse(null);
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private Optional<Tradable> getTradable(LockedListItem item) {
        String offerId = item.getAddressEntry().getOfferId();
        Optional tradeOptional = this.tradeManager.getOpenTrade(offerId);
        if (tradeOptional.isPresent()) {
            return Optional.of((Tradable)tradeOptional.get());
        }
        if (this.openOfferManager.getOpenOffer(offerId).isPresent()) {
            return Optional.of((Tradable)this.openOfferManager.getOpenOffer(offerId).get());
        }
        return Optional.empty();
    }

    private void openDetailPopup(LockedListItem item) {
        Optional<Tradable> tradableOptional = this.getTradable(item);
        if (tradableOptional.isPresent()) {
            Tradable tradable = tradableOptional.get();
            if (tradable instanceof Trade) {
                this.tradeDetailsWindow.show((Trade)tradable);
            } else if (tradable instanceof OpenOffer) {
                this.offerDetailsWindow.show(tradable.getOffer());
            }
        }
    }

    private void setDateColumnCellFactory() {
        this.dateColumn.setCellValueFactory(addressListItem -> new ReadOnlyObjectWrapper((Object)((LockedListItem)addressListItem.getValue())));
        this.dateColumn.setCellFactory((Callback)new Callback<TableColumn<LockedListItem, LockedListItem>, TableCell<LockedListItem, LockedListItem>>(){

            public TableCell<LockedListItem, LockedListItem> call(TableColumn<LockedListItem, LockedListItem> column) {
                return new TableCell<LockedListItem, LockedListItem>(){

                    public void updateItem(LockedListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            if (LockedView.this.getTradable(item).isPresent()) {
                                this.setGraphic((Node)new AutoTooltipLabel(item.getDateString()));
                            } else {
                                this.setGraphic((Node)new AutoTooltipLabel(item.getDateString()));
                            }
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setDetailsColumnCellFactory() {
        this.detailsColumn.setCellValueFactory(addressListItem -> new ReadOnlyObjectWrapper((Object)((LockedListItem)addressListItem.getValue())));
        this.detailsColumn.setCellFactory((Callback)new Callback<TableColumn<LockedListItem, LockedListItem>, TableCell<LockedListItem, LockedListItem>>(){

            public TableCell<LockedListItem, LockedListItem> call(TableColumn<LockedListItem, LockedListItem> column) {
                return new TableCell<LockedListItem, LockedListItem>(){
                    private HyperlinkWithIcon field;

                    public void updateItem(LockedListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            Optional<Tradable> tradableOptional = LockedView.this.getTradable(item);
                            if (tradableOptional.isPresent()) {
                                this.field = new HyperlinkWithIcon(item.getDetails(), AwesomeIcon.INFO_SIGN);
                                this.field.setOnAction(event -> LockedView.this.openDetailPopup(item));
                                this.field.setTooltip(new Tooltip(Res.get((String)"tooltip.openPopupForDetails")));
                                this.setGraphic((Node)this.field);
                            } else {
                                this.setGraphic((Node)new AutoTooltipLabel(item.getDetails()));
                            }
                        } else {
                            this.setGraphic(null);
                            if (this.field != null) {
                                this.field.setOnAction(null);
                            }
                        }
                    }
                };
            }
        });
    }

    private void setAddressColumnCellFactory() {
        this.addressColumn.setCellValueFactory(addressListItem -> new ReadOnlyObjectWrapper((Object)((LockedListItem)addressListItem.getValue())));
        this.addressColumn.setCellFactory((Callback)new Callback<TableColumn<LockedListItem, LockedListItem>, TableCell<LockedListItem, LockedListItem>>(this){

            public TableCell<LockedListItem, LockedListItem> call(TableColumn<LockedListItem, LockedListItem> column) {
                return new TableCell<LockedListItem, LockedListItem>(this){

                    public void updateItem(LockedListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            String address = item.getAddressString();
                            this.setGraphic((Node)new AutoTooltipLabel(address));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setBalanceColumnCellFactory() {
        this.balanceColumn.setCellValueFactory(addressListItem -> new ReadOnlyObjectWrapper((Object)((LockedListItem)addressListItem.getValue())));
        this.balanceColumn.setCellFactory((Callback)new Callback<TableColumn<LockedListItem, LockedListItem>, TableCell<LockedListItem, LockedListItem>>(this){

            public TableCell<LockedListItem, LockedListItem> call(TableColumn<LockedListItem, LockedListItem> column) {
                return new TableCell<LockedListItem, LockedListItem>(this){

                    public void updateItem(LockedListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setGraphic((Node)(item != null && !empty ? item.getBalanceLabel() : null));
                    }
                };
            }
        });
    }
}

