/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.funds.locked;

import haveno.core.locale.Res;
import haveno.core.trade.Trade;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.listeners.BalanceListener;
import haveno.core.xmr.model.AddressEntry;
import haveno.core.xmr.wallet.BtcWalletService;
import haveno.desktop.util.DisplayUtils;
import javafx.scene.control.Label;
import javax.annotation.Nullable;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Coin;

class LockedListItem {
    private final BalanceListener balanceListener;
    private final BtcWalletService btcWalletService;
    private final CoinFormatter formatter;
    private final Label balanceLabel;
    private final Trade trade;
    private final AddressEntry addressEntry;
    private final String addressString;
    @Nullable
    private final Address address;
    private Coin balance;
    private String balanceString;

    public LockedListItem(Trade trade, AddressEntry addressEntry, BtcWalletService btcWalletService, CoinFormatter formatter) {
        this.trade = trade;
        this.addressEntry = addressEntry;
        this.btcWalletService = btcWalletService;
        this.formatter = formatter;
        throw new RuntimeException("Cannot listen to multisig deposits in xmr without exchanging multisig info");
    }

    LockedListItem() {
        this.trade = null;
        this.addressEntry = null;
        this.btcWalletService = null;
        this.formatter = null;
        this.addressString = null;
        this.address = null;
        this.balanceLabel = null;
        this.balanceListener = null;
    }

    public void cleanup() {
        this.btcWalletService.removeBalanceListener(this.balanceListener);
    }

    private void updateBalance() {
        this.balance = this.addressEntry.getCoinLockedInMultiSigAsCoin();
        this.balanceString = this.formatter.formatCoin(this.balance);
        this.balanceLabel.setText(this.balanceString);
    }

    public String getDetails() {
        return this.trade != null ? Res.get((String)"funds.locked.locked", (Object[])new Object[]{this.trade.getShortId()}) : Res.get((String)"shared.noDetailsAvailable");
    }

    public String getDateString() {
        return this.trade != null ? DisplayUtils.formatDateTime(this.trade.getDate()) : Res.get((String)"shared.noDateAvailable");
    }

    public Label getBalanceLabel() {
        return this.balanceLabel;
    }

    public Trade getTrade() {
        return this.trade;
    }

    public AddressEntry getAddressEntry() {
        return this.addressEntry;
    }

    public String getAddressString() {
        return this.addressString;
    }

    public Coin getBalance() {
        return this.balance;
    }

    public String getBalanceString() {
        return this.balanceString;
    }
}

