/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.funds.deposit;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.ThreadUtils;
import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.common.util.Tuple2;
import haveno.common.util.Tuple3;
import haveno.core.locale.Res;
import haveno.core.trade.HavenoUtils;
import haveno.core.user.Preferences;
import haveno.core.util.ParsingUtils;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.listeners.XmrBalanceListener;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.AddressTextField;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.HyperlinkWithIcon;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.TitledGroupBg;
import haveno.desktop.main.funds.deposit.DepositListItem;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.QRCodeWindow;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import monero.wallet.model.MoneroWalletListener;
import monero.wallet.model.MoneroWalletListenerI;
import net.glxn.qrgen.QRCode;
import net.glxn.qrgen.image.ImageType;
import org.bitcoinj.core.Coin;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;
import org.jetbrains.annotations.NotNull;

@FxmlView
public class DepositView
extends ActivatableView<VBox, Void> {
    @FXML
    GridPane gridPane;
    @FXML
    TableView<DepositListItem> tableView;
    @FXML
    TableColumn<DepositListItem, DepositListItem> addressColumn;
    @FXML
    TableColumn<DepositListItem, DepositListItem> balanceColumn;
    @FXML
    TableColumn<DepositListItem, DepositListItem> confirmationsColumn;
    @FXML
    TableColumn<DepositListItem, DepositListItem> usageColumn;
    private ImageView qrCodeImageView;
    private StackPane qrCodePane;
    private AddressTextField addressTextField;
    private Button generateNewAddressButton;
    private TitledGroupBg titledGroupBg;
    private InputTextField amountTextField;
    private static final String THREAD_ID = DepositView.class.getName();
    private final XmrWalletService xmrWalletService;
    private final Preferences preferences;
    private final CoinFormatter formatter;
    private String paymentLabelString;
    private final ObservableList<DepositListItem> observableList = FXCollections.observableArrayList();
    private final SortedList<DepositListItem> sortedList = new SortedList(this.observableList);
    private XmrBalanceListener balanceListener;
    private MoneroWalletListener walletListener;
    private Subscription amountTextFieldSubscription;
    private ChangeListener<DepositListItem> tableViewSelectionListener;
    private int gridRow = 0;

    @Inject
    private DepositView(XmrWalletService xmrWalletService, Preferences preferences, @Named(value="BTC") CoinFormatter formatter) {
        this.xmrWalletService = xmrWalletService;
        this.preferences = preferences;
        this.formatter = formatter;
    }

    @Override
    public void initialize() {
        GUIUtil.applyTableStyle(this.tableView);
        this.paymentLabelString = Res.get((String)"funds.deposit.fundHavenoWallet");
        this.addressColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.address")));
        this.balanceColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.balanceWithCur", (Object[])new Object[]{Res.getBaseCurrencyCode()})));
        this.confirmationsColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.confirmations")));
        this.usageColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.usage")));
        Label placeholderLabel = new Label("Loading...");
        this.tableView.setPlaceholder((Node)placeholderLabel);
        this.tableView.getStyleClass().add((Object)"non-interactive-table");
        ThreadUtils.execute(() -> {
            try {
                this.xmrWalletService.getFreshAddressEntry();
            }
            catch (Exception e) {
                this.log.warn("Failed to create fresh address entry to initialize DepositView");
                e.printStackTrace();
            }
            UserThread.execute(() -> {
                this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
                this.tableView.setPlaceholder((Node)new AutoTooltipLabel(Res.get((String)"funds.deposit.noAddresses")));
                this.tableViewSelectionListener = (observableValue, oldValue, newValue) -> {
                    if (newValue != null) {
                        this.fillForm(newValue.getAddressString());
                        GUIUtil.requestFocus((Node)this.amountTextField);
                    }
                };
                this.setAddressColumnCellFactory();
                this.setBalanceColumnCellFactory();
                this.setUsageColumnCellFactory();
                this.setConfidenceColumnCellFactory();
                this.addressColumn.setComparator(Comparator.comparing(DepositListItem::getAddressString));
                this.balanceColumn.setComparator(Comparator.comparing(DepositListItem::getBalanceAsBI));
                this.confirmationsColumn.setComparator(Comparator.comparingLong(o -> o.getNumConfirmationsSinceFirstUsed()));
                this.usageColumn.setComparator(Comparator.comparing(DepositListItem::getUsage));
                this.tableView.getSortOrder().add(this.usageColumn);
                this.tableView.setItems(this.sortedList);
                this.titledGroupBg = FormBuilder.addTitledGroupBg(this.gridPane, this.gridRow, 4, Res.get((String)"funds.deposit.fundWallet"));
                this.titledGroupBg.getStyleClass().add((Object)"last");
                Tuple2<StackPane, ImageView> qrCodeTuple = GUIUtil.getSmallXmrQrCodePane();
                this.qrCodePane = (StackPane)qrCodeTuple.first;
                this.qrCodeImageView = (ImageView)qrCodeTuple.second;
                Tooltip.install((Node)this.qrCodePane, (Tooltip)new Tooltip(Res.get((String)"shared.openLargeQRWindow")));
                this.qrCodePane.setOnMouseClicked(e -> UserThread.runAfter(() -> new QRCodeWindow(this.getPaymentUri()).show(), (long)200L, (TimeUnit)TimeUnit.MILLISECONDS));
                GridPane.setRowIndex((Node)this.qrCodePane, (Integer)this.gridRow);
                GridPane.setRowSpan((Node)this.qrCodePane, (Integer)4);
                GridPane.setColumnIndex((Node)this.qrCodePane, (Integer)1);
                GridPane.setMargin((Node)this.qrCodePane, (Insets)new Insets(20.0, 0.0, 0.0, 10.0));
                this.gridPane.getChildren().add((Object)this.qrCodePane);
                this.addressTextField = FormBuilder.addAddressTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.address"), 20.0);
                this.addressTextField.setPaymentLabel(this.paymentLabelString);
                this.amountTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"funds.deposit.amount"));
                this.amountTextField.setMaxWidth(380.0);
                if (DevEnv.isDevMode()) {
                    this.amountTextField.setText("10");
                }
                this.titledGroupBg.setVisible(false);
                this.titledGroupBg.setManaged(false);
                this.qrCodePane.setVisible(false);
                this.qrCodePane.setManaged(false);
                this.addressTextField.setVisible(false);
                this.addressTextField.setManaged(false);
                this.amountTextField.setManaged(false);
                Tuple3<Button, CheckBox, HBox> buttonCheckBoxHBox = FormBuilder.addButtonCheckBoxWithBox(this.gridPane, ++this.gridRow, Res.get((String)"funds.deposit.generateAddress"), null, 15.0);
                ((HBox)buttonCheckBoxHBox.third).setSpacing(25.0);
                this.generateNewAddressButton = (Button)buttonCheckBoxHBox.first;
                this.generateNewAddressButton.setOnAction(event -> {
                    boolean hasUnusedAddress;
                    boolean bl = hasUnusedAddress = !this.xmrWalletService.getUnusedAddressEntries().isEmpty();
                    if (hasUnusedAddress) {
                        ((Popup)new Popup().warning(Res.get((String)"funds.deposit.selectUnused"))).show();
                    } else {
                        XmrAddressEntry newSavingsAddressEntry = this.xmrWalletService.getNewAddressEntry();
                        this.updateList();
                        UserThread.execute(() -> this.observableList.stream().filter(depositListItem -> depositListItem.getAddressString().equals(newSavingsAddressEntry.getAddressString())).findAny().ifPresent(depositListItem -> this.tableView.getSelectionModel().select(depositListItem)));
                    }
                });
                this.balanceListener = new XmrBalanceListener(){

                    public void onBalanceChanged(BigInteger balance) {
                        DepositView.this.updateList();
                    }
                };
                this.walletListener = new MoneroWalletListener(){

                    public void onNewBlock(long height) {
                        DepositView.this.updateList();
                    }
                };
                GUIUtil.focusWhenAddedToScene((Node)this.amountTextField);
            });
        }, (String)THREAD_ID);
    }

    @Override
    protected void activate() {
        ThreadUtils.execute(() -> UserThread.execute(() -> {
            this.tableView.getSelectionModel().selectedItemProperty().addListener(this.tableViewSelectionListener);
            this.sortedList.comparatorProperty().bind((ObservableValue)this.tableView.comparatorProperty());
            try {
                this.updateList();
            }
            catch (Exception e) {
                this.log.warn("Could not update deposits list");
                e.printStackTrace();
            }
            this.xmrWalletService.addBalanceListener(this.balanceListener);
            this.xmrWalletService.addWalletListener((MoneroWalletListenerI)this.walletListener);
            this.amountTextFieldSubscription = EasyBind.subscribe((ObservableValue)this.amountTextField.textProperty(), t -> {
                this.addressTextField.setAmount(HavenoUtils.parseXmr((String)t));
                this.updateQRCode();
            });
            if (this.tableView.getSelectionModel().getSelectedItem() == null && !this.sortedList.isEmpty()) {
                this.tableView.getSelectionModel().select(0);
            }
        }), (String)THREAD_ID);
    }

    @Override
    protected void deactivate() {
        ThreadUtils.execute(() -> {
            this.tableView.getSelectionModel().selectedItemProperty().removeListener(this.tableViewSelectionListener);
            this.sortedList.comparatorProperty().unbind();
            this.observableList.forEach(DepositListItem::cleanup);
            this.xmrWalletService.removeBalanceListener(this.balanceListener);
            this.xmrWalletService.removeWalletListener((MoneroWalletListenerI)this.walletListener);
            this.amountTextFieldSubscription.unsubscribe();
        }, (String)THREAD_ID);
    }

    private void fillForm(String address) {
        this.titledGroupBg.setVisible(true);
        this.titledGroupBg.setManaged(true);
        this.qrCodePane.setVisible(true);
        this.qrCodePane.setManaged(true);
        this.addressTextField.setVisible(true);
        this.addressTextField.setManaged(true);
        this.amountTextField.setManaged(true);
        GridPane.setMargin((Node)this.generateNewAddressButton, (Insets)new Insets(15.0, 0.0, 0.0, 0.0));
        this.addressTextField.setAddress(address);
        this.updateQRCode();
    }

    private void updateQRCode() {
        if (this.addressTextField.getAddress() != null && !this.addressTextField.getAddress().isEmpty()) {
            byte[] imageBytes = QRCode.from((String)this.getPaymentUri()).withSize(300, 300).to(ImageType.PNG).stream().toByteArray();
            Image qrImage = new Image((InputStream)new ByteArrayInputStream(imageBytes));
            this.qrCodeImageView.setImage(qrImage);
        }
    }

    private void updateList() {
        List addressEntries = this.xmrWalletService.getAddressEntries();
        ArrayList<DepositListItem> items = new ArrayList<DepositListItem>();
        for (XmrAddressEntry addressEntry : addressEntries) {
            if (addressEntry.isTradePayout()) continue;
            items.add(new DepositListItem(addressEntry, this.xmrWalletService, this.formatter));
        }
        UserThread.execute(() -> {
            this.observableList.forEach(DepositListItem::cleanup);
            this.observableList.clear();
            for (DepositListItem item : items) {
                this.observableList.add((Object)item);
            }
        });
    }

    private Coin getAmount() {
        return ParsingUtils.parseToCoin((String)this.amountTextField.getText(), (CoinFormatter)this.formatter);
    }

    @NotNull
    private String getPaymentUri() {
        return GUIUtil.getMoneroURI(this.addressTextField.getAddress(), HavenoUtils.coinToAtomicUnits((Coin)this.getAmount()), this.paymentLabelString);
    }

    private void setUsageColumnCellFactory() {
        this.usageColumn.setCellValueFactory(addressListItem -> new ReadOnlyObjectWrapper((Object)((DepositListItem)addressListItem.getValue())));
        this.usageColumn.setCellFactory((Callback)new Callback<TableColumn<DepositListItem, DepositListItem>, TableCell<DepositListItem, DepositListItem>>(this){

            public TableCell<DepositListItem, DepositListItem> call(TableColumn<DepositListItem, DepositListItem> column) {
                return new TableCell<DepositListItem, DepositListItem>(this){

                    public void updateItem(DepositListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            AutoTooltipLabel usageLabel = new AutoTooltipLabel(item.getUsage());
                            usageLabel.getStyleClass().add((Object)"highlight-text");
                            this.setGraphic((Node)usageLabel);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setAddressColumnCellFactory() {
        this.addressColumn.setCellValueFactory(addressListItem -> new ReadOnlyObjectWrapper((Object)((DepositListItem)addressListItem.getValue())));
        this.addressColumn.setCellFactory((Callback)new Callback<TableColumn<DepositListItem, DepositListItem>, TableCell<DepositListItem, DepositListItem>>(this){

            public TableCell<DepositListItem, DepositListItem> call(TableColumn<DepositListItem, DepositListItem> column) {
                return new TableCell<DepositListItem, DepositListItem>(this){
                    private HyperlinkWithIcon field;

                    public void updateItem(DepositListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            String address = item.getAddressString();
                            this.setGraphic((Node)new AutoTooltipLabel(address));
                        } else {
                            this.setGraphic(null);
                            if (this.field != null) {
                                this.field.setOnAction(null);
                            }
                        }
                    }
                };
            }
        });
    }

    private void setBalanceColumnCellFactory() {
        this.balanceColumn.setCellValueFactory(addressListItem -> new ReadOnlyObjectWrapper((Object)((DepositListItem)addressListItem.getValue())));
        this.balanceColumn.getStyleClass().add((Object)"highlight-text");
        this.balanceColumn.setCellFactory((Callback)new Callback<TableColumn<DepositListItem, DepositListItem>, TableCell<DepositListItem, DepositListItem>>(this){

            public TableCell<DepositListItem, DepositListItem> call(TableColumn<DepositListItem, DepositListItem> column) {
                return new TableCell<DepositListItem, DepositListItem>(this){

                    public void updateItem(DepositListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            if (this.textProperty().isBound()) {
                                this.textProperty().unbind();
                            }
                            this.textProperty().bind((ObservableValue)item.balanceProperty());
                        } else {
                            this.textProperty().unbind();
                            this.setText("");
                        }
                    }
                };
            }
        });
    }

    private void setConfidenceColumnCellFactory() {
        this.confirmationsColumn.setCellValueFactory(addressListItem -> new ReadOnlyObjectWrapper((Object)((DepositListItem)addressListItem.getValue())));
        this.confirmationsColumn.setCellFactory((Callback)new Callback<TableColumn<DepositListItem, DepositListItem>, TableCell<DepositListItem, DepositListItem>>(this){

            public TableCell<DepositListItem, DepositListItem> call(TableColumn<DepositListItem, DepositListItem> column) {
                return new TableCell<DepositListItem, DepositListItem>(this){

                    public void updateItem(DepositListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)item.getTxConfidenceIndicator());
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }
}

