/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.funds.deposit;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import haveno.core.locale.Res;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.components.indicator.TxConfidenceIndicator;
import haveno.desktop.util.GUIUtil;
import java.math.BigInteger;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Tooltip;
import monero.daemon.model.MoneroTx;
import monero.wallet.model.MoneroTxWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DepositListItem {
    private static final Logger log = LoggerFactory.getLogger(DepositListItem.class);
    private final StringProperty balance = new SimpleStringProperty();
    private final XmrAddressEntry addressEntry;
    private final XmrWalletService xmrWalletService;
    private BigInteger balanceAsBI;
    private String usage = "-";
    private int numTxsWithOutputs = 0;
    private final Supplier<LazyFields> lazyFieldsSupplier;

    private LazyFields lazy() {
        return (LazyFields)this.lazyFieldsSupplier.get();
    }

    DepositListItem(XmrAddressEntry addressEntry, XmrWalletService xmrWalletService, CoinFormatter formatter) {
        this.xmrWalletService = xmrWalletService;
        this.addressEntry = addressEntry;
        this.balanceAsBI = xmrWalletService.getBalanceForSubaddress(addressEntry.getSubaddressIndex(), true);
        this.balance.set((Object)HavenoUtils.formatXmr((BigInteger)this.balanceAsBI));
        this.updateUsage(addressEntry.getSubaddressIndex());
        this.lazyFieldsSupplier = Suppliers.memoize(() -> new LazyFields(){
            {
                this.txConfidenceIndicator = new TxConfidenceIndicator();
                this.txConfidenceIndicator.setId("funds-confidence");
                this.tooltip = new Tooltip(Res.get((String)"shared.notUsedYet"));
                this.txConfidenceIndicator.setProgress(0.0);
                this.txConfidenceIndicator.setTooltip(this.tooltip);
                MoneroTxWallet tx = DepositListItem.this.getTxWithFewestConfirmations();
                if (tx == null) {
                    this.txConfidenceIndicator.setVisible(false);
                } else {
                    GUIUtil.updateConfidence((MoneroTx)tx, this.tooltip, this.txConfidenceIndicator);
                    this.txConfidenceIndicator.setVisible(true);
                }
            }
        });
    }

    private void updateUsage(int subaddressIndex) {
        this.numTxsWithOutputs = this.xmrWalletService.getNumTxsWithIncomingOutputs(this.addressEntry.getSubaddressIndex());
        switch (this.addressEntry.getContext()) {
            case BASE_ADDRESS: {
                this.usage = Res.get((String)"funds.deposit.baseAddress");
                break;
            }
            case AVAILABLE: {
                this.usage = this.numTxsWithOutputs == 0 ? Res.get((String)"funds.deposit.unused") : Res.get((String)"funds.deposit.usedInTx", (Object[])new Object[]{this.numTxsWithOutputs});
                break;
            }
            case OFFER_FUNDING: {
                this.usage = Res.get((String)"funds.deposit.offerFunding", (Object[])new Object[]{this.addressEntry.getShortOfferId()});
                break;
            }
            case TRADE_PAYOUT: {
                this.usage = Res.get((String)"funds.deposit.tradePayout", (Object[])new Object[]{this.addressEntry.getShortOfferId()});
                break;
            }
            default: {
                this.usage = this.addressEntry.getContext().toString();
            }
        }
    }

    public void cleanup() {
    }

    public TxConfidenceIndicator getTxConfidenceIndicator() {
        return this.lazy().txConfidenceIndicator;
    }

    public String getAddressString() {
        return this.addressEntry.getAddressString();
    }

    public int getSubaddressIndex() {
        return this.addressEntry.getSubaddressIndex();
    }

    public String getUsage() {
        return this.usage;
    }

    public final StringProperty balanceProperty() {
        return this.balance;
    }

    public String getBalance() {
        return (String)this.balance.get();
    }

    public BigInteger getBalanceAsBI() {
        return this.balanceAsBI;
    }

    public int getNumTxsWithOutputs() {
        return this.numTxsWithOutputs;
    }

    public long getNumConfirmationsSinceFirstUsed() {
        MoneroTxWallet tx = this.getTxWithFewestConfirmations();
        return tx == null ? 0L : tx.getNumConfirmations();
    }

    private MoneroTxWallet getTxWithFewestConfirmations() {
        List txs = this.xmrWalletService.getTxsWithIncomingOutputs(Integer.valueOf(this.addressEntry.getSubaddressIndex()));
        MoneroTxWallet highestTx = null;
        for (MoneroTxWallet tx : txs) {
            if (highestTx != null && tx.getHeight() != null && (highestTx.getHeight() == null || tx.getHeight() <= highestTx.getHeight())) continue;
            highestTx = tx;
        }
        return highestTx;
    }

    private static class LazyFields {
        TxConfidenceIndicator txConfidenceIndicator;
        Tooltip tooltip;

        private LazyFields() {
        }
    }
}

