/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.funds;

import com.google.inject.Inject;
import haveno.core.locale.Res;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.CachingViewLoader;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.common.view.View;
import haveno.desktop.common.view.ViewLoader;
import haveno.desktop.main.MainView;
import haveno.desktop.main.funds.deposit.DepositView;
import haveno.desktop.main.funds.transactions.TransactionsView;
import haveno.desktop.main.funds.withdrawal.WithdrawalView;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

@FxmlView
public class FundsView
extends ActivatableView<TabPane, Void> {
    @FXML
    Tab depositTab;
    @FXML
    Tab withdrawalTab;
    @FXML
    Tab transactionsTab;
    private Navigation.Listener navigationListener;
    private ChangeListener<Tab> tabChangeListener;
    private Tab currentTab;
    private final ViewLoader viewLoader;
    private final Navigation navigation;

    @Inject
    public FundsView(CachingViewLoader viewLoader, Navigation navigation) {
        this.viewLoader = viewLoader;
        this.navigation = navigation;
    }

    @Override
    public void initialize() {
        this.depositTab.setText(Res.get((String)"funds.tab.deposit"));
        this.withdrawalTab.setText(Res.get((String)"funds.tab.withdrawal"));
        this.transactionsTab.setText(Res.get((String)"funds.tab.transactions"));
        this.navigationListener = (viewPath, data) -> {
            if (viewPath.size() == 3 && viewPath.indexOf(FundsView.class) == 1) {
                this.loadView(viewPath.tip());
            }
        };
        this.tabChangeListener = (ov, oldValue, newValue) -> {
            if (newValue == this.depositTab) {
                this.navigation.navigateTo(MainView.class, FundsView.class, DepositView.class);
            } else if (newValue == this.withdrawalTab) {
                this.navigation.navigateTo(MainView.class, FundsView.class, WithdrawalView.class);
            } else if (newValue == this.transactionsTab) {
                this.navigation.navigateTo(MainView.class, FundsView.class, TransactionsView.class);
            }
        };
    }

    @Override
    protected void activate() {
        ((TabPane)this.root).getSelectionModel().selectedItemProperty().addListener(this.tabChangeListener);
        this.navigation.addListener(this.navigationListener);
        if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.depositTab) {
            this.navigation.navigateTo(MainView.class, FundsView.class, DepositView.class);
        } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.withdrawalTab) {
            this.navigation.navigateTo(MainView.class, FundsView.class, WithdrawalView.class);
        } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.transactionsTab) {
            this.navigation.navigateTo(MainView.class, FundsView.class, TransactionsView.class);
        }
    }

    @Override
    protected void deactivate() {
        ((TabPane)this.root).getSelectionModel().selectedItemProperty().removeListener(this.tabChangeListener);
        this.navigation.removeListener(this.navigationListener);
        this.currentTab = null;
    }

    private void loadView(Class<? extends View> viewClass) {
        View view;
        if (this.currentTab != null) {
            this.currentTab.setContent(null);
        }
        if ((view = this.viewLoader.load(viewClass)) instanceof DepositView) {
            this.currentTab = this.depositTab;
        } else if (view instanceof WithdrawalView) {
            this.currentTab = this.withdrawalTab;
        } else if (view instanceof TransactionsView) {
            this.currentTab = this.transactionsTab;
        }
        this.currentTab.setContent(view.getRoot());
        ((TabPane)this.root).getSelectionModel().select((Object)this.currentTab);
    }
}

