/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.debug;

import com.google.inject.Inject;
import haveno.common.taskrunner.Task;
import haveno.common.util.Tuple2;
import haveno.core.offer.availability.tasks.ProcessOfferAvailabilityResponse;
import haveno.core.offer.availability.tasks.SendOfferAvailabilityRequest;
import haveno.core.offer.placeoffer.tasks.MakerReserveOfferFunds;
import haveno.core.offer.placeoffer.tasks.MaybeAddToOfferBook;
import haveno.core.offer.placeoffer.tasks.ValidateOffer;
import haveno.core.trade.protocol.tasks.ApplyFilter;
import haveno.core.trade.protocol.tasks.BuyerPreparePaymentSentMessage;
import haveno.core.trade.protocol.tasks.BuyerSendPaymentSentMessage;
import haveno.core.trade.protocol.tasks.MakerSetLockTime;
import haveno.core.trade.protocol.tasks.ProcessPaymentReceivedMessage;
import haveno.core.trade.protocol.tasks.ProcessPaymentSentMessage;
import haveno.core.trade.protocol.tasks.SellerPreparePaymentReceivedMessage;
import haveno.core.trade.protocol.tasks.SellerSendPaymentReceivedMessageToBuyer;
import haveno.core.trade.protocol.tasks.VerifyPeersAccountAgeWitness;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.common.view.InitializableView;
import haveno.desktop.components.TitledGroupBg;
import haveno.desktop.util.FormBuilder;
import java.util.Arrays;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.GridPane;
import javafx.util.StringConverter;

@FxmlView
public class DebugView
extends InitializableView<GridPane, Void> {
    @FXML
    TitledGroupBg titledGroupBg;
    private int rowIndex = 0;

    @Inject
    public DebugView() {
    }

    @Override
    public void initialize() {
        this.addGroup("OfferAvailabilityProtocol", (ObservableList<Class<? extends Task>>)FXCollections.observableArrayList(Arrays.asList(SendOfferAvailabilityRequest.class, ProcessOfferAvailabilityResponse.class)));
        this.addGroup("PlaceOfferProtocol", (ObservableList<Class<? extends Task>>)FXCollections.observableArrayList(Arrays.asList(ValidateOffer.class, MakerReserveOfferFunds.class, MaybeAddToOfferBook.class)));
        this.addGroup("SellerAsTakerProtocol", (ObservableList<Class<? extends Task>>)FXCollections.observableArrayList(Arrays.asList(ApplyFilter.class, ApplyFilter.class, VerifyPeersAccountAgeWitness.class, ProcessPaymentSentMessage.class, ApplyFilter.class, ApplyFilter.class, SellerPreparePaymentReceivedMessage.class, SellerSendPaymentReceivedMessageToBuyer.class)));
        this.addGroup("BuyerAsMakerProtocol", (ObservableList<Class<? extends Task>>)FXCollections.observableArrayList(Arrays.asList(ApplyFilter.class, VerifyPeersAccountAgeWitness.class, MakerSetLockTime.class, ApplyFilter.class, BuyerPreparePaymentSentMessage.class, BuyerSendPaymentSentMessage.class, ProcessPaymentReceivedMessage.class)));
        this.addGroup("BuyerAsTakerProtocol", (ObservableList<Class<? extends Task>>)FXCollections.observableArrayList(Arrays.asList(ApplyFilter.class, ApplyFilter.class, VerifyPeersAccountAgeWitness.class, ApplyFilter.class, BuyerPreparePaymentSentMessage.class, BuyerSendPaymentSentMessage.class, ProcessPaymentReceivedMessage.class)));
        this.addGroup("SellerAsMakerProtocol", (ObservableList<Class<? extends Task>>)FXCollections.observableArrayList(Arrays.asList(ApplyFilter.class, VerifyPeersAccountAgeWitness.class, MakerSetLockTime.class, ProcessPaymentSentMessage.class, ApplyFilter.class, ApplyFilter.class, SellerPreparePaymentReceivedMessage.class, SellerSendPaymentReceivedMessageToBuyer.class)));
    }

    private void addGroup(String title, ObservableList<Class<? extends Task>> list) {
        Tuple2 selectTaskToIntercept = FormBuilder.addTopLabelComboBox((GridPane)this.root, ++this.rowIndex, title, "Select task to intercept", 15);
        ComboBox comboBox = (ComboBox)selectTaskToIntercept.second;
        comboBox.setVisibleRowCount(list.size());
        comboBox.setItems(list);
        comboBox.setConverter((StringConverter)new StringConverter<Class<? extends Task>>(this){

            public String toString(Class<? extends Task> item) {
                return item.getSimpleName();
            }

            public Class<? extends Task> fromString(String s) {
                return null;
            }
        });
        comboBox.setOnAction(event -> {
            Task.taskToIntercept = (Class)comboBox.getSelectionModel().getSelectedItem();
        });
    }
}

