/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.account.register.signing;

import com.google.inject.Inject;
import haveno.common.util.Utilities;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.main.overlays.windows.SignPaymentAccountsWindow;
import haveno.desktop.main.overlays.windows.SignSpecificWitnessWindow;
import haveno.desktop.main.overlays.windows.SignUnsignedPubKeysWindow;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;

@FxmlView
public class SigningView
extends ActivatableView<AnchorPane, Void> {
    private final SignPaymentAccountsWindow signPaymentAccountsWindow;
    private final SignSpecificWitnessWindow signSpecificWitnessWindow;
    private final SignUnsignedPubKeysWindow signUnsignedPubKeysWindow;
    private EventHandler<KeyEvent> keyEventEventHandler;
    private Scene scene;

    @Inject
    public SigningView(SignPaymentAccountsWindow signPaymentAccountsWindow, SignSpecificWitnessWindow signSpecificWitnessWindow, SignUnsignedPubKeysWindow signUnsignedPubKeysWindow) {
        this.signPaymentAccountsWindow = signPaymentAccountsWindow;
        this.signSpecificWitnessWindow = signSpecificWitnessWindow;
        this.signUnsignedPubKeysWindow = signUnsignedPubKeysWindow;
        this.keyEventEventHandler = this::handleKeyPressed;
    }

    @Override
    protected void activate() {
        this.scene = ((AnchorPane)this.root).getScene();
        if (this.scene != null) {
            this.scene.addEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
        }
    }

    @Override
    protected void deactivate() {
        if (this.scene != null) {
            this.scene.removeEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
        }
    }

    protected void handleKeyPressed(KeyEvent event) {
        if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.S, (KeyEvent)event)) {
            this.signPaymentAccountsWindow.show();
        } else if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.P, (KeyEvent)event)) {
            this.signSpecificWitnessWindow.show();
        } else if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.O, (KeyEvent)event)) {
            this.signUnsignedPubKeysWindow.show();
        }
    }
}

