/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.account.register;

import haveno.common.crypto.KeyRing;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.locale.LanguageUtil;
import haveno.core.support.dispute.agent.DisputeAgent;
import haveno.core.support.dispute.agent.DisputeAgentManager;
import haveno.core.user.User;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.common.model.ActivatableViewModel;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Utils;

public abstract class AgentRegistrationViewModel<R extends DisputeAgent, T extends DisputeAgentManager<R>>
extends ActivatableViewModel {
    private final T disputeAgentManager;
    protected final User user;
    protected final P2PService p2PService;
    protected final XmrWalletService xmrWalletService;
    protected final KeyRing keyRing;
    final BooleanProperty registrationEditDisabled = new SimpleBooleanProperty(true);
    final BooleanProperty revokeButtonDisabled = new SimpleBooleanProperty(true);
    final ObjectProperty<R> myDisputeAgentProperty = new SimpleObjectProperty();
    protected final ObservableList<String> languageCodes = FXCollections.observableArrayList((Object[])new String[]{LanguageUtil.getDefaultLanguageLocaleAsCode()});
    final ObservableList<String> allLanguageCodes = FXCollections.observableArrayList((Collection)LanguageUtil.getAllLanguageCodes());
    private boolean allDataValid;
    private final MapChangeListener<NodeAddress, R> mapChangeListener;
    protected ECKey registrationKey;
    final StringProperty registrationPubKeyAsHex = new SimpleStringProperty();

    public AgentRegistrationViewModel(T disputeAgentManager, User user, P2PService p2PService, XmrWalletService xmrWalletService, KeyRing keyRing) {
        this.disputeAgentManager = disputeAgentManager;
        this.user = user;
        this.p2PService = p2PService;
        this.xmrWalletService = xmrWalletService;
        this.keyRing = keyRing;
        this.mapChangeListener = change -> {
            R registeredDisputeAgentFromUser = this.getRegisteredDisputeAgentFromUser();
            this.myDisputeAgentProperty.set(registeredDisputeAgentFromUser);
            if (registeredDisputeAgentFromUser != null) {
                this.languageCodes.setAll((Collection)registeredDisputeAgentFromUser.getLanguageCodes());
            }
            this.updateDisableStates();
        };
    }

    @Override
    protected void activate() {
        this.disputeAgentManager.getObservableMap().addListener(this.mapChangeListener);
        this.myDisputeAgentProperty.set(this.getRegisteredDisputeAgentFromUser());
        this.updateDisableStates();
    }

    protected abstract R getRegisteredDisputeAgentFromUser();

    @Override
    protected void deactivate() {
        this.disputeAgentManager.getObservableMap().removeListener(this.mapChangeListener);
    }

    void onAddLanguage(String code) {
        if (code != null && !this.languageCodes.contains((Object)code)) {
            this.languageCodes.add((Object)code);
        }
        this.updateDisableStates();
    }

    void onRemoveLanguage(String code) {
        if (code != null && this.languageCodes.contains((Object)code)) {
            this.languageCodes.remove((Object)code);
        }
        this.updateDisableStates();
    }

    boolean setPrivKeyAndCheckPubKey(String privKeyString) {
        ECKey registrationKey = this.disputeAgentManager.getRegistrationKey(privKeyString);
        if (registrationKey != null) {
            String _registrationPubKeyAsHex = Utils.HEX.encode(registrationKey.getPubKey());
            boolean isKeyValid = this.disputeAgentManager.isPublicKeyInList(_registrationPubKeyAsHex);
            if (isKeyValid) {
                this.registrationKey = registrationKey;
                this.registrationPubKeyAsHex.set((Object)_registrationPubKeyAsHex);
            }
            this.updateDisableStates();
            return isKeyValid;
        }
        this.updateDisableStates();
        return false;
    }

    protected abstract R getDisputeAgent(String var1, String var2);

    void onRegister(ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.updateDisableStates();
        if (this.allDataValid) {
            String registrationSignature = this.disputeAgentManager.signStorageSignaturePubKey(this.registrationKey);
            String emailAddress = null;
            R disputeAgent = this.getDisputeAgent(registrationSignature, emailAddress);
            this.disputeAgentManager.addDisputeAgent(disputeAgent, () -> {
                this.updateDisableStates();
                resultHandler.handleResult();
            }, errorMessage -> {
                this.updateDisableStates();
                errorMessageHandler.handleErrorMessage(errorMessage);
            });
        }
    }

    void onRevoke(ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.disputeAgentManager.removeDisputeAgent(() -> {
            this.updateDisableStates();
            resultHandler.handleResult();
        }, errorMessage -> {
            this.updateDisableStates();
            errorMessageHandler.handleErrorMessage(errorMessage);
        });
    }

    private void updateDisableStates() {
        this.allDataValid = this.languageCodes.size() > 0 && this.registrationKey != null && this.registrationPubKeyAsHex.get() != null;
        this.registrationEditDisabled.set(!this.allDataValid || this.myDisputeAgentProperty.get() != null);
        this.revokeButtonDisabled.set(!this.allDataValid || this.myDisputeAgentProperty.get() == null);
    }

    boolean isBootstrappedOrShowPopup() {
        return GUIUtil.isBootstrappedOrShowPopup(this.p2PService);
    }
}

