/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.account.register;

import haveno.common.UserThread;
import haveno.common.util.Tuple2;
import haveno.common.util.Tuple3;
import haveno.core.locale.LanguageUtil;
import haveno.core.locale.Res;
import haveno.core.support.dispute.agent.DisputeAgent;
import haveno.desktop.common.view.ActivatableViewAndModel;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.TitledGroupBg;
import haveno.desktop.main.account.register.AgentRegistrationViewModel;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.UnlockDisputeAgentRegistrationWindow;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.ImageUtil;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;

public abstract class AgentRegistrationView<R extends DisputeAgent, T extends AgentRegistrationViewModel<R, ?>>
extends ActivatableViewAndModel<VBox, T> {
    private final boolean useDevPrivilegeKeys;
    private ListView<String> languagesListView;
    private ComboBox<String> languageComboBox;
    private int gridRow = 0;
    private ChangeListener<R> changeListener;
    private UnlockDisputeAgentRegistrationWindow unlockDisputeAgentRegistrationWindow;
    private ListChangeListener<String> listChangeListener;

    public AgentRegistrationView(T model, boolean useDevPrivilegeKeys) {
        super(model);
        this.useDevPrivilegeKeys = useDevPrivilegeKeys;
    }

    @Override
    public void initialize() {
        this.buildUI();
        this.languageComboBox.setItems(((AgentRegistrationViewModel)this.model).allLanguageCodes);
        this.changeListener = (observable, oldValue, newValue) -> this.updateLanguageList();
    }

    @Override
    protected void activate() {
    }

    @Override
    protected void deactivate() {
        ((AgentRegistrationViewModel)this.model).myDisputeAgentProperty.removeListener(this.changeListener);
        this.languagesListView.getItems().removeListener(this.listChangeListener);
    }

    public void onTabSelection(boolean isSelectedTab) {
        if (isSelectedTab) {
            ((AgentRegistrationViewModel)this.model).myDisputeAgentProperty.addListener(this.changeListener);
            this.updateLanguageList();
            if (((AgentRegistrationViewModel)this.model).registrationPubKeyAsHex.get() == null && this.unlockDisputeAgentRegistrationWindow == null) {
                this.unlockDisputeAgentRegistrationWindow = new UnlockDisputeAgentRegistrationWindow(this.useDevPrivilegeKeys);
                ((UnlockDisputeAgentRegistrationWindow)((UnlockDisputeAgentRegistrationWindow)this.unlockDisputeAgentRegistrationWindow.onClose(() -> {
                    this.unlockDisputeAgentRegistrationWindow = null;
                })).onKey(((AgentRegistrationViewModel)this.model)::setPrivKeyAndCheckPubKey).width(700.0)).show();
            }
        } else {
            ((AgentRegistrationViewModel)this.model).myDisputeAgentProperty.removeListener(this.changeListener);
        }
    }

    private void updateLanguageList() {
        this.languagesListView.setItems(((AgentRegistrationViewModel)this.model).languageCodes);
        this.languagesListView.setPrefHeight((double)this.languagesListView.getItems().size() * 34.0 + 2.0);
        this.listChangeListener = c -> this.languagesListView.setPrefHeight((double)this.languagesListView.getItems().size() * 34.0 + 2.0);
        this.languagesListView.getItems().addListener(this.listChangeListener);
    }

    private void buildUI() {
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(30.0, 25.0, -1.0, 25.0));
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        ColumnConstraints columnConstraints1 = new ColumnConstraints();
        columnConstraints1.setHgrow(Priority.SOMETIMES);
        columnConstraints1.setMinWidth(200.0);
        columnConstraints1.setMaxWidth(500.0);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints1});
        ((VBox)this.root).getChildren().add((Object)gridPane);
        FormBuilder.addTitledGroupBg(gridPane, this.gridRow, 4, Res.get((String)"account.arbitratorRegistration.registration", (Object[])new Object[]{this.getRole()}));
        TextField pubKeyTextField = (TextField)FormBuilder.addTopLabelTextField((GridPane)gridPane, (int)this.gridRow, (String)Res.get((String)"account.arbitratorRegistration.pubKey"), (String)((String)((AgentRegistrationViewModel)this.model).registrationPubKeyAsHex.get()), (double)20.0).second;
        pubKeyTextField.textProperty().bind((ObservableValue)((AgentRegistrationViewModel)this.model).registrationPubKeyAsHex);
        Tuple3 tuple = FormBuilder.addTopLabelListView(gridPane, ++this.gridRow, Res.get((String)"shared.yourLanguage"));
        GridPane.setValignment((Node)((Node)tuple.first), (VPos)VPos.TOP);
        this.languagesListView = (ListView)tuple.second;
        this.languagesListView.disableProperty().bind((ObservableValue)((AgentRegistrationViewModel)this.model).registrationEditDisabled);
        this.languagesListView.setMinHeight(104.0);
        this.languagesListView.setMaxHeight(206.0);
        this.languagesListView.setCellFactory((Callback)new Callback<ListView<String>, ListCell<String>>(){

            public ListCell<String> call(ListView<String> list) {
                return new ListCell<String>(){
                    final Label label = new AutoTooltipLabel();
                    final ImageView icon = ImageUtil.getImageViewById("image-remove");
                    final Button removeButton = new AutoTooltipButton("", (Node)this.icon);
                    final AnchorPane pane = new AnchorPane(new Node[]{this.label, this.removeButton});
                    {
                        this.label.setLayoutY(5.0);
                        this.removeButton.setId("icon-button");
                        AnchorPane.setRightAnchor((Node)this.removeButton, (Double)0.0);
                    }

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.label.setText(LanguageUtil.getDisplayName((String)item));
                            this.removeButton.setOnAction(e -> AgentRegistrationView.this.onRemoveLanguage(item));
                            this.setGraphic((Node)this.pane);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        this.languageComboBox = FormBuilder.addComboBox(gridPane, ++this.gridRow);
        this.languageComboBox.disableProperty().bind((ObservableValue)((AgentRegistrationViewModel)this.model).registrationEditDisabled);
        this.languageComboBox.setPromptText(Res.get((String)"shared.addLanguage"));
        this.languageComboBox.setConverter((StringConverter)new StringConverter<String>(this){

            public String toString(String code) {
                return LanguageUtil.getDisplayName((String)code);
            }

            public String fromString(String s) {
                return null;
            }
        });
        this.languageComboBox.setOnAction(e -> this.onAddLanguage());
        Tuple2<Button, Button> buttonButtonTuple2 = FormBuilder.add2ButtonsAfterGroup(gridPane, ++this.gridRow, Res.get((String)"account.arbitratorRegistration.register"), Res.get((String)"account.arbitratorRegistration.revoke"));
        Button registerButton = (Button)buttonButtonTuple2.first;
        registerButton.disableProperty().bind((ObservableValue)((AgentRegistrationViewModel)this.model).registrationEditDisabled);
        registerButton.setOnAction(e -> this.onRegister());
        Button revokeButton = (Button)buttonButtonTuple2.second;
        revokeButton.setDefaultButton(false);
        revokeButton.disableProperty().bind((ObservableValue)((AgentRegistrationViewModel)this.model).revokeButtonDisabled);
        revokeButton.setOnAction(e -> this.onRevoke());
        TitledGroupBg titledGroupBg = FormBuilder.addTitledGroupBg(gridPane, ++this.gridRow, 2, Res.get((String)"shared.information"), 40.0);
        titledGroupBg.getStyleClass().add((Object)"last");
        Label infoLabel = FormBuilder.addMultilineLabel(gridPane, this.gridRow);
        GridPane.setMargin((Node)infoLabel, (Insets)new Insets(80.0, 0.0, 0.0, 0.0));
        infoLabel.setText(Res.get((String)"account.arbitratorRegistration.info.msg", (Object[])new Object[]{this.getRole().toLowerCase()}));
    }

    protected abstract String getRole();

    private void onAddLanguage() {
        ((AgentRegistrationViewModel)this.model).onAddLanguage((String)this.languageComboBox.getSelectionModel().getSelectedItem());
        UserThread.execute(() -> this.languageComboBox.getSelectionModel().clearSelection());
    }

    private void onRemoveLanguage(String locale) {
        ((AgentRegistrationViewModel)this.model).onRemoveLanguage(locale);
        if (this.languagesListView.getItems().size() == 0) {
            ((Popup)new Popup().warning(Res.get((String)"account.arbitratorRegistration.warn.min1Language"))).show();
            ((AgentRegistrationViewModel)this.model).onAddLanguage(LanguageUtil.getDefaultLanguageLocaleAsCode());
        }
    }

    private void onRevoke() {
        if (((AgentRegistrationViewModel)this.model).isBootstrappedOrShowPopup()) {
            ((AgentRegistrationViewModel)this.model).onRevoke(() -> ((Popup)new Popup().feedback(Res.get((String)"account.arbitratorRegistration.removedSuccess"))).show(), errorMessage -> ((Popup)new Popup().error(Res.get((String)"account.arbitratorRegistration.removedFailed", (Object[])new Object[]{Res.get((String)"shared.errorMessageInline", (Object[])new Object[]{errorMessage})}))).show());
        }
    }

    private void onRegister() {
        if (((AgentRegistrationViewModel)this.model).isBootstrappedOrShowPopup()) {
            ((AgentRegistrationViewModel)this.model).onRegister(() -> ((Popup)new Popup().feedback(Res.get((String)"account.arbitratorRegistration.registerSuccess"))).show(), errorMessage -> ((Popup)new Popup().error(Res.get((String)"account.arbitratorRegistration.registerFailed", (Object[])new Object[]{Res.get((String)"shared.errorMessageInline", (Object[])new Object[]{errorMessage})}))).show());
        }
    }
}

