/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.account.content.walletinfo;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.config.Config;
import haveno.core.locale.Res;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.listeners.BalanceListener;
import haveno.core.xmr.wallet.BtcWalletService;
import haveno.core.xmr.wallet.WalletService;
import haveno.core.xmr.wallet.WalletsManager;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.ShowWalletDataWindow;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.script.Script;
import org.bitcoinj.wallet.DeterministicKeyChain;
import org.bitcoinj.wallet.Wallet;

@FxmlView
public class WalletInfoView
extends ActivatableView<GridPane, Void> {
    private final WalletsManager walletsManager;
    private final BtcWalletService btcWalletService;
    private final CoinFormatter btcFormatter;
    private int gridRow = 0;
    private Button openDetailsButton;
    private TextField btcTextField;
    private BalanceListener btcWalletBalanceListener;

    @Inject
    private WalletInfoView(WalletsManager walletsManager, BtcWalletService btcWalletService, @Named(value="BTC") CoinFormatter btcFormatter) {
        this.walletsManager = walletsManager;
        this.btcWalletService = btcWalletService;
        this.btcFormatter = btcFormatter;
    }

    @Override
    public void initialize() {
        FormBuilder.addTitledGroupBg((GridPane)this.root, this.gridRow, 3, Res.get((String)"account.menu.walletInfo.balance.headLine"));
        FormBuilder.addMultilineLabel((GridPane)this.root, this.gridRow, Res.get((String)"account.menu.walletInfo.balance.info"), 20.0, Double.MAX_VALUE);
        this.btcTextField = (TextField)FormBuilder.addTopLabelTextField((GridPane)((GridPane)this.root), (int)(++this.gridRow), (String)"BTC", (double)-23.0).second;
        FormBuilder.addTitledGroupBg((GridPane)this.root, ++this.gridRow, 3, Res.get((String)"account.menu.walletInfo.xpub.headLine"), 40.0);
        this.addXpubKeys((WalletService)this.btcWalletService, "BTC", this.gridRow, 60.0);
        ++this.gridRow;
        FormBuilder.addTitledGroupBg((GridPane)this.root, ++this.gridRow, 4, Res.get((String)"account.menu.walletInfo.path.headLine"), 40.0);
        FormBuilder.addMultilineLabel((GridPane)this.root, this.gridRow, Res.get((String)"account.menu.walletInfo.path.info"), 60.0, Double.MAX_VALUE);
        FormBuilder.addTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"account.menu.walletInfo.walletSelector", (Object[])new Object[]{"BTC", "legacy"}), "44'/0'/0'", -23.0);
        FormBuilder.addTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"account.menu.walletInfo.walletSelector", (Object[])new Object[]{"BTC", "segwit"}), "44'/0'/1'", -23.0);
        this.openDetailsButton = FormBuilder.addButtonAfterGroup((GridPane)this.root, ++this.gridRow, Res.get((String)"account.menu.walletInfo.openDetails"));
        this.btcWalletBalanceListener = new BalanceListener(){

            public void onBalanceChanged(Coin balanceAsCoin, Transaction tx) {
                WalletInfoView.this.updateBalances((WalletService)WalletInfoView.this.btcWalletService);
            }
        };
    }

    @Override
    protected void activate() {
        this.btcWalletService.addBalanceListener(this.btcWalletBalanceListener);
        this.updateBalances((WalletService)this.btcWalletService);
        this.openDetailsButton.setOnAction(e -> {
            if (this.walletsManager.areWalletsAvailable()) {
                ((ShowWalletDataWindow)new ShowWalletDataWindow(this.walletsManager).width(((GridPane)this.root).getWidth())).show();
            } else {
                ((Popup)new Popup().warning(Res.get((String)"popup.warning.walletNotInitialized"))).show();
            }
        });
    }

    @Override
    protected void deactivate() {
        this.btcWalletService.removeBalanceListener(this.btcWalletBalanceListener);
        this.openDetailsButton.setOnAction(null);
    }

    private void addXpubKeys(WalletService walletService, String currency, int gridRow, double top) {
        int row = gridRow;
        double topDist = top;
        for (DeterministicKeyChain chain : walletService.getWallet().getActiveKeyChains()) {
            Script.ScriptType outputScriptType = chain.getOutputScriptType();
            String type = outputScriptType == Script.ScriptType.P2WPKH ? "segwit" : "legacy";
            String key = chain.getWatchingKey().serializePubB58(Config.baseCurrencyNetworkParameters(), outputScriptType);
            FormBuilder.addTopLabelTextField((GridPane)this.root, row, Res.get((String)"account.menu.walletInfo.walletSelector", (Object[])new Object[]{currency, type}), key, topDist);
            ++row;
            topDist = -23.0;
        }
    }

    private void updateBalances(WalletService walletService) {
        if (walletService instanceof BtcWalletService) {
            this.btcTextField.setText(this.btcFormatter.formatCoinWithCode(walletService.getBalance(Wallet.BalanceType.ESTIMATED_SPENDABLE)));
        }
    }
}

