/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.account.content.traditionalaccounts;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.config.Config;
import haveno.common.util.Tuple2;
import haveno.common.util.Tuple3;
import haveno.common.util.Utilities;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.offer.OfferRestrictions;
import haveno.core.payment.AmazonGiftCardAccount;
import haveno.core.payment.AustraliaPayidAccount;
import haveno.core.payment.CashAppAccount;
import haveno.core.payment.CashAtAtmAccount;
import haveno.core.payment.CashDepositAccount;
import haveno.core.payment.F2FAccount;
import haveno.core.payment.HalCashAccount;
import haveno.core.payment.MoneyGramAccount;
import haveno.core.payment.PayByMailAccount;
import haveno.core.payment.PayPalAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PaymentAccountFactory;
import haveno.core.payment.PaysafeAccount;
import haveno.core.payment.RevolutAccount;
import haveno.core.payment.USPostalMoneyOrderAccount;
import haveno.core.payment.VenmoAccount;
import haveno.core.payment.WesternUnionAccount;
import haveno.core.payment.ZelleAccount;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.validation.AdvancedCashValidator;
import haveno.core.payment.validation.AliPayValidator;
import haveno.core.payment.validation.AustraliaPayidValidator;
import haveno.core.payment.validation.BICValidator;
import haveno.core.payment.validation.CapitualValidator;
import haveno.core.payment.validation.ChaseQuickPayValidator;
import haveno.core.payment.validation.EmailOrMobileNrOrCashtagValidator;
import haveno.core.payment.validation.EmailOrMobileNrOrUsernameValidator;
import haveno.core.payment.validation.EmailOrMobileNrValidator;
import haveno.core.payment.validation.F2FValidator;
import haveno.core.payment.validation.HalCashValidator;
import haveno.core.payment.validation.InteracETransferValidator;
import haveno.core.payment.validation.JapanBankTransferValidator;
import haveno.core.payment.validation.LengthValidator;
import haveno.core.payment.validation.MoneyBeamValidator;
import haveno.core.payment.validation.PerfectMoneyValidator;
import haveno.core.payment.validation.PopmoneyValidator;
import haveno.core.payment.validation.PromptPayValidator;
import haveno.core.payment.validation.RevolutValidator;
import haveno.core.payment.validation.SwishValidator;
import haveno.core.payment.validation.TransferwiseValidator;
import haveno.core.payment.validation.USPostalMoneyOrderValidator;
import haveno.core.payment.validation.UpholdValidator;
import haveno.core.payment.validation.WeChatPayValidator;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.AutocompleteComboBox;
import haveno.desktop.components.TitledGroupBg;
import haveno.desktop.components.paymentmethods.AchTransferForm;
import haveno.desktop.components.paymentmethods.AdvancedCashForm;
import haveno.desktop.components.paymentmethods.AliPayForm;
import haveno.desktop.components.paymentmethods.AmazonGiftCardForm;
import haveno.desktop.components.paymentmethods.AustraliaPayidForm;
import haveno.desktop.components.paymentmethods.BizumForm;
import haveno.desktop.components.paymentmethods.CapitualForm;
import haveno.desktop.components.paymentmethods.CashAppForm;
import haveno.desktop.components.paymentmethods.CashAtAtmForm;
import haveno.desktop.components.paymentmethods.CashDepositForm;
import haveno.desktop.components.paymentmethods.CelPayForm;
import haveno.desktop.components.paymentmethods.ChaseQuickPayForm;
import haveno.desktop.components.paymentmethods.DomesticWireTransferForm;
import haveno.desktop.components.paymentmethods.F2FForm;
import haveno.desktop.components.paymentmethods.FasterPaymentsForm;
import haveno.desktop.components.paymentmethods.HalCashForm;
import haveno.desktop.components.paymentmethods.ImpsForm;
import haveno.desktop.components.paymentmethods.InteracETransferForm;
import haveno.desktop.components.paymentmethods.JapanBankTransferForm;
import haveno.desktop.components.paymentmethods.MoneseForm;
import haveno.desktop.components.paymentmethods.MoneyBeamForm;
import haveno.desktop.components.paymentmethods.MoneyGramForm;
import haveno.desktop.components.paymentmethods.NationalBankForm;
import haveno.desktop.components.paymentmethods.NeftForm;
import haveno.desktop.components.paymentmethods.NequiForm;
import haveno.desktop.components.paymentmethods.PaxumForm;
import haveno.desktop.components.paymentmethods.PayByMailForm;
import haveno.desktop.components.paymentmethods.PayPalForm;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.components.paymentmethods.PaysafeForm;
import haveno.desktop.components.paymentmethods.PayseraForm;
import haveno.desktop.components.paymentmethods.PaytmForm;
import haveno.desktop.components.paymentmethods.PerfectMoneyForm;
import haveno.desktop.components.paymentmethods.PixForm;
import haveno.desktop.components.paymentmethods.PopmoneyForm;
import haveno.desktop.components.paymentmethods.PromptPayForm;
import haveno.desktop.components.paymentmethods.RevolutForm;
import haveno.desktop.components.paymentmethods.RtgsForm;
import haveno.desktop.components.paymentmethods.SameBankForm;
import haveno.desktop.components.paymentmethods.SatispayForm;
import haveno.desktop.components.paymentmethods.SepaForm;
import haveno.desktop.components.paymentmethods.SepaInstantForm;
import haveno.desktop.components.paymentmethods.SpecificBankForm;
import haveno.desktop.components.paymentmethods.StrikeForm;
import haveno.desktop.components.paymentmethods.SwiftForm;
import haveno.desktop.components.paymentmethods.SwishForm;
import haveno.desktop.components.paymentmethods.TikkieForm;
import haveno.desktop.components.paymentmethods.TransferwiseForm;
import haveno.desktop.components.paymentmethods.TransferwiseUsdForm;
import haveno.desktop.components.paymentmethods.USPostalMoneyOrderForm;
import haveno.desktop.components.paymentmethods.UpholdForm;
import haveno.desktop.components.paymentmethods.UpiForm;
import haveno.desktop.components.paymentmethods.VenmoForm;
import haveno.desktop.components.paymentmethods.VerseForm;
import haveno.desktop.components.paymentmethods.WeChatPayForm;
import haveno.desktop.components.paymentmethods.WesternUnionForm;
import haveno.desktop.components.paymentmethods.ZelleForm;
import haveno.desktop.main.account.content.PaymentAccountsView;
import haveno.desktop.main.account.content.traditionalaccounts.TraditionalAccountsDataModel;
import haveno.desktop.main.account.content.traditionalaccounts.TraditionalAccountsViewModel;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import haveno.desktop.util.Layout;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.util.StringConverter;

@FxmlView
public class TraditionalAccountsView
extends PaymentAccountsView<GridPane, TraditionalAccountsViewModel> {
    private final BICValidator bicValidator;
    private final CapitualValidator capitualValidator;
    private final LengthValidator inputValidator;
    private final UpholdValidator upholdValidator;
    private final MoneyBeamValidator moneyBeamValidator;
    private final PopmoneyValidator popmoneyValidator;
    private final RevolutValidator revolutValidator;
    private final AliPayValidator aliPayValidator;
    private final PerfectMoneyValidator perfectMoneyValidator;
    private final SwishValidator swishValidator;
    private final EmailOrMobileNrValidator zelleValidator;
    private final EmailOrMobileNrOrUsernameValidator paypalValidator;
    private final EmailOrMobileNrOrUsernameValidator venmoValidator;
    private final EmailOrMobileNrOrCashtagValidator cashAppValidator;
    private final ChaseQuickPayValidator chaseQuickPayValidator;
    private final InteracETransferValidator interacETransferValidator;
    private final JapanBankTransferValidator japanBankTransferValidator;
    private final AustraliaPayidValidator australiapayidValidator;
    private final USPostalMoneyOrderValidator usPostalMoneyOrderValidator;
    private final WeChatPayValidator weChatPayValidator;
    private final HalCashValidator halCashValidator;
    private final F2FValidator f2FValidator;
    private final PromptPayValidator promptPayValidator;
    private final AdvancedCashValidator advancedCashValidator;
    private final TransferwiseValidator transferwiseValidator;
    private final CoinFormatter formatter;
    private AutocompleteComboBox<PaymentMethod> paymentMethodComboBox;
    private PaymentMethodForm paymentMethodForm;
    private TitledGroupBg accountTitledGroupBg;
    private Button saveNewAccountButton;
    private int gridRow = 0;

    @Inject
    public TraditionalAccountsView(TraditionalAccountsViewModel model, BICValidator bicValidator, CapitualValidator capitualValidator, LengthValidator inputValidator, UpholdValidator upholdValidator, MoneyBeamValidator moneyBeamValidator, PopmoneyValidator popmoneyValidator, RevolutValidator revolutValidator, AliPayValidator aliPayValidator, PerfectMoneyValidator perfectMoneyValidator, SwishValidator swishValidator, EmailOrMobileNrValidator zelleValidator, EmailOrMobileNrOrCashtagValidator cashAppValidator, EmailOrMobileNrOrUsernameValidator emailMobileUsernameValidator, ChaseQuickPayValidator chaseQuickPayValidator, InteracETransferValidator interacETransferValidator, JapanBankTransferValidator japanBankTransferValidator, AustraliaPayidValidator australiaPayIDValidator, USPostalMoneyOrderValidator usPostalMoneyOrderValidator, WeChatPayValidator weChatPayValidator, HalCashValidator halCashValidator, F2FValidator f2FValidator, PromptPayValidator promptPayValidator, AdvancedCashValidator advancedCashValidator, TransferwiseValidator transferwiseValidator, AccountAgeWitnessService accountAgeWitnessService, @Named(value="BTC") CoinFormatter formatter) {
        super(model, accountAgeWitnessService);
        this.bicValidator = bicValidator;
        this.capitualValidator = capitualValidator;
        this.inputValidator = inputValidator;
        this.inputValidator.setMaxLength(100);
        this.inputValidator.setMinLength(2);
        this.upholdValidator = upholdValidator;
        this.moneyBeamValidator = moneyBeamValidator;
        this.popmoneyValidator = popmoneyValidator;
        this.revolutValidator = revolutValidator;
        this.aliPayValidator = aliPayValidator;
        this.perfectMoneyValidator = perfectMoneyValidator;
        this.swishValidator = swishValidator;
        this.zelleValidator = zelleValidator;
        this.paypalValidator = emailMobileUsernameValidator;
        this.venmoValidator = emailMobileUsernameValidator;
        this.cashAppValidator = cashAppValidator;
        this.chaseQuickPayValidator = chaseQuickPayValidator;
        this.interacETransferValidator = interacETransferValidator;
        this.japanBankTransferValidator = japanBankTransferValidator;
        this.australiapayidValidator = australiaPayIDValidator;
        this.usPostalMoneyOrderValidator = usPostalMoneyOrderValidator;
        this.weChatPayValidator = weChatPayValidator;
        this.halCashValidator = halCashValidator;
        this.f2FValidator = f2FValidator;
        this.promptPayValidator = promptPayValidator;
        this.advancedCashValidator = advancedCashValidator;
        this.transferwiseValidator = transferwiseValidator;
        this.formatter = formatter;
    }

    @Override
    protected ObservableList<PaymentAccount> getPaymentAccounts() {
        return ((TraditionalAccountsViewModel)this.model).getPaymentAccounts();
    }

    @Override
    protected void importAccounts() {
        ((TraditionalAccountsDataModel)((TraditionalAccountsViewModel)this.model).dataModel).importAccounts((Stage)((GridPane)this.root).getScene().getWindow());
    }

    @Override
    protected void exportAccounts() {
        ((TraditionalAccountsDataModel)((TraditionalAccountsViewModel)this.model).dataModel).exportAccounts((Stage)((GridPane)this.root).getScene().getWindow());
    }

    private void onSaveNewAccount(PaymentAccount paymentAccount) {
        BigInteger maxTradeLimit = paymentAccount.getPaymentMethod().getMaxTradeLimit("USD");
        BigInteger maxTradeLimitSecondMonth = maxTradeLimit.divide(BigInteger.valueOf(2L));
        BigInteger maxTradeLimitFirstMonth = maxTradeLimit.divide(BigInteger.valueOf(4L));
        if (paymentAccount instanceof F2FAccount) {
            ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"payment.f2f.info"))).width(700.0)).closeButtonText(Res.get((String)"payment.f2f.info.openURL"))).onClose(() -> GUIUtil.openWebPage("https://docs.haveno.exchange/the-project/payment_methods/F2F"))).actionButtonText(Res.get((String)"shared.iUnderstand"))).onAction(() -> this.doSaveNewAccount(paymentAccount))).show();
        } else if (paymentAccount instanceof PayByMailAccount) {
            ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"payment.payByMail.info"))).width(850.0)).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.iUnderstand"))).onAction(() -> this.doSaveNewAccount(paymentAccount))).showScrollPane()).show();
        } else if (paymentAccount instanceof CashAtAtmAccount) {
            ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"payment.cashAtAtm.info"))).width(850.0)).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.iUnderstand"))).onAction(() -> this.doSaveNewAccount(paymentAccount))).show();
        } else if (paymentAccount instanceof HalCashAccount) {
            ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"payment.halCash.info"))).width(700.0)).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.iUnderstand"))).onAction(() -> this.doSaveNewAccount(paymentAccount))).show();
        } else {
            String limitsInfoKey = "payment.limits.info";
            String initialLimit = HavenoUtils.formatXmr((BigInteger)maxTradeLimitFirstMonth, (boolean)true);
            if (PaymentMethod.hasChargebackRisk((PaymentMethod)paymentAccount.getPaymentMethod(), (List)paymentAccount.getTradeCurrencies())) {
                limitsInfoKey = "payment.limits.info.withSigning";
                initialLimit = HavenoUtils.formatXmr((BigInteger)OfferRestrictions.TOLERATED_SMALL_TRADE_AMOUNT, (boolean)true);
            }
            ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)limitsInfoKey, (Object[])new Object[]{initialLimit, HavenoUtils.formatXmr((BigInteger)maxTradeLimitSecondMonth, (boolean)true), HavenoUtils.formatXmr((BigInteger)maxTradeLimit, (boolean)true)}))).width(700.0)).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.iUnderstand"))).onAction(() -> {
                String currencyName = Config.baseCurrencyNetwork().getCurrencyName();
                if (paymentAccount instanceof ZelleAccount) {
                    ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"payment.zelle.info", (Object[])new Object[]{currencyName, currencyName}))).width(900.0)).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.iConfirm"))).onAction(() -> this.doSaveNewAccount(paymentAccount))).show();
                } else if (paymentAccount instanceof WesternUnionAccount) {
                    ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"payment.westernUnion.info"))).width(700.0)).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.iUnderstand"))).onAction(() -> this.doSaveNewAccount(paymentAccount))).show();
                } else if (paymentAccount instanceof MoneyGramAccount) {
                    ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"payment.moneyGram.info"))).width(700.0)).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.iUnderstand"))).onAction(() -> this.doSaveNewAccount(paymentAccount))).show();
                } else if (paymentAccount instanceof CashDepositAccount) {
                    ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"payment.cashDeposit.info"))).width(700.0)).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.iConfirm"))).onAction(() -> this.doSaveNewAccount(paymentAccount))).show();
                } else if (paymentAccount instanceof RevolutAccount) {
                    ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"payment.revolut.info"))).width(700.0)).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.iConfirm"))).onAction(() -> this.doSaveNewAccount(paymentAccount))).show();
                } else if (paymentAccount instanceof USPostalMoneyOrderAccount) {
                    ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"payment.usPostalMoneyOrder.info"))).width(700.0)).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.iUnderstand"))).onAction(() -> this.doSaveNewAccount(paymentAccount))).show();
                } else if (paymentAccount instanceof AustraliaPayidAccount) {
                    ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"payment.payid.info", (Object[])new Object[]{currencyName, currencyName}))).width(900.0)).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.iConfirm"))).onAction(() -> this.doSaveNewAccount(paymentAccount))).show();
                } else if (paymentAccount instanceof AmazonGiftCardAccount) {
                    ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"payment.amazonGiftCard.info", (Object[])new Object[]{currencyName, currencyName}))).width(900.0)).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.iUnderstand"))).onAction(() -> this.doSaveNewAccount(paymentAccount))).show();
                } else if (paymentAccount instanceof CashAppAccount) {
                    ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"payment.cashapp.info"))).width(700.0)).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.iUnderstand"))).onAction(() -> this.doSaveNewAccount(paymentAccount))).show();
                } else if (paymentAccount instanceof VenmoAccount) {
                    ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"payment.venmo.info"))).width(700.0)).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.iUnderstand"))).onAction(() -> this.doSaveNewAccount(paymentAccount))).show();
                } else if (paymentAccount instanceof PayPalAccount) {
                    ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"payment.paypal.info"))).width(700.0)).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.iUnderstand"))).onAction(() -> this.doSaveNewAccount(paymentAccount))).show();
                } else if (paymentAccount instanceof PaysafeAccount) {
                    ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"payment.paysafe.info"))).width(700.0)).closeButtonText(Res.get((String)"shared.cancel"))).actionButtonText(Res.get((String)"shared.iUnderstand"))).onAction(() -> this.doSaveNewAccount(paymentAccount))).show();
                } else {
                    this.doSaveNewAccount(paymentAccount);
                }
            })).show();
        }
    }

    private void doSaveNewAccount(PaymentAccount paymentAccount) {
        if (this.getPaymentAccounts().stream().noneMatch(e -> e.getAccountName() != null && e.getAccountName().equals(paymentAccount.getAccountName()))) {
            ((TraditionalAccountsViewModel)this.model).onSaveNewAccount(paymentAccount);
            this.removeNewAccountForm();
        } else {
            ((Popup)new Popup().warning(Res.get((String)"shared.accountNameAlreadyUsed"))).show();
        }
    }

    private void onCancelNewAccount() {
        this.removeNewAccountForm();
    }

    private void onUpdateAccount(PaymentAccount paymentAccount) {
        ((TraditionalAccountsViewModel)this.model).onUpdateAccount(paymentAccount);
        this.removeSelectAccountForm();
    }

    private void onCancelSelectedAccount(PaymentAccount paymentAccount) {
        paymentAccount.revertChanges();
        this.removeSelectAccountForm();
    }

    @Override
    protected boolean deleteAccountFromModel(PaymentAccount paymentAccount) {
        return ((TraditionalAccountsViewModel)this.model).onDeleteAccount(paymentAccount);
    }

    @Override
    protected void buildForm() {
        FormBuilder.addTitledGroupBg((GridPane)this.root, this.gridRow, 2, Res.get((String)"shared.manageAccounts"));
        Tuple3 tuple = FormBuilder.addTopLabelListView((GridPane)this.root, this.gridRow, Res.get((String)"account.traditional.yourTraditionalAccounts"), 20.0);
        this.paymentAccountsListView = (ListView)tuple.second;
        this.setPaymentAccountsListHeight();
        this.setPaymentAccountsCellFactory();
        Tuple3<Button, Button, Button> tuple3 = FormBuilder.add3ButtonsAfterGroup((GridPane)this.root, ++this.gridRow, Res.get((String)"shared.addNewAccount"), Res.get((String)"shared.ExportAccounts"), Res.get((String)"shared.importAccounts"));
        this.addAccountButton = (Button)tuple3.first;
        this.addAccountButton.setId("buy-button-big");
        this.exportButton = (Button)tuple3.second;
        this.importButton = (Button)tuple3.third;
    }

    @Override
    protected void addNewAccount() {
        this.paymentAccountsListView.getSelectionModel().clearSelection();
        this.removeAccountRows();
        this.addAccountButton.setDisable(true);
        this.accountTitledGroupBg = FormBuilder.addTitledGroupBg((GridPane)this.root, ++this.gridRow, 2, Res.get((String)"shared.createNewAccount"), 30.0);
        FormBuilder.addLabel((GridPane)this.root, this.gridRow, Res.get((String)"shared.createNewAccountDescription"));
        this.paymentMethodComboBox = FormBuilder.addAutocompleteComboBox((GridPane)this.root, this.gridRow, Res.get((String)"shared.selectPaymentMethod"), 70.0 + Layout.PADDING);
        this.paymentMethodComboBox.setVisibleRowCount(Math.min(this.paymentMethodComboBox.getItems().size(), 10));
        this.paymentMethodComboBox.setPrefWidth(250.0);
        List list = PaymentMethod.paymentMethods.stream().filter(PaymentMethod::isTraditional).sorted().collect(Collectors.toList());
        this.paymentMethodComboBox.setAutocompleteItems((List<PaymentMethod>)FXCollections.observableArrayList(list));
        this.paymentMethodComboBox.setConverter((StringConverter)new StringConverter<PaymentMethod>(){

            public String toString(PaymentMethod paymentMethod) {
                return paymentMethod != null ? Res.get((String)paymentMethod.getId()) : "";
            }

            public PaymentMethod fromString(String s) {
                if (s.isEmpty()) {
                    return null;
                }
                return TraditionalAccountsView.this.paymentMethodComboBox.getItems().stream().filter(item -> Res.get((String)item.getId()).equals(s)).findAny().orElse(null);
            }
        });
        this.paymentMethodComboBox.setOnChangeConfirmed((EventHandler<Event>)((EventHandler)e -> {
            if (this.paymentMethodComboBox.getEditor().getText().isEmpty()) {
                return;
            }
            if (this.paymentMethodForm != null) {
                FormBuilder.removeRowsFromGridPane((GridPane)this.root, 3, this.paymentMethodForm.getGridRow() + 1);
                GridPane.setRowSpan((Node)this.accountTitledGroupBg, (Integer)(this.paymentMethodForm.getRowSpan() + 1));
            }
            this.gridRow = 2;
            this.paymentMethodForm = this.getPaymentMethodForm((PaymentMethod)this.paymentMethodComboBox.getSelectionModel().getSelectedItem());
            if (this.paymentMethodForm != null) {
                if (this.paymentMethodForm.getPaymentAccount().getMessageForAccountCreation() != null) {
                    ((Popup)((Popup)((Popup)new Popup().information(Res.get((String)this.paymentMethodForm.getPaymentAccount().getMessageForAccountCreation()))).width(900.0)).closeButtonText(Res.get((String)"shared.iUnderstand"))).show();
                }
                this.paymentMethodForm.addFormForAddAccount();
                this.gridRow = this.paymentMethodForm.getGridRow();
                Tuple2<Button, Button> tuple2 = FormBuilder.add2ButtonsAfterGroup((GridPane)this.root, ++this.gridRow, Res.get((String)"shared.saveNewAccount"), Res.get((String)"shared.cancel"));
                this.saveNewAccountButton = (Button)tuple2.first;
                this.saveNewAccountButton.setOnAction(event -> this.onSaveNewAccount(this.paymentMethodForm.getPaymentAccount()));
                this.saveNewAccountButton.disableProperty().bind((ObservableValue)this.paymentMethodForm.allInputsValidProperty().not());
                Button cancelButton = (Button)tuple2.second;
                cancelButton.setOnAction(event -> this.onCancelNewAccount());
                GridPane.setRowSpan((Node)this.accountTitledGroupBg, (Integer)(this.paymentMethodForm.getRowSpan() + 1));
            }
        }));
    }

    @Override
    protected void onSelectAccount(PaymentAccount previous, PaymentAccount current) {
        if (previous != null) {
            previous.revertChanges();
        }
        this.removeAccountRows();
        this.addAccountButton.setDisable(false);
        this.accountTitledGroupBg = FormBuilder.addTitledGroupBg((GridPane)this.root, ++this.gridRow, 2, "", 30.0);
        this.paymentMethodForm = this.getPaymentMethodForm(current);
        if (this.paymentMethodForm != null) {
            this.paymentMethodForm.addFormForEditAccount();
            this.gridRow = this.paymentMethodForm.getGridRow();
            Tuple3<Button, Button, Button> tuple = FormBuilder.add3ButtonsAfterGroup((GridPane)this.root, ++this.gridRow, Res.get((String)"shared.save"), Res.get((String)"shared.deleteAccount"), Res.get((String)"shared.cancel"));
            Button updateButton = (Button)tuple.first;
            updateButton.setOnAction(event -> this.onUpdateAccount(this.paymentMethodForm.getPaymentAccount()));
            Button deleteAccountButton = (Button)tuple.second;
            deleteAccountButton.setOnAction(event -> this.onDeleteAccount(this.paymentMethodForm.getPaymentAccount()));
            Button cancelButton = (Button)tuple.third;
            cancelButton.setOnAction(event -> this.onCancelSelectedAccount(this.paymentMethodForm.getPaymentAccount()));
            GridPane.setRowSpan((Node)this.accountTitledGroupBg, (Integer)this.paymentMethodForm.getRowSpan());
            ((TraditionalAccountsViewModel)this.model).onSelectAccount(current);
        }
    }

    private PaymentMethodForm getPaymentMethodForm(PaymentAccount paymentAccount) {
        return this.getPaymentMethodForm(paymentAccount.getPaymentMethod(), paymentAccount);
    }

    private PaymentMethodForm getPaymentMethodForm(PaymentMethod paymentMethod) {
        if (paymentMethod == null) {
            return null;
        }
        PaymentAccount paymentAccount = PaymentAccountFactory.getPaymentAccount((PaymentMethod)paymentMethod);
        paymentAccount.init();
        return this.getPaymentMethodForm(paymentMethod, paymentAccount);
    }

    private PaymentMethodForm getPaymentMethodForm(PaymentMethod paymentMethod, PaymentAccount paymentAccount) {
        switch (paymentMethod.getId()) {
            case "UPHOLD": {
                return new UpholdForm(paymentAccount, this.accountAgeWitnessService, this.upholdValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "MONEY_BEAM": {
                return new MoneyBeamForm(paymentAccount, this.accountAgeWitnessService, this.moneyBeamValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "POPMONEY": {
                return new PopmoneyForm(paymentAccount, this.accountAgeWitnessService, this.popmoneyValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "REVOLUT": {
                return new RevolutForm(paymentAccount, this.accountAgeWitnessService, this.revolutValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "PERFECT_MONEY": {
                return new PerfectMoneyForm(paymentAccount, this.accountAgeWitnessService, this.perfectMoneyValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "SEPA": {
                return new SepaForm(paymentAccount, this.accountAgeWitnessService, this.bicValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "SEPA_INSTANT": {
                return new SepaInstantForm(paymentAccount, this.accountAgeWitnessService, this.bicValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "FASTER_PAYMENTS": {
                return new FasterPaymentsForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "NATIONAL_BANK": {
                return new NationalBankForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "SAME_BANK": {
                return new SameBankForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "SPECIFIC_BANKS": {
                return new SpecificBankForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "JAPAN_BANK": {
                return new JapanBankTransferForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "AUSTRALIA_PAYID": {
                return new AustraliaPayidForm(paymentAccount, this.accountAgeWitnessService, this.australiapayidValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "ALI_PAY": {
                return new AliPayForm(paymentAccount, this.accountAgeWitnessService, this.aliPayValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "WECHAT_PAY": {
                return new WeChatPayForm(paymentAccount, this.accountAgeWitnessService, this.weChatPayValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "SWISH": {
                return new SwishForm(paymentAccount, this.accountAgeWitnessService, this.swishValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "ZELLE": {
                return new ZelleForm(paymentAccount, this.accountAgeWitnessService, this.zelleValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "CHASE_QUICK_PAY": {
                return new ChaseQuickPayForm(paymentAccount, this.accountAgeWitnessService, this.chaseQuickPayValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "INTERAC_E_TRANSFER": {
                return new InteracETransferForm(paymentAccount, this.accountAgeWitnessService, this.interacETransferValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "US_POSTAL_MONEY_ORDER": {
                return new USPostalMoneyOrderForm(paymentAccount, this.accountAgeWitnessService, this.usPostalMoneyOrderValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "MONEY_GRAM": {
                return new MoneyGramForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "WESTERN_UNION": {
                return new WesternUnionForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "CASH_DEPOSIT": {
                return new CashDepositForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "PAY_BY_MAIL": {
                return new PayByMailForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "CASH_AT_ATM": {
                return new CashAtAtmForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "HAL_CASH": {
                return new HalCashForm(paymentAccount, this.accountAgeWitnessService, this.halCashValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "F2F": {
                return new F2FForm(paymentAccount, this.accountAgeWitnessService, this.f2FValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "PROMPT_PAY": {
                return new PromptPayForm(paymentAccount, this.accountAgeWitnessService, this.promptPayValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "ADVANCED_CASH": {
                return new AdvancedCashForm(paymentAccount, this.accountAgeWitnessService, this.advancedCashValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "TRANSFERWISE": {
                return new TransferwiseForm(paymentAccount, this.accountAgeWitnessService, this.transferwiseValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "TRANSFERWISE_USD": {
                return new TransferwiseUsdForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "PAYSERA": {
                return new PayseraForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "PAXUM": {
                return new PaxumForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "NEFT": {
                return new NeftForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "RTGS": {
                return new RtgsForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "IMPS": {
                return new ImpsForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "UPI": {
                return new UpiForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "PAYTM": {
                return new PaytmForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "NEQUI": {
                return new NequiForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "BIZUM": {
                return new BizumForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "PIX": {
                return new PixForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "AMAZON_GIFT_CARD": {
                return new AmazonGiftCardForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "CAPITUAL": {
                return new CapitualForm(paymentAccount, this.accountAgeWitnessService, this.capitualValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "CELPAY": {
                return new CelPayForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "MONESE": {
                return new MoneseForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "SATISPAY": {
                return new SatispayForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "TIKKIE": {
                return new TikkieForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "VERSE": {
                return new VerseForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "STRIKE": {
                return new StrikeForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "SWIFT": {
                return new SwiftForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "ACH_TRANSFER": {
                return new AchTransferForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "DOMESTIC_WIRE_TRANSFER": {
                return new DomesticWireTransferForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "PAYPAL": {
                return new PayPalForm(paymentAccount, this.accountAgeWitnessService, this.paypalValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "VENMO": {
                return new VenmoForm(paymentAccount, this.accountAgeWitnessService, this.venmoValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "CASH_APP": {
                return new CashAppForm(paymentAccount, this.accountAgeWitnessService, this.cashAppValidator, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
            case "PAYSAFE": {
                return new PaysafeForm(paymentAccount, this.accountAgeWitnessService, (InputValidator)this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter);
            }
        }
        this.log.error("Not supported PaymentMethod: " + String.valueOf(paymentMethod));
        return null;
    }

    private void removeNewAccountForm() {
        this.saveNewAccountButton.disableProperty().unbind();
        this.removeAccountRows();
        this.addAccountButton.setDisable(false);
    }

    @Override
    protected void removeSelectAccountForm() {
        FormBuilder.removeRowsFromGridPane((GridPane)this.root, 2, this.gridRow);
        this.gridRow = 1;
        this.addAccountButton.setDisable(false);
        this.paymentAccountsListView.getSelectionModel().clearSelection();
    }

    private void removeAccountRows() {
        FormBuilder.removeRowsFromGridPane((GridPane)this.root, 2, this.gridRow);
        this.gridRow = 1;
    }

    @Override
    protected void copyAccount() {
        PaymentAccount selectedAccount = (PaymentAccount)this.paymentAccountsListView.getSelectionModel().getSelectedItem();
        if (selectedAccount == null) {
            return;
        }
        Utilities.copyToClipboard((String)this.accountAgeWitnessService.getSignInfoFromAccount(selectedAccount));
    }

    @Override
    protected void deactivate() {
        super.deactivate();
        PaymentAccount selectedAccount = (PaymentAccount)this.paymentAccountsListView.getSelectionModel().getSelectedItem();
        if (selectedAccount != null) {
            this.onCancelSelectedAccount(selectedAccount);
        }
    }
}

