/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.account.content.traditionalaccounts;

import com.google.inject.Inject;
import haveno.common.file.CorruptedStorageFileHandler;
import haveno.common.proto.persistable.PersistenceProtoResolver;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CryptoCurrency;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.offer.OpenOfferManager;
import haveno.core.payment.AssetAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.trade.TradeManager;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.desktop.common.model.ActivatableDataModel;
import haveno.desktop.util.GUIUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.SetChangeListener;
import javafx.stage.Stage;

class TraditionalAccountsDataModel
extends ActivatableDataModel {
    private final User user;
    private final Preferences preferences;
    private final OpenOfferManager openOfferManager;
    private final TradeManager tradeManager;
    private final AccountAgeWitnessService accountAgeWitnessService;
    final ObservableList<PaymentAccount> paymentAccounts = FXCollections.observableArrayList();
    private final SetChangeListener<PaymentAccount> setChangeListener;
    private final String accountsFileName = "FiatPaymentAccounts";
    private final PersistenceProtoResolver persistenceProtoResolver;
    private final CorruptedStorageFileHandler corruptedStorageFileHandler;

    @Inject
    public TraditionalAccountsDataModel(User user, Preferences preferences, OpenOfferManager openOfferManager, TradeManager tradeManager, AccountAgeWitnessService accountAgeWitnessService, PersistenceProtoResolver persistenceProtoResolver, CorruptedStorageFileHandler corruptedStorageFileHandler) {
        this.user = user;
        this.preferences = preferences;
        this.openOfferManager = openOfferManager;
        this.tradeManager = tradeManager;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.persistenceProtoResolver = persistenceProtoResolver;
        this.corruptedStorageFileHandler = corruptedStorageFileHandler;
        this.setChangeListener = change -> this.fillAndSortPaymentAccounts();
    }

    @Override
    protected void activate() {
        this.user.getPaymentAccountsAsObservable().addListener(this.setChangeListener);
        this.fillAndSortPaymentAccounts();
    }

    private void fillAndSortPaymentAccounts() {
        if (this.user.getPaymentAccounts() != null) {
            List list = this.user.getPaymentAccounts().stream().filter(paymentAccount -> !paymentAccount.getPaymentMethod().isBlockchain()).collect(Collectors.toList());
            this.paymentAccounts.setAll(list);
            this.paymentAccounts.sort(Comparator.comparing(PaymentAccount::getAccountName));
        }
    }

    @Override
    protected void deactivate() {
        this.user.getPaymentAccountsAsObservable().removeListener(this.setChangeListener);
    }

    public void onSaveNewAccount(PaymentAccount paymentAccount) {
        TradeCurrency singleTradeCurrency = paymentAccount.getSingleTradeCurrency();
        List tradeCurrencies = paymentAccount.getTradeCurrencies();
        if (singleTradeCurrency != null) {
            paymentAccount.setSelectedTradeCurrency(singleTradeCurrency);
            if (singleTradeCurrency instanceof TraditionalCurrency) {
                this.preferences.addTraditionalCurrency((TraditionalCurrency)singleTradeCurrency);
            } else {
                this.preferences.addCryptoCurrency((CryptoCurrency)singleTradeCurrency);
            }
        } else if (tradeCurrencies != null && !tradeCurrencies.isEmpty()) {
            if (tradeCurrencies.contains(CurrencyUtil.getDefaultTradeCurrency())) {
                paymentAccount.setSelectedTradeCurrency(CurrencyUtil.getDefaultTradeCurrency());
            } else {
                paymentAccount.setSelectedTradeCurrency((TradeCurrency)tradeCurrencies.get(0));
            }
            tradeCurrencies.forEach(tradeCurrency -> {
                if (tradeCurrency instanceof TraditionalCurrency) {
                    this.preferences.addTraditionalCurrency((TraditionalCurrency)tradeCurrency);
                } else {
                    this.preferences.addCryptoCurrency((CryptoCurrency)tradeCurrency);
                }
            });
        }
        this.user.addPaymentAccount(paymentAccount);
        paymentAccount.onPersistChanges();
        this.accountAgeWitnessService.publishMyAccountAgeWitness(paymentAccount.getPaymentAccountPayload());
        this.accountAgeWitnessService.signAndPublishSameNameAccounts();
    }

    public void onUpdateAccount(PaymentAccount paymentAccount) {
        paymentAccount.onPersistChanges();
        this.user.requestPersistence();
    }

    public boolean onDeleteAccount(PaymentAccount paymentAccount) {
        boolean isPaymentAccountUsed = this.openOfferManager.getObservableList().stream().anyMatch(o -> o.getOffer().getMakerPaymentAccountId().equals(paymentAccount.getId()));
        boolean bl = isPaymentAccountUsed = isPaymentAccountUsed || this.tradeManager.getObservableList().stream().anyMatch(t -> t.getOffer().getMakerPaymentAccountId().equals(paymentAccount.getId()) || paymentAccount.getId().equals(t.getTaker().getPaymentAccountId()));
        if (!isPaymentAccountUsed) {
            this.user.removePaymentAccount(paymentAccount);
        }
        return isPaymentAccountUsed;
    }

    public void onSelectAccount(PaymentAccount paymentAccount) {
        this.user.setCurrentPaymentAccount(paymentAccount);
    }

    public void exportAccounts(Stage stage) {
        if (this.user.getPaymentAccounts() != null) {
            ArrayList<PaymentAccount> accounts = new ArrayList<PaymentAccount>(this.user.getPaymentAccounts().stream().filter(paymentAccount -> !(paymentAccount instanceof AssetAccount)).collect(Collectors.toList()));
            GUIUtil.exportAccounts(accounts, "FiatPaymentAccounts", this.preferences, stage, this.persistenceProtoResolver, this.corruptedStorageFileHandler);
        }
    }

    public void importAccounts(Stage stage) {
        GUIUtil.importAccounts(this.user, "FiatPaymentAccounts", this.preferences, stage, this.persistenceProtoResolver, this.corruptedStorageFileHandler);
    }

    public int getNumPaymentAccounts() {
        return this.user.getPaymentAccounts() != null ? this.user.getPaymentAccounts().size() : 0;
    }
}

