/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.account.content.seedwords;

import com.google.common.base.Splitter;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.core.locale.Res;
import haveno.core.offer.OpenOfferManager;
import haveno.core.user.DontShowAgainLookup;
import haveno.core.xmr.wallet.WalletsManager;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.main.SharedPresentation;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.WalletPasswordWindow;
import haveno.desktop.util.FormBuilder;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.TimeZone;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import org.bitcoinj.crypto.MnemonicCode;
import org.bitcoinj.crypto.MnemonicException;
import org.bitcoinj.wallet.DeterministicSeed;

@FxmlView
public class SeedWordsView
extends ActivatableView<GridPane, Void> {
    private final WalletsManager walletsManager;
    private final OpenOfferManager openOfferManager;
    private final XmrWalletService xmrWalletService;
    private final WalletPasswordWindow walletPasswordWindow;
    private final File storageDir;
    private Button restoreButton;
    private TextArea displaySeedWordsTextArea;
    private TextArea seedWordsTextArea;
    private DatePicker datePicker;
    private DatePicker restoreDatePicker;
    private int gridRow = 0;
    private ChangeListener<Boolean> seedWordsValidChangeListener;
    private final SimpleBooleanProperty seedWordsValid = new SimpleBooleanProperty(false);
    private ChangeListener<String> seedWordsTextAreaChangeListener;
    private final BooleanProperty seedWordsEdited = new SimpleBooleanProperty();
    private String seedWordText;
    private LocalDate walletCreationDate;

    @Inject
    private SeedWordsView(WalletsManager walletsManager, OpenOfferManager openOfferManager, XmrWalletService xmrWalletService, WalletPasswordWindow walletPasswordWindow, @Named(value="storageDir") File storageDir) {
        this.walletsManager = walletsManager;
        this.openOfferManager = openOfferManager;
        this.xmrWalletService = xmrWalletService;
        this.walletPasswordWindow = walletPasswordWindow;
        this.storageDir = storageDir;
    }

    @Override
    protected void initialize() {
        FormBuilder.addTitledGroupBg((GridPane)this.root, this.gridRow, 2, Res.get((String)"account.seed.backup.title"));
        this.displaySeedWordsTextArea = (TextArea)FormBuilder.addTopLabelTextArea((GridPane)((GridPane)this.root), (int)this.gridRow, (String)Res.get((String)"seed.seedWords"), (String)"", (double)20.0).second;
        this.displaySeedWordsTextArea.getStyleClass().add((Object)"wallet-seed-words");
        this.displaySeedWordsTextArea.setPrefHeight(70.0);
        this.displaySeedWordsTextArea.setMaxHeight(70.0);
        this.displaySeedWordsTextArea.setEditable(false);
        this.datePicker = (DatePicker)FormBuilder.addTopLabelDatePicker((GridPane)((GridPane)this.root), (int)(++this.gridRow), (String)Res.get((String)"seed.date"), (double)10.0).second;
        this.datePicker.setMouseTransparent(true);
        FormBuilder.addTitledGroupBg((GridPane)this.root, ++this.gridRow, 1, Res.get((String)"shared.information"), 40.0);
        FormBuilder.addMultilineLabel((GridPane)this.root, this.gridRow, Res.get((String)"account.seed.info"), 60.0);
        this.seedWordsValidChangeListener = (observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.seedWordsTextArea.getStyleClass().remove((Object)"validation-error");
            } else {
                this.seedWordsTextArea.getStyleClass().add((Object)"validation-error");
            }
        };
        this.seedWordsTextAreaChangeListener = (observable, oldValue, newValue) -> {
            this.seedWordsEdited.set(true);
            try {
                MnemonicCode codec = new MnemonicCode();
                codec.check(Splitter.on((String)" ").splitToList((CharSequence)newValue));
                this.seedWordsValid.set(true);
            }
            catch (IOException | MnemonicException e) {
                this.seedWordsValid.set(false);
            }
        };
    }

    @Override
    public void activate() {
        String key = "showBackupWarningAtSeedPhrase";
        if (DontShowAgainLookup.showAgain((String)key)) {
            ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"account.seed.backup.warning"))).onAction(this::showSeedPhrase)).actionButtonText(Res.get((String)"shared.iUnderstand"))).useIUnderstandButton()).dontShowAgainId(key)).hideCloseButton()).show();
        } else {
            this.showSeedPhrase();
        }
    }

    private void showSeedPhrase() {
        if (this.xmrWalletService.isWalletEncrypted()) {
            this.askForPassword();
        } else {
            String key = "showSeedWordsWarning";
            if (DontShowAgainLookup.showAgain((String)key)) {
                ((Popup)((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"account.seed.warn.noPw.msg"))).actionButtonText(Res.get((String)"account.seed.warn.noPw.yes"))).onAction(() -> {
                    DontShowAgainLookup.dontShowAgain((String)key, (boolean)true);
                    this.initSeedWords(this.xmrWalletService.getWallet().getSeed());
                    this.showSeedScreen();
                })).closeButtonText(Res.get((String)"shared.no"))).show();
            } else {
                this.initSeedWords(this.xmrWalletService.getWallet().getSeed());
                this.showSeedScreen();
            }
        }
    }

    @Override
    protected void deactivate() {
        this.displaySeedWordsTextArea.setText("");
        this.datePicker.setValue(null);
    }

    private void askForPassword() {
        ((WalletPasswordWindow)this.walletPasswordWindow.headLine(Res.get((String)"account.seed.enterPw"))).onSuccess(() -> {
            this.initSeedWords(this.xmrWalletService.getWallet().getSeed());
            this.showSeedScreen();
        }).hideForgotPasswordButton().show();
    }

    private void initSeedWords(String seed) {
        this.seedWordText = seed;
    }

    private void showSeedScreen() {
        this.displaySeedWordsTextArea.setText(this.seedWordText);
        this.walletCreationDate = Instant.ofEpochSecond(this.xmrWalletService.getWalletCreationDate()).atZone(ZoneId.systemDefault()).toLocalDate();
        this.datePicker.setValue((Object)this.walletCreationDate);
    }

    private void onRestore() {
        if (this.walletsManager.hasPositiveBalance()) {
            ((Popup)((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"seed.warn.walletNotEmpty.msg"))).actionButtonText(Res.get((String)"seed.warn.walletNotEmpty.restore"))).onAction(this::checkIfEncrypted)).closeButtonText(Res.get((String)"seed.warn.walletNotEmpty.emptyWallet"))).show();
        } else {
            this.checkIfEncrypted();
        }
    }

    private void checkIfEncrypted() {
        if (this.walletsManager.areWalletsEncrypted()) {
            ((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"seed.warn.notEncryptedAnymore"))).closeButtonText(Res.get((String)"shared.no"))).actionButtonText(Res.get((String)"shared.yes"))).onAction(this::doRestoreDateCheck)).show();
        } else {
            this.doRestoreDateCheck();
        }
    }

    private void doRestoreDateCheck() {
        if (this.restoreDatePicker.getValue() == null) {
            ((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"seed.warn.walletDateEmpty"))).closeButtonText(Res.get((String)"shared.no"))).actionButtonText(Res.get((String)"shared.yes"))).onAction(this::doRestore)).show();
        } else {
            this.doRestore();
        }
    }

    private LocalDate getWalletDate() {
        LocalDate walletDate = (LocalDate)this.restoreDatePicker.getValue();
        LocalDate oldestWalletDate = LocalDate.ofInstant(Instant.ofEpochMilli(MnemonicCode.BIP39_STANDARDISATION_TIME_SECS * 1000L), TimeZone.getDefault().toZoneId());
        if (walletDate == null) {
            walletDate = oldestWalletDate;
        } else if (walletDate.isBefore(oldestWalletDate)) {
            walletDate = oldestWalletDate;
        } else if (walletDate.isAfter(LocalDate.now())) {
            walletDate = LocalDate.now();
        }
        return walletDate;
    }

    private void doRestore() {
        LocalDate walletDate = this.getWalletDate();
        LocalDateTime localDateTime = walletDate.atStartOfDay().minusDays(1L);
        long date = localDateTime.toEpochSecond(ZoneOffset.UTC);
        DeterministicSeed seed = new DeterministicSeed(Splitter.on((String)" ").splitToList((CharSequence)this.seedWordsTextArea.getText()), null, "", date);
        SharedPresentation.restoreSeedWords(this.walletsManager, this.openOfferManager, seed, this.storageDir);
    }
}

