/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.account.content.password;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.jfoenix.validation.RequiredFieldValidator;
import com.jfoenix.validation.base.ValidatorBase;
import haveno.common.util.Tuple4;
import haveno.core.api.CoreAccountService;
import haveno.core.locale.Res;
import haveno.core.xmr.wallet.WalletsManager;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.BusyAnimation;
import haveno.desktop.components.PasswordTextField;
import haveno.desktop.components.TitledGroupBg;
import haveno.desktop.main.MainView;
import haveno.desktop.main.account.AccountView;
import haveno.desktop.main.account.content.backup.BackupView;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.validation.PasswordValidator;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

@FxmlView
public class PasswordView
extends ActivatableView<GridPane, Void> {
    private final WalletsManager walletsManager;
    private final PasswordValidator passwordValidator;
    private final Navigation navigation;
    private final CoreAccountService accountService;
    private PasswordTextField passwordField;
    private PasswordTextField repeatedPasswordField;
    private AutoTooltipButton pwButton;
    private TitledGroupBg headline;
    private int gridRow = 0;
    private ChangeListener<Boolean> passwordFieldFocusChangeListener;
    private ChangeListener<String> passwordFieldTextChangeListener;
    private ChangeListener<String> repeatedPasswordFieldChangeListener;

    @Inject
    private PasswordView(CoreAccountService accountService, WalletsManager walletsManager, PasswordValidator passwordValidator, Navigation navigation) {
        this.walletsManager = walletsManager;
        this.passwordValidator = passwordValidator;
        this.navigation = navigation;
        this.accountService = accountService;
    }

    @Override
    public void initialize() {
        this.headline = FormBuilder.addTitledGroupBg((GridPane)this.root, this.gridRow, 3, "");
        this.passwordField = FormBuilder.addPasswordTextField((GridPane)this.root, this.gridRow, Res.get((String)"password.enterPassword"), 40.0);
        RequiredFieldValidator requiredFieldValidator = new RequiredFieldValidator();
        this.passwordField.getValidators().addAll((Object[])new ValidatorBase[]{requiredFieldValidator, this.passwordValidator});
        this.passwordFieldFocusChangeListener = (observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.validatePasswords();
            }
        };
        this.passwordFieldTextChangeListener = (observable, oldvalue, newValue) -> {
            if (oldvalue != newValue) {
                this.validatePasswords();
            }
        };
        this.repeatedPasswordField = FormBuilder.addPasswordTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"password.confirmPassword"));
        requiredFieldValidator.setMessage(Res.get((String)"validation.empty"));
        this.repeatedPasswordField.getValidators().addAll((Object[])new ValidatorBase[]{requiredFieldValidator, this.passwordValidator});
        this.repeatedPasswordFieldChangeListener = (observable, oldValue, newValue) -> {
            if (oldValue != newValue) {
                this.validatePasswords();
            }
        };
        Tuple4<Button, BusyAnimation, Label, HBox> tuple = FormBuilder.addButtonBusyAnimationLabel((GridPane)this.root, ++this.gridRow, 0, "", 10.0);
        this.pwButton = (AutoTooltipButton)((Object)tuple.first);
        BusyAnimation busyAnimation = (BusyAnimation)((Object)tuple.second);
        Label deriveStatusLabel = (Label)tuple.third;
        this.pwButton.setDisable(true);
        this.setText();
        this.pwButton.setOnAction(e -> {
            if (!this.walletsManager.areWalletsEncrypted()) {
                ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().backgroundInfo(Res.get((String)"password.backupReminder"))).actionButtonText(Res.get((String)"password.setPassword"))).onAction(() -> this.onApplyPassword(busyAnimation, deriveStatusLabel))).secondaryActionButtonText(Res.get((String)"password.makeBackup"))).onSecondaryAction(() -> {
                    this.navigation.setReturnPath(this.navigation.getCurrentPath());
                    this.navigation.navigateTo(MainView.class, AccountView.class, BackupView.class);
                })).width(800.0)).show();
            } else {
                this.onApplyPassword(busyAnimation, deriveStatusLabel);
            }
        });
        FormBuilder.addTitledGroupBg((GridPane)this.root, ++this.gridRow, 1, Res.get((String)"shared.information"), 40.0);
        FormBuilder.addMultilineLabel((GridPane)this.root, this.gridRow, Res.get((String)"account.password.info"), 60.0);
    }

    private void onApplyPassword(BusyAnimation busyAnimation, Label deriveStatusLabel) {
        String password = this.passwordField.getText();
        Preconditions.checkArgument((password.length() < 500 ? 1 : 0) != 0, (Object)Res.get((String)"password.tooLong"));
        this.pwButton.setDisable(true);
        deriveStatusLabel.setText(Res.get((String)"password.deriveKey"));
        busyAnimation.play();
        if (this.walletsManager.areWalletsEncrypted()) {
            try {
                this.accountService.changePassword(password, null);
                ((Popup)new Popup().feedback(Res.get((String)"password.walletDecrypted"))).show();
                this.backupWalletAndResetFields();
            }
            catch (Throwable t) {
                this.pwButton.setDisable(false);
                ((Popup)new Popup().warning(Res.get((String)"password.wrongPw"))).show();
            }
        } else {
            try {
                this.accountService.changePassword(this.accountService.getPassword(), password);
                ((Popup)new Popup().feedback(Res.get((String)"password.walletEncrypted"))).show();
                this.backupWalletAndResetFields();
                this.walletsManager.clearBackup();
            }
            catch (Throwable t) {
                this.log.error("Error applying password: {}\n", (Object)t.getMessage(), (Object)t);
                ((Popup)new Popup().warning(Res.get((String)"password.walletEncryptionFailed") + "\n\n" + t.getMessage())).show();
            }
        }
        this.setText();
        this.updatePasswordListeners();
        deriveStatusLabel.setText("");
        busyAnimation.stop();
    }

    private void backupWalletAndResetFields() {
        this.passwordField.clear();
        this.repeatedPasswordField.clear();
        this.walletsManager.backupWallets();
    }

    private void setText() {
        if (this.walletsManager.areWalletsEncrypted()) {
            this.pwButton.updateText(Res.get((String)"account.password.removePw.button"));
            this.headline.setText(Res.get((String)"account.password.removePw.headline"));
            this.repeatedPasswordField.setVisible(false);
            this.repeatedPasswordField.setManaged(false);
        } else {
            this.pwButton.updateText(Res.get((String)"account.password.setPw.button"));
            this.headline.setText(Res.get((String)"account.password.setPw.headline"));
            this.repeatedPasswordField.setVisible(true);
            this.repeatedPasswordField.setManaged(true);
        }
    }

    @Override
    protected void activate() {
        this.updatePasswordListeners();
        this.repeatedPasswordField.textProperty().addListener(this.repeatedPasswordFieldChangeListener);
    }

    private void updatePasswordListeners() {
        this.passwordField.focusedProperty().removeListener(this.passwordFieldFocusChangeListener);
        this.passwordField.textProperty().removeListener(this.passwordFieldTextChangeListener);
        if (this.walletsManager.areWalletsEncrypted()) {
            this.passwordField.textProperty().addListener(this.passwordFieldTextChangeListener);
        } else {
            this.passwordField.focusedProperty().addListener(this.passwordFieldFocusChangeListener);
        }
    }

    @Override
    protected void deactivate() {
        this.passwordField.focusedProperty().removeListener(this.passwordFieldFocusChangeListener);
        this.passwordField.textProperty().removeListener(this.passwordFieldTextChangeListener);
        this.repeatedPasswordField.textProperty().removeListener(this.repeatedPasswordFieldChangeListener);
    }

    private void validatePasswords() {
        this.passwordValidator.setPasswordsMatch(true);
        if (this.passwordField.validate()) {
            if (this.walletsManager.areWalletsEncrypted()) {
                this.pwButton.setDisable(false);
                return;
            }
            if (this.repeatedPasswordField.validate()) {
                if (this.passwordField.getText().equals(this.repeatedPasswordField.getText())) {
                    this.pwButton.setDisable(false);
                    return;
                }
                this.passwordValidator.setPasswordsMatch(false);
                this.repeatedPasswordField.validate();
            }
        }
        this.pwButton.setDisable(true);
    }
}

