/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.account.content.notifications;

import com.google.inject.Inject;
import haveno.common.UserThread;
import haveno.common.util.Tuple2;
import haveno.common.util.Tuple3;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.notifications.MobileMessage;
import haveno.core.notifications.MobileNotificationService;
import haveno.core.notifications.alerts.DisputeMsgEvents;
import haveno.core.notifications.alerts.MyOfferTakenEvents;
import haveno.core.notifications.alerts.TradeEvents;
import haveno.core.notifications.alerts.market.MarketAlertFilter;
import haveno.core.notifications.alerts.market.MarketAlerts;
import haveno.core.notifications.alerts.price.PriceAlert;
import haveno.core.notifications.alerts.price.PriceAlertFilter;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.validation.PercentageNumberValidator;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.core.util.FormattingUtils;
import haveno.core.util.ParsingUtils;
import haveno.core.util.PriceUtil;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.InfoInputTextField;
import haveno.desktop.components.InputTextField;
import haveno.desktop.main.account.content.notifications.ManageMarketAlertsWindow;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.SetChangeListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.util.StringConverter;

@FxmlView
public class MobileNotificationsView
extends ActivatableView<GridPane, Void> {
    private final Preferences preferences;
    private final User user;
    private final PriceFeedService priceFeedService;
    private final MarketAlerts marketAlerts;
    private final MobileNotificationService mobileNotificationService;
    private TextField tokenInputTextField;
    private InputTextField priceAlertHighInputTextField;
    private InputTextField priceAlertLowInputTextField;
    private InputTextField marketAlertTriggerInputTextField;
    private ToggleButton useSoundToggleButton;
    private ToggleButton tradeToggleButton;
    private ToggleButton marketToggleButton;
    private ToggleButton priceToggleButton;
    private ComboBox<TradeCurrency> currencyComboBox;
    private ComboBox<PaymentAccount> paymentAccountsComboBox;
    private Button downloadButton;
    private Button eraseButton;
    private Button setPriceAlertButton;
    private Button removePriceAlertButton;
    private Button addMarketAlertButton;
    private Button manageAlertsButton;
    private ChangeListener<Boolean> useSoundCheckBoxListener;
    private ChangeListener<Boolean> tradeCheckBoxListener;
    private ChangeListener<Boolean> marketCheckBoxListener;
    private ChangeListener<Boolean> priceCheckBoxListener;
    private ChangeListener<Boolean> priceAlertHighFocusListener;
    private ChangeListener<Boolean> priceAlertLowFocusListener;
    private ChangeListener<Boolean> marketAlertTriggerFocusListener;
    private ChangeListener<String> tokenInputTextFieldListener;
    private ChangeListener<String> priceAlertHighListener;
    private ChangeListener<String> priceAlertLowListener;
    private ChangeListener<String> marketAlertTriggerListener;
    private ChangeListener<Number> priceFeedServiceListener;
    private SetChangeListener<PaymentAccount> paymentAccountsChangeListener;
    private int gridRow = 0;
    private int testMsgCounter = 0;
    private RadioButton buyOffersRadioButton;
    private RadioButton sellOffersRadioButton;
    private ToggleGroup offerTypeRadioButtonsToggleGroup;
    private ChangeListener<Toggle> offerTypeListener;
    private String selectedPriceAlertTradeCurrency;

    @Inject
    private MobileNotificationsView(Preferences preferences, User user, PriceFeedService priceFeedService, MarketAlerts marketAlerts, MobileNotificationService mobileNotificationService) {
        this.preferences = preferences;
        this.user = user;
        this.priceFeedService = priceFeedService;
        this.marketAlerts = marketAlerts;
        this.mobileNotificationService = mobileNotificationService;
    }

    @Override
    public void initialize() {
        this.createListeners();
        this.createSetupFields();
        this.createSettingsFields();
        this.createMarketAlertFields();
        this.createPriceAlertFields();
    }

    @Override
    protected void activate() {
        this.addListeners();
        this.tokenInputTextField.textProperty().addListener(this.tokenInputTextFieldListener);
        this.downloadButton.setOnAction(e -> this.onDownload());
        this.eraseButton.setOnAction(e -> this.onErase());
        this.useSoundToggleButton.selectedProperty().addListener(this.useSoundCheckBoxListener);
        this.tradeToggleButton.selectedProperty().addListener(this.tradeCheckBoxListener);
        this.marketToggleButton.selectedProperty().addListener(this.marketCheckBoxListener);
        this.priceToggleButton.selectedProperty().addListener(this.priceCheckBoxListener);
        this.marketAlertTriggerInputTextField.textProperty().addListener(this.marketAlertTriggerListener);
        this.marketAlertTriggerInputTextField.focusedProperty().addListener(this.marketAlertTriggerFocusListener);
        this.offerTypeRadioButtonsToggleGroup.selectedToggleProperty().addListener(this.offerTypeListener);
        this.paymentAccountsComboBox.setOnAction(e -> this.onPaymentAccountSelected());
        this.addMarketAlertButton.setOnAction(e -> this.onAddMarketAlert());
        this.manageAlertsButton.setOnAction(e -> this.onManageMarketAlerts());
        this.fillPaymentAccounts();
        this.priceAlertHighInputTextField.textProperty().addListener(this.priceAlertHighListener);
        this.priceAlertLowInputTextField.textProperty().addListener(this.priceAlertLowListener);
        this.priceAlertHighInputTextField.focusedProperty().addListener(this.priceAlertHighFocusListener);
        this.priceAlertLowInputTextField.focusedProperty().addListener(this.priceAlertLowFocusListener);
        this.priceFeedService.updateCounterProperty().addListener(this.priceFeedServiceListener);
        this.currencyComboBox.setOnAction(e -> this.onSelectedTradeCurrency());
        this.setPriceAlertButton.setOnAction(e -> this.onSetPriceAlert());
        this.removePriceAlertButton.setOnAction(e -> this.onRemovePriceAlert());
        this.currencyComboBox.setItems(this.preferences.getTradeCurrenciesAsObservable());
        if (this.preferences.getPhoneKeyAndToken() != null) {
            this.tokenInputTextField.setText(this.preferences.getPhoneKeyAndToken());
            this.setPairingTokenFieldsVisible();
        } else {
            this.eraseButton.setDisable(true);
        }
        this.setDisableForSetupFields(!this.mobileNotificationService.isSetupConfirmationSent());
        this.updateMarketAlertFields();
        this.fillPriceAlertFields();
        this.updatePriceAlertFields();
    }

    @Override
    protected void deactivate() {
        this.removeListeners();
        this.tokenInputTextField.textProperty().removeListener(this.tokenInputTextFieldListener);
        this.downloadButton.setOnAction(null);
        this.eraseButton.setOnAction(null);
        this.useSoundToggleButton.selectedProperty().removeListener(this.useSoundCheckBoxListener);
        this.tradeToggleButton.selectedProperty().removeListener(this.tradeCheckBoxListener);
        this.marketToggleButton.selectedProperty().removeListener(this.marketCheckBoxListener);
        this.priceToggleButton.selectedProperty().removeListener(this.priceCheckBoxListener);
        this.marketAlertTriggerInputTextField.textProperty().removeListener(this.marketAlertTriggerListener);
        this.marketAlertTriggerInputTextField.focusedProperty().removeListener(this.marketAlertTriggerFocusListener);
        this.offerTypeRadioButtonsToggleGroup.selectedToggleProperty().removeListener(this.offerTypeListener);
        this.paymentAccountsComboBox.setOnAction(null);
        this.addMarketAlertButton.setOnAction(null);
        this.manageAlertsButton.setOnAction(null);
        this.priceAlertHighInputTextField.textProperty().removeListener(this.priceAlertHighListener);
        this.priceAlertLowInputTextField.textProperty().removeListener(this.priceAlertLowListener);
        this.priceAlertHighInputTextField.focusedProperty().removeListener(this.priceAlertHighFocusListener);
        this.priceAlertLowInputTextField.focusedProperty().removeListener(this.priceAlertLowFocusListener);
        this.priceFeedService.updateCounterProperty().removeListener(this.priceFeedServiceListener);
        this.currencyComboBox.setOnAction(null);
        this.setPriceAlertButton.setOnAction(null);
        this.removePriceAlertButton.setOnAction(null);
    }

    private void onDownload() {
        GUIUtil.openWebPage("https://haveno.exchange/downloads");
    }

    private void onErase() {
        try {
            this.mobileNotificationService.sendEraseMessage();
            this.reset();
        }
        catch (Exception e) {
            ((Popup)new Popup().error(e.toString())).show();
        }
    }

    private void onSendTestMsg() {
        MobileMessage message = null;
        List messages = null;
        switch (this.testMsgCounter) {
            case 0: {
                message = MyOfferTakenEvents.getTestMsg();
                break;
            }
            case 1: {
                messages = TradeEvents.getTestMessages();
                break;
            }
            case 2: {
                message = DisputeMsgEvents.getTestMsg();
                break;
            }
            case 3: {
                message = PriceAlert.getTestMsg();
                break;
            }
            default: {
                message = MarketAlerts.getTestMsg();
            }
        }
        ++this.testMsgCounter;
        if (this.testMsgCounter > 4) {
            this.testMsgCounter = 0;
        }
        try {
            if (message != null) {
                this.mobileNotificationService.sendMessage(message, this.useSoundToggleButton.isSelected());
            } else {
                messages.forEach(msg -> {
                    try {
                        this.mobileNotificationService.sendMessage(msg, this.useSoundToggleButton.isSelected());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (Exception e) {
            ((Popup)new Popup().error(e.toString())).show();
        }
    }

    private void onPaymentAccountSelected() {
        this.marketAlertTriggerInputTextField.clear();
        this.marketAlertTriggerInputTextField.resetValidation();
        this.offerTypeRadioButtonsToggleGroup.selectToggle(null);
        this.updateMarketAlertFields();
    }

    private void onAddMarketAlert() {
        PaymentAccount paymentAccount = (PaymentAccount)this.paymentAccountsComboBox.getSelectionModel().getSelectedItem();
        double percentAsDouble = ParsingUtils.parsePercentStringToDouble((String)this.marketAlertTriggerInputTextField.getText());
        int triggerValue = (int)Math.round(percentAsDouble * 10000.0);
        boolean isBuyOffer = this.offerTypeRadioButtonsToggleGroup.getSelectedToggle() == this.buyOffersRadioButton;
        MarketAlertFilter marketAlertFilter = new MarketAlertFilter(paymentAccount, triggerValue, isBuyOffer);
        this.marketAlerts.addMarketAlertFilter(marketAlertFilter);
        this.paymentAccountsComboBox.getSelectionModel().clearSelection();
    }

    private void onManageMarketAlerts() {
        ((ManageMarketAlertsWindow)new ManageMarketAlertsWindow(this.marketAlerts).onClose(this::updateMarketAlertFields)).show();
    }

    private void onSelectedTradeCurrency() {
        TradeCurrency selectedItem = (TradeCurrency)this.currencyComboBox.getSelectionModel().getSelectedItem();
        if (selectedItem != null) {
            this.selectedPriceAlertTradeCurrency = selectedItem.getCode();
            this.priceAlertHighInputTextField.setValidator((InputValidator)PriceUtil.getPriceValidator((String)this.selectedPriceAlertTradeCurrency));
            this.priceAlertLowInputTextField.setValidator((InputValidator)PriceUtil.getPriceValidator((String)this.selectedPriceAlertTradeCurrency));
        } else {
            this.selectedPriceAlertTradeCurrency = null;
        }
        this.updatePriceAlertFields();
    }

    private void onSetPriceAlert() {
        if (this.arePriceAlertInputsValid()) {
            String code = this.selectedPriceAlertTradeCurrency;
            long high = this.getPriceAsLong(this.priceAlertHighInputTextField);
            long low = this.getPriceAsLong(this.priceAlertLowInputTextField);
            if (high > 0L && low > 0L) {
                this.user.setPriceAlertFilter(new PriceAlertFilter(code, high, low));
            }
            this.updatePriceAlertFields();
        }
    }

    private void onRemovePriceAlert() {
        this.user.removePriceAlertFilter();
        this.fillPriceAlertFields();
        this.updatePriceAlertFields();
    }

    private void createSetupFields() {
        FormBuilder.addTitledGroupBg((GridPane)this.root, this.gridRow, 4, Res.get((String)"account.notifications.setup.title"));
        this.downloadButton = FormBuilder.addButton((GridPane)this.root, this.gridRow, Res.get((String)"account.notifications.download.label"), 40.0);
        this.tokenInputTextField = FormBuilder.addInputTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"account.notifications.email.label"));
        this.tokenInputTextField.setPromptText(Res.get((String)"account.notifications.email.prompt"));
        this.tokenInputTextFieldListener = (observable, oldValue, newValue) -> this.applyKeyAndToken((String)newValue);
        this.eraseButton = (Button)FormBuilder.addTopLabelButton((GridPane)((GridPane)this.root), (int)(++this.gridRow), (String)Res.get((String)"account.notifications.erase.label"), (String)Res.get((String)"account.notifications.erase.title")).second;
        this.eraseButton.setId("notification-erase-button");
    }

    private void createSettingsFields() {
        FormBuilder.addTitledGroupBg((GridPane)this.root, ++this.gridRow, 4, Res.get((String)"account.notifications.settings.title"), 40.0);
        this.useSoundToggleButton = FormBuilder.addSlideToggleButton((GridPane)this.root, this.gridRow, Res.get((String)"account.notifications.useSound.label"), 60.0);
        this.useSoundToggleButton.setSelected(this.preferences.isUseSoundForMobileNotifications());
        this.useSoundCheckBoxListener = (observable, oldValue, newValue) -> {
            this.mobileNotificationService.getUseSoundProperty().set(newValue.booleanValue());
            this.preferences.setUseSoundForMobileNotifications(newValue.booleanValue());
        };
        this.tradeToggleButton = FormBuilder.addSlideToggleButton((GridPane)this.root, ++this.gridRow, Res.get((String)"account.notifications.trade.label"));
        this.tradeToggleButton.setSelected(this.preferences.isUseTradeNotifications());
        this.tradeCheckBoxListener = (observable, oldValue, newValue) -> {
            this.mobileNotificationService.getUseTradeNotificationsProperty().set(newValue.booleanValue());
            this.preferences.setUseTradeNotifications(newValue.booleanValue());
        };
        this.marketToggleButton = FormBuilder.addSlideToggleButton((GridPane)this.root, ++this.gridRow, Res.get((String)"account.notifications.market.label"));
        this.marketToggleButton.setSelected(this.preferences.isUseMarketNotifications());
        this.marketCheckBoxListener = (observable, oldValue, newValue) -> {
            this.mobileNotificationService.getUseMarketNotificationsProperty().set(newValue.booleanValue());
            this.preferences.setUseMarketNotifications(newValue.booleanValue());
            this.updateMarketAlertFields();
        };
        this.priceToggleButton = FormBuilder.addSlideToggleButton((GridPane)this.root, ++this.gridRow, Res.get((String)"account.notifications.price.label"));
        this.priceToggleButton.setSelected(this.preferences.isUsePriceNotifications());
        this.priceCheckBoxListener = (observable, oldValue, newValue) -> {
            this.mobileNotificationService.getUsePriceNotificationsProperty().set(newValue.booleanValue());
            this.preferences.setUsePriceNotifications(newValue.booleanValue());
            this.updatePriceAlertFields();
        };
    }

    private void createMarketAlertFields() {
        FormBuilder.addTitledGroupBg((GridPane)this.root, ++this.gridRow, 4, Res.get((String)"account.notifications.marketAlert.title"), 40.0);
        this.paymentAccountsComboBox = FormBuilder.addComboBox((GridPane)this.root, this.gridRow, Res.get((String)"account.notifications.marketAlert.selectPaymentAccount"), 60.0);
        this.paymentAccountsComboBox.setConverter((StringConverter)new StringConverter<PaymentAccount>(this){

            public String toString(PaymentAccount paymentAccount) {
                return paymentAccount.getAccountName();
            }

            public PaymentAccount fromString(String string) {
                return null;
            }
        });
        this.offerTypeRadioButtonsToggleGroup = new ToggleGroup();
        Tuple3<Label, RadioButton, RadioButton> tuple = FormBuilder.addTopLabelRadioButtonRadioButton((GridPane)this.root, ++this.gridRow, this.offerTypeRadioButtonsToggleGroup, Res.get((String)"account.notifications.marketAlert.offerType.label"), Res.get((String)"account.notifications.marketAlert.offerType.buy"), Res.get((String)"account.notifications.marketAlert.offerType.sell"), 10.0);
        this.buyOffersRadioButton = (RadioButton)tuple.second;
        this.sellOffersRadioButton = (RadioButton)tuple.third;
        this.offerTypeListener = (observable, oldValue, newValue) -> {
            this.marketAlertTriggerInputTextField.clear();
            this.marketAlertTriggerInputTextField.resetValidation();
            this.updateMarketAlertFields();
        };
        InfoInputTextField infoInputTextField = (InfoInputTextField)((Object)FormBuilder.addTopLabelInfoInputTextField((GridPane)((GridPane)this.root), (int)(++this.gridRow), (String)Res.get((String)"account.notifications.marketAlert.trigger"), (double)10.0).second);
        this.marketAlertTriggerInputTextField = infoInputTextField.getInputTextField();
        this.marketAlertTriggerInputTextField.setPromptText(Res.get((String)"account.notifications.marketAlert.trigger.prompt"));
        PercentageNumberValidator validator = new PercentageNumberValidator();
        validator.setMaxValue(Double.valueOf(50.0));
        this.marketAlertTriggerInputTextField.setValidator((InputValidator)validator);
        infoInputTextField.setContentForInfoPopOver((Node)this.createMarketAlertPriceInfoPopupLabel(Res.get((String)"account.notifications.marketAlert.trigger.info")));
        infoInputTextField.setIconsRightAligned();
        this.marketAlertTriggerListener = (observable, oldValue, newValue) -> this.updateMarketAlertFields();
        this.marketAlertTriggerFocusListener = (observable, oldValue, newValue) -> {
            if (oldValue.booleanValue() && !newValue.booleanValue()) {
                try {
                    double percentAsDouble = ParsingUtils.parsePercentStringToDouble((String)this.marketAlertTriggerInputTextField.getText()) * 100.0;
                    this.marketAlertTriggerInputTextField.setText(FormattingUtils.formatRoundedDoubleWithPrecision((double)percentAsDouble, (int)2) + "%");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.updateMarketAlertFields();
            }
        };
        Tuple2<Button, Button> buttonTuple = FormBuilder.add2ButtonsAfterGroup((GridPane)this.root, ++this.gridRow, Res.get((String)"account.notifications.marketAlert.addButton"), Res.get((String)"account.notifications.marketAlert.manageAlertsButton"));
        this.addMarketAlertButton = (Button)buttonTuple.first;
        this.manageAlertsButton = (Button)buttonTuple.second;
    }

    private void createPriceAlertFields() {
        FormBuilder.addTitledGroupBg((GridPane)this.root, ++this.gridRow, 4, Res.get((String)"account.notifications.priceAlert.title"), 20.0);
        this.currencyComboBox = FormBuilder.addComboBox((GridPane)this.root, this.gridRow, Res.get((String)"list.currency.select"), 40.0);
        this.currencyComboBox.setPromptText(Res.get((String)"list.currency.select"));
        this.currencyComboBox.setConverter((StringConverter)new StringConverter<TradeCurrency>(this){

            public String toString(TradeCurrency currency) {
                return currency.getNameAndCode();
            }

            public TradeCurrency fromString(String string) {
                return null;
            }
        });
        this.priceAlertHighInputTextField = FormBuilder.addInputTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"account.notifications.priceAlert.high.label"));
        this.priceAlertHighListener = (observable, oldValue, newValue) -> {
            long priceAlertHighTextFieldValue = this.getPriceAsLong(this.priceAlertHighInputTextField);
            long priceAlertLowTextFieldValue = this.getPriceAsLong(this.priceAlertLowInputTextField);
            if (priceAlertLowTextFieldValue != 0L && priceAlertHighTextFieldValue != 0L && priceAlertHighTextFieldValue > priceAlertLowTextFieldValue) {
                this.updatePriceAlertFields();
            }
        };
        this.priceAlertHighFocusListener = (observable, oldValue, newValue) -> {
            if (oldValue.booleanValue() && !newValue.booleanValue()) {
                this.applyPriceFormatting(this.priceAlertHighInputTextField);
                long priceAlertHighTextFieldValue = this.getPriceAsLong(this.priceAlertHighInputTextField);
                long priceAlertLowTextFieldValue = this.getPriceAsLong(this.priceAlertLowInputTextField);
                if (priceAlertLowTextFieldValue != 0L && priceAlertHighTextFieldValue != 0L && priceAlertHighTextFieldValue <= priceAlertLowTextFieldValue) {
                    ((Popup)new Popup().warning(Res.get((String)"account.notifications.priceAlert.warning.highPriceTooLow"))).show();
                    UserThread.execute(() -> {
                        this.priceAlertHighInputTextField.clear();
                        this.updatePriceAlertFields();
                    });
                }
            }
        };
        this.priceAlertLowInputTextField = FormBuilder.addInputTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"account.notifications.priceAlert.low.label"));
        this.priceAlertLowListener = (observable, oldValue, newValue) -> {
            long priceAlertHighTextFieldValue = this.getPriceAsLong(this.priceAlertHighInputTextField);
            long priceAlertLowTextFieldValue = this.getPriceAsLong(this.priceAlertLowInputTextField);
            if (priceAlertLowTextFieldValue != 0L && priceAlertHighTextFieldValue != 0L && priceAlertLowTextFieldValue < priceAlertHighTextFieldValue) {
                this.updatePriceAlertFields();
            }
        };
        this.priceAlertLowFocusListener = (observable, oldValue, newValue) -> {
            this.applyPriceFormatting(this.priceAlertLowInputTextField);
            long priceAlertHighTextFieldValue = this.getPriceAsLong(this.priceAlertHighInputTextField);
            long priceAlertLowTextFieldValue = this.getPriceAsLong(this.priceAlertLowInputTextField);
            if (priceAlertLowTextFieldValue != 0L && priceAlertHighTextFieldValue != 0L && priceAlertLowTextFieldValue >= priceAlertHighTextFieldValue) {
                ((Popup)new Popup().warning(Res.get((String)"account.notifications.priceAlert.warning.lowerPriceTooHigh"))).show();
                UserThread.execute(() -> {
                    this.priceAlertLowInputTextField.clear();
                    this.updatePriceAlertFields();
                });
            }
        };
        Tuple2<Button, Button> tuple = FormBuilder.add2ButtonsAfterGroup((GridPane)this.root, ++this.gridRow, Res.get((String)"account.notifications.priceAlert.setButton"), Res.get((String)"account.notifications.priceAlert.removeButton"));
        this.setPriceAlertButton = (Button)tuple.first;
        this.removePriceAlertButton = (Button)tuple.second;
        this.priceFeedServiceListener = (observable, oldValue, newValue) -> UserThread.execute(() -> {
            this.fillPriceAlertFields();
            this.updatePriceAlertFields();
        });
    }

    private void applyKeyAndToken(String keyAndToken) {
        boolean isValid;
        if (keyAndToken != null && !keyAndToken.isEmpty() && (isValid = this.mobileNotificationService.applyKeyAndToken(keyAndToken))) {
            this.setDisableForSetupFields(false);
            this.setPairingTokenFieldsVisible();
            this.updateMarketAlertFields();
            this.updatePriceAlertFields();
        }
    }

    private void setDisableForSetupFields(boolean disable) {
        this.eraseButton.setDisable(disable);
        this.useSoundToggleButton.setDisable(disable);
        this.tradeToggleButton.setDisable(disable);
        this.marketToggleButton.setDisable(disable);
        this.priceToggleButton.setDisable(disable);
    }

    private void setPairingTokenFieldsVisible() {
        this.tokenInputTextField.setManaged(true);
        this.tokenInputTextField.setVisible(true);
    }

    private void reset() {
        this.mobileNotificationService.reset();
        this.tokenInputTextField.clear();
        this.setDisableForSetupFields(true);
        this.eraseButton.setDisable(true);
        this.onRemovePriceAlert();
        new ArrayList<MarketAlertFilter>(this.marketAlerts.getMarketAlertFilters()).forEach(arg_0 -> ((MarketAlerts)this.marketAlerts).removeMarketAlertFilter(arg_0));
    }

    private Label createMarketAlertPriceInfoPopupLabel(String text) {
        Label label = new Label(text);
        label.setPrefWidth(300.0);
        label.setWrapText(true);
        label.setPadding(new Insets(10.0));
        return label;
    }

    private void updateMarketAlertFields() {
        boolean setupConfirmationSent = this.mobileNotificationService.isSetupConfirmationSent();
        boolean selected = this.marketToggleButton.isSelected();
        boolean disabled = !selected || !setupConfirmationSent;
        boolean isPaymentAccountSelected = this.paymentAccountsComboBox.getSelectionModel().getSelectedItem() != null;
        boolean isOfferTypeSelected = this.offerTypeRadioButtonsToggleGroup.getSelectedToggle() != null;
        boolean isTriggerValueValid = this.marketAlertTriggerInputTextField.getValidator() != null && this.marketAlertTriggerInputTextField.getValidator().validate((String)this.marketAlertTriggerInputTextField.getText()).isValid;
        boolean allInputsValid = isPaymentAccountSelected && isOfferTypeSelected && isTriggerValueValid;
        this.paymentAccountsComboBox.setDisable(disabled);
        this.buyOffersRadioButton.setDisable(disabled);
        this.sellOffersRadioButton.setDisable(disabled);
        this.marketAlertTriggerInputTextField.setDisable(disabled);
        this.addMarketAlertButton.setDisable(disabled || !allInputsValid);
        this.manageAlertsButton.setDisable(disabled || this.marketAlerts.getMarketAlertFilters().isEmpty());
    }

    private void fillPriceAlertFields() {
        PriceAlertFilter priceAlertFilter = this.user.getPriceAlertFilter();
        if (priceAlertFilter != null) {
            String currencyCode = priceAlertFilter.getCurrencyCode();
            Optional optionalTradeCurrency = CurrencyUtil.getTradeCurrency((String)currencyCode);
            if (optionalTradeCurrency.isPresent()) {
                this.currencyComboBox.getSelectionModel().select((Object)((TradeCurrency)optionalTradeCurrency.get()));
                this.onSelectedTradeCurrency();
                this.priceAlertHighInputTextField.setText(PriceUtil.formatMarketPrice((long)priceAlertFilter.getHigh(), (String)currencyCode));
                this.priceAlertHighInputTextField.setText(FormattingUtils.formatMarketPrice((double)((double)priceAlertFilter.getHigh() / 10000.0), (String)currencyCode));
                this.priceAlertLowInputTextField.setText(FormattingUtils.formatMarketPrice((double)((double)priceAlertFilter.getLow() / 10000.0), (String)currencyCode));
            } else {
                this.currencyComboBox.getSelectionModel().clearSelection();
            }
        } else {
            this.priceAlertHighInputTextField.clear();
            this.priceAlertLowInputTextField.clear();
            this.priceAlertHighInputTextField.resetValidation();
            this.priceAlertLowInputTextField.resetValidation();
            this.currencyComboBox.getSelectionModel().clearSelection();
        }
    }

    private void updatePriceAlertFields() {
        boolean setupConfirmationSent = this.mobileNotificationService.isSetupConfirmationSent();
        boolean selected = this.priceToggleButton.isSelected();
        boolean disable = !setupConfirmationSent || !selected;
        this.priceAlertHighInputTextField.setDisable(this.selectedPriceAlertTradeCurrency == null || disable);
        this.priceAlertLowInputTextField.setDisable(this.selectedPriceAlertTradeCurrency == null || disable);
        PriceAlertFilter priceAlertFilter = this.user.getPriceAlertFilter();
        boolean valueSameAsFilter = false;
        if (priceAlertFilter != null && this.selectedPriceAlertTradeCurrency != null) {
            valueSameAsFilter = priceAlertFilter.getHigh() == this.getPriceAsLong(this.priceAlertHighInputTextField) && priceAlertFilter.getLow() == this.getPriceAsLong(this.priceAlertLowInputTextField) && priceAlertFilter.getCurrencyCode().equals(this.selectedPriceAlertTradeCurrency);
        }
        this.setPriceAlertButton.setDisable(disable || !this.arePriceAlertInputsValid() || valueSameAsFilter);
        this.removePriceAlertButton.setDisable(disable || priceAlertFilter == null);
        this.currencyComboBox.setDisable(disable);
    }

    private boolean arePriceAlertInputsValid() {
        return this.selectedPriceAlertTradeCurrency != null && this.isPriceInputValid((InputTextField)this.priceAlertHighInputTextField).isValid && this.isPriceInputValid((InputTextField)this.priceAlertLowInputTextField).isValid;
    }

    private InputValidator.ValidationResult isPriceInputValid(InputTextField inputTextField) {
        InputValidator validator = inputTextField.getValidator();
        if (validator != null) {
            return validator.validate(inputTextField.getText());
        }
        return new InputValidator.ValidationResult(false);
    }

    private long getPriceAsLong(InputTextField inputTextField) {
        return PriceUtil.getMarketPriceAsLong((String)inputTextField.getText(), (String)this.selectedPriceAlertTradeCurrency);
    }

    private void applyPriceFormatting(InputTextField inputTextField) {
        try {
            String reformattedPrice = PriceUtil.reformatMarketPrice((String)inputTextField.getText(), (String)this.selectedPriceAlertTradeCurrency);
            inputTextField.setText(reformattedPrice);
        }
        catch (Throwable ignore) {
            this.updatePriceAlertFields();
        }
    }

    private void createListeners() {
        this.paymentAccountsChangeListener = change -> this.fillPaymentAccounts();
    }

    private void addListeners() {
        this.user.getPaymentAccountsAsObservable().addListener(this.paymentAccountsChangeListener);
    }

    private void removeListeners() {
        this.user.getPaymentAccountsAsObservable().removeListener(this.paymentAccountsChangeListener);
    }

    private void fillPaymentAccounts() {
        this.paymentAccountsComboBox.setItems(FXCollections.observableArrayList((Collection)this.user.getPaymentAccounts()));
    }
}

