/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.account.content.notifications;

import haveno.common.UserThread;
import haveno.core.locale.Res;
import haveno.core.notifications.alerts.market.MarketAlertFilter;
import haveno.core.notifications.alerts.market.MarketAlerts;
import haveno.core.util.FormattingUtils;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.AutoTooltipTableColumn;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.util.GUIUtil;
import haveno.desktop.util.ImageUtil;
import java.util.Collection;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageMarketAlertsWindow
extends Overlay<ManageMarketAlertsWindow> {
    private static final Logger log = LoggerFactory.getLogger(ManageMarketAlertsWindow.class);
    private final MarketAlerts marketAlerts;

    ManageMarketAlertsWindow(MarketAlerts marketAlerts) {
        this.marketAlerts = marketAlerts;
        this.type = Overlay.Type.Attention;
    }

    @Override
    public void show() {
        if (this.headLine == null) {
            this.headLine = Res.get((String)"account.notifications.marketAlert.manageAlerts.title");
        }
        this.width = 968.0;
        this.createGridPane();
        this.addHeadLine();
        this.addContent();
        this.addButtons();
        this.applyStyles();
        this.display();
    }

    @Override
    protected void applyStyles() {
        super.applyStyles();
        this.gridPane.setId("popup-grid-pane-bg");
    }

    private void addContent() {
        TableView tableView = new TableView();
        GUIUtil.applyTableStyle(tableView);
        GridPane.setRowIndex((Node)tableView, (Integer)(++this.rowIndex));
        GridPane.setColumnSpan((Node)tableView, (Integer)2);
        GridPane.setMargin((Node)tableView, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        this.gridPane.getChildren().add((Object)tableView);
        AutoTooltipLabel placeholder = new AutoTooltipLabel(Res.get((String)"table.placeholder.noData"));
        placeholder.setWrapText(true);
        tableView.setPlaceholder((Node)placeholder);
        tableView.setPrefHeight(300.0);
        tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.setColumns((TableView<MarketAlertFilter>)tableView);
        tableView.setItems(FXCollections.observableArrayList((Collection)this.marketAlerts.getMarketAlertFilters()));
    }

    private void removeMarketAlertFilter(MarketAlertFilter marketAlertFilter, TableView<MarketAlertFilter> tableView) {
        this.marketAlerts.removeMarketAlertFilter(marketAlertFilter);
        UserThread.execute(() -> tableView.setItems(FXCollections.observableArrayList((Collection)this.marketAlerts.getMarketAlertFilters())));
    }

    private void setColumns(final TableView<MarketAlertFilter> tableView) {
        TableColumn column = new AutoTooltipTableColumn(Res.get((String)"account.notifications.marketAlert.manageAlerts.header.paymentAccount"));
        column.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((MarketAlertFilter)item.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<MarketAlertFilter, MarketAlertFilter>, TableCell<MarketAlertFilter, MarketAlertFilter>>(this){

            public TableCell<MarketAlertFilter, MarketAlertFilter> call(TableColumn<MarketAlertFilter, MarketAlertFilter> column) {
                return new TableCell<MarketAlertFilter, MarketAlertFilter>(this){

                    public void updateItem(MarketAlertFilter item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(item.getPaymentAccount().getAccountName());
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        tableView.getColumns().add(column);
        column = new AutoTooltipTableColumn(Res.get((String)"account.notifications.marketAlert.manageAlerts.header.trigger"));
        column.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((MarketAlertFilter)item.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<MarketAlertFilter, MarketAlertFilter>, TableCell<MarketAlertFilter, MarketAlertFilter>>(this){

            public TableCell<MarketAlertFilter, MarketAlertFilter> call(TableColumn<MarketAlertFilter, MarketAlertFilter> column) {
                return new TableCell<MarketAlertFilter, MarketAlertFilter>(this){

                    public void updateItem(MarketAlertFilter item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(FormattingUtils.formatPercentagePrice((double)((double)item.getTriggerValue() / 10000.0)));
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        tableView.getColumns().add(column);
        column = new AutoTooltipTableColumn(Res.get((String)"account.notifications.marketAlert.manageAlerts.header.offerType"));
        column.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((MarketAlertFilter)item.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<MarketAlertFilter, MarketAlertFilter>, TableCell<MarketAlertFilter, MarketAlertFilter>>(this){

            public TableCell<MarketAlertFilter, MarketAlertFilter> call(TableColumn<MarketAlertFilter, MarketAlertFilter> column) {
                return new TableCell<MarketAlertFilter, MarketAlertFilter>(this){

                    public void updateItem(MarketAlertFilter item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(item.isBuyOffer() ? Res.get((String)"shared.buyBitcoin") : Res.get((String)"shared.sellBitcoin"));
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        tableView.getColumns().add(column);
        column = new TableColumn();
        column.setMinWidth(40.0);
        column.setMaxWidth(column.getMinWidth());
        column.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((MarketAlertFilter)item.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<MarketAlertFilter, MarketAlertFilter>, TableCell<MarketAlertFilter, MarketAlertFilter>>(){

            public TableCell<MarketAlertFilter, MarketAlertFilter> call(TableColumn<MarketAlertFilter, MarketAlertFilter> column) {
                return new TableCell<MarketAlertFilter, MarketAlertFilter>(){
                    final ImageView icon = ImageUtil.getImageViewById("image-remove");
                    final Button removeButton = new AutoTooltipButton("", (Node)this.icon);
                    {
                        this.removeButton.setId("icon-button");
                        this.removeButton.setTooltip(new Tooltip(Res.get((String)"shared.remove")));
                    }

                    public void updateItem(MarketAlertFilter item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.removeButton.setOnAction(e -> ManageMarketAlertsWindow.this.removeMarketAlertFilter(item, (TableView<MarketAlertFilter>)tableView));
                            this.setGraphic((Node)this.removeButton);
                        } else {
                            this.setGraphic(null);
                            this.removeButton.setOnAction(null);
                        }
                    }
                };
            }
        });
        tableView.getColumns().add((Object)column);
    }
}

