/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.account.content.cryptoaccounts;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.asset.Asset;
import haveno.asset.CryptoAccountDisclaimer;
import haveno.asset.coins.Monero;
import haveno.common.util.Tuple2;
import haveno.common.util.Tuple3;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.filter.FilterManager;
import haveno.core.locale.CryptoCurrency;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PaymentAccountFactory;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.validation.CryptoAddressValidator;
import haveno.core.user.Preferences;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.TitledGroupBg;
import haveno.desktop.components.paymentmethods.AssetsForm;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.main.account.content.PaymentAccountsView;
import haveno.desktop.main.account.content.cryptoaccounts.CryptoAccountsDataModel;
import haveno.desktop.main.account.content.cryptoaccounts.CryptoAccountsViewModel;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.FormBuilder;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

@FxmlView
public class CryptoAccountsView
extends PaymentAccountsView<GridPane, CryptoAccountsViewModel> {
    private final InputValidator inputValidator;
    private final CryptoAddressValidator altCoinAddressValidator;
    private final FilterManager filterManager;
    private final CoinFormatter formatter;
    private final Preferences preferences;
    private PaymentMethodForm paymentMethodForm;
    private TitledGroupBg accountTitledGroupBg;
    private Button saveNewAccountButton;
    private int gridRow = 0;

    @Inject
    public CryptoAccountsView(CryptoAccountsViewModel model, InputValidator inputValidator, CryptoAddressValidator altCoinAddressValidator, AccountAgeWitnessService accountAgeWitnessService, FilterManager filterManager, @Named(value="BTC") CoinFormatter formatter, Preferences preferences) {
        super(model, accountAgeWitnessService);
        this.inputValidator = inputValidator;
        this.altCoinAddressValidator = altCoinAddressValidator;
        this.filterManager = filterManager;
        this.formatter = formatter;
        this.preferences = preferences;
    }

    @Override
    protected ObservableList<PaymentAccount> getPaymentAccounts() {
        return ((CryptoAccountsViewModel)this.model).getPaymentAccounts();
    }

    @Override
    protected void importAccounts() {
        ((CryptoAccountsDataModel)((CryptoAccountsViewModel)this.model).dataModel).importAccounts((Stage)((GridPane)this.root).getScene().getWindow());
    }

    @Override
    protected void exportAccounts() {
        ((CryptoAccountsDataModel)((CryptoAccountsViewModel)this.model).dataModel).exportAccounts((Stage)((GridPane)this.root).getScene().getWindow());
    }

    private void onSaveNewAccount(PaymentAccount paymentAccount) {
        TradeCurrency selectedTradeCurrency = paymentAccount.getSelectedTradeCurrency();
        if (selectedTradeCurrency != null) {
            CryptoAccountDisclaimer disclaimerAnnotation;
            Optional asset;
            if (selectedTradeCurrency instanceof CryptoCurrency && ((CryptoCurrency)selectedTradeCurrency).isAsset()) {
                String name = selectedTradeCurrency.getName();
                ((Popup)((Popup)new Popup().information(Res.get((String)"account.crypto.popup.wallet.msg", (Object[])new Object[]{selectedTradeCurrency.getCodeAndName(), name, name}))).closeButtonText(Res.get((String)"account.crypto.popup.wallet.confirm"))).show();
            }
            if ((asset = CurrencyUtil.findAsset((String)selectedTradeCurrency.getCode())).isPresent() && (disclaimerAnnotation = ((Asset)asset.get()).getClass().getAnnotation(CryptoAccountDisclaimer.class)) != null) {
                ((Popup)((Popup)((Popup)((Popup)new Popup().width(asset.get() instanceof Monero ? 1000.0 : 669.0)).maxMessageLength(2500)).information(Res.get((String)disclaimerAnnotation.value()))).useIUnderstandButton()).show();
            }
            if (((CryptoAccountsViewModel)this.model).getPaymentAccounts().stream().noneMatch(e -> e.getAccountName() != null && e.getAccountName().equals(paymentAccount.getAccountName()))) {
                ((CryptoAccountsViewModel)this.model).onSaveNewAccount(paymentAccount);
                this.removeNewAccountForm();
            } else {
                ((Popup)new Popup().warning(Res.get((String)"shared.accountNameAlreadyUsed"))).show();
            }
            this.preferences.dontShowAgain("instantTradeNews0.9.5", true);
        }
    }

    private void onCancelNewAccount() {
        this.removeNewAccountForm();
        this.preferences.dontShowAgain("instantTradeNews0.9.5", true);
    }

    private void onUpdateAccount(PaymentAccount paymentAccount) {
        ((CryptoAccountsViewModel)this.model).onUpdateAccount(paymentAccount);
        this.removeSelectAccountForm();
    }

    private void onCancelSelectedAccount(PaymentAccount paymentAccount) {
        paymentAccount.revertChanges();
        this.removeSelectAccountForm();
    }

    @Override
    protected void buildForm() {
        FormBuilder.addTitledGroupBg((GridPane)this.root, this.gridRow, 2, Res.get((String)"shared.manageAccounts"));
        Tuple3 tuple = FormBuilder.addTopLabelListView((GridPane)this.root, this.gridRow, Res.get((String)"account.crypto.yourCryptoAccounts"), 20.0);
        this.paymentAccountsListView = (ListView)tuple.second;
        this.setPaymentAccountsListHeight();
        this.setPaymentAccountsCellFactory();
        Tuple3<Button, Button, Button> tuple3 = FormBuilder.add3ButtonsAfterGroup((GridPane)this.root, ++this.gridRow, Res.get((String)"shared.addNewAccount"), Res.get((String)"shared.ExportAccounts"), Res.get((String)"shared.importAccounts"));
        this.addAccountButton = (Button)tuple3.first;
        this.addAccountButton.setId("buy-button-big");
        this.exportButton = (Button)tuple3.second;
        this.importButton = (Button)tuple3.third;
    }

    @Override
    protected void addNewAccount() {
        this.paymentAccountsListView.getSelectionModel().clearSelection();
        this.removeAccountRows();
        this.addAccountButton.setDisable(true);
        this.accountTitledGroupBg = FormBuilder.addTitledGroupBg((GridPane)this.root, ++this.gridRow, 1, Res.get((String)"shared.createNewAccount"), 30.0);
        if (this.paymentMethodForm != null) {
            FormBuilder.removeRowsFromGridPane((GridPane)this.root, 3, this.paymentMethodForm.getGridRow() + 1);
            GridPane.setRowSpan((Node)this.accountTitledGroupBg, (Integer)(this.paymentMethodForm.getRowSpan() + 1));
        }
        this.gridRow = 2;
        this.paymentMethodForm = this.getPaymentMethodForm(PaymentMethod.BLOCK_CHAINS);
        this.paymentMethodForm.addFormForAddAccount();
        this.gridRow = this.paymentMethodForm.getGridRow();
        Tuple2<Button, Button> tuple2 = FormBuilder.add2ButtonsAfterGroup((GridPane)this.root, ++this.gridRow, Res.get((String)"shared.saveNewAccount"), Res.get((String)"shared.cancel"));
        this.saveNewAccountButton = (Button)tuple2.first;
        this.saveNewAccountButton.setOnAction(event -> this.onSaveNewAccount(this.paymentMethodForm.getPaymentAccount()));
        this.saveNewAccountButton.disableProperty().bind((ObservableValue)this.paymentMethodForm.allInputsValidProperty().not());
        Button cancelButton = (Button)tuple2.second;
        cancelButton.setOnAction(event -> this.onCancelNewAccount());
        GridPane.setRowSpan((Node)this.accountTitledGroupBg, (Integer)(this.paymentMethodForm.getRowSpan() + 1));
    }

    @Override
    protected void onSelectAccount(PaymentAccount previous, PaymentAccount current) {
        if (previous != null) {
            previous.revertChanges();
        }
        this.removeAccountRows();
        this.addAccountButton.setDisable(false);
        this.accountTitledGroupBg = FormBuilder.addTitledGroupBg((GridPane)this.root, ++this.gridRow, 2, "", 30.0);
        this.paymentMethodForm = this.getPaymentMethodForm(current);
        this.paymentMethodForm.addFormForEditAccount();
        this.gridRow = this.paymentMethodForm.getGridRow();
        Tuple3<Button, Button, Button> tuple = FormBuilder.add3ButtonsAfterGroup((GridPane)this.root, ++this.gridRow, Res.get((String)"shared.save"), Res.get((String)"shared.deleteAccount"), Res.get((String)"shared.cancel"));
        Button saveAccountButton = (Button)tuple.first;
        saveAccountButton.setOnAction(event -> this.onUpdateAccount(current));
        Button deleteAccountButton = (Button)tuple.second;
        deleteAccountButton.setOnAction(event -> this.onDeleteAccount(current));
        Button cancelButton = (Button)tuple.third;
        cancelButton.setOnAction(event -> this.onCancelSelectedAccount(current));
        GridPane.setRowSpan((Node)this.accountTitledGroupBg, (Integer)this.paymentMethodForm.getRowSpan());
        ((CryptoAccountsViewModel)this.model).onSelectAccount(current);
    }

    private PaymentMethodForm getPaymentMethodForm(PaymentMethod paymentMethod) {
        PaymentAccount paymentAccount = PaymentAccountFactory.getPaymentAccount((PaymentMethod)paymentMethod);
        paymentAccount.init();
        return this.getPaymentMethodForm(paymentAccount);
    }

    private PaymentMethodForm getPaymentMethodForm(PaymentAccount paymentAccount) {
        return new AssetsForm(paymentAccount, this.accountAgeWitnessService, this.altCoinAddressValidator, this.inputValidator, (GridPane)this.root, this.gridRow, this.formatter, this.filterManager);
    }

    private void removeNewAccountForm() {
        this.saveNewAccountButton.disableProperty().unbind();
        this.removeAccountRows();
        this.addAccountButton.setDisable(false);
    }

    @Override
    protected void removeSelectAccountForm() {
        FormBuilder.removeRowsFromGridPane((GridPane)this.root, 2, this.gridRow);
        this.gridRow = 1;
        this.addAccountButton.setDisable(false);
        this.paymentAccountsListView.getSelectionModel().clearSelection();
    }

    @Override
    protected boolean deleteAccountFromModel(PaymentAccount paymentAccount) {
        return ((CryptoAccountsViewModel)this.model).onDeleteAccount(paymentAccount);
    }

    private void removeAccountRows() {
        FormBuilder.removeRowsFromGridPane((GridPane)this.root, 2, this.gridRow);
        this.gridRow = 1;
    }
}

