/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.account.content.backup;

import com.google.inject.Inject;
import haveno.common.UserThread;
import haveno.common.config.Config;
import haveno.common.file.FileUtil;
import haveno.common.persistence.PersistenceManager;
import haveno.common.util.Tuple2;
import haveno.common.util.Utilities;
import haveno.core.api.XmrLocalNode;
import haveno.core.locale.Res;
import haveno.core.user.Preferences;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.app.HavenoApp;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.FormBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.stage.DirectoryChooser;
import javax.annotation.Nullable;

@FxmlView
public class BackupView
extends ActivatableView<GridPane, Void> {
    private final File dataDir;
    private final File logFile;
    private int gridRow = 0;
    private final Preferences preferences;
    private Button selectBackupDir;
    private Button backupNow;
    private TextField backUpLocationTextField;
    private Button openDataDirButton;
    private Button openLogsButton;
    private ChangeListener<Boolean> backUpLocationTextFieldFocusListener;

    @Inject
    private BackupView(Preferences preferences, Config config) {
        this.preferences = preferences;
        this.dataDir = new File(config.appDataDir.getPath());
        this.logFile = new File(Paths.get(this.dataDir.getPath(), "haveno.log").toString());
    }

    @Override
    public void initialize() {
        FormBuilder.addTitledGroupBg((GridPane)this.root, this.gridRow, 2, Res.get((String)"account.backup.title"));
        this.backUpLocationTextField = FormBuilder.addInputTextField((GridPane)this.root, this.gridRow, Res.get((String)"account.backup.location"), 20.0);
        String backupDirectory = this.preferences.getBackupDirectory();
        if (backupDirectory != null) {
            this.backUpLocationTextField.setText(backupDirectory);
        }
        this.backUpLocationTextFieldFocusListener = (observable, oldValue, newValue) -> {
            if (oldValue.booleanValue() && !newValue.booleanValue()) {
                this.applyBackupDirectory(this.backUpLocationTextField.getText());
            }
        };
        Tuple2<Button, Button> tuple2 = FormBuilder.add2ButtonsAfterGroup((GridPane)this.root, ++this.gridRow, Res.get((String)"account.backup.selectLocation"), Res.get((String)"account.backup.backupNow"));
        this.selectBackupDir = (Button)tuple2.first;
        this.selectBackupDir.setId("buy-button-big");
        this.backupNow = (Button)tuple2.second;
        this.updateButtons();
        FormBuilder.addTitledGroupBg((GridPane)this.root, ++this.gridRow, 2, Res.get((String)"account.backup.appDir"), 40.0);
        Tuple2<Button, Button> applicationDataDirTuple2 = FormBuilder.add2Buttons((GridPane)this.root, this.gridRow, Res.get((String)"account.backup.openDirectory"), Res.get((String)"account.backup.openLogFile"), 80.0, false);
        this.openDataDirButton = (Button)applicationDataDirTuple2.first;
        this.openLogsButton = (Button)applicationDataDirTuple2.second;
    }

    @Override
    protected void activate() {
        this.backUpLocationTextField.focusedProperty().addListener(this.backUpLocationTextFieldFocusListener);
        this.selectBackupDir.setOnAction(e -> {
            String path = this.preferences.getDirectoryChooserPath();
            if (!Utilities.isDirectory((String)path)) {
                path = Utilities.getSystemHomeDirectory();
                this.backUpLocationTextField.setText(path);
            }
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setInitialDirectory(new File(path));
            directoryChooser.setTitle(Res.get((String)"account.backup.selectLocation"));
            try {
                File dir = directoryChooser.showDialog(((GridPane)this.root).getScene().getWindow());
                if (dir != null) {
                    this.applyBackupDirectory(dir.getAbsolutePath());
                }
            }
            catch (Throwable t) {
                this.showWrongPathWarningAndReset(t);
            }
        });
        this.openFileOrShowWarning(this.openDataDirButton, this.dataDir);
        this.openFileOrShowWarning(this.openLogsButton, this.logFile);
        this.backupNow.setOnAction(event -> {
            if (Utilities.isWindows()) {
                ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"settings.net.needRestart"))).actionButtonText(Res.get((String)"shared.applyAndShutDown"))).onAction(() -> UserThread.runAfter(() -> {
                    HavenoApp.setOnGracefulShutDownHandler(() -> this.doBackup());
                    HavenoApp.getShutDownHandler().run();
                }, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS))).closeButtonText(Res.get((String)"shared.cancel"))).onClose(() -> {})).show();
            } else {
                this.doBackup();
            }
        });
    }

    private void doBackup() {
        this.log.info("Backing up data directory");
        String backupDirectory = this.preferences.getBackupDirectory();
        if (backupDirectory != null && backupDirectory.length() > 0) {
            PersistenceManager.flushAllDataToDiskAtBackup(() -> {
                try {
                    File moneroWalletRpc;
                    String dateString = new SimpleDateFormat("yyyy-MM-dd-HHmmss").format(new Date());
                    String destination = Paths.get(backupDirectory, "haveno_backup_" + dateString).toString();
                    File destinationFile = new File(destination);
                    FileUtil.copyDirectory((File)this.dataDir, (File)new File(destination));
                    File monerod = new File(destinationFile, XmrLocalNode.MONEROD_NAME);
                    if (monerod.exists()) {
                        monerod.delete();
                    }
                    if ((moneroWalletRpc = new File(destinationFile, XmrWalletService.MONERO_WALLET_RPC_NAME)).exists()) {
                        moneroWalletRpc.delete();
                    }
                    ((Popup)new Popup().feedback(Res.get((String)"account.backup.success", (Object[])new Object[]{destination}))).show();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.log.error(e.getMessage());
                    this.showWrongPathWarningAndReset(e);
                }
            });
        }
    }

    private void openFileOrShowWarning(Button button, File dataDir) {
        button.setOnAction(event -> {
            try {
                Utilities.openFile((File)dataDir);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.log.error(e.getMessage());
                this.showWrongPathWarningAndReset(e);
            }
        });
    }

    @Override
    protected void deactivate() {
        this.backUpLocationTextField.focusedProperty().removeListener(this.backUpLocationTextFieldFocusListener);
        this.selectBackupDir.setOnAction(null);
        this.openDataDirButton.setOnAction(null);
        this.openLogsButton.setOnAction(null);
        this.backupNow.setOnAction(null);
    }

    private void updateButtons() {
        boolean noBackupSet = this.backUpLocationTextField.getText() == null || this.backUpLocationTextField.getText().length() == 0;
        this.selectBackupDir.setDefaultButton(noBackupSet);
        this.backupNow.setDefaultButton(!noBackupSet);
        this.backupNow.setDisable(noBackupSet);
    }

    private void showWrongPathWarningAndReset(@Nullable Throwable t) {
        String error = t != null ? Res.get((String)"shared.errorMessageInline", (Object[])new Object[]{t.getMessage()}) : "";
        ((Popup)new Popup().warning(Res.get((String)"account.backup.directoryNotAccessible", (Object[])new Object[]{error}))).show();
        this.applyBackupDirectory(Utilities.getSystemHomeDirectory());
    }

    private void applyBackupDirectory(String path) {
        if (this.isPathValid(path)) {
            this.preferences.setDirectoryChooserPath(path);
            this.backUpLocationTextField.setText(path);
            this.preferences.setBackupDirectory(path);
            this.updateButtons();
        } else {
            this.showWrongPathWarningAndReset(null);
        }
    }

    private boolean isPathValid(String path) {
        return path == null || path.isEmpty() || Utilities.isDirectory((String)path);
    }
}

