/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.account.content;

import de.jensd.fx.glyphs.GlyphIcons;
import haveno.common.UserThread;
import haveno.common.util.Utilities;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentMethod;
import haveno.desktop.common.model.ActivatableWithDataModel;
import haveno.desktop.common.view.ActivatableViewAndModel;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.InfoAutoTooltipLabel;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.GUIUtil;
import haveno.desktop.util.ImageUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import org.apache.commons.lang3.StringUtils;

public abstract class PaymentAccountsView<R extends Node, M extends ActivatableWithDataModel>
extends ActivatableViewAndModel<R, M> {
    protected ListView<PaymentAccount> paymentAccountsListView;
    private ChangeListener<PaymentAccount> paymentAccountChangeListener;
    protected Button addAccountButton;
    protected Button exportButton;
    protected Button importButton;
    protected AccountAgeWitnessService accountAgeWitnessService;
    private EventHandler<KeyEvent> keyEventEventHandler;

    public PaymentAccountsView(M model, AccountAgeWitnessService accountAgeWitnessService) {
        super(model);
        this.accountAgeWitnessService = accountAgeWitnessService;
    }

    @Override
    public void initialize() {
        this.keyEventEventHandler = event -> {
            if (Utilities.isCtrlShiftPressed((KeyCode)KeyCode.L, (KeyEvent)event)) {
                this.accountAgeWitnessService.getAccountAgeWitnessUtils().logSignedWitnesses();
            } else if (Utilities.isCtrlShiftPressed((KeyCode)KeyCode.S, (KeyEvent)event)) {
                this.accountAgeWitnessService.getAccountAgeWitnessUtils().logSigners();
            } else if (Utilities.isCtrlShiftPressed((KeyCode)KeyCode.U, (KeyEvent)event)) {
                this.accountAgeWitnessService.getAccountAgeWitnessUtils().logUnsignedSignerPubKeys();
            } else if (Utilities.isCtrlShiftPressed((KeyCode)KeyCode.C, (KeyEvent)event)) {
                this.copyAccount();
            }
        };
        this.buildForm();
        this.paymentAccountChangeListener = (observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.onSelectAccount((PaymentAccount)oldValue, (PaymentAccount)newValue);
            }
        };
        AutoTooltipLabel placeholder = new AutoTooltipLabel(Res.get((String)"shared.noAccountsSetupYet"));
        placeholder.setWrapText(true);
        this.paymentAccountsListView.setPlaceholder((Node)placeholder);
        this.getPaymentAccounts().addListener(change -> this.setPaymentAccountsListHeight());
    }

    @Override
    protected void activate() {
        this.paymentAccountsListView.setItems(this.getPaymentAccounts());
        this.paymentAccountsListView.getSelectionModel().selectedItemProperty().addListener(this.paymentAccountChangeListener);
        this.addAccountButton.setOnAction(event -> this.addNewAccount());
        this.exportButton.setOnAction(event -> this.exportAccounts());
        this.importButton.setOnAction(event -> this.importAccounts());
        if (this.root.getScene() != null) {
            this.root.getScene().addEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
        }
    }

    @Override
    protected void deactivate() {
        this.paymentAccountsListView.getSelectionModel().selectedItemProperty().removeListener(this.paymentAccountChangeListener);
        this.addAccountButton.setOnAction(null);
        this.exportButton.setOnAction(null);
        this.importButton.setOnAction(null);
        if (this.root.getScene() != null) {
            this.root.getScene().removeEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
        }
    }

    protected void onDeleteAccount(PaymentAccount paymentAccount) {
        ((Popup)((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"shared.askConfirmDeleteAccount"))).actionButtonText(Res.get((String)"shared.yes"))).onAction(() -> {
            boolean isPaymentAccountUsed = this.deleteAccountFromModel(paymentAccount);
            if (!isPaymentAccountUsed) {
                this.removeSelectAccountForm();
            } else {
                UserThread.runAfter(() -> ((Popup)new Popup().warning(Res.get((String)"shared.cannotDeleteAccount"))).show(), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        })).closeButtonText(Res.get((String)"shared.cancel"))).show();
    }

    protected void setPaymentAccountsCellFactory() {
        this.paymentAccountsListView.setCellFactory((Callback)new Callback<ListView<PaymentAccount>, ListCell<PaymentAccount>>(){

            public ListCell<PaymentAccount> call(ListView<PaymentAccount> list) {
                return new ListCell<PaymentAccount>(){
                    final InfoAutoTooltipLabel label = new InfoAutoTooltipLabel("", ContentDisplay.RIGHT);
                    final ImageView icon = ImageUtil.getImageViewById("image-remove");
                    final Button removeButton = new AutoTooltipButton("", (Node)this.icon);
                    final AnchorPane pane = new AnchorPane(new Node[]{this.label, this.removeButton});
                    {
                        this.label.setLayoutY(5.0);
                        this.removeButton.setId("icon-button");
                        AnchorPane.setRightAnchor((Node)this.removeButton, (Double)0.0);
                    }

                    public void updateItem(PaymentAccount item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.label.setText(item.getAccountName());
                            boolean needsSigning = PaymentMethod.hasChargebackRisk((PaymentMethod)item.getPaymentMethod(), (List)item.getTradeCurrencies());
                            if (needsSigning) {
                                AccountAgeWitnessService.SignState signState = PaymentAccountsView.this.accountAgeWitnessService.getSignState(PaymentAccountsView.this.accountAgeWitnessService.getMyWitness(item.paymentAccountPayload));
                                String info = StringUtils.capitalize((String)signState.getDisplayString());
                                this.label.setIcon((GlyphIcons)GUIUtil.getIconForSignState(signState), info);
                            } else {
                                this.label.hideIcon();
                            }
                            this.removeButton.setOnAction(e -> PaymentAccountsView.this.onDeleteAccount(item));
                            this.setGraphic((Node)this.pane);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    protected void setPaymentAccountsListHeight() {
        int prefNumRows = Math.min(5, Math.max(2, this.getPaymentAccounts().size()));
        double prefHeight = (double)prefNumRows * 40.0;
        this.paymentAccountsListView.setMinHeight(prefHeight);
        this.paymentAccountsListView.setMaxHeight(prefHeight);
    }

    protected abstract void removeSelectAccountForm();

    protected abstract boolean deleteAccountFromModel(PaymentAccount var1);

    protected abstract void importAccounts();

    protected abstract void exportAccounts();

    protected abstract void addNewAccount();

    protected abstract ObservableList<PaymentAccount> getPaymentAccounts();

    protected abstract void buildForm();

    protected abstract void onSelectAccount(PaymentAccount var1, PaymentAccount var2);

    protected void copyAccount() {
    }
}

