/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.account;

import com.google.inject.Inject;
import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.core.user.DontShowAgainLookup;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.CachingViewLoader;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.common.view.View;
import haveno.desktop.common.view.ViewLoader;
import haveno.desktop.main.MainView;
import haveno.desktop.main.account.content.backup.BackupView;
import haveno.desktop.main.account.content.cryptoaccounts.CryptoAccountsView;
import haveno.desktop.main.account.content.password.PasswordView;
import haveno.desktop.main.account.content.seedwords.SeedWordsView;
import haveno.desktop.main.account.content.traditionalaccounts.TraditionalAccountsView;
import haveno.desktop.main.account.content.walletinfo.WalletInfoView;
import haveno.desktop.main.account.register.arbitrator.ArbitratorRegistrationView;
import haveno.desktop.main.account.register.mediator.MediatorRegistrationView;
import haveno.desktop.main.account.register.refundagent.RefundAgentRegistrationView;
import haveno.desktop.main.account.register.signing.SigningView;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

@FxmlView
public class AccountView
extends ActivatableView<TabPane, Void> {
    @FXML
    Tab traditionalAccountsTab;
    @FXML
    Tab cryptoAccountsTab;
    @FXML
    Tab passwordTab;
    @FXML
    Tab seedWordsTab;
    @FXML
    Tab walletInfoTab;
    @FXML
    Tab backupTab;
    private Navigation.Listener navigationListener;
    private ChangeListener<Tab> tabChangeListener;
    private final ViewLoader viewLoader;
    private final Navigation navigation;
    private Tab selectedTab;
    private Tab arbitratorRegistrationTab;
    private Tab mediatorRegistrationTab;
    private Tab refundAgentRegistrationTab;
    private Tab signingTab;
    private ArbitratorRegistrationView arbitratorRegistrationView;
    private MediatorRegistrationView mediatorRegistrationView;
    private RefundAgentRegistrationView refundAgentRegistrationView;
    private Scene scene;
    private EventHandler<KeyEvent> keyEventEventHandler;
    private ListChangeListener<Tab> tabListChangeListener;

    @Inject
    private AccountView(CachingViewLoader viewLoader, Navigation navigation) {
        this.viewLoader = viewLoader;
        this.navigation = navigation;
    }

    @Override
    public void initialize() {
        ((TabPane)this.root).setTabClosingPolicy(TabPane.TabClosingPolicy.ALL_TABS);
        this.traditionalAccountsTab.setText(Res.get((String)"account.menu.paymentAccount"));
        this.cryptoAccountsTab.setText(Res.get((String)"account.menu.altCoinsAccountView"));
        this.passwordTab.setText(Res.get((String)"account.menu.password"));
        this.seedWordsTab.setText(Res.get((String)"account.menu.seedWords"));
        this.backupTab.setText(Res.get((String)"account.menu.backup"));
        this.navigationListener = (viewPath, data) -> {
            if (viewPath.size() == 3 && viewPath.indexOf(AccountView.class) == 1) {
                if (this.arbitratorRegistrationTab == null && ((Class)viewPath.get(2)).equals(ArbitratorRegistrationView.class)) {
                    this.navigation.navigateTo(MainView.class, AccountView.class, TraditionalAccountsView.class);
                } else if (this.mediatorRegistrationTab == null && ((Class)viewPath.get(2)).equals(MediatorRegistrationView.class)) {
                    this.navigation.navigateTo(MainView.class, AccountView.class, TraditionalAccountsView.class);
                } else if (this.refundAgentRegistrationTab == null && ((Class)viewPath.get(2)).equals(RefundAgentRegistrationView.class)) {
                    this.navigation.navigateTo(MainView.class, AccountView.class, TraditionalAccountsView.class);
                } else if (this.signingTab == null && ((Class)viewPath.get(2)).equals(SigningView.class)) {
                    this.navigation.navigateTo(MainView.class, AccountView.class, TraditionalAccountsView.class);
                } else {
                    this.loadView(viewPath.tip());
                }
            } else {
                this.resetSelectedTab();
            }
        };
        this.keyEventEventHandler = event -> {
            if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.R, (KeyEvent)event) && this.arbitratorRegistrationTab == null) {
                this.closeOtherExtraTabs(this.arbitratorRegistrationTab);
                this.arbitratorRegistrationTab = new Tab(Res.get((String)"account.tab.arbitratorRegistration").toUpperCase());
                this.arbitratorRegistrationTab.setClosable(true);
                ((TabPane)this.root).getTabs().add((Object)this.arbitratorRegistrationTab);
                this.navigation.navigateTo(MainView.class, AccountView.class, ArbitratorRegistrationView.class);
            } else if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.D, (KeyEvent)event) && this.mediatorRegistrationTab == null) {
                this.closeOtherExtraTabs(this.mediatorRegistrationTab);
                this.mediatorRegistrationTab = new Tab(Res.get((String)"account.tab.mediatorRegistration").toUpperCase());
                this.mediatorRegistrationTab.setClosable(true);
                ((TabPane)this.root).getTabs().add((Object)this.mediatorRegistrationTab);
                this.navigation.navigateTo(MainView.class, AccountView.class, MediatorRegistrationView.class);
            } else if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.N, (KeyEvent)event) && this.refundAgentRegistrationTab == null) {
                this.closeOtherExtraTabs(this.refundAgentRegistrationTab);
                this.refundAgentRegistrationTab = new Tab(Res.get((String)"account.tab.refundAgentRegistration").toUpperCase());
                this.refundAgentRegistrationTab.setClosable(true);
                ((TabPane)this.root).getTabs().add((Object)this.refundAgentRegistrationTab);
                this.navigation.navigateTo(MainView.class, AccountView.class, RefundAgentRegistrationView.class);
            } else if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.I, (KeyEvent)event) && this.signingTab == null) {
                this.closeOtherExtraTabs(this.signingTab);
                this.signingTab = new Tab(Res.get((String)"account.tab.signing").toUpperCase());
                this.signingTab.setClosable(true);
                ((TabPane)this.root).getTabs().add((Object)this.signingTab);
                this.navigation.navigateTo(MainView.class, AccountView.class, SigningView.class);
            }
        };
        this.tabChangeListener = (ov, oldValue, newValue) -> {
            if (this.arbitratorRegistrationTab != null && this.selectedTab != this.arbitratorRegistrationTab) {
                this.navigation.navigateTo(MainView.class, AccountView.class, ArbitratorRegistrationView.class);
            } else if (this.mediatorRegistrationTab != null && this.selectedTab != this.mediatorRegistrationTab) {
                this.navigation.navigateTo(MainView.class, AccountView.class, MediatorRegistrationView.class);
            } else if (this.refundAgentRegistrationTab != null && this.selectedTab != this.refundAgentRegistrationTab) {
                this.navigation.navigateTo(MainView.class, AccountView.class, RefundAgentRegistrationView.class);
            } else if (this.signingTab != null && !this.selectedTab.equals(this.signingTab)) {
                this.navigation.navigateTo(MainView.class, AccountView.class, SigningView.class);
            } else if (newValue == this.traditionalAccountsTab && this.selectedTab != this.traditionalAccountsTab) {
                this.navigation.navigateTo(MainView.class, AccountView.class, TraditionalAccountsView.class);
            } else if (newValue == this.cryptoAccountsTab && this.selectedTab != this.cryptoAccountsTab) {
                this.navigation.navigateTo(MainView.class, AccountView.class, CryptoAccountsView.class);
            } else if (newValue == this.passwordTab && this.selectedTab != this.passwordTab) {
                this.navigation.navigateTo(MainView.class, AccountView.class, PasswordView.class);
            } else if (newValue == this.seedWordsTab && this.selectedTab != this.seedWordsTab) {
                this.navigation.navigateTo(MainView.class, AccountView.class, SeedWordsView.class);
            } else if (newValue == this.walletInfoTab && this.selectedTab != this.walletInfoTab) {
                this.navigation.navigateTo(MainView.class, AccountView.class, WalletInfoView.class);
            } else if (newValue == this.backupTab && this.selectedTab != this.backupTab) {
                this.navigation.navigateTo(MainView.class, AccountView.class, BackupView.class);
            }
        };
        this.tabListChangeListener = change -> {
            change.next();
            List removedTabs = change.getRemoved();
            if (removedTabs.size() == 1 && ((Tab)removedTabs.get(0)).equals(this.arbitratorRegistrationTab)) {
                this.onArbitratorRegistrationTabRemoved();
            }
            if (removedTabs.size() == 1 && ((Tab)removedTabs.get(0)).equals(this.mediatorRegistrationTab)) {
                this.onMediatorRegistrationTabRemoved();
            }
            if (removedTabs.size() == 1 && ((Tab)removedTabs.get(0)).equals(this.refundAgentRegistrationTab)) {
                this.onRefundAgentRegistrationTabRemoved();
            }
            if (removedTabs.size() == 1 && ((Tab)removedTabs.get(0)).equals(this.signingTab)) {
                this.onSigningTabRemoved();
            }
        };
    }

    private void closeOtherExtraTabs(Tab newTab) {
        if (this.arbitratorRegistrationTab != null && !this.arbitratorRegistrationTab.equals(newTab)) {
            ((TabPane)this.root).getTabs().remove((Object)this.arbitratorRegistrationTab);
        }
        if (this.mediatorRegistrationTab != null && !this.mediatorRegistrationTab.equals(newTab)) {
            ((TabPane)this.root).getTabs().remove((Object)this.mediatorRegistrationTab);
        }
        if (this.refundAgentRegistrationTab != null && !this.refundAgentRegistrationTab.equals(newTab)) {
            ((TabPane)this.root).getTabs().remove((Object)this.refundAgentRegistrationTab);
        }
        if (this.signingTab != null && !this.signingTab.equals(newTab)) {
            ((TabPane)this.root).getTabs().remove((Object)this.signingTab);
        }
    }

    private void onArbitratorRegistrationTabRemoved() {
        this.arbitratorRegistrationTab = null;
        this.navigation.navigateTo(MainView.class, AccountView.class, TraditionalAccountsView.class);
    }

    private void onMediatorRegistrationTabRemoved() {
        this.mediatorRegistrationTab = null;
        this.navigation.navigateTo(MainView.class, AccountView.class, TraditionalAccountsView.class);
    }

    private void onRefundAgentRegistrationTabRemoved() {
        this.refundAgentRegistrationTab = null;
        this.navigation.navigateTo(MainView.class, AccountView.class, TraditionalAccountsView.class);
    }

    private void onSigningTabRemoved() {
        this.signingTab = null;
        this.navigation.navigateTo(MainView.class, AccountView.class, TraditionalAccountsView.class);
    }

    @Override
    protected void activate() {
        DontShowAgainLookup.dontShowAgain((String)"accountNews", (boolean)true);
        this.navigation.addListener(this.navigationListener);
        ((TabPane)this.root).getSelectionModel().selectedItemProperty().addListener(this.tabChangeListener);
        ((TabPane)this.root).getTabs().addListener(this.tabListChangeListener);
        this.scene = ((TabPane)this.root).getScene();
        if (this.scene != null) {
            this.scene.addEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
        }
        if (this.navigation.getCurrentPath().size() == 2 && this.navigation.getCurrentPath().get(1) == AccountView.class) {
            if (this.arbitratorRegistrationTab != null) {
                this.navigation.navigateTo(MainView.class, AccountView.class, ArbitratorRegistrationView.class);
            } else if (this.mediatorRegistrationTab != null) {
                this.navigation.navigateTo(MainView.class, AccountView.class, MediatorRegistrationView.class);
            } else if (this.refundAgentRegistrationTab != null) {
                this.navigation.navigateTo(MainView.class, AccountView.class, RefundAgentRegistrationView.class);
            } else if (this.signingTab != null) {
                this.navigation.navigateTo(MainView.class, AccountView.class, SigningView.class);
            } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.traditionalAccountsTab) {
                this.navigation.navigateTo(MainView.class, AccountView.class, TraditionalAccountsView.class);
            } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.cryptoAccountsTab) {
                this.navigation.navigateTo(MainView.class, AccountView.class, CryptoAccountsView.class);
            } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.passwordTab) {
                this.navigation.navigateTo(MainView.class, AccountView.class, PasswordView.class);
            } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.seedWordsTab) {
                this.navigation.navigateTo(MainView.class, AccountView.class, SeedWordsView.class);
            } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.walletInfoTab) {
                this.navigation.navigateTo(MainView.class, AccountView.class, WalletInfoView.class);
            } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.backupTab) {
                this.navigation.navigateTo(MainView.class, AccountView.class, BackupView.class);
            } else {
                this.navigation.navigateTo(MainView.class, AccountView.class, TraditionalAccountsView.class);
            }
        }
    }

    @Override
    protected void deactivate() {
        this.navigation.removeListener(this.navigationListener);
        ((TabPane)this.root).getSelectionModel().selectedItemProperty().removeListener(this.tabChangeListener);
        ((TabPane)this.root).getTabs().removeListener(this.tabListChangeListener);
        if (this.scene != null) {
            this.scene.removeEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
        }
    }

    private void loadView(Class<? extends View> viewClass) {
        View view = this.viewLoader.load(viewClass);
        this.resetSelectedTab();
        if (view instanceof ArbitratorRegistrationView) {
            if (this.arbitratorRegistrationTab != null) {
                this.selectedTab = this.arbitratorRegistrationTab;
                this.arbitratorRegistrationView = (ArbitratorRegistrationView)view;
                this.arbitratorRegistrationView.onTabSelection(true);
            }
        } else if (view instanceof MediatorRegistrationView) {
            if (this.mediatorRegistrationTab != null) {
                this.selectedTab = this.mediatorRegistrationTab;
                this.mediatorRegistrationView = (MediatorRegistrationView)view;
                this.mediatorRegistrationView.onTabSelection(true);
            }
        } else if (view instanceof RefundAgentRegistrationView) {
            if (this.refundAgentRegistrationTab != null) {
                this.selectedTab = this.refundAgentRegistrationTab;
                this.refundAgentRegistrationView = (RefundAgentRegistrationView)view;
                this.refundAgentRegistrationView.onTabSelection(true);
            }
        } else if (view instanceof SigningView) {
            if (this.signingTab != null) {
                this.selectedTab = this.signingTab;
            }
        } else if (view instanceof TraditionalAccountsView) {
            this.selectedTab = this.traditionalAccountsTab;
        } else if (view instanceof CryptoAccountsView) {
            this.selectedTab = this.cryptoAccountsTab;
        } else if (view instanceof PasswordView) {
            this.selectedTab = this.passwordTab;
        } else if (view instanceof SeedWordsView) {
            this.selectedTab = this.seedWordsTab;
        } else if (view instanceof WalletInfoView) {
            this.selectedTab = this.walletInfoTab;
        } else if (view instanceof BackupView) {
            this.selectedTab = this.backupTab;
        } else {
            throw new IllegalArgumentException("View not supported: " + String.valueOf(view));
        }
        if (this.selectedTab.getContent() != null && this.selectedTab.getContent() instanceof ScrollPane) {
            ((ScrollPane)this.selectedTab.getContent()).setContent(view.getRoot());
        } else {
            this.selectedTab.setContent(view.getRoot());
        }
        ((TabPane)this.root).getSelectionModel().select((Object)this.selectedTab);
    }

    private void resetSelectedTab() {
        if (this.selectedTab != null && this.selectedTab.getContent() != null) {
            if (this.selectedTab.getContent() instanceof ScrollPane) {
                ((ScrollPane)this.selectedTab.getContent()).setContent(null);
            } else {
                this.selectedTab.setContent(null);
            }
        }
    }
}

