/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main;

import haveno.common.UserThread;
import haveno.common.file.FileUtil;
import haveno.core.locale.Res;
import haveno.core.offer.OpenOfferManager;
import haveno.core.xmr.wallet.WalletsManager;
import haveno.desktop.app.HavenoApp;
import haveno.desktop.main.overlays.popups.Popup;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.bitcoinj.wallet.DeterministicSeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedPresentation {
    private static final Logger log = LoggerFactory.getLogger(SharedPresentation.class);

    public static void restoreSeedWords(WalletsManager walletsManager, OpenOfferManager openOfferManager, DeterministicSeed seed, File storageDir) {
        if (!openOfferManager.getObservableList().isEmpty()) {
            UserThread.runAfter(() -> ((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"seed.restore.openOffers.warn"))).actionButtonText(Res.get((String)"shared.yes"))).onAction(() -> openOfferManager.removeAllOpenOffers(() -> SharedPresentation.doRestoreSeedWords(walletsManager, seed, storageDir)))).show(), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        } else {
            SharedPresentation.doRestoreSeedWords(walletsManager, seed, storageDir);
        }
    }

    private static void doRestoreSeedWords(WalletsManager walletsManager, DeterministicSeed seed, File storageDir) {
        try {
            File backup = new File(storageDir, "AddressEntryList_backup_pre_wallet_restore_" + System.currentTimeMillis());
            FileUtil.copyFile((File)new File(storageDir, "AddressEntryList"), (File)backup);
        }
        catch (Throwable t) {
            ((Popup)new Popup().error(Res.get((String)"error.deleteAddressEntryListFailed", (Object[])new Object[]{t}))).show();
        }
        walletsManager.restoreSeedWords(seed, () -> UserThread.execute(() -> {
            log.info("Wallets restored with seed words");
            ((Popup)((Popup)new Popup().feedback(Res.get((String)"seed.restore.success"))).hideCloseButton()).show();
            HavenoApp.getShutDownHandler().run();
        }), throwable -> UserThread.execute(() -> {
            log.error(throwable.toString());
            ((Popup)new Popup().error(Res.get((String)"seed.restore.error", (Object[])new Object[]{Res.get((String)"shared.errorMessageInline", (Object[])new Object[]{throwable})}))).show();
        }));
    }
}

