/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main;

import com.google.inject.Inject;
import haveno.common.ThreadUtils;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.common.config.BaseCurrencyNetwork;
import haveno.common.config.Config;
import haveno.common.file.CorruptedStorageFileHandler;
import haveno.common.util.Tuple2;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.alert.Alert;
import haveno.core.alert.PrivateNotificationManager;
import haveno.core.api.XmrConnectionService;
import haveno.core.app.HavenoSetup;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.OpenOfferManager;
import haveno.core.payment.AliPayAccount;
import haveno.core.payment.AmazonGiftCardAccount;
import haveno.core.payment.CryptoCurrencyAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.RevolutAccount;
import haveno.core.presentation.BalancePresentation;
import haveno.core.presentation.SupportTicketsPresentation;
import haveno.core.presentation.TradePresentation;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.TradeManager;
import haveno.core.user.DontShowAgainLookup;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.Navigation;
import haveno.desktop.app.HavenoApp;
import haveno.desktop.common.model.ViewModel;
import haveno.desktop.components.TxIdTextField;
import haveno.desktop.main.MainView;
import haveno.desktop.main.account.AccountView;
import haveno.desktop.main.account.content.backup.BackupView;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.main.overlays.notifications.NotificationCenter;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.DisplayAlertMessageWindow;
import haveno.desktop.main.overlays.windows.TacWindow;
import haveno.desktop.main.overlays.windows.TorNetworkSettingsWindow;
import haveno.desktop.main.overlays.windows.UpdateAmazonGiftCardAccountWindow;
import haveno.desktop.main.overlays.windows.UpdateRevolutAccountWindow;
import haveno.desktop.main.overlays.windows.WalletPasswordWindow;
import haveno.desktop.main.overlays.windows.downloadupdate.DisplayUpdateDownloadWindow;
import haveno.desktop.main.presentation.AccountPresentation;
import haveno.desktop.main.presentation.MarketPricePresentation;
import haveno.desktop.main.presentation.SettingsPresentation;
import haveno.desktop.main.shared.PriceFeedComboBoxItem;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.BootstrapListener;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.P2PServiceListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainViewModel
implements ViewModel,
HavenoSetup.HavenoSetupListener {
    private static final Logger log = LoggerFactory.getLogger(MainViewModel.class);
    private final HavenoSetup havenoSetup;
    private final XmrConnectionService xmrConnectionService;
    private final User user;
    private final BalancePresentation balancePresentation;
    private final TradePresentation tradePresentation;
    private final SupportTicketsPresentation supportTicketsPresentation;
    private final MarketPricePresentation marketPricePresentation;
    private final AccountPresentation accountPresentation;
    private final SettingsPresentation settingsPresentation;
    private final P2PService p2PService;
    private final TradeManager tradeManager;
    private final OpenOfferManager openOfferManager;
    private final Preferences preferences;
    private final PrivateNotificationManager privateNotificationManager;
    private final WalletPasswordWindow walletPasswordWindow;
    private final NotificationCenter notificationCenter;
    private final TacWindow tacWindow;
    private final PriceFeedService priceFeedService;
    private final Config config;
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final TorNetworkSettingsWindow torNetworkSettingsWindow;
    private final CorruptedStorageFileHandler corruptedStorageFileHandler;
    private final Navigation navigation;
    private final BooleanProperty showAppScreen = new SimpleBooleanProperty();
    private final DoubleProperty combinedSyncProgress = new SimpleDoubleProperty(-1.0);
    private final BooleanProperty isSplashScreenRemoved = new SimpleBooleanProperty();
    private final StringProperty footerVersionInfo = new SimpleStringProperty();
    private Timer checkNumberOfXmrPeersTimer;
    private Timer checkNumberOfP2pNetworkPeersTimer;
    private MonadicBinding<Boolean> tradesAndUIReady;
    private final Queue<Overlay<?>> popupQueue = new PriorityQueue<Overlay>(Comparator.comparing(Overlay::getDisplayOrderPriority));
    private Popup moneroConnectionErrorPopup;

    @Inject
    public MainViewModel(HavenoSetup havenoSetup, XmrConnectionService xmrConnectionService, XmrWalletService xmrWalletService, User user, BalancePresentation balancePresentation, TradePresentation tradePresentation, SupportTicketsPresentation supportTicketsPresentation, MarketPricePresentation marketPricePresentation, AccountPresentation accountPresentation, SettingsPresentation settingsPresentation, P2PService p2PService, TradeManager tradeManager, OpenOfferManager openOfferManager, Preferences preferences, PrivateNotificationManager privateNotificationManager, WalletPasswordWindow walletPasswordWindow, NotificationCenter notificationCenter, TacWindow tacWindow, PriceFeedService priceFeedService, Config config, AccountAgeWitnessService accountAgeWitnessService, TorNetworkSettingsWindow torNetworkSettingsWindow, CorruptedStorageFileHandler corruptedStorageFileHandler, Navigation navigation) {
        this.havenoSetup = havenoSetup;
        this.xmrConnectionService = xmrConnectionService;
        this.user = user;
        this.balancePresentation = balancePresentation;
        this.tradePresentation = tradePresentation;
        this.supportTicketsPresentation = supportTicketsPresentation;
        this.marketPricePresentation = marketPricePresentation;
        this.accountPresentation = accountPresentation;
        this.settingsPresentation = settingsPresentation;
        this.p2PService = p2PService;
        this.tradeManager = tradeManager;
        this.openOfferManager = openOfferManager;
        this.preferences = preferences;
        this.privateNotificationManager = privateNotificationManager;
        this.walletPasswordWindow = walletPasswordWindow;
        this.notificationCenter = notificationCenter;
        this.tacWindow = tacWindow;
        this.priceFeedService = priceFeedService;
        this.config = config;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.torNetworkSettingsWindow = torNetworkSettingsWindow;
        this.corruptedStorageFileHandler = corruptedStorageFileHandler;
        this.navigation = navigation;
        TxIdTextField.setPreferences(preferences);
        TxIdTextField.setXmrWalletService(xmrWalletService);
        GUIUtil.setPreferences(preferences);
        this.setupHandlers();
        havenoSetup.addHavenoSetupListener((HavenoSetup.HavenoSetupListener)this);
    }

    public void onSetupComplete() {
        this.tradesAndUIReady = EasyBind.combine((ObservableValue)this.isSplashScreenRemoved, (ObservableValue)this.tradeManager.tradesInitializedProperty(), (a, b) -> a != false && b != false);
        this.tradesAndUIReady.subscribe((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                ThreadUtils.submitToPool(() -> {
                    this.tradeManager.applyTradePeriodState();
                    this.tradeManager.getOpenTrades().forEach(trade -> {
                        if (trade.getInitError() != null) {
                            ((Popup)new Popup().warning("Error initializing trade " + trade.getShortId() + "\n\n" + trade.getInitError().getMessage())).show();
                            return;
                        }
                        Date maxTradePeriodDate = trade.getMaxTradePeriodDate();
                        switch (trade.getPeriodState()) {
                            case FIRST_HALF: {
                                break;
                            }
                            case SECOND_HALF: {
                                String key = "displayHalfTradePeriodOver" + trade.getId();
                                if (!DontShowAgainLookup.showAgain((String)key)) break;
                                DontShowAgainLookup.dontShowAgain((String)key, (boolean)true);
                                if (trade instanceof ArbitratorTrade) break;
                                ((Popup)new Popup().warning(Res.get((String)"popup.warning.tradePeriod.halfReached", (Object[])new Object[]{trade.getShortId(), DisplayUtils.formatDateTime(maxTradePeriodDate)}))).show();
                                break;
                            }
                            case TRADE_PERIOD_OVER: {
                                String key = "displayTradePeriodOver" + trade.getId();
                                if (!DontShowAgainLookup.showAgain((String)key)) break;
                                DontShowAgainLookup.dontShowAgain((String)key, (boolean)true);
                                if (trade instanceof ArbitratorTrade) break;
                                ((Popup)new Popup().warning(Res.get((String)"popup.warning.tradePeriod.ended", (Object[])new Object[]{trade.getShortId(), DisplayUtils.formatDateTime(maxTradePeriodDate)}))).show();
                            }
                        }
                    });
                });
            }
        });
        this.setupP2PNumPeersWatcher();
        this.marketPricePresentation.setup();
        this.accountPresentation.setup();
        this.settingsPresentation.setup();
        if (DevEnv.isDevMode()) {
            this.preferences.setShowOwnOffersInOfferBook(true);
            this.setupDevDummyPaymentAccounts();
        }
        UserThread.execute(() -> this.getShowAppScreen().set(true));
        if (Config.baseCurrencyNetwork() == BaseCurrencyNetwork.XMR_STAGENET) {
            String key = "welcome.stagenet";
            if (DontShowAgainLookup.showAgain((String)key)) {
                UserThread.runAfter(() -> ((Popup)((Popup)((Popup)new Popup().attention(Res.get((String)"popup.attention.welcome.stagenet"))).dontShowAgainId(key)).closeButtonText(Res.get((String)"shared.iUnderstand"))).show(), (long)1L);
            }
        } else if (Config.baseCurrencyNetwork() == BaseCurrencyNetwork.XMR_MAINNET) {
            String key = "welcome.mainnet";
            boolean isReleaseLimited = HavenoUtils.isReleasedWithinDays((int)60);
            if (DontShowAgainLookup.showAgain((String)key)) {
                UserThread.runAfter(() -> ((Popup)((Popup)((Popup)new Popup().attention(Res.get((String)(isReleaseLimited ? "popup.attention.welcome.mainnet.test" : "popup.attention.welcome.mainnet")))).dontShowAgainId(key)).closeButtonText(Res.get((String)"shared.iUnderstand"))).show(), (long)1L);
            }
        }
    }

    void onSplashScreenRemoved() {
        this.isSplashScreenRemoved.set(true);
        this.notificationCenter.onAllServicesAndViewsInitialized();
        this.maybeShowPopupsFromQueue();
    }

    void onOpenDownloadWindow() {
        this.havenoSetup.displayAlertIfPresent(this.user.getDisplayedAlert(), true);
    }

    void setPriceFeedComboBoxItem(PriceFeedComboBoxItem item) {
        this.marketPricePresentation.setPriceFeedComboBoxItem(item);
    }

    private void setupHandlers() {
        this.havenoSetup.setDisplayTacHandler(acceptedHandler -> UserThread.runAfter(() -> ((TacWindow)this.tacWindow.onAction(acceptedHandler::run)).show(), (long)1L));
        this.havenoSetup.setDisplayMoneroConnectionFallbackHandler(connectionError -> {
            if (connectionError == null) {
                if (this.moneroConnectionErrorPopup != null) {
                    this.moneroConnectionErrorPopup.hide();
                }
            } else {
                switch (connectionError) {
                    case LOCAL: {
                        this.moneroConnectionErrorPopup = (Popup)((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"xmrConnectionError.headline"))).warning(Res.get((String)"xmrConnectionError.localNode"))).actionButtonText(Res.get((String)"xmrConnectionError.localNode.start"))).onAction(() -> {
                            log.warn("User has chosen to start local node.");
                            new Thread(() -> {
                                try {
                                    HavenoUtils.xmrConnectionService.startLocalNode();
                                }
                                catch (Exception e) {
                                    log.error("Error starting local node: {}", (Object)e.getMessage(), (Object)e);
                                    ((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"xmrConnectionError.localNode.start.error"))).warning(e.getMessage())).closeButtonText(Res.get((String)"shared.close"))).onClose(() -> this.havenoSetup.getConnectionServiceFallbackType().set(null))).show();
                                }
                                finally {
                                    this.havenoSetup.getConnectionServiceFallbackType().set(null);
                                }
                            }).start();
                        })).secondaryActionButtonText(Res.get((String)"xmrConnectionError.localNode.fallback"))).onSecondaryAction(() -> {
                            log.warn("User has chosen to fallback to the next best available Monero node.");
                            new Thread(() -> {
                                HavenoUtils.xmrConnectionService.fallbackToBestConnection();
                                this.havenoSetup.getConnectionServiceFallbackType().set(null);
                            }).start();
                        })).closeButtonText(Res.get((String)"shared.shutDown"))).onClose(HavenoApp.getShutDownHandler());
                        break;
                    }
                    case CUSTOM: {
                        this.moneroConnectionErrorPopup = (Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"xmrConnectionError.headline"))).warning(Res.get((String)"xmrConnectionError.customNodes"))).actionButtonText(Res.get((String)"shared.yes"))).onAction(() -> new Thread(() -> {
                            HavenoUtils.xmrConnectionService.fallbackToBestConnection();
                            this.havenoSetup.getConnectionServiceFallbackType().set(null);
                        }).start())).closeButtonText(Res.get((String)"shared.no"))).onClose(() -> {
                            log.warn("User has declined to fallback to the next best available Monero node.");
                            this.havenoSetup.getConnectionServiceFallbackType().set(null);
                        });
                        break;
                    }
                    case PROVIDED: {
                        this.moneroConnectionErrorPopup = (Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"xmrConnectionError.headline"))).warning(Res.get((String)"xmrConnectionError.providedNodes"))).actionButtonText(Res.get((String)"shared.yes"))).onAction(() -> new Thread(() -> {
                            HavenoUtils.xmrConnectionService.fallbackToBestConnection();
                            this.havenoSetup.getConnectionServiceFallbackType().set(null);
                        }).start())).closeButtonText(Res.get((String)"shared.no"))).onClose(() -> {
                            log.warn("User has declined to fallback to the next best available Monero node.");
                            this.havenoSetup.getConnectionServiceFallbackType().set(null);
                        });
                    }
                }
                this.moneroConnectionErrorPopup.show();
            }
        });
        this.havenoSetup.setDisplayTorNetworkSettingsHandler(show -> {
            if (show.booleanValue()) {
                this.torNetworkSettingsWindow.show();
                if (this.moneroConnectionErrorPopup != null && this.moneroConnectionErrorPopup.isDisplayed()) {
                    this.moneroConnectionErrorPopup.hide();
                    this.moneroConnectionErrorPopup.show();
                }
            } else if (this.torNetworkSettingsWindow.isDisplayed()) {
                this.torNetworkSettingsWindow.hide();
            }
        });
        this.havenoSetup.setChainFileLockedExceptionHandler(msg -> ((Popup)((Popup)new Popup().warning((String)msg)).useShutDownButton()).show());
        this.tradeManager.setLockedUpFundsHandler(msg -> ((Popup)((Popup)new Popup().width(850.0)).warning((String)msg)).show());
        this.havenoSetup.setDisplayUpdateHandler((alert, key) -> ((DisplayUpdateDownloadWindow)((DisplayUpdateDownloadWindow)((DisplayUpdateDownloadWindow)((DisplayUpdateDownloadWindow)new DisplayUpdateDownloadWindow((Alert)alert, this.config).actionButtonText(Res.get((String)"displayUpdateDownloadWindow.button.downloadLater"))).onAction(() -> this.preferences.dontShowAgain(key, false))).closeButtonText(Res.get((String)"shared.cancel"))).onClose(() -> this.preferences.dontShowAgain(key, true))).show());
        this.havenoSetup.setDisplayAlertHandler(alert -> ((DisplayAlertMessageWindow)((DisplayAlertMessageWindow)new DisplayAlertMessageWindow().alertMessage((Alert)alert).closeButtonText(Res.get((String)"shared.close"))).onClose(() -> this.user.setDisplayedAlert(alert))).show());
        this.havenoSetup.setDisplayPrivateNotificationHandler(privateNotification -> ((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"popup.privateNotification.headline"))).attention(privateNotification.getMessage())).onClose(() -> ((PrivateNotificationManager)this.privateNotificationManager).removePrivateNotification())).useIUnderstandButton()).show());
        this.havenoSetup.setDisplaySecurityRecommendationHandler(key -> {});
        this.havenoSetup.setDisplayLocalhostHandler(key -> {
            if (!DevEnv.isDevMode()) {
                Popup popup = (Popup)((Popup)new Popup().backgroundInfo(Res.get((String)"popup.xmrLocalNode.msg"))).dontShowAgainId((String)key);
                popup.setDisplayOrderPriority(5);
                this.popupQueue.add(popup);
            }
        });
        this.havenoSetup.setDisplaySignedByArbitratorHandler(key -> this.accountPresentation.showOneTimeAccountSigningPopup((String)key, "popup.accountSigning.signedByArbitrator"));
        this.havenoSetup.setDisplaySignedByPeerHandler(key -> this.accountPresentation.showOneTimeAccountSigningPopup((String)key, "popup.accountSigning.signedByPeer", String.valueOf(30L)));
        this.havenoSetup.setDisplayPeerLimitLiftedHandler(key -> this.accountPresentation.showOneTimeAccountSigningPopup((String)key, "popup.accountSigning.peerLimitLifted"));
        this.havenoSetup.setDisplayPeerSignerHandler(key -> this.accountPresentation.showOneTimeAccountSigningPopup((String)key, "popup.accountSigning.peerSigner"));
        this.havenoSetup.setWrongOSArchitectureHandler(msg -> ((Popup)new Popup().warning((String)msg)).show());
        this.havenoSetup.setRejectedTxErrorMessageHandler(msg -> ((Popup)((Popup)new Popup().width(850.0)).warning((String)msg)).show());
        this.havenoSetup.setShowPopupIfInvalidXmrConfigHandler(this::showPopupIfInvalidXmrConfig);
        this.havenoSetup.setRevolutAccountsUpdateHandler(revolutAccountList -> this.showRevolutAccountUpdateWindow(new ArrayList<RevolutAccount>((Collection<RevolutAccount>)revolutAccountList)));
        this.havenoSetup.setAmazonGiftCardAccountsUpdateHandler(amazonGiftCardAccountList -> this.showAmazonGiftCardAccountUpdateWindow(new ArrayList<AmazonGiftCardAccount>((Collection<AmazonGiftCardAccount>)amazonGiftCardAccountList)));
        this.havenoSetup.setOsxKeyLoggerWarningHandler(() -> {});
        this.havenoSetup.setQubesOSInfoHandler(() -> {
            String key = "qubesOSSetupInfo";
            if (this.preferences.showAgain(key)) {
                ((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"popup.info.qubesOSSetupInfo"))).closeButtonText(Res.get((String)"shared.iUnderstand"))).dontShowAgainId(key)).show();
            }
        });
        this.havenoSetup.setDownGradePreventionHandler(lastVersion -> ((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"popup.warn.downGradePrevention", (Object[])new Object[]{lastVersion, "1.2.2"}))).useShutDownButton()).hideCloseButton()).show());
        this.havenoSetup.setTorAddressUpgradeHandler(() -> ((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"popup.info.torMigration.msg"))).actionButtonTextWithGoTo("navigation.account.backup")).onAction(() -> {
            this.navigation.setReturnPath(this.navigation.getCurrentPath());
            this.navigation.navigateTo(MainView.class, AccountView.class, BackupView.class);
        })).show());
        this.corruptedStorageFileHandler.getFiles().ifPresent(files -> ((Popup)((Popup)new Popup().warning(Res.get((String)"popup.warning.incompatibleDB", (Object[])new Object[]{files.toString(), this.config.appDataDir}))).useShutDownButton()).show());
        this.havenoSetup.getXmrDaemonSyncProgress().addListener((observable, oldValue, newValue) -> this.updateXmrDaemonSyncProgress());
        this.havenoSetup.getXmrWalletSyncProgress().addListener((observable, oldValue, newValue) -> this.updateXmrWalletSyncProgress());
        this.havenoSetup.setFilterWarningHandler(warning -> ((Popup)new Popup().warning((String)warning)).show());
        this.footerVersionInfo.setValue("v1.2.2");
        this.getNewVersionAvailableProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.footerVersionInfo.setValue("v1.2.2 " + Res.get((String)"mainView.version.update"));
            } else {
                this.footerVersionInfo.setValue("v1.2.2");
            }
        });
        if (this.p2PService.isBootstrapped()) {
            this.setupInvalidOpenOffersHandler();
        } else {
            this.p2PService.addP2PServiceListener((P2PServiceListener)new BootstrapListener(){

                public void onDataReceived() {
                    MainViewModel.this.setupInvalidOpenOffersHandler();
                }
            });
        }
    }

    private void showRevolutAccountUpdateWindow(List<RevolutAccount> revolutAccountList) {
        if (!revolutAccountList.isEmpty()) {
            RevolutAccount revolutAccount = revolutAccountList.get(0);
            revolutAccountList.remove(0);
            ((UpdateRevolutAccountWindow)new UpdateRevolutAccountWindow(revolutAccount, this.user).onClose(() -> UserThread.runAfter(() -> this.showRevolutAccountUpdateWindow(revolutAccountList), (long)300L, (TimeUnit)TimeUnit.MILLISECONDS))).show();
        }
    }

    private void showAmazonGiftCardAccountUpdateWindow(List<AmazonGiftCardAccount> amazonGiftCardAccountList) {
        if (!amazonGiftCardAccountList.isEmpty()) {
            AmazonGiftCardAccount amazonGiftCardAccount = amazonGiftCardAccountList.get(0);
            amazonGiftCardAccountList.remove(0);
            ((UpdateAmazonGiftCardAccountWindow)new UpdateAmazonGiftCardAccountWindow(amazonGiftCardAccount, this.user).onClose(() -> UserThread.runAfter(() -> this.showAmazonGiftCardAccountUpdateWindow(amazonGiftCardAccountList), (long)300L, (TimeUnit)TimeUnit.MILLISECONDS))).show();
        }
    }

    private void setupP2PNumPeersWatcher() {
        this.p2PService.getNumConnectedPeers().addListener((observable, oldValue, newValue) -> {
            int numPeers = (Integer)newValue;
            if ((Integer)oldValue > 0 && numPeers == 0) {
                if (this.checkNumberOfP2pNetworkPeersTimer != null) {
                    this.checkNumberOfP2pNetworkPeersTimer.stop();
                }
                this.checkNumberOfP2pNetworkPeersTimer = UserThread.runAfter(() -> {
                    if (this.p2PService.getNumConnectedPeers().get() == 0) {
                        this.getP2pNetworkWarnMsg().set((Object)Res.get((String)"mainView.networkWarning.allConnectionsLost", (Object[])new Object[]{Res.get((String)"shared.P2P")}));
                        this.getP2pNetworkLabelId().set((Object)"splash-error-state-msg");
                    } else {
                        this.getP2pNetworkWarnMsg().set(null);
                        this.getP2pNetworkLabelId().set((Object)"footer-pane");
                    }
                }, (long)5L);
            } else if ((Integer)oldValue == 0 && numPeers > 0) {
                if (this.checkNumberOfP2pNetworkPeersTimer != null) {
                    this.checkNumberOfP2pNetworkPeersTimer.stop();
                }
                this.getP2pNetworkWarnMsg().set(null);
                this.getP2pNetworkLabelId().set((Object)"footer-pane");
            }
        });
    }

    private void showPopupIfInvalidXmrConfig() {
        this.preferences.setMoneroNodesOptionOrdinal(0);
        ((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"settings.net.warn.invalidXmrConfig"))).hideCloseButton()).useShutDownButton()).show();
    }

    private void setupDevDummyPaymentAccounts() {
        if (this.user.getPaymentAccounts() != null && this.user.getPaymentAccounts().isEmpty()) {
            final AliPayAccount aliPayAccount = new AliPayAccount();
            aliPayAccount.init();
            aliPayAccount.setAccountNr("dummy_" + new Random().nextInt(100));
            aliPayAccount.setAccountName("AliPayAccount dummy");
            this.user.addPaymentAccount((PaymentAccount)aliPayAccount);
            if (this.p2PService.isBootstrapped()) {
                this.accountAgeWitnessService.publishMyAccountAgeWitness(aliPayAccount.getPaymentAccountPayload());
            } else {
                this.p2PService.addP2PServiceListener((P2PServiceListener)new BootstrapListener(){

                    public void onDataReceived() {
                        MainViewModel.this.accountAgeWitnessService.publishMyAccountAgeWitness(aliPayAccount.getPaymentAccountPayload());
                    }
                });
            }
            CryptoCurrencyAccount cryptoCurrencyAccount = new CryptoCurrencyAccount();
            cryptoCurrencyAccount.init();
            cryptoCurrencyAccount.setAccountName("ETH dummy");
            cryptoCurrencyAccount.setAddress("0x" + new Random().nextInt(1000000));
            Optional eth = CurrencyUtil.getCryptoCurrency((String)"ETH");
            eth.ifPresent(arg_0 -> ((CryptoCurrencyAccount)cryptoCurrencyAccount).setSingleTradeCurrency(arg_0));
            this.user.addPaymentAccount((PaymentAccount)cryptoCurrencyAccount);
        }
    }

    private void updateXmrDaemonSyncProgress() {
        DoubleProperty xmrDaemonSyncProgress = this.havenoSetup.getXmrDaemonSyncProgress();
        UserThread.execute(() -> this.combinedSyncProgress.set(xmrDaemonSyncProgress.doubleValue()));
    }

    private void updateXmrWalletSyncProgress() {
        DoubleProperty xmrWalletSyncProgress = this.havenoSetup.getXmrWalletSyncProgress();
        UserThread.execute(() -> this.combinedSyncProgress.set(xmrWalletSyncProgress.doubleValue()));
    }

    private void setupInvalidOpenOffersHandler() {
        this.openOfferManager.getInvalidOffers().addListener(c -> {
            c.next();
            if (c.wasAdded()) {
                this.handleInvalidOpenOffers(c.getAddedSubList());
            }
        });
        this.handleInvalidOpenOffers((List<? extends Tuple2<OpenOffer, String>>)this.openOfferManager.getInvalidOffers());
    }

    private void handleInvalidOpenOffers(List<? extends Tuple2<OpenOffer, String>> list) {
        list.forEach(tuple2 -> {
            String errorMsg = (String)tuple2.second;
            OpenOffer openOffer = (OpenOffer)tuple2.first;
            ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().warning(errorMsg)).width(1000.0)).actionButtonText(Res.get((String)"shared.removeOffer"))).onAction(() -> this.openOfferManager.cancelOpenOffer(openOffer, () -> log.info("Invalid open offer with ID {} was successfully removed.", (Object)openOffer.getId()), arg_0 -> ((Logger)log).error(arg_0)))).hideCloseButton()).show();
        });
    }

    BooleanProperty getNewVersionAvailableProperty() {
        return this.havenoSetup.getNewVersionAvailableProperty();
    }

    StringProperty getNumOpenSupportTickets() {
        return this.supportTicketsPresentation.getNumOpenSupportTickets();
    }

    BooleanProperty getShowOpenSupportTicketsNotification() {
        return this.supportTicketsPresentation.getShowOpenSupportTicketsNotification();
    }

    BooleanProperty getShowPendingTradesNotification() {
        return this.tradePresentation.getShowPendingTradesNotification();
    }

    StringProperty getNumPendingTrades() {
        return this.tradePresentation.getNumPendingTrades();
    }

    StringProperty getAvailableBalance() {
        return this.balancePresentation.getAvailableBalance();
    }

    StringProperty getReservedBalance() {
        return this.balancePresentation.getReservedBalance();
    }

    StringProperty getPendingBalance() {
        return this.balancePresentation.getPendingBalance();
    }

    StringProperty getXmrInfo() {
        SimpleStringProperty combinedInfo = new SimpleStringProperty();
        combinedInfo.bind((ObservableValue)this.havenoSetup.getXmrInfo());
        return combinedInfo;
    }

    StringProperty getCombinedFooterInfo() {
        SimpleStringProperty combinedInfo = new SimpleStringProperty();
        combinedInfo.bind((ObservableValue)Bindings.concat((Object[])new Object[]{this.footerVersionInfo, " "}));
        return combinedInfo;
    }

    DoubleProperty getCombinedSyncProgress() {
        return this.combinedSyncProgress;
    }

    StringProperty getConnectionServiceErrorMsg() {
        return this.havenoSetup.getConnectionServiceErrorMsg();
    }

    StringProperty getTopErrorMsg() {
        return this.havenoSetup.getTopErrorMsg();
    }

    StringProperty getXmrSplashSyncIconId() {
        return this.havenoSetup.getXmrSplashSyncIconId();
    }

    ObjectProperty<Preferences.UseTorForXmr> getUseTorForXmr() {
        return this.havenoSetup.getUseTorForXmr();
    }

    StringProperty getP2PNetworkInfo() {
        return this.havenoSetup.getP2PNetworkInfo();
    }

    BooleanProperty getSplashP2PNetworkAnimationVisible() {
        return this.havenoSetup.getSplashP2PNetworkAnimationVisible();
    }

    StringProperty getP2pNetworkWarnMsg() {
        return this.havenoSetup.getP2pNetworkWarnMsg();
    }

    StringProperty getP2PNetworkIconId() {
        return this.havenoSetup.getP2PNetworkIconId();
    }

    StringProperty getP2PNetworkStatusIconId() {
        return this.havenoSetup.getP2PNetworkStatusIconId();
    }

    BooleanProperty getUpdatedDataReceived() {
        return this.havenoSetup.getUpdatedDataReceived();
    }

    StringProperty getP2pNetworkLabelId() {
        return this.havenoSetup.getP2pNetworkLabelId();
    }

    ObjectProperty<PriceFeedComboBoxItem> getSelectedPriceFeedComboBoxItemProperty() {
        return this.marketPricePresentation.getSelectedPriceFeedComboBoxItemProperty();
    }

    BooleanProperty getIsFiatCurrencyPriceFeedSelected() {
        return this.marketPricePresentation.getIsFiatCurrencyPriceFeedSelected();
    }

    BooleanProperty getIsExternallyProvidedPrice() {
        return this.marketPricePresentation.getIsExternallyProvidedPrice();
    }

    BooleanProperty getIsPriceAvailable() {
        return this.marketPricePresentation.getIsPriceAvailable();
    }

    IntegerProperty getMarketPriceUpdated() {
        return this.marketPricePresentation.getMarketPriceUpdated();
    }

    StringProperty getMarketPrice() {
        return this.marketPricePresentation.getMarketPrice();
    }

    StringProperty getMarketPrice(String currencyCode) {
        return this.marketPricePresentation.getMarketPrice(currencyCode);
    }

    public ObservableList<PriceFeedComboBoxItem> getPriceFeedComboBoxItems() {
        return this.marketPricePresentation.getPriceFeedComboBoxItems();
    }

    public BooleanProperty getShowAccountUpdatesNotification() {
        return this.accountPresentation.getShowAccountUpdatesNotification();
    }

    public BooleanProperty getShowSettingsUpdatesNotification() {
        return this.settingsPresentation.getShowSettingsUpdatesNotification();
    }

    private void maybeShowPopupsFromQueue() {
        if (!this.popupQueue.isEmpty()) {
            Overlay<?> overlay = this.popupQueue.poll();
            overlay.getIsHiddenProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    UserThread.runAfter(this::maybeShowPopupsFromQueue, (long)2L);
                }
            });
            overlay.show();
        }
    }

    public String getP2pConnectionSummary() {
        return Res.get((String)"mainView.status.connections", (Object[])new Object[]{this.p2PService.getNetworkNode().getInboundConnectionCount(), this.p2PService.getNetworkNode().getOutboundConnectionCount()});
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public PriceFeedService getPriceFeedService() {
        return this.priceFeedService;
    }

    public TorNetworkSettingsWindow getTorNetworkSettingsWindow() {
        return this.torNetworkSettingsWindow;
    }

    public BooleanProperty getShowAppScreen() {
        return this.showAppScreen;
    }
}

