/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main;

import com.google.inject.Inject;
import com.jfoenix.controls.JFXBadge;
import com.jfoenix.controls.JFXComboBox;
import haveno.common.HavenoException;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.config.BaseCurrencyNetwork;
import haveno.common.config.Config;
import haveno.common.util.Tuple2;
import haveno.common.util.Utilities;
import haveno.core.locale.GlobalSettings;
import haveno.core.locale.LanguageUtil;
import haveno.core.locale.Res;
import haveno.core.provider.price.MarketPrice;
import haveno.core.user.Preferences;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.CachingViewLoader;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.common.view.InitializableView;
import haveno.desktop.common.view.View;
import haveno.desktop.common.view.ViewLoader;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.AutoTooltipToggleButton;
import haveno.desktop.components.BusyAnimation;
import haveno.desktop.main.MainViewModel;
import haveno.desktop.main.account.AccountView;
import haveno.desktop.main.funds.FundsView;
import haveno.desktop.main.market.MarketView;
import haveno.desktop.main.market.offerbook.OfferBookChartView;
import haveno.desktop.main.offer.BuyOfferView;
import haveno.desktop.main.offer.SellOfferView;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.TorNetworkSettingsWindow;
import haveno.desktop.main.portfolio.PortfolioView;
import haveno.desktop.main.settings.SettingsView;
import haveno.desktop.main.shared.PriceFeedComboBoxItem;
import haveno.desktop.main.support.SupportView;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.Transitions;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Separator;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxmlView
public class MainView
extends InitializableView<StackPane, MainViewModel> {
    private static final Logger log = LoggerFactory.getLogger(MainView.class);
    private static final int SHOW_TOR_SETTINGS_DELAY_SEC = 90;
    private Runnable onApplicationStartedHandler;
    private static Transitions transitions;
    private static StackPane rootContainer;
    private final ViewLoader viewLoader;
    private final Navigation navigation;
    private final ToggleGroup navButtons = new ToggleGroup();
    private ChangeListener<String> walletServiceErrorMsgListener;
    private ChangeListener<String> xmrSyncIconIdListener;
    private ChangeListener<String> splashP2PNetworkErrorMsgListener;
    private ChangeListener<String> splashP2PNetworkIconIdListener;
    private ChangeListener<Boolean> splashP2PNetworkVisibleListener;
    private BusyAnimation splashP2PNetworkBusyAnimation;
    private Label splashP2PNetworkLabel;
    private ProgressBar xmrSyncIndicator;
    private Label xmrSplashInfo;
    private Popup p2PNetworkWarnMsgPopup;
    private Popup xmrNetworkWarnMsgPopup;
    private final TorNetworkSettingsWindow torNetworkSettingsWindow;
    private final Preferences preferences;
    private static final int networkIconSize = 20;

    public static StackPane getRootContainer() {
        return rootContainer;
    }

    public static void blurLight() {
        transitions.blur((Node)rootContainer, 400, -0.6, false, 15.0);
    }

    public static void blurUltraLight() {
        transitions.blur((Node)rootContainer, 400, -0.6, false, 15.0);
    }

    public static void darken() {
        transitions.darken((Node)rootContainer, 400, false);
    }

    public static void removeEffect() {
        transitions.removeEffect((Node)rootContainer);
    }

    @Inject
    public MainView(MainViewModel model, CachingViewLoader viewLoader, Navigation navigation, Transitions transitions, TorNetworkSettingsWindow torNetworkSettingsWindow, Preferences preferences) {
        super(model);
        this.viewLoader = viewLoader;
        this.navigation = navigation;
        MainView.transitions = transitions;
        this.torNetworkSettingsWindow = torNetworkSettingsWindow;
        this.preferences = preferences;
    }

    @Override
    protected void initialize() {
        rootContainer = (StackPane)this.root;
        if (LanguageUtil.isDefaultLanguageRTL()) {
            rootContainer.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        }
        NavButton marketButton = new NavButton(MarketView.class, Res.get((String)"mainView.menu.market"));
        NavButton buyButton = new NavButton(BuyOfferView.class, Res.get((String)"mainView.menu.buyXmr"));
        NavButton sellButton = new NavButton(SellOfferView.class, Res.get((String)"mainView.menu.sellXmr"));
        NavButton portfolioButton = new NavButton(PortfolioView.class, Res.get((String)"mainView.menu.portfolio"));
        NavButton fundsButton = new NavButton(FundsView.class, Res.get((String)"mainView.menu.funds"));
        SecondaryNavButton supportButton = new SecondaryNavButton(this, SupportView.class, Res.get((String)"mainView.menu.support"), "image-support");
        SecondaryNavButton accountButton = new SecondaryNavButton(this, AccountView.class, Res.get((String)"mainView.menu.account"), "image-account");
        SecondaryNavButton settingsButton = new SecondaryNavButton(this, SettingsView.class, Res.get((String)"mainView.menu.settings"), "image-settings");
        JFXBadge portfolioButtonWithBadge = new JFXBadge((Node)portfolioButton);
        JFXBadge supportButtonWithBadge = new JFXBadge((Node)supportButton);
        JFXBadge settingsButtonWithBadge = new JFXBadge((Node)settingsButton);
        Locale locale = GlobalSettings.getLocale();
        final DecimalFormat currencyFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        currencyFormat.setMinimumFractionDigits(2);
        currencyFormat.setMaximumFractionDigits(2);
        ((StackPane)this.root).sceneProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                newValue.addEventHandler(KeyEvent.KEY_RELEASED, keyEvent -> {
                    if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.DIGIT1, (KeyEvent)keyEvent)) {
                        marketButton.fire();
                    } else if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.DIGIT2, (KeyEvent)keyEvent)) {
                        buyButton.fire();
                    } else if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.DIGIT3, (KeyEvent)keyEvent)) {
                        sellButton.fire();
                    } else if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.DIGIT4, (KeyEvent)keyEvent)) {
                        portfolioButton.fire();
                    } else if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.DIGIT5, (KeyEvent)keyEvent)) {
                        fundsButton.fire();
                    } else if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.DIGIT6, (KeyEvent)keyEvent)) {
                        supportButton.fire();
                    } else if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.DIGIT8, (KeyEvent)keyEvent)) {
                        accountButton.fire();
                    } else if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.DIGIT7, (KeyEvent)keyEvent)) {
                        settingsButton.fire();
                    }
                });
            }
        });
        Tuple2<ComboBox<PriceFeedComboBoxItem>, VBox> marketPriceBox = this.getMarketPriceBox();
        ComboBox priceComboBox = (ComboBox)marketPriceBox.first;
        priceComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> ((MainViewModel)this.model).setPriceFeedComboBoxItem((PriceFeedComboBoxItem)newValue));
        ChangeListener selectedPriceFeedItemListener = (observable, oldValue, newValue) -> {
            if (newValue != null) {
                priceComboBox.getSelectionModel().select(newValue);
            }
        };
        ((MainViewModel)this.model).getSelectedPriceFeedComboBoxItemProperty().addListener(selectedPriceFeedItemListener);
        priceComboBox.setItems(((MainViewModel)this.model).getPriceFeedComboBoxItems());
        Tuple2<Label, VBox> availableBalanceBox = this.getBalanceBox(Res.get((String)"mainView.balance.available"));
        ((Label)availableBalanceBox.first).textProperty().bind((ObservableValue)((MainViewModel)this.model).getAvailableBalance());
        ((Label)availableBalanceBox.first).setPrefWidth(112.0);
        ((Label)availableBalanceBox.first).tooltipProperty().bind((ObservableValue)new ObjectBinding<Tooltip>(){
            {
                this.bind(new Observable[]{((MainViewModel)MainView.this.model).getAvailableBalance()});
                this.bind(new Observable[]{((MainViewModel)MainView.this.model).getMarketPrice()});
            }

            protected Tooltip computeValue() {
                Object tooltipText = Res.get((String)"mainView.balance.available");
                try {
                    String preferredTradeCurrency = ((MainViewModel)MainView.this.model).getPreferences().getPreferredTradeCurrency().getCode();
                    double availableBalance = Double.parseDouble(((MainViewModel)MainView.this.model).getAvailableBalance().getValue().replace("XMR", ""));
                    double marketPrice = Double.parseDouble(((MainViewModel)MainView.this.model).getMarketPrice(preferredTradeCurrency).getValue());
                    tooltipText = (String)tooltipText + "\n" + currencyFormat.format(availableBalance * marketPrice) + " " + preferredTradeCurrency;
                }
                catch (NullPointerException | NumberFormatException runtimeException) {
                    // empty catch block
                }
                return new Tooltip((String)tooltipText);
            }
        });
        Tuple2<Label, VBox> reservedBalanceBox = this.getBalanceBox(Res.get((String)"mainView.balance.reserved.short"));
        ((Label)reservedBalanceBox.first).textProperty().bind((ObservableValue)((MainViewModel)this.model).getReservedBalance());
        ((Label)reservedBalanceBox.first).tooltipProperty().bind((ObservableValue)new ObjectBinding<Tooltip>(){
            {
                this.bind(new Observable[]{((MainViewModel)MainView.this.model).getReservedBalance()});
                this.bind(new Observable[]{((MainViewModel)MainView.this.model).getMarketPrice()});
            }

            protected Tooltip computeValue() {
                Object tooltipText = Res.get((String)"mainView.balance.reserved");
                try {
                    String preferredTradeCurrency = ((MainViewModel)MainView.this.model).getPreferences().getPreferredTradeCurrency().getCode();
                    double reservedBalance = Double.parseDouble(((MainViewModel)MainView.this.model).getReservedBalance().getValue().replace("XMR", ""));
                    double marketPrice = Double.parseDouble(((MainViewModel)MainView.this.model).getMarketPrice(preferredTradeCurrency).getValue());
                    tooltipText = (String)tooltipText + "\n" + currencyFormat.format(reservedBalance * marketPrice) + " " + preferredTradeCurrency;
                }
                catch (NullPointerException | NumberFormatException runtimeException) {
                    // empty catch block
                }
                return new Tooltip((String)tooltipText);
            }
        });
        Tuple2<Label, VBox> pendingBalanceBox = this.getBalanceBox(Res.get((String)"mainView.balance.pending.short"));
        ((Label)pendingBalanceBox.first).textProperty().bind((ObservableValue)((MainViewModel)this.model).getPendingBalance());
        ((Label)pendingBalanceBox.first).tooltipProperty().bind((ObservableValue)new ObjectBinding<Tooltip>(){
            {
                this.bind(new Observable[]{((MainViewModel)MainView.this.model).getPendingBalance()});
                this.bind(new Observable[]{((MainViewModel)MainView.this.model).getMarketPrice()});
            }

            protected Tooltip computeValue() {
                Object tooltipText = Res.get((String)"mainView.balance.pending");
                try {
                    String preferredTradeCurrency = ((MainViewModel)MainView.this.model).getPreferences().getPreferredTradeCurrency().getCode();
                    double lockedBalance = Double.parseDouble(((MainViewModel)MainView.this.model).getPendingBalance().getValue().replace("XMR", ""));
                    double marketPrice = Double.parseDouble(((MainViewModel)MainView.this.model).getMarketPrice(preferredTradeCurrency).getValue());
                    tooltipText = (String)tooltipText + "\n" + currencyFormat.format(lockedBalance * marketPrice) + " " + preferredTradeCurrency;
                }
                catch (NullPointerException | NumberFormatException runtimeException) {
                    // empty catch block
                }
                return new Tooltip((String)tooltipText);
            }
        });
        Region rightSpacer = new Region();
        HBox.setHgrow((Node)rightSpacer, (Priority)Priority.ALWAYS);
        HBox primaryNav = new HBox(new Node[]{this.getLogoPane(), marketButton, this.getNavigationSpacer(), buyButton, this.getNavigationSpacer(), sellButton, this.getNavigationSpacer(), portfolioButtonWithBadge, this.getNavigationSpacer(), fundsButton, rightSpacer});
        primaryNav.setAlignment(Pos.CENTER_LEFT);
        primaryNav.getStyleClass().add((Object)"nav-primary");
        HBox.setHgrow((Node)primaryNav, (Priority)Priority.SOMETIMES);
        HBox priceAndBalance = new HBox(new Node[]{(Node)marketPriceBox.second, this.getNavigationSeparator(), (Node)availableBalanceBox.second, this.getNavigationSeparator(), (Node)pendingBalanceBox.second, this.getNavigationSeparator(), (Node)reservedBalanceBox.second});
        priceAndBalance.setAlignment(Pos.CENTER);
        priceAndBalance.setSpacing(12.0);
        priceAndBalance.getStyleClass().add((Object)"nav-price-balance");
        HBox navPane = new HBox(this, new Node[]{primaryNav, priceAndBalance}){
            {
                AnchorPane.setLeftAnchor((Node)this, (Double)25.0);
                AnchorPane.setRightAnchor((Node)this, (Double)25.0);
                AnchorPane.setTopAnchor((Node)this, (Double)20.0);
                this.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
                this.getStyleClass().add((Object)"top-navigation");
            }
        };
        navPane.setAlignment(Pos.CENTER);
        HBox secondaryNav = new HBox(new Node[]{supportButtonWithBadge, accountButton, settingsButtonWithBadge});
        secondaryNav.getStyleClass().add((Object)"nav-secondary");
        secondaryNav.setAlignment(Pos.CENTER_RIGHT);
        secondaryNav.setPickOnBounds(false);
        HBox.setHgrow((Node)secondaryNav, (Priority)Priority.ALWAYS);
        AnchorPane.setLeftAnchor((Node)secondaryNav, (Double)0.0);
        AnchorPane.setRightAnchor((Node)secondaryNav, (Double)0.0);
        AnchorPane.setTopAnchor((Node)secondaryNav, (Double)0.0);
        AnchorPane secondaryNavContainer = new AnchorPane(this){
            {
                this.setId("nav-secondary-container");
                5.setLeftAnchor((Node)this, (Double)0.0);
                5.setRightAnchor((Node)this, (Double)0.0);
                5.setTopAnchor((Node)this, (Double)94.0);
            }
        };
        secondaryNavContainer.setPickOnBounds(false);
        secondaryNavContainer.getChildren().add((Object)secondaryNav);
        AnchorPane contentContainer = new AnchorPane(this){
            {
                this.getStyleClass().add((Object)"content-pane");
                6.setLeftAnchor((Node)this, (Double)0.0);
                6.setRightAnchor((Node)this, (Double)0.0);
                6.setTopAnchor((Node)this, (Double)95.0);
                6.setBottomAnchor((Node)this, (Double)0.0);
            }
        };
        AnchorPane applicationContainer = new AnchorPane(this, new Node[]{navPane, contentContainer, secondaryNavContainer}){
            {
                this.setId("application-container");
            }
        };
        BorderPane baseApplicationContainer = new BorderPane(this, (Node)applicationContainer){
            {
                this.setId("base-content-container");
            }
        };
        baseApplicationContainer.setBottom((Node)this.createFooter());
        this.setupBadge(portfolioButtonWithBadge, ((MainViewModel)this.model).getNumPendingTrades(), ((MainViewModel)this.model).getShowPendingTradesNotification());
        this.setupBadge(supportButtonWithBadge, ((MainViewModel)this.model).getNumOpenSupportTickets(), ((MainViewModel)this.model).getShowOpenSupportTicketsNotification());
        this.setupBadge(settingsButtonWithBadge, (StringProperty)new SimpleStringProperty(Res.get((String)"shared.new")), (BooleanProperty)new SimpleBooleanProperty(false));
        settingsButtonWithBadge.getStyleClass().add((Object)"new");
        this.navigation.addListener((viewPath, data) -> UserThread.await(() -> {
            if (viewPath.size() != 2 || viewPath.indexOf(MainView.class) != 0) {
                return;
            }
            Class<? extends View> viewClass = viewPath.tip();
            View view = this.viewLoader.load(viewClass);
            contentContainer.getChildren().setAll((Object[])new Node[]{view.getRoot()});
            try {
                this.navButtons.getToggles().stream().filter(toggle -> toggle instanceof NavButton).filter(button -> viewClass == ((NavButton)button).viewClass).findFirst().orElseThrow(() -> new HavenoException("No button matching %s found", new Object[]{viewClass})).setSelected(true);
            }
            catch (HavenoException e) {
                this.navigation.navigateTo(MainView.class, MarketView.class, OfferBookChartView.class);
            }
        }));
        VBox splashScreen = this.createSplashScreen();
        ((StackPane)this.root).getChildren().addAll((Object[])new Node[]{baseApplicationContainer, splashScreen});
        ((MainViewModel)this.model).getShowAppScreen().addListener((ov, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.navigation.navigateToPreviousVisitedView();
                transitions.fadeOutAndRemove((Node)splashScreen, 1500, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.disposeSplashScreen()));
            }
        });
        UserThread.execute(() -> this.onApplicationStartedHandler.run());
    }

    @NotNull
    private Separator getNavigationSeparator() {
        Separator separator = new Separator(Orientation.VERTICAL);
        HBox.setHgrow((Node)separator, (Priority)Priority.ALWAYS);
        separator.setMaxWidth(Double.MAX_VALUE);
        separator.getStyleClass().add((Object)"nav-separator");
        return separator;
    }

    @NotNull
    private Pane getLogoPane() {
        ImageView logo = new ImageView();
        logo.setId("image-logo-landscape");
        logo.setPreserveRatio(true);
        logo.setFitHeight(40.0);
        logo.setSmooth(true);
        logo.setCache(true);
        Pane pane = new Pane();
        HBox.setHgrow((Node)pane, (Priority)Priority.ALWAYS);
        pane.getStyleClass().add((Object)"nav-logo");
        pane.getChildren().add((Object)logo);
        return pane;
    }

    @NotNull
    private Region getNavigationSpacer() {
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        spacer.getStyleClass().add((Object)"nav-spacer");
        return spacer;
    }

    private Tuple2<Label, VBox> getBalanceBox(String text) {
        Label balanceDisplay = new Label();
        balanceDisplay.getStyleClass().add((Object)"nav-balance-display");
        Label label = new Label(text);
        label.getStyleClass().add((Object)"nav-balance-label");
        label.maxWidthProperty().bind((ObservableValue)balanceDisplay.widthProperty());
        label.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        VBox vBox = new VBox();
        vBox.setAlignment(Pos.CENTER_LEFT);
        vBox.getChildren().addAll((Object[])new Node[]{balanceDisplay, label});
        return new Tuple2((Object)balanceDisplay, (Object)vBox);
    }

    private ListCell<PriceFeedComboBoxItem> getPriceFeedComboBoxListCell() {
        return new ListCell<PriceFeedComboBoxItem>(this){

            protected void updateItem(PriceFeedComboBoxItem item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty && item != null) {
                    this.textProperty().bind((ObservableValue)item.displayStringProperty);
                } else {
                    this.textProperty().unbind();
                }
            }
        };
    }

    private Tuple2<ComboBox<PriceFeedComboBoxItem>, VBox> getMarketPriceBox() {
        VBox marketPriceBox = new VBox();
        marketPriceBox.setAlignment(Pos.CENTER_LEFT);
        JFXComboBox priceComboBox = new JFXComboBox();
        priceComboBox.setVisibleRowCount(12);
        priceComboBox.setFocusTraversable(false);
        priceComboBox.setId("price-feed-combo");
        priceComboBox.setCellFactory(p -> this.getPriceFeedComboBoxListCell());
        ListCell<PriceFeedComboBoxItem> buttonCell = this.getPriceFeedComboBoxListCell();
        buttonCell.setId("price-feed-combo");
        priceComboBox.setButtonCell(buttonCell);
        Label marketPriceLabel = new Label();
        this.updateMarketPriceLabel(marketPriceLabel);
        marketPriceLabel.getStyleClass().add((Object)"nav-balance-label");
        marketPriceBox.getChildren().addAll((Object[])new Node[]{priceComboBox, marketPriceLabel});
        ((MainViewModel)this.model).getMarketPriceUpdated().addListener((observable, oldValue, newValue) -> this.updateMarketPriceLabel(marketPriceLabel));
        return new Tuple2((Object)priceComboBox, (Object)marketPriceBox);
    }

    @NotNull
    private String getPriceProvider() {
        return ((MainViewModel)this.model).getIsFiatCurrencyPriceFeedSelected().get() ? "BitcoinAverage" : "Poloniex";
    }

    private void updateMarketPriceLabel(Label label) {
        if (((MainViewModel)this.model).getIsPriceAvailable().get()) {
            if (((MainViewModel)this.model).getIsExternallyProvidedPrice().get()) {
                label.setText(Res.get((String)"mainView.marketPriceWithProvider.label", (Object[])new Object[]{"Haveno Price Index"}));
                label.setTooltip(new Tooltip(this.getPriceProviderTooltipString()));
            } else {
                label.setText(Res.get((String)"mainView.marketPrice.havenoInternalPrice"));
                Tooltip tooltip = new Tooltip(Res.get((String)"mainView.marketPrice.tooltip.havenoInternalPrice"));
                label.setTooltip(tooltip);
            }
        } else {
            label.setText("");
            label.setTooltip(null);
        }
    }

    @NotNull
    private String getPriceProviderTooltipString() {
        String selectedCurrencyCode = ((MainViewModel)this.model).getPriceFeedService().getCurrencyCode();
        MarketPrice selectedMarketPrice = ((MainViewModel)this.model).getPriceFeedService().getMarketPrice(selectedCurrencyCode);
        return Res.get((String)"mainView.marketPrice.tooltip", (Object[])new Object[]{"Haveno Price Index for " + selectedCurrencyCode, "", selectedMarketPrice != null ? DisplayUtils.formatTime(new Date(selectedMarketPrice.getTimestampSec())) : Res.get((String)"shared.na"), ((MainViewModel)this.model).getPriceFeedService().getProviderNodeAddress()});
    }

    private VBox createSplashScreen() {
        VBox vBox = new VBox();
        vBox.setAlignment(Pos.CENTER);
        vBox.setSpacing(10.0);
        vBox.setId("splash");
        ImageView logo = new ImageView();
        logo.setId(Config.baseCurrencyNetwork() == BaseCurrencyNetwork.XMR_MAINNET ? "image-logo-splash" : "image-logo-splash-testnet");
        logo.setFitWidth(400.0);
        logo.setPreserveRatio(true);
        logo.setSmooth(true);
        this.xmrSplashInfo = new AutoTooltipLabel();
        this.xmrSplashInfo.textProperty().bind((ObservableValue)((MainViewModel)this.model).getXmrInfo());
        this.walletServiceErrorMsgListener = (ov, oldValue, newValue) -> UserThread.execute(() -> {
            if (newValue != null && !newValue.isEmpty()) {
                this.xmrSplashInfo.setId("splash-error-state-msg");
                if (!this.xmrSplashInfo.getStyleClass().contains((Object)"error-text")) {
                    this.xmrSplashInfo.getStyleClass().add((Object)"error-text");
                }
            } else {
                this.xmrSplashInfo.setId("");
                this.xmrSplashInfo.getStyleClass().remove((Object)"error-text");
            }
        });
        ((MainViewModel)this.model).getConnectionServiceErrorMsg().addListener(this.walletServiceErrorMsgListener);
        this.xmrSyncIndicator = new ProgressBar();
        this.xmrSyncIndicator.setPrefWidth(305.0);
        this.xmrSyncIndicator.progressProperty().bind((ObservableValue)((MainViewModel)this.model).getCombinedSyncProgress());
        ImageView xmrSyncIcon = new ImageView();
        xmrSyncIcon.setVisible(false);
        xmrSyncIcon.setManaged(false);
        this.xmrSyncIconIdListener = (ov, oldValue, newValue) -> {
            xmrSyncIcon.setId(newValue);
            xmrSyncIcon.setVisible(true);
            xmrSyncIcon.setManaged(true);
            boolean inProgress = "".equals(newValue);
            this.xmrSyncIndicator.setVisible(inProgress);
            this.xmrSyncIndicator.setManaged(inProgress);
        };
        ((MainViewModel)this.model).getXmrSplashSyncIconId().addListener(this.xmrSyncIconIdListener);
        HBox blockchainSyncBox = new HBox();
        blockchainSyncBox.setSpacing(10.0);
        blockchainSyncBox.setAlignment(Pos.CENTER);
        blockchainSyncBox.setPadding(new Insets(40.0, 0.0, 0.0, 0.0));
        blockchainSyncBox.setPrefHeight(50.0);
        blockchainSyncBox.getChildren().addAll((Object[])new Node[]{this.xmrSplashInfo, xmrSyncIcon});
        this.splashP2PNetworkLabel = new AutoTooltipLabel();
        this.splashP2PNetworkLabel.setWrapText(true);
        this.splashP2PNetworkLabel.setMaxWidth(700.0);
        this.splashP2PNetworkLabel.setTextAlignment(TextAlignment.CENTER);
        this.splashP2PNetworkLabel.getStyleClass().add((Object)"sub-info");
        this.splashP2PNetworkLabel.textProperty().bind((ObservableValue)((MainViewModel)this.model).getP2PNetworkInfo());
        AutoTooltipButton showTorNetworkSettingsButton = new AutoTooltipButton(Res.get((String)"settings.net.openTorSettingsButton"));
        showTorNetworkSettingsButton.setVisible(false);
        showTorNetworkSettingsButton.setManaged(false);
        showTorNetworkSettingsButton.setOnAction(e -> ((MainViewModel)this.model).getTorNetworkSettingsWindow().show());
        this.splashP2PNetworkBusyAnimation = new BusyAnimation(false);
        this.splashP2PNetworkErrorMsgListener = (arg_0, arg_1, arg_2) -> this.lambda$createSplashScreen$18((Button)showTorNetworkSettingsButton, arg_0, arg_1, arg_2);
        ((MainViewModel)this.model).getP2pNetworkWarnMsg().addListener(this.splashP2PNetworkErrorMsgListener);
        ImageView splashP2PNetworkIcon = new ImageView();
        splashP2PNetworkIcon.setId("image-connection-tor");
        splashP2PNetworkIcon.setFitWidth(20.0);
        splashP2PNetworkIcon.setFitHeight(20.0);
        splashP2PNetworkIcon.setVisible(false);
        splashP2PNetworkIcon.setManaged(false);
        HBox.setMargin((Node)splashP2PNetworkIcon, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
        splashP2PNetworkIcon.setOnMouseClicked(e -> this.torNetworkSettingsWindow.show());
        Timer showTorNetworkSettingsTimer = UserThread.runAfter(() -> MainView.lambda$createSplashScreen$20((Button)showTorNetworkSettingsButton), (long)90L);
        this.splashP2PNetworkIconIdListener = (ov, oldValue, newValue) -> {
            splashP2PNetworkIcon.setId(newValue);
            splashP2PNetworkIcon.setVisible(true);
            splashP2PNetworkIcon.setManaged(true);
            splashP2PNetworkIcon.setFitWidth(20.0);
            splashP2PNetworkIcon.setFitHeight(20.0);
            showTorNetworkSettingsTimer.stop();
        };
        ((MainViewModel)this.model).getP2PNetworkIconId().addListener(this.splashP2PNetworkIconIdListener);
        this.splashP2PNetworkVisibleListener = (ov, oldValue, newValue) -> {
            this.splashP2PNetworkBusyAnimation.setDisable(newValue == false);
            if (newValue.booleanValue()) {
                this.splashP2PNetworkBusyAnimation.play();
            }
        };
        ((MainViewModel)this.model).getSplashP2PNetworkAnimationVisible().addListener(this.splashP2PNetworkVisibleListener);
        HBox splashP2PNetworkBox = new HBox();
        splashP2PNetworkBox.setSpacing(10.0);
        splashP2PNetworkBox.setAlignment(Pos.CENTER);
        splashP2PNetworkBox.setPrefHeight(40.0);
        splashP2PNetworkBox.getChildren().addAll((Object[])new Node[]{this.splashP2PNetworkLabel, this.splashP2PNetworkBusyAnimation, splashP2PNetworkIcon, showTorNetworkSettingsButton});
        Label versionLabel = new Label("v1.2.2");
        vBox.getChildren().addAll((Object[])new Node[]{logo, blockchainSyncBox, this.xmrSyncIndicator, splashP2PNetworkBox, versionLabel});
        return vBox;
    }

    private void disposeSplashScreen() {
        ((MainViewModel)this.model).getConnectionServiceErrorMsg().removeListener(this.walletServiceErrorMsgListener);
        ((MainViewModel)this.model).getXmrSplashSyncIconId().removeListener(this.xmrSyncIconIdListener);
        ((MainViewModel)this.model).getP2pNetworkWarnMsg().removeListener(this.splashP2PNetworkErrorMsgListener);
        ((MainViewModel)this.model).getP2PNetworkIconId().removeListener(this.splashP2PNetworkIconIdListener);
        ((MainViewModel)this.model).getSplashP2PNetworkAnimationVisible().removeListener(this.splashP2PNetworkVisibleListener);
        this.xmrSplashInfo.textProperty().unbind();
        this.xmrSyncIndicator.progressProperty().unbind();
        this.splashP2PNetworkLabel.textProperty().unbind();
        ((MainViewModel)this.model).onSplashScreenRemoved();
    }

    private AnchorPane createFooter() {
        Separator separator = new Separator();
        separator.setId("footer-pane-line");
        separator.setPrefHeight(1.0);
        AnchorPane.setLeftAnchor((Node)separator, (Double)0.0);
        AnchorPane.setRightAnchor((Node)separator, (Double)0.0);
        AnchorPane.setTopAnchor((Node)separator, (Double)0.0);
        AutoTooltipLabel xmrInfoLabel = new AutoTooltipLabel();
        xmrInfoLabel.setId("footer-pane");
        xmrInfoLabel.textProperty().bind((ObservableValue)((MainViewModel)this.model).getXmrInfo());
        AnchorPane.setLeftAnchor((Node)xmrInfoLabel, (Double)10.0);
        AnchorPane.setBottomAnchor((Node)xmrInfoLabel, (Double)7.0);
        ((MainViewModel)this.model).getConnectionServiceErrorMsg().addListener((ov, oldValue, newValue) -> UserThread.execute(() -> {
            if (newValue != null && !newValue.isEmpty()) {
                xmrInfoLabel.setId("splash-error-state-msg");
                if (!xmrInfoLabel.getStyleClass().contains((Object)"error-text")) {
                    xmrInfoLabel.getStyleClass().add((Object)"error-text");
                }
                this.xmrNetworkWarnMsgPopup = (Popup)new Popup().warning((String)newValue);
                this.xmrNetworkWarnMsgPopup.show();
            } else {
                xmrInfoLabel.setId("footer-pane");
                xmrInfoLabel.getStyleClass().remove((Object)"error-text");
                if (this.xmrNetworkWarnMsgPopup != null) {
                    this.xmrNetworkWarnMsgPopup.hide();
                }
            }
        }));
        ((MainViewModel)this.model).getTopErrorMsg().addListener((ov, oldValue, newValue) -> {
            log.warn("Top level warning: " + newValue);
            if (newValue != null) {
                ((Popup)new Popup().warning((String)newValue)).show();
            }
        });
        AutoTooltipLabel versionLabel = new AutoTooltipLabel();
        versionLabel.setId("footer-pane");
        versionLabel.setTextAlignment(TextAlignment.CENTER);
        versionLabel.setAlignment(Pos.BASELINE_CENTER);
        versionLabel.textProperty().bind((ObservableValue)((MainViewModel)this.model).getCombinedFooterInfo());
        ((StackPane)this.root).widthProperty().addListener((ov, oldValue, newValue) -> versionLabel.setLayoutX(((Double)newValue - versionLabel.getWidth()) / 2.0));
        ((MainViewModel)this.model).getNewVersionAvailableProperty().addListener((observable, oldValue, newValue) -> {
            versionLabel.getStyleClass().removeAll((Object[])new String[]{"version-new", "version"});
            if (newValue.booleanValue()) {
                versionLabel.getStyleClass().add((Object)"version-new");
                versionLabel.setOnMouseClicked(e -> ((MainViewModel)this.model).onOpenDownloadWindow());
            } else {
                versionLabel.getStyleClass().add((Object)"version");
                versionLabel.setOnMouseClicked(null);
            }
        });
        HBox versionBox = new HBox();
        versionBox.setSpacing(10.0);
        versionBox.setAlignment(Pos.CENTER);
        versionBox.setAlignment(Pos.BASELINE_CENTER);
        versionBox.getChildren().addAll((Object[])new Node[]{versionLabel});
        AnchorPane.setLeftAnchor((Node)versionBox, (Double)10.0);
        AnchorPane.setRightAnchor((Node)versionBox, (Double)10.0);
        AnchorPane.setBottomAnchor((Node)versionBox, (Double)7.0);
        ImageView useDarkModeIcon = new ImageView();
        useDarkModeIcon.setId(this.preferences.getCssTheme() == 1 ? "image-dark-mode-toggle" : "image-light-mode-toggle");
        useDarkModeIcon.setFitHeight(20.0);
        useDarkModeIcon.setPreserveRatio(true);
        useDarkModeIcon.setPickOnBounds(true);
        useDarkModeIcon.setCursor(Cursor.HAND);
        AnchorPane.setRightAnchor((Node)useDarkModeIcon, (Double)8.0);
        AnchorPane.setBottomAnchor((Node)useDarkModeIcon, (Double)6.0);
        Tooltip modeToolTip = new Tooltip();
        Tooltip.install((Node)useDarkModeIcon, (Tooltip)modeToolTip);
        useDarkModeIcon.setOnMouseEntered(e -> modeToolTip.setText(Res.get((String)(this.preferences.getCssTheme() == 1 ? "setting.preferences.useLightMode" : "setting.preferences.useDarkMode"))));
        useDarkModeIcon.setOnMouseClicked(e -> this.preferences.setCssTheme(this.preferences.getCssTheme() != 1));
        this.preferences.getCssThemeProperty().addListener((observable, oldValue, newValue) -> useDarkModeIcon.setId(this.preferences.getCssTheme() == 1 ? "image-dark-mode-toggle" : "image-light-mode-toggle"));
        AutoTooltipLabel p2PNetworkLabel = new AutoTooltipLabel();
        p2PNetworkLabel.setId("footer-pane");
        p2PNetworkLabel.textProperty().bind((ObservableValue)((MainViewModel)this.model).getP2PNetworkInfo());
        double networkIconRightAnchor = 54.0;
        ImageView p2PNetworkIcon = new ImageView();
        AnchorPane.setRightAnchor((Node)p2PNetworkIcon, (Double)networkIconRightAnchor);
        AnchorPane.setBottomAnchor((Node)p2PNetworkIcon, (Double)6.0);
        p2PNetworkIcon.setPickOnBounds(true);
        p2PNetworkIcon.setCursor(Cursor.HAND);
        p2PNetworkIcon.setOpacity(0.4);
        p2PNetworkIcon.setFitWidth(20.0);
        p2PNetworkIcon.setFitHeight(20.0);
        p2PNetworkIcon.idProperty().bind((ObservableValue)((MainViewModel)this.model).getP2PNetworkIconId());
        p2PNetworkLabel.idProperty().bind((ObservableValue)((MainViewModel)this.model).getP2pNetworkLabelId());
        ((MainViewModel)this.model).getP2pNetworkWarnMsg().addListener((ov, oldValue, newValue) -> {
            if (newValue != null) {
                this.p2PNetworkWarnMsgPopup = (Popup)new Popup().warning((String)newValue);
                this.p2PNetworkWarnMsgPopup.show();
            } else if (this.p2PNetworkWarnMsgPopup != null) {
                this.p2PNetworkWarnMsgPopup.hide();
            }
        });
        p2PNetworkIcon.setOnMouseClicked(e -> this.torNetworkSettingsWindow.show());
        ImageView p2PNetworkStatusIcon = new ImageView();
        p2PNetworkStatusIcon.setPickOnBounds(true);
        p2PNetworkStatusIcon.setCursor(Cursor.HAND);
        p2PNetworkStatusIcon.setFitWidth(20.0);
        p2PNetworkStatusIcon.setFitHeight(20.0);
        AnchorPane.setRightAnchor((Node)p2PNetworkStatusIcon, (Double)(networkIconRightAnchor + 22.0));
        AnchorPane.setBottomAnchor((Node)p2PNetworkStatusIcon, (Double)6.0);
        Tooltip p2pNetworkStatusToolTip = new Tooltip();
        Tooltip.install((Node)p2PNetworkStatusIcon, (Tooltip)p2pNetworkStatusToolTip);
        p2PNetworkStatusIcon.setOnMouseEntered(e -> p2pNetworkStatusToolTip.setText(((MainViewModel)this.model).getP2pConnectionSummary()));
        Timeline flasher = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.5), e -> p2PNetworkStatusIcon.setOpacity(0.2), new KeyValue[0]), new KeyFrame(Duration.seconds((double)1.0), e -> p2PNetworkStatusIcon.setOpacity(1.0), new KeyValue[0])});
        flasher.setCycleCount(-1);
        ((MainViewModel)this.model).getP2PNetworkStatusIconId().addListener((ov, oldValue, newValue) -> {
            if (newValue.equalsIgnoreCase("flashing:image-yellow_circle")) {
                p2PNetworkStatusIcon.setId("image-yellow_circle");
                flasher.play();
            } else {
                p2PNetworkStatusIcon.setId(newValue);
                flasher.stop();
                p2PNetworkStatusIcon.setOpacity(1.0);
            }
        });
        p2PNetworkStatusIcon.setOnMouseClicked(e -> {
            if (p2PNetworkStatusIcon.getId().equalsIgnoreCase("image-alert-round")) {
                ((Popup)new Popup().warning(Res.get((String)"popup.info.p2pStatusIndicator.red", (Object[])new Object[]{((MainViewModel)this.model).getP2pConnectionSummary()}))).show();
            } else if (p2PNetworkStatusIcon.getId().equalsIgnoreCase("image-yellow_circle")) {
                ((Popup)new Popup().information(Res.get((String)"popup.info.p2pStatusIndicator.yellow", (Object[])new Object[]{((MainViewModel)this.model).getP2pConnectionSummary()}))).show();
            } else {
                ((Popup)new Popup().information(Res.get((String)"popup.info.p2pStatusIndicator.green", (Object[])new Object[]{((MainViewModel)this.model).getP2pConnectionSummary()}))).show();
            }
        });
        ((MainViewModel)this.model).getUpdatedDataReceived().addListener((observable, oldValue, newValue) -> UserThread.execute(() -> p2PNetworkIcon.setOpacity(1.0)));
        VBox vBox = new VBox();
        vBox.setAlignment(Pos.CENTER_RIGHT);
        vBox.getChildren().addAll((Object[])new Node[]{p2PNetworkLabel});
        AnchorPane.setRightAnchor((Node)vBox, (Double)(networkIconRightAnchor + 45.0));
        AnchorPane.setBottomAnchor((Node)vBox, (Double)7.0);
        return new AnchorPane(this, new Node[]{separator, xmrInfoLabel, versionBox, vBox, p2PNetworkStatusIcon, p2PNetworkIcon, useDarkModeIcon}){
            {
                this.setId("footer-pane");
                this.setMinHeight(30.0);
                this.setMaxHeight(30.0);
            }
        };
    }

    private void setupBadge(JFXBadge buttonWithBadge, StringProperty badgeNumber, BooleanProperty badgeEnabled) {
        buttonWithBadge.textProperty().bind((ObservableValue)badgeNumber);
        buttonWithBadge.setEnabled(badgeEnabled.get());
        badgeEnabled.addListener((observable, oldValue, newValue) -> UserThread.execute(() -> {
            buttonWithBadge.setEnabled(newValue.booleanValue());
            buttonWithBadge.refreshBadge();
        }));
        buttonWithBadge.setPosition(Pos.TOP_RIGHT);
        buttonWithBadge.setMinHeight(34.0);
        buttonWithBadge.setMaxHeight(34.0);
    }

    public void setOnApplicationStartedHandler(Runnable onApplicationStartedHandler) {
        this.onApplicationStartedHandler = onApplicationStartedHandler;
    }

    private static /* synthetic */ void lambda$createSplashScreen$20(Button showTorNetworkSettingsButton) {
        showTorNetworkSettingsButton.setVisible(true);
        showTorNetworkSettingsButton.setManaged(true);
    }

    private /* synthetic */ void lambda$createSplashScreen$18(Button showTorNetworkSettingsButton, ObservableValue ov, String oldValue, String newValue) {
        if (newValue != null) {
            this.splashP2PNetworkLabel.setId("splash-error-state-msg");
            this.splashP2PNetworkLabel.getStyleClass().remove((Object)"sub-info");
            this.splashP2PNetworkLabel.getStyleClass().add((Object)"error-text");
            this.splashP2PNetworkBusyAnimation.setDisable(true);
            this.splashP2PNetworkBusyAnimation.stop();
            showTorNetworkSettingsButton.setVisible(true);
            showTorNetworkSettingsButton.setManaged(true);
            if (((Preferences.UseTorForXmr)((MainViewModel)this.model).getUseTorForXmr().get()).isUseTorForXmr()) {
                this.xmrSyncIndicator.setVisible(false);
                this.xmrSplashInfo.setVisible(false);
            }
        } else if (((MainViewModel)this.model).getSplashP2PNetworkAnimationVisible().get()) {
            this.splashP2PNetworkBusyAnimation.setDisable(false);
            this.splashP2PNetworkBusyAnimation.play();
        }
    }

    private class NavButton
    extends AutoTooltipToggleButton {
        private final Class<? extends View> viewClass;

        NavButton(Class<? extends View> viewClass, String title) {
            super(title);
            this.viewClass = viewClass;
            this.setToggleGroup(MainView.this.navButtons);
            this.getStyleClass().add((Object)"nav-button");
            this.setMinWidth(Double.NEGATIVE_INFINITY);
            this.setPrefWidth(-1.0);
            if (((MainViewModel)MainView.this.model).getPreferences() != null && "ja".equals(((MainViewModel)MainView.this.model).getPreferences().getUserLanguage())) {
                this.getStyleClass().add((Object)"nav-button-japanese");
            }
            this.selectedProperty().addListener((ov, oldValue, newValue) -> this.setMouseTransparent((boolean)newValue));
            this.setOnAction(e -> MainView.this.navigation.navigateTo(MainView.class, viewClass));
        }
    }

    private class SecondaryNavButton
    extends NavButton {
        SecondaryNavButton(MainView mainView, Class<? extends View> viewClass, String title, String iconId) {
            super(viewClass, title);
            this.getStyleClass().setAll((Object[])new String[]{"nav-secondary-button"});
            if (((MainViewModel)mainView.model).getPreferences() != null && "ja".equals(((MainViewModel)mainView.model).getPreferences().getUserLanguage())) {
                this.getStyleClass().setAll((Object[])new String[]{"nav-secondary-button-japanese"});
            }
            ImageView imageView = new ImageView();
            imageView.setId(iconId);
            imageView.setFitWidth(15.0);
            imageView.setPreserveRatio(true);
            this.setGraphicTextGap(10.0);
            this.setGraphic((Node)imageView);
            this.setPickOnBounds(true);
        }
    }
}

