/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.common.util.Tuple2;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.BankUtil;
import haveno.core.locale.Country;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.WesternUnionAccountPayload;
import haveno.core.payment.validation.EmailValidator;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WesternUnionForm
extends PaymentMethodForm {
    private static final Logger log = LoggerFactory.getLogger(WesternUnionForm.class);
    private final WesternUnionAccountPayload westernUnionAccountPayload;
    private InputTextField cityInputTextField;
    private InputTextField stateInputTextField;
    private final EmailValidator emailValidator;
    private Country selectedCountry;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        WesternUnionAccountPayload payload = (WesternUnionAccountPayload)paymentAccountPayload;
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, Res.get((String)"payment.account.fullName"), payload.getHolderName());
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, Res.get((String)"payment.email"), payload.getEmail());
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, Res.get((String)"payment.account.city"), payload.getCity());
        if (BankUtil.isStateRequired((String)payload.getCountryCode())) {
            FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, gridRow, 1, Res.get((String)"payment.account.state"), payload.getState());
        }
        return gridRow;
    }

    public WesternUnionForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.westernUnionAccountPayload = (WesternUnionAccountPayload)paymentAccount.paymentAccountPayload;
        this.emailValidator = new EmailValidator();
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.paymentAccount.getPaymentMethod().getId()));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.country"), this.getCountryBasedPaymentAccount().getCountry() != null ? this.getCountryBasedPaymentAccount().getCountry().name : "");
        TradeCurrency singleTradeCurrency = this.paymentAccount.getSingleTradeCurrency();
        String nameAndCode = singleTradeCurrency != null ? singleTradeCurrency.getNameAndCode() : "null";
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.currency"), nameAndCode);
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.fullName"), this.westernUnionAccountPayload.getHolderName());
        ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.account.city"), (String)this.westernUnionAccountPayload.getCity()).second).setMouseTransparent(false);
        if (BankUtil.isStateRequired((String)this.westernUnionAccountPayload.getCountryCode())) {
            ((TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.account.state"), (String)this.westernUnionAccountPayload.getState()).second).setMouseTransparent(false);
        }
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.email"), this.westernUnionAccountPayload.getEmail());
        this.addLimitations(true);
    }

    private void onTradeCurrencySelected(TradeCurrency tradeCurrency) {
        TraditionalCurrency defaultCurrency = CurrencyUtil.getCurrencyByCountryCode((String)this.selectedCountry.code);
        this.applyTradeCurrency(tradeCurrency, defaultCurrency);
    }

    private void onCountrySelected(Country country) {
        this.selectedCountry = country;
        if (country != null) {
            this.getCountryBasedPaymentAccount().setCountry(country);
            String countryCode = country.code;
            TraditionalCurrency currency = CurrencyUtil.getCurrencyByCountryCode((String)countryCode);
            this.paymentAccount.setSingleTradeCurrency((TradeCurrency)currency);
            this.currencyComboBox.setDisable(false);
            this.currencyComboBox.getSelectionModel().select((Object)currency);
            this.updateFromInputs();
            this.applyIsStateRequired();
            this.cityInputTextField.setText("");
            this.stateInputTextField.setText("");
        }
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        Tuple2<ComboBox<TradeCurrency>, Integer> tuple = GUIUtil.addRegionCountryTradeCurrencyComboBoxes(this.gridPane, this.gridRow, this::onCountrySelected, this::onTradeCurrencySelected);
        this.currencyComboBox = (ComboBox)tuple.first;
        this.gridRow = (Integer)tuple.second;
        InputTextField holderNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.fullName"));
        holderNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.westernUnionAccountPayload.setHolderName(newValue);
            this.updateFromInputs();
        });
        holderNameInputTextField.setValidator(this.inputValidator);
        this.cityInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.city"));
        this.cityInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.westernUnionAccountPayload.setCity(newValue);
            this.updateFromInputs();
        });
        this.stateInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.state"));
        this.stateInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.westernUnionAccountPayload.setState(newValue);
            this.updateFromInputs();
        });
        this.applyIsStateRequired();
        InputTextField emailInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.email"));
        emailInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.westernUnionAccountPayload.setEmail(newValue);
            this.updateFromInputs();
        });
        emailInputTextField.setValidator((InputValidator)this.emailValidator);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        this.updateFromInputs();
    }

    private void applyIsStateRequired() {
        boolean stateRequired = BankUtil.isStateRequired((String)this.westernUnionAccountPayload.getCountryCode());
        this.stateInputTextField.setManaged(stateRequired);
        this.stateInputTextField.setVisible(stateRequired);
    }

    private CountryBasedPaymentAccount getCountryBasedPaymentAccount() {
        return (CountryBasedPaymentAccount)this.paymentAccount;
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.westernUnionAccountPayload.getHolderName() == null ? "" : this.westernUnionAccountPayload.getHolderName());
    }

    @Override
    public void updateAllInputsValid() {
        boolean result = this.isAccountNameValid() && this.paymentAccount.getSingleTradeCurrency() != null && this.getCountryBasedPaymentAccount().getCountry() != null && this.inputValidator.validate((String)this.westernUnionAccountPayload.getHolderName()).isValid && this.inputValidator.validate((String)this.westernUnionAccountPayload.getCity()).isValid && this.emailValidator.validate((String)this.westernUnionAccountPayload.getEmail()).isValid;
        this.allInputsValid.set(result);
    }
}

