/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.components.paymentmethods;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.VerseAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.VerseAccountPayload;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.util.FormBuilder;
import javafx.scene.control.TextField;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;

public class VerseForm
extends PaymentMethodForm {
    private final VerseAccount account;

    public static int addFormForBuyer(GridPane gridPane, int gridRow, PaymentAccountPayload paymentAccountPayload) {
        FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(gridPane, ++gridRow, Res.get((String)"payment.account.username"), ((VerseAccountPayload)paymentAccountPayload).getHolderName());
        return gridRow;
    }

    public VerseForm(PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService, InputValidator inputValidator, GridPane gridPane, int gridRow, CoinFormatter formatter) {
        super(paymentAccount, accountAgeWitnessService, inputValidator, gridPane, gridRow, formatter);
        this.account = (VerseAccount)paymentAccount;
    }

    @Override
    public void addFormForAddAccount() {
        this.gridRowFrom = this.gridRow + 1;
        InputTextField holderNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.gridRow, Res.get((String)"payment.account.username"));
        holderNameInputTextField.setValidator(this.inputValidator);
        holderNameInputTextField.textProperty().addListener((ov, oldValue, newValue) -> {
            this.account.setHolderName(newValue.trim());
            this.updateFromInputs();
        });
        this.addCurrenciesGrid(true);
        this.addLimitations(false);
        this.addAccountNameTextFieldWithAutoFillToggleButton();
    }

    private void addCurrenciesGrid(boolean isEditable) {
        FlowPane flowPane = (FlowPane)FormBuilder.addTopLabelFlowPane((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.supportedCurrencies"), (double)20.0, (double)20.0).second;
        if (isEditable) {
            flowPane.setId("flow-pane-checkboxes-bg");
        } else {
            flowPane.setId("flow-pane-checkboxes-non-editable-bg");
        }
        this.paymentAccount.getSupportedCurrencies().forEach(currency -> this.fillUpFlowPaneWithCurrencies(isEditable, flowPane, (TradeCurrency)currency, (PaymentAccount)this.account));
    }

    @Override
    protected void autoFillNameTextField() {
        this.setAccountNameWithString(this.account.getHolderName());
    }

    @Override
    public void addFormForEditAccount() {
        this.gridRowFrom = this.gridRow++;
        this.addAccountNameTextFieldWithAutoFillToggleButton();
        FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.paymentMethod"), Res.get((String)this.account.getPaymentMethod().getId()));
        TextField field = (TextField)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"payment.account.username"), (String)this.account.getHolderName()).second;
        field.setMouseTransparent(false);
        this.addLimitations(true);
        this.addCurrenciesGrid(false);
    }

    @Override
    public void updateAllInputsValid() {
        this.allInputsValid.set(this.isAccountNameValid() && this.account.getHolderName() != null && this.inputValidator.validate((String)this.account.getHolderName()).isValid && this.account.getTradeCurrencies().size() > 0);
    }
}

